/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.FatalInternalException;
import com.odi.imp.HashBucket;
import com.odi.imp.ObjectManager;
import com.odi.imp.Primes;
import com.odi.imp.WeakCache;

public final class WeakKeyCache
extends WeakCache {
    public WeakKeyCache(ObjectManager om, int initialCapacity) {
        super(om, initialCapacity);
        this.table = new HashBucket[Primes.nextPrime(initialCapacity)];
        this.reorgThreshold = (int)(0.75f * (float)this.table.length);
    }

    @Override
    Object getKey(HashBucket e) {
        return e.getElement();
    }

    @Override
    Object getElement(HashBucket e) {
        return e.getKey();
    }

    @Override
    HashBucket getNext(HashBucket e) {
        return e.getNext2();
    }

    @Override
    HashBucket getOtherNext(HashBucket e) {
        return e.getNext();
    }

    @Override
    void setNext(HashBucket e, HashBucket n) {
        e.setNext2(n);
    }

    @Override
    int getHash(HashBucket e) {
        Object key = e.getElement();
        if (key == null) {
            return -1;
        }
        return System.identityHashCode(key);
    }

    @Override
    int computeHashCode(Object key) {
        return System.identityHashCode(key);
    }

    @Override
    boolean compareKeys(Object key1, Object key2) {
        return key1 == key2;
    }

    HashBucket makeWritable(Object key) {
        throw new FatalInternalException("WeakKeyCache.makeWritable called");
    }

    HashBucket makeReadable(Object key) {
        throw new FatalInternalException("WeakKeyCache.makeReadable called");
    }

    @Override
    HashBucket findBucket(Object key) {
        this.lastFindBucketObject = null;
        int hash = System.identityHashCode(key);
        for (HashBucket e = this.table[this.slotIndex(hash)]; e != null; e = e.getNext2()) {
            Object element = e.getElement();
            if (element == null || e.getElement() != key) continue;
            this.lastFindBucketObject = element;
            return e;
        }
        return null;
    }
}

