/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.DatabaseLockedException;
import com.odi.FatalInternalException;
import java.util.Hashtable;
import java.util.Vector;

public class Lock {
    private LockRegistry m_registry = null;
    private String m_dbName;
    boolean m_transactionLevelLocking;

    Lock(String name, boolean transactionLevelLocking) {
        this.m_dbName = name;
        this.m_registry = new LockRegistry();
        this.m_transactionLevelLocking = transactionLevelLocking;
    }

    void lock(Object session, boolean forWrite, boolean nonBlocking) {
        if (!this.m_transactionLevelLocking) {
            return;
        }
        if (!this.m_registry.addOM(session, forWrite, nonBlocking)) {
            throw new DatabaseLockedException(this.m_dbName);
        }
    }

    boolean hasLock(Object session) {
        return this.m_registry.hasLock(session);
    }

    void unlock(Object session) {
        if (!this.m_transactionLevelLocking) {
            return;
        }
        this.m_registry.removeOM(session);
    }

    class LockRegistry {
        private boolean forWrite = false;
        private Hashtable lockers = new Hashtable(1);
        private Vector waiters = new Vector(1);

        LockRegistry() {
        }

        synchronized boolean addOM(Object session, boolean forWrite, boolean nonBlocking) {
            if (!this.waiters.isEmpty() || !this.lockers.isEmpty() && (this.forWrite || forWrite)) {
                if (nonBlocking) {
                    return false;
                }
                this.waitForLock(session, forWrite);
            }
            this.forWrite = forWrite;
            if (session == null) {
                throw new FatalInternalException("session is null when locking");
            }
            if (this.lockers.get(session) == null) {
                this.lockers.put(session, new Boolean(true));
            }
            return true;
        }

        private void waitForLock(Object session, boolean forWrite) {
            Waiter w = new Waiter();
            w.forWrite = forWrite;
            w.m_session = session;
            this.waiters.addElement(w);
            while (this.lockers.get(session) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException IE) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void removeOM(Object session) {
            this.lockers.remove(session);
            if (!this.lockers.isEmpty()) {
                return;
            }
            this.forWrite = false;
            boolean unblockedAWaiter = false;
            try {
                while (this.waiters.size() > 0 && !this.forWrite) {
                    Waiter w = (Waiter)this.waiters.elementAt(0);
                    boolean waiterForWrite = w.forWrite;
                    if (waiterForWrite && unblockedAWaiter) {
                        return;
                    }
                    this.waiters.removeElementAt(0);
                    this.lockers.put(w.m_session, new Boolean(true));
                    unblockedAWaiter = true;
                    if (!waiterForWrite) continue;
                    this.forWrite = true;
                    return;
                }
            }
            finally {
                this.notifyAll();
            }
        }

        boolean hasLock(Object session) {
            return this.lockers.get(session) != null;
        }

        private class Waiter {
            boolean forWrite;
            Object m_session;

            private Waiter() {
            }

            public String toString() {
                return this.m_session.toString() + "(" + (this.forWrite ? "write" : "read") + ")";
            }
        }
    }
}

