/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.ClassInfo;
import com.odi.ClassNotRegisteredException;
import com.odi.FatalApplicationException;
import com.odi.FatalInternalException;
import com.odi.IncompatibleClassException;
import com.odi.SchemaEvolutionException;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ReferenceType;
import com.odi.imp.SimpleHashtable;
import com.odi.imp.mtsonic.Database;
import com.odi.imp.mtsonic.ObjectAccess8ByteObjRefFormat;
import com.odi.imp.mtsonic.Server;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public final class SchemaManager
extends com.odi.imp.SchemaManager {
    private static final int MAX_CLASS_AFT = Short.MAX_VALUE;
    private Stack AFTToPos = new Stack();
    private final Hashtable classNameToAFT = new Hashtable(50);
    final Hashtable AFTToClassName = new Hashtable(50);
    private String committedSchemaString;
    private final StringBuffer newSchemaString = new StringBuffer();
    private int committedClassCount;
    private int newClassCount;
    private Database databaseForSchema;
    private SimpleHashtable AVTtoReferenceMap = new SimpleHashtable(31);
    private SimpleHashtable AVTtoFieldMap = new SimpleHashtable(31);
    private boolean evolved = false;

    SchemaManager(Server sv) {
        this.sv = sv;
    }

    void doRenameClass(String oldClassName, String newClassName) {
        boolean caught = false;
        try {
            ClassInfo.get(newClassName);
        }
        catch (ClassNotRegisteredException e) {
            caught = true;
        }
        if (!caught) {
            throw new SchemaEvolutionException("The class name " + newClassName + " is already registered.");
        }
        int aft = this.getClassAFTypeCode(oldClassName);
        if (!this.evolved) {
            this.evolved = true;
            this.newSchemaString.insert(0, this.committedSchemaString);
        }
        String schemaString = this.newSchemaString.toString();
        schemaString = SEMethods.renameClassInString(schemaString, oldClassName, newClassName);
        this.newSchemaString.setLength(0);
        this.newSchemaString.insert(0, schemaString);
        this.classNameToAFT.remove(oldClassName);
        this.classNameToAFT.put(newClassName, new Integer(aft));
    }

    void doDeleteClass(String className) {
        this.doDeleteClass(className, true, true);
    }

    void doDeleteClass(String className, boolean checkBaseAndField, boolean adjustMaps) {
        int aft = this.getClassAFTypeCode(className);
        String schemaString = this.newSchemaString.toString();
        if (!this.evolved) {
            schemaString = this.committedSchemaString + schemaString;
        }
        if (checkBaseAndField && SEMethods.checkBaseAndField(schemaString, className)) {
            throw new SchemaEvolutionException("The class " + className + " cannot be deleted " + "since it is needed in the definition of another class.");
        }
        if (!this.evolved) {
            this.evolved = true;
            this.newSchemaString.insert(0, this.committedSchemaString);
        }
        schemaString = this.newSchemaString.toString();
        String classEncoding = SEMethods.getClassEncodingFromString(schemaString, className);
        int index = schemaString.indexOf(classEncoding);
        String newClassEncoding = SEMethods.markClassAsDeleted(classEncoding);
        String end = schemaString.substring(index + classEncoding.length());
        this.newSchemaString.setLength(index);
        this.newSchemaString.append(newClassEncoding).append(end);
        if (adjustMaps) {
            this.classNameToAFT.remove(className);
            this.adjustMapsForDeleteClass(aft);
        }
    }

    void doClassBecome(Hashtable table) {
        String newClassName;
        String oldClassName;
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            oldClassName = (String)keys.nextElement();
            newClassName = (String)table.get(oldClassName);
            ClassInfo.get(oldClassName);
            ClassInfo.get(newClassName);
        }
        keys = table.keys();
        while (keys.hasMoreElements()) {
            oldClassName = (String)keys.nextElement();
            if (oldClassName.equals(newClassName = (String)table.get(oldClassName))) continue;
            int oldAFT = this.getClassAFTypeCode(oldClassName);
            int newAFT = this.getClassAFTypeCode(newClassName);
            if (!this.evolved) {
                this.evolved = true;
                this.newSchemaString.insert(0, this.committedSchemaString);
            }
            String schemaString = this.newSchemaString.toString();
            String oldClassEncoding = SEMethods.getClassEncodingFromString(schemaString, oldClassName);
            String newClassEncoding = SEMethods.getClassEncodingFromString(schemaString, newClassName);
            int endOfClass = newClassEncoding.indexOf(";");
            newClassEncoding = "C" + oldClassName + newClassEncoding.substring(endOfClass);
            int index = schemaString.indexOf(oldClassEncoding);
            String before = schemaString.substring(0, index);
            String after = schemaString.substring(index + oldClassEncoding.length());
            schemaString = before + newClassEncoding + after;
            this.newSchemaString.setLength(0);
            this.newSchemaString.insert(0, schemaString);
            this.doDeleteClass(newClassName, false, false);
            this.classNameToAFT.remove(newClassName);
            this.adjustMapsForClassBecome(oldAFT, newAFT);
            schemaString = this.newSchemaString.toString();
            schemaString = SEMethods.renameClassInString(schemaString, newClassName, oldClassName);
            this.newSchemaString.setLength(0);
            this.newSchemaString.insert(0, schemaString);
        }
    }

    @Override
    protected void adjustMapsForDeleteClass(int oldAFT) {
        this.AVTtoReferenceMap.remove(oldAFT);
        this.AVTtoFieldMap.remove(oldAFT);
        super.adjustMapsForDeleteClass(oldAFT);
    }

    @Override
    protected void adjustMapsForClassBecome(int oldAFT, int newAFT) {
        int[] newMap = (int[])this.AVTtoReferenceMap.get(newAFT);
        this.AVTtoReferenceMap.put(oldAFT, newMap);
        this.AVTtoReferenceMap.remove(newAFT);
        newMap = (int[])this.AVTtoFieldMap.get(newAFT);
        this.AVTtoFieldMap.put(oldAFT, newMap);
        this.AVTtoFieldMap.remove(newAFT);
        super.adjustMapsForClassBecome(oldAFT, newAFT);
    }

    @Override
    protected int serverGetAVTypeCode(int AFTypeCode) {
        return AFTypeCode;
    }

    @Override
    protected String serverGetGTSClassName(int AFTypeCode) {
        int cnameStart = this.getPos(AFTypeCode) + 1;
        int endOfName = this.committedSchemaString.indexOf(59, cnameStart);
        return this.committedSchemaString.substring(cnameStart, endOfName);
    }

    @Override
    protected int serverAddClass(String classEncoding) {
        String className = SchemaManager.validateTypeSyntax(classEncoding);
        Integer existingAFT = (Integer)this.classNameToAFT.get(className);
        if (existingAFT != null) {
            int existingDefPos = this.getPos(existingAFT);
            if (!this.committedSchemaString.regionMatches(existingDefPos, classEncoding, 0, classEncoding.length())) {
                System.err.println("classEncoding=" + classEncoding + " and committed schema string=" + this.committedSchemaString);
                throw new IncompatibleClassException("The class definition for " + className + " is incompatible with the database definition.");
            }
            return existingAFT;
        }
        int classAFT = 200 + this.committedClassCount + this.newClassCount;
        SchemaManager.checkMaxClassAFT(classAFT);
        this.putPos(classAFT, this.committedSchemaString.length() + this.newSchemaString.length());
        Integer AFTVal = new Integer(classAFT);
        this.classNameToAFT.put(className, AFTVal);
        this.AFTToClassName.put(AFTVal, className);
        this.newSchemaString.append(classEncoding);
        ++this.newClassCount;
        return classAFT;
    }

    private int skipType(String def, int iType) {
        char typeChar = def.charAt(iType);
        while (typeChar == '[' || typeChar == ']') {
            typeChar = def.charAt(++iType);
        }
        if (typeChar == 'T' || typeChar == 'S') {
            iType = def.indexOf(59, iType);
        } else if (typeChar == 'W') {
            ++iType;
        }
        return iType + 1;
    }

    private boolean isForwardClass(String className) {
        int pos;
        Integer Aft = (Integer)this.classNameToAFT.get(className);
        return Aft == null || this.committedSchemaString.charAt(pos = this.getPos(Aft)) != 'C';
    }

    @Override
    protected int[] serverGetMappingTable(int AFTypeCode) {
        int[] map = (int[])this.AVTtoFieldMap.get(AFTypeCode);
        if (map != null) {
            return map;
        }
        return this.lookupFieldMapForClass(AFTypeCode, new FieldToOffsetMap(this.sv.getObjectAccess()), this.AVTtoFieldMap);
    }

    private int[] lookupFieldMapForClass(int AFTypeCode, MapBuilder builder, SimpleHashtable existingMaps) {
        int[] map = null;
        this.computeMap(AFTypeCode, builder);
        Stack s = builder.s;
        map = new int[s.size() + 1];
        map[0] = builder.currOffset;
        for (int i = 0; i < s.size(); ++i) {
            map[i + 1] = (Integer)s.elementAt(i);
        }
        existingMaps.put(AFTypeCode, map);
        return map;
    }

    public void beginTransaction(Database db) {
        if (db != this.databaseForSchema || this.committedClassCount != db.getSchemaClassCount() || this.newClassCount > 0) {
            this.refreshSchemaCache(db);
        }
    }

    @Override
    protected void commitTransaction() {
        if (this.newClassCount > 0 || this.evolved) {
            if (!this.evolved) {
                this.newSchemaString.insert(0, this.committedSchemaString);
            }
            this.committedSchemaString = this.newSchemaString.toString();
            this.committedClassCount += this.newClassCount;
            this.removeTrailingDeletedClasses();
            this.newSchemaString.setLength(0);
            this.newClassCount = 0;
            this.databaseForSchema.setSchemaString(this.committedSchemaString);
            this.databaseForSchema.setSchemaClassCount(this.committedClassCount);
            if (this.evolved) {
                this.evolved = false;
            }
        }
    }

    private void removeTrailingDeletedClasses() {
        if (this.evolved) {
            int index;
            while ((index = this.committedSchemaString.lastIndexOf("}C")) != -1) {
                String classEncoding = this.committedSchemaString.substring(index + 1);
                if (SEMethods.isDeletedClassEncoding(classEncoding)) {
                    this.committedSchemaString = this.committedSchemaString.substring(0, index + 1);
                    --this.committedClassCount;
                    this.AFTToPos.pop();
                    continue;
                }
                return;
            }
        }
    }

    private void refreshSchemaCache(Database db) {
        this.discardSchemaCache();
        this.committedClassCount = db.getSchemaClassCount();
        SchemaManager.checkMaxClassAFT(this.committedClassCount);
        this.newClassCount = 0;
        this.databaseForSchema = db;
        this.committedSchemaString = db.getSchemaString();
        this.newSchemaString.setLength(0);
        while (!this.AFTToPos.isEmpty()) {
            this.AFTToPos.pop();
        }
        this.classNameToAFT.clear();
        this.AVTtoReferenceMap.clear();
        this.AVTtoFieldMap.clear();
        if (this.committedSchemaString != null) {
            this.initializeCache(this.committedSchemaString);
        }
    }

    private void initializeCache(String s) {
        int nextClassIndex = 0;
        int pos = 0;
        while (pos < s.length()) {
            char startChar = s.charAt(pos);
            int classPos = pos++;
            int endOfName = s.indexOf(59, pos);
            try {
                String className = s.substring(classPos + 1, endOfName);
                int endOfClass = startChar == 'C' ? s.indexOf(125, endOfName + 1) : endOfName;
                int AFT = nextClassIndex + 200;
                this.putPos(AFT, classPos);
                if (!SEMethods.isDeletedClass(className)) {
                    Integer AFTVal = new Integer(AFT);
                    this.classNameToAFT.put(className, AFTVal);
                    this.AFTToClassName.put(AFTVal, className);
                }
                ++nextClassIndex;
                pos = endOfClass + 1;
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new FatalInternalException("The database schema definition is corrupted");
            }
        }
        if (nextClassIndex != this.committedClassCount) {
            throw new FatalInternalException("The database schema definition is corrupted.");
        }
    }

    private static String validateTypeSyntax(String classEncoding) {
        int endOfName;
        char startChar;
        if (classEncoding.length() >= 3 && ((startChar = classEncoding.charAt(0)) == 'C' || startChar == 'S' || startChar == 'T') && (endOfName = classEncoding.indexOf(59, 1)) > 0 && ((startChar == 'S' || startChar == 'T') && classEncoding.length() == endOfName + 1 || startChar == 'C' && classEncoding.charAt(endOfName + 1) == '{' && classEncoding.charAt(classEncoding.length() - 1) == '}')) {
            return classEncoding.substring(1, endOfName);
        }
        throw new FatalInternalException("The class encoding is invalid");
    }

    private static void checkMaxClassAFT(int classAFT) {
        if (classAFT > Short.MAX_VALUE) {
            throw new FatalApplicationException("Attempt to exceed the maximum of 32767 classes per database.");
        }
    }

    @Override
    protected int[] getReferenceMap(int AFTypeCode) {
        int[] map = (int[])this.AVTtoReferenceMap.get(AFTypeCode);
        if (map != null) {
            return map;
        }
        return this.lookupFieldMapForClass(AFTypeCode, new OffsetReferencesList(this.sv.getObjectAccess()), this.AVTtoReferenceMap);
    }

    public String[] getAllClasses() {
        String[] classNames = new String[this.classNameToAFT.size()];
        Enumeration keys = this.classNameToAFT.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String className = (String)keys.nextElement();
            classNames[i++] = className;
        }
        return classNames;
    }

    String[] getDirectAndIndirectClasses() {
        int endIndex;
        String className;
        String[] classNames = this.getAllClasses();
        Vector<String> classes = new Vector<String>();
        int len = classNames.length;
        for (int i = 0; i < len; ++i) {
            classes.addElement(classNames[i]);
        }
        String currentString = this.getCurrentSchemaString();
        boolean done = true;
        int index = 0;
        int strLength = currentString.length();
        String marker = ";T";
        while ((index = currentString.indexOf(marker, index)) >= 0) {
            if (classes.contains(className = currentString.substring(index += 2, endIndex = currentString.indexOf(";", index)))) continue;
            classes.addElement(className);
        }
        marker = "]T";
        while ((index = currentString.indexOf(marker, index)) >= 0) {
            if (classes.contains(className = currentString.substring(index += 2, endIndex = currentString.indexOf(";", index)))) continue;
            classes.addElement(className);
        }
        int newlen = classes.size();
        String[] newClassNames = new String[newlen];
        for (int i = 0; i < newlen; ++i) {
            newClassNames[i] = (String)classes.elementAt(i);
        }
        return newClassNames;
    }

    public int getClassCount() {
        return this.committedClassCount + this.newClassCount;
    }

    public String getCurrentSchemaString() {
        return this.committedSchemaString + this.newSchemaString.toString();
    }

    public void upgradeSchema(String[] skipTypes) {
        throw new FatalInternalException("upgradeSchema is not implemented.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeMap(int AFTypeCode, MapBuilder action) {
        int i;
        int classStart = this.getPos(AFTypeCode);
        String schemaString = this.committedSchemaString;
        if (classStart >= this.committedSchemaString.length()) {
            classStart -= this.committedSchemaString.length();
            schemaString = this.newSchemaString.toString();
        }
        if (schemaString.charAt(i = schemaString.indexOf(123, classStart) + 1) == 'B') {
            int start = i + 1;
            i = schemaString.indexOf(59, start);
            action.doBaseClass(schemaString.substring(start, i));
        }
        int limit = schemaString.indexOf(125, i);
        while (i < limit) {
            int memberIndex = schemaString.indexOf(77, i);
            int indexableIndex = schemaString.indexOf(73, i);
            if (indexableIndex != -1 && indexableIndex < memberIndex || memberIndex == -1) {
                memberIndex = indexableIndex;
            }
            if (memberIndex == -1 || memberIndex >= limit) return;
            i = schemaString.indexOf(59, memberIndex) + 1;
            char typeChar = schemaString.charAt(i);
            if (typeChar == 'E') {
                if ((typeChar = schemaString.charAt(++i)) == 'T') {
                    int nameStart = i + 1;
                    i = schemaString.indexOf(59, i);
                    action.doEmbeddedFieldClass(schemaString.substring(nameStart, i));
                    continue;
                }
                if (typeChar != '[') throw new FatalInternalException("Embedded type not recognized:" + typeChar);
                int start = i + 1;
                i = schemaString.indexOf(93, i);
                int arrayLength = Integer.parseInt(schemaString.substring(start, i));
                action.doField(schemaString.charAt(i + 1), arrayLength);
            } else {
                action.doField(typeChar, 0);
            }
            while (typeChar == '[' || typeChar == ']') {
                typeChar = schemaString.charAt(++i);
            }
            if (typeChar != 'T' && typeChar != 'S') continue;
            i = schemaString.indexOf(59, i);
        }
    }

    private int getPos(int AFT) {
        return (Integer)this.AFTToPos.elementAt(AFT - 200);
    }

    private void putPos(int AFT, int pos) {
        if (AFT - 200 != this.AFTToPos.size()) {
            throw new FatalInternalException("AFT/STACK mismatch " + AFT + " " + this.AFTToPos.size());
        }
        this.AFTToPos.push(new Integer(pos));
    }

    static class SEMethods {
        SEMethods() {
        }

        public static String renameClassInString(String schemaString, String oldClassName, String newClassName) {
            int index;
            int checked = 0;
            while ((index = schemaString.indexOf(oldClassName, checked)) >= 0) {
                if (SEMethods.isValidClass(schemaString, oldClassName, index)) {
                    String start = schemaString.substring(0, index);
                    String end = schemaString.substring(index + oldClassName.length(), schemaString.length());
                    schemaString = start + newClassName + end;
                    checked = index + newClassName.length();
                    continue;
                }
                checked = index + oldClassName.length();
            }
            return schemaString;
        }

        public static boolean isValidClass(String schemaString, String className, int beginIndex) {
            if (schemaString.charAt(beginIndex + className.length()) == ';') {
                if (schemaString.charAt(beginIndex - 1) == 'C' && beginIndex == 1) {
                    return true;
                }
                return schemaString.regionMatches(beginIndex - 2, "}C", 0, 2) || schemaString.regionMatches(beginIndex - 2, ";T", 0, 2) || schemaString.regionMatches(beginIndex - 2, "{B", 0, 2) || schemaString.regionMatches(beginIndex - 2, "]T", 0, 2);
            }
            return false;
        }

        public static boolean checkBaseAndField(String schemaString, String className) {
            int index = 0;
            while ((index = SEMethods.findBaseOrField(schemaString, className, index)) >= 0) {
                if (SEMethods.isField(schemaString, index)) {
                    if (!SEMethods.checkValidField(schemaString, className, index)) {
                        return true;
                    }
                    index += className.length();
                    continue;
                }
                return true;
            }
            return false;
        }

        public static int findBaseOrField(String schemaString, String className, int beginIndex) {
            while ((beginIndex = schemaString.indexOf(className, beginIndex)) != -1) {
                if (SEMethods.isBaseClass(schemaString, beginIndex) || SEMethods.isField(schemaString, beginIndex)) {
                    return beginIndex;
                }
                beginIndex += className.length();
            }
            return -1;
        }

        public static String markClassAsDeleted(String classEncoding) {
            return "C-;{}";
        }

        public static boolean isDeletedClass(String className) {
            return className.charAt(0) == '-';
        }

        public static boolean isDeletedClassEncoding(String classEncoding) {
            return classEncoding.charAt(1) == '-';
        }

        public static boolean isField(String schemaString, int beginIndex) {
            if (beginIndex < 4) {
                return false;
            }
            return schemaString.regionMatches(beginIndex - 2, ";T", 0, 2) || schemaString.regionMatches(beginIndex - 2, "]T", 0, 2);
        }

        public static boolean isBaseClass(String schemaString, int beginIndex) {
            if (beginIndex < 3) {
                return false;
            }
            return schemaString.regionMatches(beginIndex - 2, "{B", 0, 2);
        }

        public static boolean checkValidField(String schemaString, String fieldName, int beginIndex) {
            int index = schemaString.lastIndexOf("}C", beginIndex);
            int endOfClass = schemaString.indexOf(";", index + 2);
            String className = schemaString.substring(index + 2, endOfClass);
            return className.equals(fieldName);
        }

        public static String getClassEncodingFromString(String schemaString, String className) {
            int startOfClass = schemaString.indexOf("C" + className + ";");
            if (startOfClass == -1) {
                return null;
            }
            return schemaString.substring(startOfClass, schemaString.indexOf("}", startOfClass) + 1);
        }
    }

    class OffsetReferencesList
    extends MapBuilder {
        OffsetReferencesList(ObjectAccess objectAccess) {
            super(objectAccess);
        }

        @Override
        int[] getMap(int AFTypeCode) {
            return SchemaManager.this.getReferenceMap(AFTypeCode);
        }

        @Override
        void doEmbeddedFieldClass(String className) {
            this.embedFields(className);
        }

        @Override
        public void doField(char typeChar, int arrayLength) {
            if (SchemaManager.isRefTypeChar(typeChar)) {
                ReferenceType refType = SchemaManager.getRefType(typeChar);
                if (arrayLength > 1) {
                    int arrayMapEntry = com.odi.imp.SchemaManager.makeArrayMapEntry(arrayLength);
                    this.s.push(new Integer(arrayMapEntry));
                }
                int lazyRefMapEntry = com.odi.imp.SchemaManager.makeLazyRefMapEntry(this.currOffset, refType);
                this.s.push(new Integer(lazyRefMapEntry));
            } else if (typeChar == 'T' || typeChar == 'S' || typeChar == 'O' || typeChar == 'P' || typeChar == 'W' || typeChar == '[') {
                if (arrayLength > 1) {
                    this.s.push(new Integer(com.odi.imp.SchemaManager.makeArrayMapEntry(arrayLength)));
                }
                this.s.push(new Integer(this.currOffset));
            }
            super.doField(typeChar, arrayLength);
        }
    }

    class FieldToOffsetMap
    extends MapBuilder {
        FieldToOffsetMap(ObjectAccess objectAccess) {
            super(objectAccess);
        }

        @Override
        protected int[] getMap(int AFTypeCode) {
            return SchemaManager.this.serverGetMappingTable(AFTypeCode);
        }

        @Override
        void doField(char typeChar, int arrayLength) {
            this.s.push(new Integer(this.currOffset));
            super.doField(typeChar, arrayLength);
        }

        @Override
        void doEmbeddedFieldClass(String className) {
            this.s.push(new Integer(this.currOffset));
            int[] classMap = this.getMap(SchemaManager.this.getClassAFTypeCode(className));
            this.currOffset += classMap[0];
        }
    }

    abstract class MapBuilder {
        Stack s = new Stack();
        int currOffset = 0;
        final ObjectAccess8ByteObjRefFormat objectAccess;

        MapBuilder(ObjectAccess objectAccess) {
            this.objectAccess = (ObjectAccess8ByteObjRefFormat)objectAccess;
        }

        abstract int[] getMap(int var1);

        void doBaseClass(String className) {
            if (!className.equals("com.odi.Persistent")) {
                this.embedFields(className);
            }
        }

        void doField(char typeChar, int arrayLength) {
            byte typeSize = this.objectAccess.typeSizes[typeChar];
            if (typeSize == 0) {
                throw new FatalInternalException("Missing size entry for:" + typeChar);
            }
            this.currOffset += typeSize * (arrayLength > 0 ? arrayLength : 1);
        }

        void embedFields(String className) {
            int[] classMap = this.getMap(SchemaManager.this.getClassAFTypeCode(className));
            for (int j = 1; j < classMap.length; ++j) {
                this.s.push(new Integer(classMap[j] + this.currOffset));
            }
            this.currOffset += classMap[0];
        }

        abstract void doEmbeddedFieldClass(String var1);
    }
}

