/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.AbortException;
import com.odi.Database;
import com.odi.DatabaseNotOpenException;
import com.odi.FatalApplicationException;
import com.odi.FatalInternalException;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStoreException;
import com.odi.Session;
import com.odi.imp.Cluster;
import com.odi.imp.DatabaseIdAndMode;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Transaction;
import com.odi.imp.Utilities;
import com.odi.imp.mtsonic.GenericObject;
import com.odi.imp.mtsonic.ObjectAccess8ByteObjRefFormat;
import com.odi.imp.mtsonic.ObjectTable;
import com.odi.imp.mtsonic.SchemaManager;
import com.odi.util.BTreeEntryNotFoundException;
import com.sonicsw.mtstorage.AbstractBTreeIterator;
import com.sonicsw.mtstorage.BTreeKeyNotFoundException;
import com.sonicsw.mtstorage.BTreeValueNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public final class Server
extends com.odi.imp.Server {
    public ObjectTable objectTable;
    SchemaManager schemaManager;
    Hashtable databasesByName = new Hashtable();
    com.odi.imp.mtsonic.Database currentDatabase = null;
    int nextDatabaseId = 1;
    int autoOpenMode = 7;
    private static boolean oneExists = false;
    private boolean isPSE = false;
    private boolean disableCrossTransactionCaching = true;
    private long nextTransactionId = 1L;

    @Override
    public void serverShutdown(Session sess) {
        if (oneExists && this.isPSE) {
            oneExists = false;
        }
        try {
            if (this.objectTable != null) {
                this.objectTable.closeDatabase(sess);
            }
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
        this.databasesByName.clear();
        this.objectTable = null;
    }

    @Override
    public com.odi.imp.Database makeDatabase(int databaseId, String pathname, int openMode, ObjectManager om) {
        return com.odi.imp.mtsonic.Database.get(this, databaseId, pathname, openMode, om);
    }

    @Override
    public Transaction makeTransaction(int type) {
        return new com.odi.imp.mtsonic.Transaction(this, type, this.om);
    }

    @Override
    public com.odi.imp.GenericObject makeGenericObject() {
        return new GenericObject(this.om);
    }

    @Override
    public int serverCreateDatabase(String pathname, int fileMode, HashMap parameters, int schemaInstallMode) {
        return com.odi.imp.mtsonic.Database.serverCreateDatabase(this, pathname, fileMode, parameters, this.om);
    }

    @Override
    public boolean serverOpenDatabase(String pathname, int openMode, HashMap parameters, DatabaseIdAndMode diam) {
        return com.odi.imp.mtsonic.Database.serverOpenDatabaseByName(this, pathname, openMode, parameters, this.om, diam);
    }

    @Override
    public int serverGetDatabaseId(String pathname) {
        try {
            if (this.currentDatabase != null && (pathname.equals(this.currentDatabase.getPath()) || new File(this.currentDatabase.getPath()).getCanonicalPath().equals(new File(pathname).getCanonicalPath()))) {
                return this.currentDatabase.getDatabaseId();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new DatabaseNotOpenException("The database " + pathname + " is not open.");
    }

    @Override
    public ObjectReference serverCreateEmptyObject(Cluster place, Object hollowObject, int AFTypeCode, int arrayElementCount, int alignment) {
        int size = this.schemaManager.linearRepSize(AFTypeCode, arrayElementCount);
        long location = 0L;
        try {
            location = this.objectTable.allocateObject(size, AFTypeCode, alignment);
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
        return hollowObject == null ? this.om.objRefFactory.createMutating(place, location, AFTypeCode, arrayElementCount) : this.om.objRefFactory.create(hollowObject, place, location, AFTypeCode, arrayElementCount);
    }

    public long bTreeCreate(boolean noDuplicates, String pathInfo) {
        try {
            return this.objectTable.createBTree(noDuplicates, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
            return 0L;
        }
    }

    public void bTreeRemove(long treeDbk, byte[] key, byte[] value, String pathInfo) {
        try {
            this.objectTable.remove(treeDbk, key, value, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
    }

    public byte[] bTreeRemove(long treeDbk, byte[] key, String pathInfo) {
        try {
            return this.objectTable.remove(treeDbk, key, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
            return null;
        }
    }

    public byte[] bTreePut(long treeDbk, byte[] key, byte[] value, String pathInfo) {
        try {
            return this.objectTable.put(treeDbk, key, value, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
            return null;
        }
    }

    public void bTreeClear(long treeDbk, String pathInfo) {
        try {
            this.objectTable.clear(treeDbk, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
    }

    public void bTreeDelete(long treeDbk, String pathInfo) {
        try {
            this.objectTable.delete(treeDbk, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
    }

    public byte[] bTreeGet(long treeDbk, byte[] key, String pathInfo) {
        try {
            return this.objectTable.get(treeDbk, key, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
            return null;
        }
    }

    public byte[] bTreeGetFirstKey(long treeDbk, String pathInfo) {
        try {
            return this.objectTable.getFirstKey(treeDbk, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
            return null;
        }
    }

    public byte[] bTreeGetLastKey(long treeDbk, String pathInfo) {
        try {
            return this.objectTable.getLastKey(treeDbk, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
            return null;
        }
    }

    public boolean bTreeContains(long treeDbk, byte[] key, byte[] value, String pathInfo) {
        try {
            return this.objectTable.contains(treeDbk, key, value, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
            return false;
        }
    }

    public boolean bTreeContainsKey(long treeDbk, byte[] key, String pathInfo) {
        try {
            return this.objectTable.containsKey(treeDbk, key, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
            return false;
        }
    }

    public void bTreeAdvance(AbstractBTreeIterator iterator, String pathInfo) {
        try {
            this.objectTable.advance(iterator, pathInfo);
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
    }

    @Override
    public void serverWriteLock(ObjectReference objectRef) {
        this.currentDatabase.assureUpdate("write lock an object");
        this.objectTable.acquireLock(objectRef.getLocation(), 7, this.getLockTimeout(), true);
    }

    @Override
    public long serverGetStorageOffset(ObjectReference objRef) {
        return this.objectTable.getStorageOffset(objRef.getLocation());
    }

    @Override
    public byte[] serverGetExtRef(int databaseId, int segmentId, int clusterId, long location) {
        if (this.currentDatabase == null) {
            throw new DatabaseNotOpenException("Attempt to acquire a lock on a segment when database is not open.");
        }
        if (segmentId != 0) {
            throw new ObjectNotFoundException("The segment id " + segmentId + " is illegal.");
        }
        if (clusterId != 0) {
            throw new ObjectNotFoundException("The cluster id " + clusterId + " is illegal.");
        }
        this.currentDatabase.assureRead("get an external reference");
        byte[] buffer = new byte[this.om.objectAccess.referenceSize];
        try {
            ObjectReference objRef = this.objectTable.getObjRef(location, this.currentDatabase.theSegment.theCluster, this.om.objRefFactory.createMutating());
            this.om.objectAccess.encodeObjRef(buffer, 0, objRef);
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
        return buffer;
    }

    @Override
    public String serverGetPathname(int databaseId) {
        if (databaseId == this.currentDatabase.getDatabaseId()) {
            return this.currentDatabase.getPath();
        }
        throw new FatalInternalException("Getting a pathname for a closed database ID.");
    }

    @Override
    public int serverGetAutoOpenMode() {
        return this.autoOpenMode;
    }

    @Override
    public void serverSetAutoOpenMode(int openMode) {
        this.autoOpenMode = openMode;
    }

    @Override
    public void serverAcquireLock(ObjectReference objRef, int lockType, int timeoutMillis) {
        if (lockType == 7) {
            this.currentDatabase.assureUpdate("acquire an update lock on an object");
        } else {
            this.currentDatabase.assureRead("acquire a lock on an object");
        }
        this.objectTable.acquireLock(objRef.getLocation(), lockType, timeoutMillis, true);
    }

    @Override
    public void initialize(ObjectManager om, String host, boolean createPro, Properties plist) {
        if (!createPro) {
            if (oneExists) {
                throw new FatalApplicationException("PSE allows only one object manager at a time");
            }
            oneExists = true;
            this.isPSE = true;
        }
        this.om = om;
        this.schemaManager = new SchemaManager(this);
        ObjectAccess8ByteObjRefFormat oa = new ObjectAccess8ByteObjRefFormat(this);
        om.setSMandOA(this.schemaManager, oa);
        try {
            Class otClass = Utilities.findClass("com.odi.imp.mtsonic.ObjectTable");
            this.objectTable = (ObjectTable)otClass.newInstance();
        }
        catch (ClassNotFoundException CNFE) {
            throw new FatalInternalException("Couldn't create ObjectTable instance: " + CNFE);
        }
        catch (InstantiationException IE) {
            throw new FatalInternalException("Couldn't create ObjectTable instance: " + IE);
        }
        catch (IllegalAccessException IAE) {
            throw new FatalInternalException("Couldn't create ObjectTable instance: " + IAE);
        }
        this.objectTable.init(this.schemaManager, oa, plist);
        oa.setObjectTable(this.objectTable);
        String PSEName = createPro ? "PSE Pro" : "PSE";
        om.setStorageSystemInfo(PSEName, "imp.mtsonic");
        plist.put("com.odi.product", createPro ? "PSEPro" : "PSE");
        String value = om.getProperty("com.odi.disableCrossTransactionCaching", "true");
        plist.put("com.odi.disableCrossTransactionCaching", value);
        this.disableCrossTransactionCaching = Boolean.valueOf(value);
        value = om.getProperty("com.odi.useImmediateStrings", "true");
        plist.put("com.odi.useImmediateStrings", value);
    }

    @Override
    public void initialize(ObjectManager om, String host, String name, int numExpectedSessions, boolean global, Properties plist) {
    }

    @Override
    protected void validate(ObjectReference objRef) {
        if (ObjRefUtils.isNull(objRef)) {
            return;
        }
        try {
            this.objectTable.validate(objRef.getLocation(), objRef.getAFTypeCode());
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
    }

    @Override
    public void elaborateLazyReference(MutatingObjRef objRef, boolean notPeer) {
        try {
            this.objectTable.getObjRef(objRef.location, objRef.place, objRef);
        }
        catch (IOException e) {
            this.IOFailure(e);
        }
    }

    void IOFailure(IOException e) {
        if (e instanceof BTreeKeyNotFoundException || e instanceof BTreeValueNotFoundException) {
            throw new BTreeEntryNotFoundException();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(stream);
        e.printStackTrace(writer);
        writer.flush();
        throw new AbortException("An I/O exception occurred.\nStack trace at point of original failure:\n*****************************************\n" + stream + "*****************************************\n", e);
    }

    public SchemaManager debugGetSchemaManager() {
        return this.schemaManager;
    }

    @Override
    public boolean leaveBarriersDownAcrossTransactions() {
        return !this.disableCrossTransactionCaching;
    }

    @Override
    public boolean objectValid(ObjectReference ignore) {
        return !this.disableCrossTransactionCaching;
    }

    @Override
    public boolean supportsObjectCaching() {
        return true;
    }

    @Override
    public boolean checkCachedObjectsValid() {
        return true;
    }

    @Override
    public boolean checkCachedObjectValid(ObjectReference objRef, long transaction) {
        return true;
    }

    @Override
    public boolean needObjectSizeForGetObjects() {
        return true;
    }

    @Override
    public void serverEvolveSchema(String dbName, String workdbName) {
        throw new ObjectStoreException("com.odi.imp.mtsonic.Server.serverEvolveSchema() not yet implemented");
    }

    @Override
    protected int serverGetTransactionPriority() {
        return 0;
    }

    @Override
    protected void serverSetTransactionPriority(int priority) {
    }

    @Override
    public void serverInstanceBecome(ObjectReference otherRef, ObjectReference thisRef) {
        this.currentDatabase.assureUpdate("ObjectStore._instanceBecome()");
        this.objectTable.doInstanceBecome(otherRef.getLocation(), thisRef.getLocation());
    }

    @Override
    public void serverClassBecome(Hashtable table) {
        this.currentDatabase.assureUpdate("ObjectStore._classBecome()");
        this.schemaManager.doClassBecome(table);
    }

    @Override
    public void serverRenameClass(String oldClassName, String newClassName) {
        this.currentDatabase.assureUpdate("ObjectStore._renameClass()");
        this.schemaManager.doRenameClass(oldClassName, newClassName);
    }

    @Override
    public void serverDeleteClass(String className) {
        this.currentDatabase.assureUpdate("ObjectStore._deleteClass()");
        this.schemaManager.doDeleteClass(className);
    }

    @Override
    protected void serverGetCounters(Properties props, boolean reset) {
        if (this.currentDatabase != null) {
            this.objectTable.getCounters(props, reset);
        }
    }

    @Override
    public Database getCurrentDatabase() {
        return this.currentDatabase;
    }

    long allocateTransactionId() {
        return this.nextTransactionId++;
    }

    @Override
    public void join() {
    }

    @Override
    public void leave() {
    }

    @Override
    public int getCacheSize() {
        return -1;
    }

    @Override
    public void setLockTimeout(int milliseconds) {
        this.objectTable.setLockTimeout(milliseconds);
    }

    @Override
    public int getLockTimeout() {
        return this.objectTable.getLockTimeout();
    }

    @Override
    public int getPageSize() {
        throw new ObjectStoreException("getPageSize is not implemented in PSE/PSE-PRO; no concept of pages");
    }
}

