/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.AccessViolationException;
import com.odi.DatabaseFormatException;
import com.odi.DatabaseNotFoundException;
import com.odi.DeadlockException;
import com.odi.FatalInternalException;
import com.odi.LockTimeoutException;
import com.odi.LockWaitInterruptedException;
import com.odi.ObjectException;
import com.odi.ObjectNotFoundException;
import com.odi.Placement;
import com.odi.Session;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Utilities;
import com.odi.imp.mtsonic.Lock;
import com.odi.imp.mtsonic.ObjectAccess8ByteObjRefFormat;
import com.odi.imp.mtsonic.SchemaManager;
import com.sonicsw.mtstorage.AbstractBTreeIterator;
import com.sonicsw.mtstorage.BTreeLockNeededException;
import com.sonicsw.mtstorage.IBTreeManager;
import com.sonicsw.mtstorage.IObjectInfo;
import com.sonicsw.mtstorage.IStorage;
import com.sonicsw.mtstorage.StorageFileDoesNotExistException;
import com.sonicsw.mtstorage.StorageFormatException;
import com.sonicsw.mtstorage.impl.Storage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;

class StorageObject {
    private static final int REF_LENGTH = 8;
    private boolean m_explicitStorageOpen;
    private IStorage storage;
    private IBTreeManager m_btreeManager;
    private static final boolean DO_TRACE = false;
    private static boolean TRACE_LOCKING = false;
    private static final String SINGLE_UPDATE_TRANSACTION = "SINGLE_UPDATE_TRANSACTION";
    private SchemaManager m_schemaManager;
    private ObjectAccess8ByteObjRefFormat objectAccess;
    private Lock m_lock;
    private String m_dataFilePathname;
    private int m_databaseID;
    private long m_databaseHeaderOID;
    private long[] m_idList;
    private int m_position;
    private long m_allocateCount_statistics = 0L;
    private long m_deletedBytes_statistics = 0L;
    private long m_deletedCount_statistics = 0L;
    private long m_readBytes_statistics = 0L;
    private long m_readCount_statistics = 0L;
    private long m_writeBytes_statistics = 0L;
    private long m_writeCount_statistics = 0L;
    private long m_transactionCount_statistics = 0L;
    private boolean m_singleUpdateTransaction = false;

    StorageObject() {
    }

    public static void main(String[] args) throws Exception {
        long TIMEOUT = 1000000000L;
        final StorageObject st = new StorageObject();
        st.init(null, null, null, null);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("BTREE_LOCKING_LEVEL", new Integer(2));
        st.openDatabase("/usr1/udi/btree_test", true, true, params);
        Long transID = st.begin(7);
        final long treeDbk = st.createBTree(transID, false, 1000000000L, "pathInfo");
        byte[] key = new byte[1];
        byte[] value = new byte[8];
        for (int i = 1; i < 10; ++i) {
            System.out.println("main loop  put " + i);
            value[0] = (byte)i;
            st.put(transID, treeDbk, key, value, 1000000000L, "pathInfo");
        }
        st.commit(transID);
        st.releaseAllLocks(transID, false);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Long transID1 = st.begin(7);
                    byte[] key1 = new byte[1];
                    byte[] value1 = new byte[8];
                    value1[0] = 1;
                    System.out.println("T contains " + st.contains(transID1, treeDbk, key1, value1, 1000000000L, "pathInfo"));
                    byte[] value2 = new byte[8];
                    value2[0] = 3;
                    System.out.println("T contains " + st.contains(transID1, treeDbk, key1, value2, 1000000000L, "pathInfo"));
                    StorageObject.doSleep(30);
                    st.commit(transID1);
                    st.releaseAllLocks(transID1, false);
                    System.out.println("T DONE");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        StorageObject.doSleep(7);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("T1 START");
                    Long transID1 = st.begin(7);
                    byte[] key1 = new byte[1];
                    byte[] value1 = new byte[8];
                    value1[0] = 2;
                    System.out.println("T1 BEFORE REMOVE");
                    st.remove(transID1, treeDbk, key1, value1, 1000000000L, "pathInfo");
                    System.out.println("T1 AFTER REMOVE");
                    st.commit(transID1);
                    System.out.println("T1 DONE");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t1.start();
    }

    static void doSleep(int sec) throws Exception {
        Thread.sleep(sec * 1000);
    }

    void init(IStorage physicalStorage, SchemaManager schemaManager, ObjectAccess8ByteObjRefFormat objectAccess, Properties plist_unused) {
        this.trace("init called.");
        if (physicalStorage == null) {
            this.m_explicitStorageOpen = false;
            this.storage = new Storage();
        } else {
            this.m_explicitStorageOpen = true;
            this.storage = physicalStorage;
        }
        this.m_schemaManager = schemaManager;
        this.objectAccess = objectAccess;
        this.m_idList = null;
    }

    void advance(Long transID, AbstractBTreeIterator iterator, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                this.m_btreeManager.advance(transID, iterator, pathInfo);
                return;
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    void remove(Long transID, long treeDbk, byte[] key, byte[] value, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                this.m_btreeManager.remove(transID, treeDbk, key, value, pathInfo, true);
                return;
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    byte[] remove(Long transID, long treeDbk, byte[] key, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                return this.m_btreeManager.remove(transID, treeDbk, key, pathInfo);
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    long createBTree(Long transID, boolean noDuplicates, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                return this.m_btreeManager.createBTree(transID, noDuplicates, pathInfo);
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    byte[] get(Long transID, long treeDbk, byte[] key, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                return this.m_btreeManager.get(transID, treeDbk, key, new byte[8], pathInfo);
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    byte[] getFirstKey(Long transID, long treeDbk, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                return this.m_btreeManager.getFirstKey(transID, treeDbk, pathInfo);
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    byte[] getLastKey(Long transID, long treeDbk, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                return this.m_btreeManager.getLastKey(transID, treeDbk, pathInfo);
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    boolean contains(Long transID, long treeDbk, byte[] key, byte[] value, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                return this.m_btreeManager.contains(transID, treeDbk, key, value, pathInfo);
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    boolean containsKey(Long transID, long treeDbk, byte[] key, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                return this.m_btreeManager.containsKey(transID, treeDbk, key, pathInfo);
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    byte[] put(Long transID, long treeDbk, byte[] key, byte[] value, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                return this.m_btreeManager.put(transID, treeDbk, key, value, pathInfo, true);
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    void clear(Long transID, long treeDbk, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                this.m_btreeManager.clear(transID, treeDbk, pathInfo, false);
                return;
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    void delete(Long transID, long treeDbk, long timeoutMillis, String pathInfo) throws Exception {
        while (true) {
            try {
                this.m_btreeManager.delete(transID, treeDbk, pathInfo, false);
                return;
            }
            catch (BTreeLockNeededException lockDetails) {
                this.storage.acquireLock(transID, lockDetails, timeoutMillis, pathInfo);
                continue;
            }
            break;
        }
    }

    long allocateObject(Long transID, int size, int AFT, int alignment_unused) throws IOException {
        String className = (String)this.m_schemaManager.AFTToClassName.get(new Integer(AFT));
        long dbk = StorageObject.storageDBKtoPSE(this.storage.allocate(transID, AFT, this.classTypeToPageType(AFT, className), size));
        this.trace("allocateObject called AFT: " + AFT + " size: " + size + " dbk " + dbk);
        ++this.m_allocateCount_statistics;
        return dbk;
    }

    public byte classTypeToPageType(int AFT, String className) {
        int pageType = 102;
        if (AFT == 12648450 || AFT == 12648463) {
            pageType = 101;
        } else if (className != null && className.startsWith("com.odi.util.BTree")) {
            pageType = 100;
        }
        return (byte)pageType;
    }

    void backup(String backupDBPath) throws IOException {
        this.storage.backup(backupDBPath);
    }

    void deleteObject(Long transID, long oid, boolean notUsed_checkLive) throws IOException {
        this.trace("deleteObject called oid: " + oid);
        this.m_deletedBytes_statistics += this.storage.delete(transID, StorageObject.PSEToStorageDBK(oid));
        ++this.m_deletedCount_statistics;
    }

    int getObjectSize(Long transSnapID, long oid) throws IOException {
        this.trace("getObjectSize called oid: " + oid);
        IObjectInfo objectInfo = this.storage.get(transSnapID, StorageObject.PSEToStorageDBK(oid));
        return objectInfo.getSize();
    }

    void readObject(Long transSnapID, long oid, byte[] rep, int size) throws IOException {
        this.trace("readObject called oid: " + oid + " buffer length: " + rep.length);
        IObjectInfo objectInfo = this.storage.get(transSnapID, StorageObject.PSEToStorageDBK(oid), rep, 0);
        if (objectInfo == null) {
            throw new ObjectNotFoundException("Object " + ObjRefUtils.OIDString(oid) + " was not found.");
        }
        if (size != objectInfo.getSize()) {
            throw new Error("Size mismatch");
        }
        this.trace("readObject object size: " + size);
        this.trace("readObject done");
        this.m_readBytes_statistics += (long)size;
        ++this.m_readCount_statistics;
    }

    void writeObject(Long transID, long oid, int header_unused, byte[] rep, int size, int alignment_unused) throws IOException {
        this.trace("writeObject called oid: " + oid + " size: " + size);
        this.storage.update(transID, StorageObject.PSEToStorageDBK(oid), rep, 0, size);
        this.trace("writeObject " + oid + " done");
        this.m_writeBytes_statistics += (long)size;
        ++this.m_writeCount_statistics;
    }

    private static boolean isNonBlocking(int type) {
        return type == 5 || type == 4;
    }

    private static boolean isForWrite(int type) {
        return type == 7 || type == 4;
    }

    Long createSnapshot() throws IOException {
        return this.storage.createSnapshot();
    }

    void deleteSnapshot(Long snapshotID) throws IOException {
        this.storage.deleteSnapshot(snapshotID);
    }

    Long begin(int type) {
        this.trace("begin called transaction type: " + type);
        try {
            if (!this.storage.isOpen()) {
                return null;
            }
            boolean writeTransaction = StorageObject.isForWrite(type);
            ++this.m_transactionCount_statistics;
            this.m_lock.lock(ObjectManager.getCurrent(), writeTransaction, StorageObject.isNonBlocking(type));
            if (writeTransaction) {
                return this.storage.begin();
            }
            return this.storage.beginReadonly();
        }
        catch (IOException e) {
            this.m_lock.unlock(ObjectManager.getCurrent());
            e.printStackTrace();
            throw new FatalInternalException("Could not begin a transaction: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Long transID) throws IOException {
        this.trace("commit called.");
        try {
            if (this.storage.isOpen()) {
                this.storage.commit(transID);
            }
        }
        finally {
            this.m_lock.unlock(ObjectManager.getCurrent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(Long transID) throws IOException {
        this.trace("abort called.");
        try {
            if (this.storage.isOpen()) {
                this.storage.rollback(transID);
            }
        }
        finally {
            this.m_lock.unlock(ObjectManager.getCurrent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDatabase(String dataFilePathname, boolean openForWrite, boolean createDB, HashMap parameters) throws IOException {
        this.trace("openDatabase called file:  " + dataFilePathname + " openForWrite " + openForWrite);
        this.m_singleUpdateTransaction = false;
        Boolean singleUpdateTransaction = null;
        if (parameters != null) {
            singleUpdateTransaction = (Boolean)parameters.get(SINGLE_UPDATE_TRANSACTION);
        }
        if (singleUpdateTransaction != null) {
            this.m_singleUpdateTransaction = singleUpdateTransaction;
        }
        this.m_lock = new Lock(dataFilePathname, this.m_singleUpdateTransaction);
        this.m_dataFilePathname = dataFilePathname;
        if (!this.m_explicitStorageOpen && this.storage.isOpen()) {
            throw new FatalInternalException(dataFilePathname + " is already open. ");
        }
        try {
            this.m_lock.lock(ObjectManager.getCurrent(), true, false);
            if (!this.m_explicitStorageOpen) {
                this.storage.open(this.m_dataFilePathname, createDB, parameters != null ? parameters : new HashMap());
            }
            this.m_btreeManager = this.storage.getBTreeManager();
        }
        catch (StorageFileDoesNotExistException e) {
            throw new DatabaseNotFoundException(e.getMessage());
        }
        catch (StorageFormatException se) {
            throw new DatabaseFormatException(se.getMessage());
        }
        catch (IOException ioe) {
            this.throwDatabaseException(ioe, openForWrite, createDB);
        }
        finally {
            this.m_lock.unlock(ObjectManager.getCurrent());
        }
    }

    private void throwDatabaseException(IOException exception, boolean openForWrite, boolean createDB) {
        File dirPath;
        File data = new File(this.m_dataFilePathname);
        File absPath = new File(data.getAbsolutePath());
        String dir = absPath.getParent();
        if (dir == null) {
            dir = File.separator;
        }
        if (!(dirPath = new File(dir)).exists()) {
            if (createDB) {
                throw new AccessViolationException("Directory " + dirPath + " does not exist.");
            }
            throw new DatabaseNotFoundException("Directory " + dirPath + " does not exist.");
        }
        if ((createDB || openForWrite) && !dirPath.canWrite()) {
            throw new AccessViolationException("Directory " + dirPath + " is not writable.");
        }
        throw new AccessViolationException("Access violation for " + this.m_dataFilePathname + " Exception was " + exception.toString());
    }

    void openDatabase(String dataFilePathname, boolean openForWrite, HashMap parameters, int upgradeType_not_used, boolean exclusive_always_false) throws IOException {
        this.openDatabase(dataFilePathname, openForWrite, false, parameters);
    }

    void closeDatabase() throws IOException {
        this.trace("closeDatabase called");
        this.closeDatabase(ObjectManager.getCurrent());
    }

    void closeDatabase(Session sess) throws IOException {
        this.trace("closeDatabase called session:  " + sess);
        if (!this.m_explicitStorageOpen) {
            this.storage.close();
        }
    }

    void resync() {
        this.trace("resync called ");
    }

    void createDatabase(String dataFilePathname, HashMap parameters) throws IOException {
        this.trace("createDatabase called file:  " + dataFilePathname);
        this.openDatabase(dataFilePathname, true, true, parameters);
    }

    String getPathname() {
        this.trace("getPathname called return: " + this.m_dataFilePathname);
        return this.m_dataFilePathname;
    }

    void destroyDatabase() throws IOException {
        this.trace("destroyDatabase called");
        this.storage.destroy();
    }

    long databaseGetSizeInBytes() {
        this.trace("databaseGetSizeInBytes called");
        try {
            return this.storage.getStorageSize();
        }
        catch (IOException e) {
            throw new FatalInternalException(e.toString());
        }
    }

    void checkLive(Long transSnapID, long oid) {
        this.trace("checkALive called oid: " + oid);
        try {
            IObjectInfo objectInfo = this.storage.get(transSnapID, StorageObject.PSEToStorageDBK(oid));
            if (objectInfo == null) {
                throw new ObjectNotFoundException("Object " + ObjRefUtils.OIDString(oid) + " was not found.");
            }
        }
        catch (IOException e) {
            throw new FatalInternalException(e.toString());
        }
    }

    long databaseGetHeader() {
        this.trace("databaseGetSizeInBytes called");
        return this.m_databaseHeaderOID;
    }

    void databaseSetHeader(long oid) {
        this.trace("databaseSetHeader called");
        this.m_databaseHeaderOID = oid;
    }

    ObjectReference getObjRef(Long transSnapID, long oid, Placement place, MutatingObjRef objRef) throws IOException {
        objRef.setObjectId(place, oid);
        IObjectInfo objectInfo = this.storage.get(transSnapID, StorageObject.PSEToStorageDBK(oid));
        if (objectInfo == null) {
            throw new ObjectNotFoundException("Object " + ObjRefUtils.OIDString(oid) + " was not found.");
        }
        int AFT = objectInfo.getClassType();
        int dataSize = objectInfo.getSize();
        this.trace("getObjRef called oid: " + oid + " AFT: " + AFT + " size: " + dataSize);
        objRef.AFTypeCode = AFT;
        objRef.arrayElementCount = Utilities.isArrayTypeCode(AFT) ? dataSize / this.objectAccess.arrayElementSize(AFT) : 0;
        return objRef;
    }

    long nextValidOid(long oid) throws IOException {
        this.trace("nextValidOid called oid: " + oid);
        if (oid == -1L) {
            this.m_idList = this.storage.getList();
            this.m_position = 0;
        } else if (this.m_position == this.m_idList.length) {
            this.m_idList = null;
            return -1L;
        }
        long longDbk = this.m_idList[this.m_position++];
        return StorageObject.storageDBKtoPSE(longDbk);
    }

    long nextValidOid(Long transSnapID, long oid, int[] sizes) throws IOException {
        this.trace("nextValidOid with sizes called oid: " + oid);
        oid = this.nextValidOid(oid);
        while (oid != -1L) {
            IObjectInfo objectInfo = this.storage.get(transSnapID, StorageObject.PSEToStorageDBK(oid));
            if (objectInfo == null) {
                throw new ObjectNotFoundException("Object " + ObjRefUtils.OIDString(oid) + " was not found.");
            }
            int size = objectInfo.getSize();
            int max = sizes.length;
            for (int i = 0; i < max; ++i) {
                if (size != sizes[i]) continue;
                return oid;
            }
            oid = this.nextValidOid(oid);
        }
        return -1L;
    }

    public boolean hasLock(Session sess) {
        this.trace("hasLock called");
        return this.m_lock.hasLock(sess);
    }

    int getArrayElementCount(Long transSnapID, long oid, int AFTypeCode) {
        try {
            IObjectInfo objectInfo = this.storage.get(transSnapID, StorageObject.PSEToStorageDBK(oid));
            int elementSize = this.m_schemaManager.linearRepSize(AFTypeCode, 1);
            int arraySize = objectInfo.getSize() / elementSize;
            this.trace("getArrayElementCount called return: " + arraySize);
            return arraySize;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    void trace(String message) {
    }

    Properties GC(Properties GCProperties) {
        throw new Error("Not supported");
    }

    public long getStorageOffset(Long transSnapID, long oid) {
        try {
            IObjectInfo objectInfo = this.storage.get(transSnapID, StorageObject.PSEToStorageDBK(oid));
            if (objectInfo == null) {
                throw new ObjectNotFoundException("Object " + ObjRefUtils.OIDString(oid) + " was not found.");
            }
        }
        catch (IOException e) {
            throw new FatalInternalException(e.toString());
        }
        return oid;
    }

    void doInstanceBecome(long otherOID, long thisOID) {
        throw new Error("Used only for object schema upgrades.");
    }

    void upgradeComplete() throws IOException {
        throw new Error("Used only upgrades.");
    }

    int getUpgradeType() {
        return 0;
    }

    void getMetrics(Properties props) {
        if (this.storage != null) {
            this.storage.getMetrics(props, this.m_dataFilePathname);
        }
        props.setProperty(this.m_dataFilePathname + ".allocateCount_statistics", new Long(this.m_allocateCount_statistics).toString());
        props.setProperty(this.m_dataFilePathname + ".deletedBytes_statistics", new Long(this.m_deletedBytes_statistics).toString());
        props.setProperty(this.m_dataFilePathname + ".deletedCount_statistics", new Long(this.m_deletedCount_statistics).toString());
        props.setProperty(this.m_dataFilePathname + ".readBytes_statistics", new Long(this.m_readBytes_statistics).toString());
        props.setProperty(this.m_dataFilePathname + ".readCount_statistics", new Long(this.m_readCount_statistics).toString());
        props.setProperty(this.m_dataFilePathname + ".writeBytes_statistics", new Long(this.m_writeBytes_statistics).toString());
        props.setProperty(this.m_dataFilePathname + ".writeCount_statistics", new Long(this.m_writeCount_statistics).toString());
        props.setProperty(this.m_dataFilePathname + ".transactionCount_statistics", new Long(this.m_transactionCount_statistics).toString());
    }

    int getNDeadOTEs() {
        this.trace("getNDeadOTEs called");
        return 0;
    }

    void validate(Long transSnapID, long oid, int refAFT) throws IOException {
        IObjectInfo objectInfo = this.storage.get(transSnapID, StorageObject.PSEToStorageDBK(oid));
        if (objectInfo == null) {
            throw new ObjectNotFoundException("object " + ObjRefUtils.OIDString(oid) + " was not found.");
        }
        if (refAFT == 17) {
            return;
        }
        int targetAFT = objectInfo.getClassType();
        if (refAFT != targetAFT) {
            throw new ObjectException("the type: " + refAFT + " associated with the reference, " + "does not match the type of the referred to object: " + targetAFT);
        }
    }

    private static long storageDBKtoPSE(long dbkey) {
        if (dbkey == 1L) {
            return 0L;
        }
        return dbkey;
    }

    private static long PSEToStorageDBK(long dbkey) {
        if (dbkey == 0L) {
            return 1L;
        }
        return dbkey;
    }

    public void acquireLock(Object lockOwner, long oid, int lockmode, long timeoutMillis) {
        try {
            int objectType = 0;
            String className = null;
            if (TRACE_LOCKING) {
                try {
                    IObjectInfo objectInfo = this.storage.get(null, StorageObject.PSEToStorageDBK(oid));
                    objectType = objectInfo.getClassType();
                    className = (String)this.m_schemaManager.AFTToClassName.get(new Integer(objectType));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!this.m_singleUpdateTransaction) {
                this.storage.acquireLock(lockOwner, StorageObject.PSEToStorageDBK(oid), StorageObject.lockModeToStorageLockMode(lockmode), timeoutMillis, objectType, className);
            }
        }
        catch (com.sonicsw.mtstorage.DeadlockException ex) {
            throw new DeadlockException(ex.toString());
        }
        catch (com.sonicsw.mtstorage.LockTimeoutException ex) {
            throw new LockTimeoutException(ex.toString(), null, lockmode);
        }
        catch (com.sonicsw.mtstorage.LockWaitInterruptedException ex1) {
            throw new LockWaitInterruptedException(ex1.toString());
        }
    }

    public void releaseAllLocks(Object lockOwner, boolean convertToCacheLocks) {
        if (!this.m_singleUpdateTransaction) {
            this.storage.releaseAllLocks(lockOwner, convertToCacheLocks);
        }
    }

    public void releaseLock(Object lockOwner, long oid) {
        if (!this.m_singleUpdateTransaction) {
            this.storage.releaseLock(lockOwner, StorageObject.PSEToStorageDBK(oid));
        }
    }

    private static int lockModeToStorageLockMode(int lockMode) {
        int result = 1;
        if (lockMode == 6) {
            result = 1;
        } else if (lockMode == 7) {
            result = 2;
        }
        return result;
    }

    static {
        String temp = System.getProperty("_PSETraceLocking");
        if (temp != null && temp.equalsIgnoreCase("true")) {
            TRACE_LOCKING = true;
            System.out.println("Warning: Deadlock tracer is on! Expect some small performance impact. ");
        }
    }

    public static class ObjectEntry
    implements Serializable {
        public int m_size;
        public int m_AFT;
        public byte[] m_rep;

        public ObjectEntry() {
        }

        ObjectEntry(int size, int AFT) {
            this.m_size = size;
            this.m_AFT = AFT;
            this.m_rep = new byte[size];
        }

        void setRep(byte[] rep) {
            this.m_rep = new byte[rep.length];
            System.arraycopy(rep, 0, this.m_rep, 0, rep.length);
        }
    }
}

