/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.imp.ReferenceType;
import com.odi.util.AbstractNodeFactory;
import com.odi.util.BTreeImpl;
import com.odi.util.BTreeLeafNode;
import com.odi.util.BTreeNode;
import com.odi.util.KeyType;
import com.odi.util.LazyMapMap;
import java.lang.reflect.Constructor;

public class BTreeNodeFactory {
    public static BTreeNodeFactory instance = new BTreeNodeFactory();
    private static LazyMapMap nodeFactories = new NodeFactoryMap();
    private static LazyMapMap leafNodeFactories = new LeafNodeFactoryMap();

    private BTreeNodeFactory() {
    }

    public static BTreeNode createNode(BTreeImpl btree, BTreeNode parent, boolean isLeaf) {
        return isLeaf ? BTreeNodeFactory.createLeafNode(btree, parent) : BTreeNodeFactory.createNonLeafNode(btree, parent);
    }

    public static String newNodeClassName(BTreeImpl btree, BTreeNode parent, boolean isLeaf) {
        return isLeaf ? BTreeNodeFactory.newLeafNodeClassName(parent.leafChildRefType(), parent.KEYTYPE(), btree) : BTreeNodeFactory.newNodeClassName(parent.nonLeafChildRefType(), parent.KEYTYPE(), btree);
    }

    public static BTreeNode createTopNode(BTreeImpl btree) {
        BTreeNodeFactory.newNode(btree.getTopNodeType(), btree.getKeyType(), btree);
        return BTreeNodeFactory.newLeafNode(btree.getTopNodeType(), btree.getKeyType(), btree);
    }

    static BTreeNode createNonLeafNode(BTreeImpl btree, BTreeNode parent) {
        return BTreeNodeFactory.newNode(parent.nonLeafChildRefType(), parent.KEYTYPE(), btree);
    }

    static BTreeLeafNode createLeafNode(BTreeImpl btree, BTreeNode parent) {
        return BTreeNodeFactory.newLeafNode(parent.leafChildRefType(), parent.KEYTYPE(), btree);
    }

    private static BTreeNode newNode(ReferenceType refType, KeyType keyType, BTreeImpl btree) {
        return ((AbstractNodeFactory)nodeFactories.get(refType, keyType, null)).createNode(btree);
    }

    private static BTreeLeafNode newLeafNode(ReferenceType refType, KeyType keyType, BTreeImpl btree) {
        return (BTreeLeafNode)((AbstractNodeFactory)leafNodeFactories.get(refType, keyType, null)).createNode(btree);
    }

    private static Class newNodeClass(ReferenceType refType, KeyType keyType, BTreeImpl btree) {
        return ((AbstractNodeFactory)nodeFactories.get(refType, keyType, null)).getNodeClass();
    }

    private static String newNodeClassName(ReferenceType refType, KeyType keyType, BTreeImpl btree) {
        return BTreeNodeFactory.newNodeClass(refType, keyType, btree).getName();
    }

    private static Class factoryClass(ReferenceType refType, KeyType keyType) {
        return nodeFactories.get(refType, keyType, null).getClass();
    }

    private static String newLeafNodeClassName(ReferenceType refType, KeyType keyType, BTreeImpl btree) {
        return BTreeNodeFactory.newLeafNodeClass(refType, keyType, btree).getName();
    }

    private static Class newLeafNodeClass(ReferenceType refType, KeyType keyType, BTreeImpl btree) {
        return ((AbstractNodeFactory)leafNodeFactories.get(refType, keyType, null)).getNodeClass();
    }

    private static Class leafFactoryClass(ReferenceType refType, KeyType keyType) {
        return leafNodeFactories.get(refType, keyType, null).getClass();
    }

    static AbstractNodeFactory createNodeFactory(Object refType, Object keyType) {
        ReferenceType _refType = (ReferenceType)refType;
        KeyType _keyType = (KeyType)keyType;
        return new NodeFactoryImpl(_refType, _keyType);
    }

    static AbstractNodeFactory createLeafNodeFactory(Object refType, Object keyType) {
        ReferenceType _refType = (ReferenceType)refType;
        KeyType _keyType = (KeyType)keyType;
        return new LeafNodeFactoryImpl(_refType, _keyType);
    }

    private static int extractRefEnum(Class clazz) {
        String className = clazz.getName();
        int start = className.indexOf("__ref_");
        int end = className.indexOf("__key");
        if (start == -1 || end == -1) {
            throw new FatalInternalException("invalid node factory class " + className);
        }
        return Integer.parseInt(className.substring(start += 6, end));
    }

    private static int extractKeyEnum(Class clazz) {
        String className = clazz.getName();
        int start = className.indexOf("__key_");
        int end = className.length();
        if (start == -1) {
            throw new FatalInternalException("invalid node factory class " + className);
        }
        return Integer.parseInt(className.substring(start += 6, end));
    }

    private static String makeNodeClassName(int refEnum, int keyEnum) {
        return "com.odi.util.BTreeNodeFactory$BTreeNode__ref_" + refEnum + "__key_" + keyEnum;
    }

    private static String makeLeafNodeClassName(int refEnum, int keyEnum) {
        return "com.odi.util.BTreeNodeFactory$BTreeLeafNode__ref_" + refEnum + "__key_" + keyEnum;
    }

    private static Class findNodeClass(int refEnum, int keyEnum) {
        try {
            return Class.forName(BTreeNodeFactory.makeNodeClassName(refEnum, keyEnum));
        }
        catch (Exception e) {
            throw new FatalInternalException("Can not locate node class for ref=" + refEnum + " and key=" + keyEnum + ":" + e);
        }
    }

    private static Class findLeafNodeClass(int refEnum, int keyEnum) {
        try {
            return Class.forName(BTreeNodeFactory.makeLeafNodeClassName(refEnum, keyEnum));
        }
        catch (Exception e) {
            throw new FatalInternalException("Can not locate node class for ref=" + refEnum + " and key=" + keyEnum + ":" + e);
        }
    }

    private static BTreeNode newNodeInstance(Class nodeClass, BTreeImpl btree) {
        try {
            Constructor ctor = nodeClass.getConstructor(BTreeImpl.class);
            return (BTreeNode)ctor.newInstance(btree);
        }
        catch (Exception e) {
            throw new FatalInternalException("Can not create new node class " + nodeClass.getName() + ":" + e);
        }
    }

    private static BTreeNode newNodeInstance(Class nodeClass) {
        try {
            return (BTreeNode)nodeClass.newInstance();
        }
        catch (Exception e) {
            throw new FatalInternalException("Can not create new node class " + nodeClass.getName() + ":" + e);
        }
    }

    private static void bootstrap(ReferenceType refType, KeyType keyType) {
        String nodeClass = BTreeNodeFactory.makeNodeClassName(refType.getEnumeratedValue(), keyType.getEnumeratedValue());
        BTreeNode.getClassInfo(nodeClass, refType, keyType);
        String leafNodeClass = BTreeNodeFactory.makeLeafNodeClassName(refType.getEnumeratedValue(), keyType.getEnumeratedValue());
        BTreeLeafNode.getClassInfo(leafNodeClass, refType, keyType);
    }

    static /* synthetic */ int access$400(Class x0) {
        return BTreeNodeFactory.extractRefEnum(x0);
    }

    static /* synthetic */ int access$500(Class x0) {
        return BTreeNodeFactory.extractKeyEnum(x0);
    }

    static {
        BTreeNodeFactory.bootstrap(ReferenceType.REF_4BYTE_LOCAL, KeyType.KEY_4BYTE);
        BTreeNodeFactory.bootstrap(ReferenceType.REF_4BYTE_LOCAL, KeyType.KEY_8BYTE);
        BTreeNodeFactory.bootstrap(ReferenceType.REF_4BYTE_LOCAL, KeyType.VARKEY_4BYTEREF);
        BTreeNodeFactory.bootstrap(ReferenceType.REF_4BYTE_LOCAL, KeyType.VARKEY_8BYTEREF);
        BTreeNodeFactory.bootstrap(ReferenceType.REF_8BYTE_LOCAL, KeyType.KEY_4BYTE);
        BTreeNodeFactory.bootstrap(ReferenceType.REF_8BYTE_LOCAL, KeyType.KEY_8BYTE);
        BTreeNodeFactory.bootstrap(ReferenceType.REF_8BYTE_LOCAL, KeyType.VARKEY_4BYTEREF);
        BTreeNodeFactory.bootstrap(ReferenceType.REF_8BYTE_LOCAL, KeyType.VARKEY_8BYTEREF);
    }

    public static class BTreeLeafNode__ref_2__key_4
    extends BTreeLeafNodeImpl {
        public BTreeLeafNode__ref_2__key_4() {
        }

        public BTreeLeafNode__ref_2__key_4(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeLeafNode__ref_2__key_4(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeLeafNode__ref_2__key_3
    extends BTreeLeafNodeImpl {
        public BTreeLeafNode__ref_2__key_3() {
        }

        public BTreeLeafNode__ref_2__key_3(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeLeafNode__ref_2__key_3(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeLeafNode__ref_2__key_2
    extends BTreeLeafNodeImpl {
        public BTreeLeafNode__ref_2__key_2() {
        }

        public BTreeLeafNode__ref_2__key_2(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeLeafNode__ref_2__key_2(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeLeafNode__ref_2__key_1
    extends BTreeLeafNodeImpl {
        public BTreeLeafNode__ref_2__key_1() {
        }

        public BTreeLeafNode__ref_2__key_1(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeLeafNode__ref_2__key_1(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeLeafNode__ref_1__key_4
    extends BTreeLeafNodeImpl {
        public BTreeLeafNode__ref_1__key_4() {
        }

        public BTreeLeafNode__ref_1__key_4(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeLeafNode__ref_1__key_4(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeLeafNode__ref_1__key_3
    extends BTreeLeafNodeImpl {
        public BTreeLeafNode__ref_1__key_3() {
        }

        public BTreeLeafNode__ref_1__key_3(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeLeafNode__ref_1__key_3(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeLeafNode__ref_1__key_2
    extends BTreeLeafNodeImpl {
        public BTreeLeafNode__ref_1__key_2() {
        }

        public BTreeLeafNode__ref_1__key_2(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeLeafNode__ref_1__key_2(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeLeafNode__ref_1__key_1
    extends BTreeLeafNodeImpl {
        public BTreeLeafNode__ref_1__key_1() {
        }

        public BTreeLeafNode__ref_1__key_1(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeLeafNode__ref_1__key_1(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeNode__ref_2__key_4
    extends BTreeNodeImpl {
        public BTreeNode__ref_2__key_4() {
        }

        public BTreeNode__ref_2__key_4(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeNode__ref_2__key_4(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeNode__ref_2__key_3
    extends BTreeNodeImpl {
        public BTreeNode__ref_2__key_3() {
        }

        public BTreeNode__ref_2__key_3(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeNode__ref_2__key_3(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeNode__ref_2__key_2
    extends BTreeNodeImpl {
        public BTreeNode__ref_2__key_2() {
        }

        public BTreeNode__ref_2__key_2(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeNode__ref_2__key_2(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeNode__ref_2__key_1
    extends BTreeNodeImpl {
        public BTreeNode__ref_2__key_1() {
        }

        public BTreeNode__ref_2__key_1(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeNode__ref_2__key_1(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeNode__ref_1__key_4
    extends BTreeNodeImpl {
        public BTreeNode__ref_1__key_4() {
        }

        public BTreeNode__ref_1__key_4(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeNode__ref_1__key_4(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeNode__ref_1__key_3
    extends BTreeNodeImpl {
        public BTreeNode__ref_1__key_3() {
        }

        public BTreeNode__ref_1__key_3(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeNode__ref_1__key_3(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeNode__ref_1__key_2
    extends BTreeNodeImpl {
        public BTreeNode__ref_1__key_2() {
        }

        public BTreeNode__ref_1__key_2(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeNode__ref_1__key_2(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static class BTreeNode__ref_1__key_1
    extends BTreeNodeImpl {
        public BTreeNode__ref_1__key_1() {
        }

        public BTreeNode__ref_1__key_1(ClassInfo cinfo) {
            super(cinfo);
        }

        public BTreeNode__ref_1__key_1(BTreeImpl cinfo) {
            super(cinfo);
        }
    }

    public static abstract class BTreeLeafNodeImpl
    extends BTreeLeafNode {
        private final transient ReferenceType _refType = ReferenceType.getReferenceType(BTreeNodeFactory.access$400(this.getClass()));
        private final transient KeyType _keyType = KeyType.getKeyType(BTreeNodeFactory.access$500(this.getClass()));
        private final transient ClassInfo linfo = BTreeLeafNode.getClassInfo(this.getClass(), this._refType, this._keyType);

        @Override
        final ClassInfo getClassInfo() {
            return this.linfo;
        }

        protected BTreeLeafNodeImpl() {
        }

        protected BTreeLeafNodeImpl(ClassInfo cinfo) {
            super(cinfo);
        }

        protected BTreeLeafNodeImpl(BTreeImpl btreeImpl) {
            super(btreeImpl);
        }

        @Override
        public final KeyType KEYTYPE() {
            return this._keyType;
        }

        @Override
        public final ReferenceType REFTYPE() {
            return this._refType;
        }
    }

    public static abstract class BTreeNodeImpl
    extends BTreeNode {
        private final transient ReferenceType _refType = ReferenceType.getReferenceType(BTreeNodeFactory.access$400(this.getClass()));
        private final transient KeyType _keyType = KeyType.getKeyType(BTreeNodeFactory.access$500(this.getClass()));
        private final transient ClassInfo cinfo = BTreeNode.getClassInfo(this.getClass(), this._refType, this._keyType);

        @Override
        final ClassInfo getClassInfo() {
            return this.cinfo;
        }

        protected BTreeNodeImpl() {
        }

        protected BTreeNodeImpl(ClassInfo cinfo) {
            super(cinfo);
        }

        protected BTreeNodeImpl(BTreeImpl btreeImpl) {
            super(btreeImpl);
        }

        @Override
        public final KeyType KEYTYPE() {
            return this._keyType;
        }

        @Override
        public final ReferenceType REFTYPE() {
            return this._refType;
        }
    }

    public static class LeafNodeFactoryImpl
    extends AbstractNodeFactory {
        private final Class nodeClass;

        LeafNodeFactoryImpl(ReferenceType refType, KeyType keyType) {
            this.nodeClass = BTreeNodeFactory.findLeafNodeClass(refType.getEnumeratedValue(), keyType.getEnumeratedValue());
        }

        @Override
        public final BTreeNode createNode(BTreeImpl btree) {
            if (btree == null) {
                return BTreeNodeFactory.newNodeInstance(this.nodeClass);
            }
            return BTreeNodeFactory.newNodeInstance(this.nodeClass, btree).init();
        }

        @Override
        public final Class getNodeClass() {
            return this.nodeClass;
        }
    }

    public static class NodeFactoryImpl
    extends AbstractNodeFactory {
        private final Class nodeClass;

        NodeFactoryImpl(ReferenceType refType, KeyType keyType) {
            this.nodeClass = BTreeNodeFactory.findNodeClass(refType.getEnumeratedValue(), keyType.getEnumeratedValue());
        }

        @Override
        public final BTreeNode createNode(BTreeImpl btree) {
            if (btree == null) {
                return BTreeNodeFactory.newNodeInstance(this.nodeClass);
            }
            return BTreeNodeFactory.newNodeInstance(this.nodeClass, btree).init();
        }

        @Override
        public final Class getNodeClass() {
            return this.nodeClass;
        }
    }

    static class LeafNodeFactoryMap
    extends LazyMapMap {
        LeafNodeFactoryMap() {
        }

        @Override
        public Object createNew(Object refType, Object keyType, Object[] ignored) {
            return BTreeNodeFactory.createLeafNodeFactory(refType, keyType);
        }
    }

    static class NodeFactoryMap
    extends LazyMapMap {
        NodeFactoryMap() {
        }

        @Override
        public Object createNew(Object refType, Object keyType, Object[] ignored) {
            return BTreeNodeFactory.createNodeFactory(refType, keyType);
        }
    }
}

