/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.imp.Utilities;
import com.odi.util.IndexException;
import com.odi.util.Path;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IndexDescriptor
implements Serializable {
    static final long serialVersionUID = 5029835408714163055L;
    private String pathstring;
    private Class elementclass;
    private boolean isOrdered;
    private boolean allowsDuplicates;

    public String toString() {
        return "<index on " + this.elementclass.getName() + "." + this.pathstring + ", " + (this.isOrdered ? "ordered, " : "unordered, ") + (this.allowsDuplicates ? "duplicates" : "no duplicates") + ">";
    }

    public String pathString() {
        return this.pathstring;
    }

    public Class elementClass() {
        return this.elementclass;
    }

    public boolean ordered() {
        return this.isOrdered;
    }

    public boolean duplicates() {
        return this.allowsDuplicates;
    }

    public IndexDescriptor(Class elementClass, String pathString, boolean ordered, boolean duplicates) {
        this.elementclass = elementClass;
        this.pathstring = pathString;
        this.isOrdered = ordered;
        this.allowsDuplicates = duplicates;
    }

    public IndexDescriptor(Path path, boolean ordered, boolean duplicates) {
        this.elementclass = path.getElementType();
        this.pathstring = path.getPathString();
        this.isOrdered = ordered;
        this.allowsDuplicates = duplicates;
    }

    public int hashCode() {
        return this.elementclass.hashCode() + this.pathstring.hashCode() + (this.isOrdered ? 7 : 11) + (this.allowsDuplicates ? 13 : 17);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndexDescriptor)) {
            return false;
        }
        IndexDescriptor that = (IndexDescriptor)obj;
        return this.elementclass.equals(that.elementclass) && this.pathstring.equals(that.pathstring) && this.allowsDuplicates == that.allowsDuplicates && this.isOrdered == that.isOrdered;
    }

    public boolean isSupersetOf(IndexDescriptor other) {
        return this.elementclass.isAssignableFrom(other.elementclass) && this.pathstring.equals(other.pathstring) && (!this.isOrdered || other.isOrdered);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.pathstring);
        out.writeUTF(this.elementclass.getName());
        out.writeBoolean(this.isOrdered);
        out.writeBoolean(this.allowsDuplicates);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.pathstring = in.readUTF();
        String classString = in.readUTF();
        try {
            this.elementclass = Utilities.findClass(classString);
        }
        catch (ClassNotFoundException e) {
            throw new IndexException("Class not found: " + classString);
        }
        this.isOrdered = in.readBoolean();
        this.allowsDuplicates = in.readBoolean();
    }
}

