/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.IndexDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class IndexDescriptorSet
implements Cloneable,
Set,
Serializable {
    static final long serialVersionUID = 6886613171296036239L;
    private Vector descriptors;

    public IndexDescriptorSet() {
        this.descriptors = new Vector(5);
    }

    public IndexDescriptorSet(int initSize) {
        this.descriptors = new Vector(initSize);
    }

    private IndexDescriptorSet(Vector v) {
        this.descriptors = v;
    }

    public Object clone() {
        return new IndexDescriptorSet((Vector)this.descriptors.clone());
    }

    @Override
    public int size() {
        return this.descriptors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.descriptors.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.descriptors.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new IndexDescriptorIterator(this.descriptors.elements());
    }

    @Override
    public Object[] toArray() {
        Object[] anArray = new Object[this.size()];
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            anArray[i++] = iter.next();
        }
        return anArray;
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(Object o) {
        IndexDescriptor idesc = (IndexDescriptor)o;
        if (this.descriptors.contains(o)) {
            return false;
        }
        this.descriptors.addElement(o);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.descriptors.removeElement(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        if (!c.isEmpty()) {
            boolean modified = false;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                modified = this.add(iter.next());
            }
            return modified;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (!c.isEmpty()) {
            boolean modified = false;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                modified = this.remove(iter.next()) || modified;
            }
            return modified;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection coll) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (coll.contains(obj)) continue;
            modified = true;
            iter.remove();
        }
        return modified;
    }

    @Override
    public void clear() {
        this.descriptors.removeAllElements();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set s = (Set)obj;
        return s.size() == this.size() && this.containsAll((Collection)s);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            hash += iter.next().hashCode();
        }
        return hash;
    }

    public boolean isSupersetOf(IndexDescriptorSet indexDescSet) {
        for (IndexDescriptor thing : indexDescSet) {
            if (this.isSupersetOf(thing)) continue;
            return false;
        }
        return true;
    }

    public boolean isSupersetOf(IndexDescriptor indexDesc) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!((IndexDescriptor)iter.next()).isSupersetOf(indexDesc)) continue;
            return true;
        }
        return false;
    }

    class IndexDescriptorIterator
    implements Iterator {
        Enumeration enumeration;
        IndexDescriptor current;

        IndexDescriptorIterator(Enumeration e) {
            this.enumeration = e;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        public Object next() {
            this.current = (IndexDescriptor)this.enumeration.nextElement();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException("no current element to remove in IndexDescriptorIterator.remove");
            }
            IndexDescriptorSet.this.remove(this.current);
            this.current = null;
        }
    }
}

