/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.Cluster;
import com.odi.ObjectStore;
import com.odi.imp.ObjectAccess;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.util.BTreeImpl;
import com.odi.util.BTreeNode;
import com.odi.util.KeyType;
import com.odi.util.MapKeys;
import java.util.NoSuchElementException;

public abstract class KeyVariableSizeType
extends KeyType {
    private static final boolean debug = BTreeImpl.debug;

    protected KeyVariableSizeType(int enumVal) {
        super(enumVal);
    }

    abstract int fixedSize();

    abstract ReferenceType REFTYPE();

    boolean isOverflow(byte[] keyRep, int offset) {
        if (debug) {
            System.out.println("isOverflow at " + offset + "?" + ":" + Integer.toHexString(keyRep[offset]));
        }
        return keyRep[offset] == 15;
    }

    private byte[] getOverflow(byte[] rep, int offset, BTreeImpl btree) {
        if (!this.isOverflow(rep, offset)) {
            return null;
        }
        byte[] ovfl = (byte[])this.getOverflowReference(rep, offset).resolve(Cluster.of(btree));
        ObjectStore.fetch(ovfl);
        return ovfl;
    }

    void setOverflow(byte[] keyRep, int offset, boolean ovflow) {
        keyRep[offset] = ovflow ? 15 : 0;
    }

    Reference getOverflowReference(byte[] keyRep, int offset) {
        if (!this.isOverflow(keyRep, offset)) {
            return this.REFTYPE().NULL();
        }
        return this.REFTYPE().makeReference(keyRep, offset + 1);
    }

    @Override
    public int compare(byte[] givenKey, byte[] keyRep, int offset, BTreeImpl btree) {
        int givenKeyLen;
        if (debug) {
            System.out.println("VarKey: finding match for " + BTreeNode.keyToString(givenKey) + " in keys starting at " + offset);
        }
        if (!this.isOverflow(keyRep, offset)) {
            if (debug) {
                System.out.println("Performing no-overflow match for " + BTreeNode.keyToString(givenKey));
            }
            return BTreeNode.compareKeys(givenKey, 0, givenKey.length, keyRep, offset + 1, this.size() - 1);
        }
        if (debug) {
            System.out.println("Performing overflow match for " + BTreeNode.keyToString(givenKey));
        }
        int givenKeyLenToCompare = (givenKeyLen = BTreeNode.keyLength(givenKey)) > this.fixedSize() ? this.fixedSize() : givenKeyLen;
        int fixedResult = BTreeNode.compareKeys(givenKey, 0, givenKeyLenToCompare, keyRep, offset + 1 + this.REFTYPE().size(), this.fixedSize());
        if (debug) {
            System.out.println("Fixed length portion (" + this.fixedSize() + ") comparsition returns " + fixedResult);
        }
        if (fixedResult != 0) {
            return fixedResult;
        }
        if (givenKeyLen <= this.fixedSize()) {
            return -1;
        }
        Reference reference = this.getOverflowReference(keyRep, offset);
        byte[] overflowValue = (byte[])reference.resolve(Cluster.of(btree));
        ObjectStore.fetch(overflowValue);
        if (debug) {
            System.out.println("Comparing overflow " + BTreeNode.keyToString(overflowValue) + " of length " + BTreeNode.keyLength(overflowValue) + " with given key overflow of length " + (givenKeyLen - this.fixedSize()));
        }
        int retval = BTreeNode.compareKeys(givenKey, this.fixedSize(), givenKeyLen - this.fixedSize(), overflowValue, 0, overflowValue.length);
        if (debug && retval == 0) {
            System.out.println("Found exact match with overflow at lazyRef=" + reference);
        }
        return retval;
    }

    @Override
    public int compare(byte[] key1, int offset1, byte[] key2, int offset2, BTreeImpl btree) {
        Reference of2Ref;
        boolean of1 = this.isOverflow(key1, offset1);
        boolean of2 = this.isOverflow(key2, offset2);
        if (!of1 && !of2) {
            return BTreeNode.compareKeys(key1, offset1 + 1, this.size() - 1, key2, offset2 + 1, this.size() - 1);
        }
        if (of1 && !of2) {
            int fixedSizeCompare = BTreeNode.compareKeys(key1, offset1 + 1 + this.REFTYPE().size(), this.fixedSize(), key2, offset2 + 1, this.size() - 1);
            if (fixedSizeCompare != 0) {
                return fixedSizeCompare;
            }
            return 1;
        }
        if (!of1 && of2) {
            int fixedSizeCompare = BTreeNode.compareKeys(key1, offset1 + 1, this.size() - 1, key2, offset2 + 1 + this.REFTYPE().size(), this.fixedSize());
            if (fixedSizeCompare != 0) {
                return fixedSizeCompare;
            }
            return -1;
        }
        int fixedSizeCompare = BTreeNode.compareKeys(key1, offset1 + 1 + this.REFTYPE().size(), this.fixedSize(), key2, offset2 + 1 + this.REFTYPE().size(), this.fixedSize());
        if (fixedSizeCompare != 0) {
            return fixedSizeCompare;
        }
        Reference of1Ref = this.getOverflowReference(key1, offset1);
        if (of1Ref.equals(of2Ref = this.getOverflowReference(key2, offset2))) {
            return 0;
        }
        byte[] of1values = (byte[])of1Ref.resolve(Cluster.of(btree));
        byte[] of2values = (byte[])of2Ref.resolve(Cluster.of(btree));
        ObjectStore.fetch(of1values);
        ObjectStore.fetch(of2values);
        return BTreeNode.compareKeys(of1values, 0, of1values.length, of2values, 0, of2values.length);
    }

    @Override
    public byte[] getKey(byte[] keys, int offset, byte[] buffer, BTreeImpl btree) {
        if (!this.isOverflow(keys, offset)) {
            return BTreeNode.dupKey(keys, offset + 1, this.size() - 1, buffer);
        }
        Reference ref = this.getOverflowReference(keys, offset);
        byte[] overflowValue = (byte[])ref.resolve(Cluster.of(btree));
        ObjectStore.fetch(overflowValue);
        byte[] result = new byte[this.fixedSize() + overflowValue.length];
        System.arraycopy(keys, offset + 1 + this.REFTYPE().size(), result, 0, this.fixedSize());
        System.arraycopy(overflowValue, 0, result, this.fixedSize(), overflowValue.length);
        return result;
    }

    @Override
    public void setKey(byte[] key, byte[] keys, int offset, BTreeImpl btree) {
        int keyLen = BTreeNode.keyLength(key);
        if (keyLen <= this.size() - 1) {
            this.setOverflow(keys, offset, false);
            BTreeNode.copyKey(key, 0, keyLen, keys, offset + 1, this.size() - 1);
        } else {
            this.setOverflow(keys, offset, true);
            BTreeNode.copyKey(key, 0, this.fixedSize(), keys, offset + 1 + this.REFTYPE().size(), this.fixedSize());
            byte[] overflow = BTreeNode.dupKey(key, this.fixedSize(), keyLen - this.fixedSize(), null);
            ObjectStore.migrate(overflow, Cluster.of(btree), false);
            Reference ref = this.REFTYPE().getReference(overflow);
            byte[] refBytes = ref.getBytes();
            System.arraycopy(refBytes, 0, keys, offset + 1, this.REFTYPE().size());
        }
    }

    private static byte toLowerASCII(byte b) {
        if (b > 64 && b < 91) {
            return (byte)(b + 32);
        }
        return b;
    }

    static boolean allASCII(byte[] keys) {
        if (keys == null) {
            return true;
        }
        return KeyVariableSizeType.allASCII(keys, 0, keys.length);
    }

    static boolean allASCII(byte[] keys, int offset, int len) {
        if (keys == null) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (keys[i] <= 127) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean substringMatch(byte[] keyRep, int offset, byte[] substring, boolean caseInsensitive, BTreeImpl btree) {
        int searchSize = substring.length;
        byte[] overflow = null;
        byte[] fixed = keyRep;
        int fixedOffset = offset;
        int fixedLen = 0;
        int keyLen = 0;
        if (!this.isOverflow(keyRep, offset)) {
            ++fixedOffset;
            fixedLen = this.size() - 1;
            keyLen = BTreeNode.keyLength(keyRep, offset, fixedLen);
        } else {
            fixedOffset += 1 + this.REFTYPE().size();
            fixedLen = this.fixedSize();
            overflow = (byte[])this.getOverflowReference(keyRep, offset).resolve(Cluster.of(btree));
            ObjectStore.fetch(overflow);
            keyLen = fixedLen + overflow.length;
        }
        if (!(!caseInsensitive || KeyVariableSizeType.allASCII(fixed, fixedOffset, fixedLen) && KeyVariableSizeType.allASCII(overflow))) {
            byte[] keyBuff = new byte[keyLen];
            char[] charBuff = new char[keyLen];
            System.arraycopy(fixed, fixedOffset, keyBuff, 0, fixedLen);
            if (overflow != null) {
                System.arraycopy(overflow, 0, keyBuff, fixedLen, overflow.length);
            }
            String key = MapKeys.byteArrayToString(keyBuff, charBuff);
            char[] buff = new char[substring.length];
            String searchString = ObjectAccess.decodeString(substring, 0, substring.length, buff);
            return (key = key.toLowerCase()).indexOf(searchString) >= 0;
        }
        for (int i = 0; i <= keyLen - searchSize; ++i) {
            byte keyByte;
            int j = 0;
            if (j >= searchSize) continue;
            byte by = keyByte = i + j < fixedLen ? fixed[fixedOffset + i + j] : overflow[i + j - fixedLen];
            if (keyByte != substring[j] && (!caseInsensitive || KeyVariableSizeType.toLowerASCII(keyByte) != substring[j])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void destroy(byte[] rep, int offset, boolean isLeaf, BTreeImpl btree) {
        if (isLeaf && this.isOverflow(rep, offset)) {
            Reference ref = this.getOverflowReference(rep, offset);
            if (debug) {
                System.out.println("Destroying overflow key at lazyRef=" + ref);
            }
            ObjectStore.destroy(ref.resolve(Cluster.of(btree)));
        }
    }

    @Override
    public int size() {
        return 1 + this.REFTYPE().size() + this.fixedSize();
    }

    @Override
    public KeyType.ByteIterator getByteIterator(byte[] rep, int offset, BTreeImpl btree) {
        return new VariableSizeKeyByteIterator(rep, offset, btree);
    }

    public class VariableSizeKeyByteIterator
    implements KeyType.ByteIterator {
        private final byte[] rep;
        private final int offset;
        private final byte[] overflow;
        private int pos = 1;
        private final boolean isOverflow;

        public VariableSizeKeyByteIterator(byte[] rep, int offset, BTreeImpl btree) {
            this.rep = rep;
            this.offset = offset;
            this.isOverflow = KeyVariableSizeType.this.isOverflow(rep, offset);
            this.overflow = KeyVariableSizeType.this.getOverflow(rep, offset, btree);
        }

        @Override
        public boolean hasNext() {
            if (!this.isOverflow) {
                return this.pos < KeyVariableSizeType.this.size();
            }
            return this.pos - KeyVariableSizeType.this.fixedSize() < this.overflow.length;
        }

        @Override
        public byte next() {
            if (!this.isOverflow) {
                if (this.pos < KeyVariableSizeType.this.size()) {
                    return this.rep[this.offset + this.pos++];
                }
            } else if (this.pos - KeyVariableSizeType.this.fixedSize() < this.overflow.length) {
                return this.overflow[this.pos++ - KeyVariableSizeType.this.fixedSize()];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void reset() {
            this.pos = 1;
        }
    }
}

