/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.imp.ByteIterator;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectManager;
import com.odi.imp.ReferenceType;
import com.odi.util.CharIterator;
import java.util.NoSuchElementException;

public class MapKeys {
    static final int BooleanKey = 1;
    static final int CharacterKey = 2;
    static final int IntegerKey = 3;
    static final int FloatKey = 4;
    static final int LongKey = 5;
    static final int DoubleKey = 6;
    static final int StringKey = 7;
    static final int ByteArrayKey = 8;
    static final int ReferenceKey = 9;
    static final int ReferenceKeyEnd = 13;

    static final boolean isReferenceType(int keyType) {
        return keyType > 9 && keyType <= 13;
    }

    static final ReferenceType getReferenceType(int keyType) {
        int refEnum = keyType - 9;
        return ReferenceType.getReferenceType(refEnum);
    }

    public static int keyType(Class keyClass, ObjectManager om) {
        if (keyClass == Boolean.TYPE || keyClass == Boolean.class) {
            return 1;
        }
        if (keyClass == Character.TYPE || keyClass == Character.class) {
            return 2;
        }
        if (keyClass == Byte.TYPE || keyClass == Short.TYPE || keyClass == Integer.TYPE || keyClass == Byte.class || keyClass == Short.class || keyClass == Integer.class) {
            return 3;
        }
        if (keyClass == Long.TYPE || keyClass == Long.class) {
            return 5;
        }
        if (keyClass == Float.TYPE || keyClass == Float.class) {
            return 4;
        }
        if (keyClass == Double.TYPE || keyClass == Double.class) {
            return 6;
        }
        if (keyClass == String.class) {
            return 7;
        }
        if (keyClass == byte[].class) {
            return 8;
        }
        return 9 + ReferenceType.getKeyReferenceType().getEnumeratedValue();
    }

    public static int keySize(int keyType) {
        switch (keyType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 4;
            }
            case 5: 
            case 6: {
                return 8;
            }
            case 7: 
            case 8: {
                return 28;
            }
        }
        if (MapKeys.isReferenceType(keyType)) {
            return MapKeys.getReferenceType(keyType).size();
        }
        throw new IllegalArgumentException("Unknown key class: " + keyType);
    }

    static boolean fixedSizeKeys(int keyType) {
        switch (keyType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
            case 7: 
            case 8: {
                return false;
            }
        }
        if (MapKeys.isReferenceType(keyType)) {
            return true;
        }
        throw new IllegalArgumentException("Unknown key class: " + keyType);
    }

    public static byte[] intToByteArray(int key, byte[] buffer) {
        key ^= Integer.MIN_VALUE;
        if (buffer == null || buffer.length < 4) {
            buffer = new byte[]{(byte)(key >>> 24), (byte)(key >>> 16), (byte)(key >>> 8), (byte)key};
        }
        return buffer;
    }

    public static byte[] longToByteArray(long key, byte[] buffer) {
        key ^= Long.MIN_VALUE;
        if (buffer == null || buffer.length < 8) {
            buffer = new byte[]{(byte)(key >>> 56), (byte)(key >>> 48), (byte)(key >>> 40), (byte)(key >>> 32), (byte)(key >>> 24), (byte)(key >>> 16), (byte)(key >>> 8), (byte)key};
        }
        return buffer;
    }

    public static byte[] floatToByteArray(float key, byte[] buffer) {
        if (buffer == null || buffer.length < 4) {
            buffer = new byte[4];
        }
        if (Float.isNaN(key)) {
            throw new IllegalArgumentException("Illegal floating point key (NaN) passed to MapKeys.floatToByteArray");
        }
        int bits = key > 0.0f ? Float.floatToIntBits(-key) : (key < 0.0f ? ~Float.floatToIntBits(key) : Float.floatToIntBits(-0.0f));
        buffer[0] = (byte)(bits >>> 24);
        buffer[1] = (byte)(bits >>> 16);
        buffer[2] = (byte)(bits >>> 8);
        buffer[3] = (byte)bits;
        return buffer;
    }

    public static byte[] doubleToByteArray(double key, byte[] buffer) {
        if (buffer == null || buffer.length < 8) {
            buffer = new byte[8];
        }
        if (Double.isNaN(key)) {
            throw new IllegalArgumentException("Illegal floating point key (NaN) passed to OSMapKeys.doubleToByteArray");
        }
        long bits = key > 0.0 ? Double.doubleToLongBits(-key) : (key < 0.0 ? Double.doubleToLongBits(key) ^ 0xFFFFFFFFFFFFFFFFL : Double.doubleToLongBits(-0.0));
        buffer[0] = (byte)(bits >>> 56);
        buffer[1] = (byte)(bits >>> 48);
        buffer[2] = (byte)(bits >>> 40);
        buffer[3] = (byte)(bits >>> 32);
        buffer[4] = (byte)(bits >>> 24);
        buffer[5] = (byte)(bits >>> 16);
        buffer[6] = (byte)(bits >>> 8);
        buffer[7] = (byte)bits;
        return buffer;
    }

    public static byte[] stringToByteArray(char[] key, int nChars, byte[] buffer) {
        int encodedLength;
        int n = encodedLength = key == null ? 0 : ObjectAccess.UTF8Length(key, nChars) + 1;
        if (buffer == null || buffer.length < encodedLength) {
            buffer = new byte[encodedLength];
        }
        if (buffer.length > encodedLength) {
            for (int i = encodedLength; i < buffer.length; ++i) {
                buffer[i] = 0;
            }
        }
        if (key != null) {
            ObjectAccess.encodeString(buffer, 1, key, nChars);
            buffer[0] = 1;
        }
        return buffer;
    }

    public static int byteArrayToInt(byte[] key) {
        int i = key[0] << 24 | (key[1] & 0xFF) << 16 | (key[2] & 0xFF) << 8 | key[3] & 0xFF;
        return i ^ Integer.MIN_VALUE;
    }

    public static long byteArrayToLong(byte[] key) {
        long i = (long)key[0] << 56 | (long)(key[1] & 0xFF) << 48 | (long)(key[2] & 0xFF) << 40 | (long)(key[3] & 0xFF) << 32 | (long)(key[4] & 0xFF) << 24 | (long)((key[5] & 0xFF) << 16) | (long)((key[6] & 0xFF) << 8) | (long)(key[7] & 0xFF);
        return i ^ Long.MIN_VALUE;
    }

    public static float byteArrayToFloat(byte[] key) {
        if ((key[0] & 0x80) != 0) {
            int bits = (key[0] & 0xFF) << 24 | (key[1] & 0xFF) << 16 | (key[2] & 0xFF) << 8 | key[3] & 0xFF;
            return -Float.intBitsToFloat(bits);
        }
        int bits = (~key[0] & 0xFF) << 24 | (~key[1] & 0xFF) << 16 | (~key[2] & 0xFF) << 8 | ~key[3] & 0xFF;
        return Float.intBitsToFloat(bits);
    }

    public static double byteArrayToDouble(byte[] key) {
        if ((key[0] & 0x80) != 0) {
            long bits = (long)(key[0] & 0xFF) << 56 | (long)(key[1] & 0xFF) << 48 | (long)(key[2] & 0xFF) << 40 | (long)(key[3] & 0xFF) << 32 | (long)(key[4] & 0xFF) << 24 | (long)((key[5] & 0xFF) << 16) | (long)((key[6] & 0xFF) << 8) | (long)(key[7] & 0xFF);
            return -Double.longBitsToDouble(bits);
        }
        long bits = (long)(~key[0] & 0xFF) << 56 | (long)(~key[1] & 0xFF) << 48 | (long)(~key[2] & 0xFF) << 40 | (long)(~key[3] & 0xFF) << 32 | (long)(~key[4] & 0xFF) << 24 | (long)((~key[5] & 0xFF) << 16) | (long)((~key[6] & 0xFF) << 8) | (long)(~key[7] & 0xFF);
        return Double.longBitsToDouble(bits);
    }

    public static String byteArrayToString(byte[] key, char[] charBuffer) {
        int length;
        int max = key.length;
        for (length = 0; length < max && key[length] != 0; ++length) {
        }
        if (length == 0) {
            return null;
        }
        return ObjectAccess.decodeString(key, 1, length - 1, charBuffer);
    }

    static final class ByteToCharIterator
    extends CharIterator {
        private ByteIterator bytes;
        private char next;
        private boolean hasNext;
        private boolean isNull;

        ByteToCharIterator(ByteIterator bytes) {
            this.reset(bytes);
        }

        public void reset(ByteIterator bytes) {
            this.bytes = bytes;
            this.advance();
            if (this.hasNext) {
                this.advance();
            } else {
                this.isNull = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public char next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            char result = this.next;
            this.advance();
            return result;
        }

        @Override
        public boolean isNull() {
            return this.isNull;
        }

        private void advance() {
            try {
                this.next = ObjectAccess.decodeUTF8Bytes(this.bytes);
                this.hasNext = this.next != '\u0000';
            }
            catch (NoSuchElementException e) {
                this.hasNext = false;
            }
        }
    }
}

