/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

abstract class OSAbstractCollection
implements Collection {
    OSAbstractCollection() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator e = this.iterator();
        int i = 0;
        while (e.hasNext()) {
            result[i] = e.next();
            ++i;
        }
        return result;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        if (!c.isEmpty()) {
            boolean modified = false;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                modified = this.add(iter.next());
            }
            return modified;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (!c.isEmpty()) {
            boolean modified = false;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                modified = this.remove(iter.next()) || modified;
            }
            return modified;
        }
        return false;
    }

    public boolean retainAll(Collection coll) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (coll.contains(obj)) continue;
            modified = true;
            iter.remove();
        }
        return modified;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }
}

