/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.NoSessionException;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.imp.Utilities;
import com.odi.util.FastContains;
import com.odi.util.IndexIterator;
import com.odi.util.OSDictionary;
import com.odi.util.OSHashBagIterator;
import com.odi.util.OSHashtable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class OSHashBag
implements IPersistent,
IPersistentHooks,
Cloneable,
Collection,
FastContains,
Serializable {
    static final long serialVersionUID = 10023393468598342L;
    private static final ClassInfo OSHBI = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSHashBag"));
    private int OSITheHashCode;
    private OSDictionary dict;
    private int modificationTick;
    private int cardinality;
    private transient ObjectReference ref;
    public transient byte objectState;

    @Override
    public void initializeContents(GenericObject genObject) {
        this.OSITheHashCode = genObject.getIntField(1, OSHBI);
        this.dict = (OSDictionary)genObject.getClassField(2, OSHBI);
        this.modificationTick = genObject.getIntField(3, OSHBI);
        this.cardinality = genObject.getIntField(4, OSHBI);
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setIntField(1, this.OSITheHashCode, OSHBI);
        genObject.setClassField(2, this.dict, OSHBI);
        genObject.setIntField(3, this.modificationTick, OSHBI);
        genObject.setIntField(4, this.cardinality, OSHBI);
    }

    @Override
    public void clearContents() {
        this.OSITheHashCode = 0;
        this.dict = null;
        this.modificationTick = 0;
        this.cardinality = 0;
    }

    @Override
    public void preDestroyPersistent() {
        ObjectStore.fetch(this);
        ObjectStore.destroy(this.dict);
    }

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte objectState) {
        this.objectState = objectState;
    }

    public OSHashBag(ClassInfo ignored) {
    }

    public void clearDestroyed() {
        ObjectStore.dirty(this);
        this.dict.clearDestroyed();
        ++this.modificationTick;
        this.cardinality = 0;
        IndexIterator iter = this.dict.elements();
        while (iter.hasNext()) {
            this.cardinality += ((Integer)iter.next()).intValue();
        }
    }

    public OSHashBag() {
        this.OSITheHashCode = super.hashCode();
        this.dict = new OSHashtable();
        this.modificationTick = 0;
        this.cardinality = 0;
    }

    public OSHashBag(int initSize) {
        this.OSITheHashCode = super.hashCode();
        this.dict = new OSHashtable(initSize);
        this.modificationTick = 0;
        this.cardinality = 0;
    }

    public int duplicateCount(Object o) {
        ObjectStore.fetch(this);
        Object value = this.dict.get(o);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    @Override
    public int size() {
        ObjectStore.fetch(this);
        return this.cardinality;
    }

    @Override
    public boolean isEmpty() {
        ObjectStore.fetch(this);
        return this.cardinality == 0;
    }

    @Override
    public boolean contains(Object o) {
        ObjectStore.fetch(this);
        return this.dict.containsKey(o);
    }

    @Override
    public Iterator iterator() {
        return new OSHashBagIterator(this);
    }

    @Override
    public Object[] toArray() {
        Object[] anArray = new Object[this.size()];
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            anArray[i++] = iter.next();
        }
        return anArray;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public boolean add(Object o) {
        Object value;
        ObjectStore.dirty(this);
        if (o == null) {
            Utilities.throwNullArgumentException("OSHashBag", "add", "o");
        }
        if ((value = this.dict.get(o)) == null) {
            this.dict.put(o, new Integer(1));
        } else {
            this.dict.put(o, new Integer((Integer)value + 1));
        }
        ++this.cardinality;
        ++this.modificationTick;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        ObjectStore.fetch(this);
        Object value = this.dict.get(o);
        if (value == null) {
            return false;
        }
        ObjectStore.dirty(this);
        int count = (Integer)value;
        if (count == 1) {
            this.dict.remove(o);
        } else {
            this.dict.put(o, new Integer(count - 1));
        }
        --this.cardinality;
        ++this.modificationTick;
        return true;
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        if (!c.isEmpty()) {
            boolean modified = false;
            for (Object obj : c) {
                if (this.contains(obj)) continue;
                modified = this.add(obj);
            }
            return modified;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (!c.isEmpty()) {
            ObjectStore.fetch(this);
            boolean modified = false;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                Object previous = this.dict.remove(iter.next());
                if (previous == null) continue;
                this.cardinality -= ((Integer)previous).intValue();
                modified = true;
            }
            if (modified) {
                ObjectStore.dirty(this);
            }
            return modified;
        }
        return false;
    }

    public boolean retainAll(Collection coll) {
        ObjectStore.fetch(this);
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (coll.contains(obj)) continue;
            modified = true;
            iter.remove();
        }
        return modified;
    }

    @Override
    public void clear() {
        ObjectStore.dirty(this);
        this.dict.clear();
        this.cardinality = 0;
        ++this.modificationTick;
    }

    @Override
    public int hashCode() {
        block2: {
            try {
                ObjectStore.fetch(this);
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block2;
                throw e;
            }
        }
        return this.OSITheHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    int getTick() {
        ObjectStore.fetch(this);
        return this.modificationTick;
    }

    Iterator keyIterator() {
        ObjectStore.fetch(this);
        return this.dict.keys();
    }
}

