/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.ObjectStore;
import com.odi.imp.Utilities;
import com.odi.util.FastContains;
import com.odi.util.OSAbstractSet;
import com.odi.util.OSDictionary;
import com.odi.util.OSHashSetIterator;
import com.odi.util.OSHashtable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

public class OSHashSet
extends OSAbstractSet
implements IPersistent,
Cloneable,
Set,
FastContains,
Serializable {
    static final long serialVersionUID = -8988962094197480448L;
    private static final ClassInfo OSHSI = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSHashSet"));
    private OSDictionary dict;
    private int modificationTick;

    @Override
    public void initializeContents(GenericObject genObject) {
        this.dict = (OSDictionary)genObject.getClassField(1, OSHSI);
        this.modificationTick = genObject.getIntField(2, OSHSI);
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setClassField(1, this.dict, OSHSI);
        genObject.setIntField(2, this.modificationTick, OSHSI);
    }

    @Override
    public void clearContents() {
        this.dict = null;
        this.modificationTick = 0;
    }

    @Override
    public void preDestroyPersistent() {
        ObjectStore.fetch(this);
        ObjectStore.destroy(this.dict);
    }

    public OSHashSet(ClassInfo ignored) {
    }

    public void clearDestroyed() {
        ObjectStore.dirty(this);
        this.dict.clearDestroyed();
        ++this.modificationTick;
    }

    public OSHashSet() {
        this.dict = new OSHashtable();
        this.modificationTick = 0;
    }

    public OSHashSet(int initSize) {
        this.dict = new OSHashtable(initSize);
        this.modificationTick = 0;
    }

    @Override
    public int size() {
        ObjectStore.fetch(this);
        return this.dict.size();
    }

    @Override
    public boolean isEmpty() {
        ObjectStore.fetch(this);
        return this.dict.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        ObjectStore.fetch(this);
        return this.dict.containsKey(o);
    }

    @Override
    public Iterator iterator() {
        return new OSHashSetIterator(this);
    }

    @Override
    public Object[] toArray() {
        Object[] anArray = new Object[this.size()];
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            anArray[i++] = iter.next();
        }
        return anArray;
    }

    @Override
    public boolean add(Object o) {
        boolean modified;
        ObjectStore.fetch(this);
        if (o == null) {
            Utilities.throwNullArgumentException("OSHashSet", "add", "o");
        }
        boolean bl = modified = this.dict.put(o, o) == null;
        if (modified) {
            ObjectStore.dirty(this);
            ++this.modificationTick;
        }
        return modified;
    }

    @Override
    public boolean remove(Object o) {
        boolean modified;
        ObjectStore.fetch(this);
        boolean bl = modified = this.dict.remove(o) != null;
        if (modified) {
            ObjectStore.dirty(this);
            ++this.modificationTick;
        }
        return modified;
    }

    @Override
    public void clear() {
        ObjectStore.dirty(this);
        this.dict.clear();
        ++this.modificationTick;
    }

    int getTick() {
        ObjectStore.fetch(this);
        return this.modificationTick;
    }

    Iterator keyIterator() {
        ObjectStore.fetch(this);
        return this.dict.keys();
    }
}

