/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.GenericObject;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.Persistent;

public class OSHashtableEntry
extends Persistent
implements Cloneable {
    Object key;
    Object element;
    OSHashtableEntry next;
    int hash;
    private static final ClassInfo OSHEI = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSHashtableEntry"));

    @Override
    public void initializeContents(GenericObject genObject) {
        this.key = genObject.getClassField(1, OSHEI);
        this.element = genObject.getClassField(2, OSHEI);
        this.next = (OSHashtableEntry)genObject.getClassField(3, OSHEI);
        this.hash = genObject.getIntField(4, OSHEI);
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setClassField(1, this.key, OSHEI);
        genObject.setClassField(2, this.element, OSHEI);
        genObject.setClassField(3, this.next, OSHEI);
        genObject.setIntField(4, this.hash, OSHEI);
    }

    @Override
    public void clearContents() {
        this.key = null;
        this.element = null;
        this.next = null;
        this.hash = 0;
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        Persistent.fetch(this);
        try {
            OSHashtableEntry newEntry = (OSHashtableEntry)super.clone();
            if (this.next != null) {
                newEntry.next = (OSHashtableEntry)this.next.clone();
            }
            return newEntry;
        }
        catch (CloneNotSupportedException e) {
            throw new FatalInternalException("Attempt to clone OSHashtableEntry failed");
        }
    }

    public OSHashtableEntry(ClassInfo ignored) {
    }

    OSHashtableEntry(Object aKey, Object anElement, int hashValue) {
        this.key = aKey;
        this.element = anElement;
        this.hash = hashValue;
        this.next = null;
    }

    void setNext(OSHashtableEntry e) {
        Persistent.dirty(this);
        this.next = e;
    }

    OSHashtableEntry getNext() {
        Persistent.fetch(this);
        return this.next;
    }

    void rehash() {
        try {
            ObjectStore.fetch(this);
            if (this.key != null) {
                this.hash = this.key.hashCode();
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    void destroyChain() {
        Persistent.fetch(this);
        if (this.next != null) {
            this.next.destroyChain();
        }
        ObjectStore.destroy(this);
    }

    public int hashCode() {
        return super.transientHashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

