/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.FatalInternalException;
import com.odi.ObjectStore;
import com.odi.util.CharIterator;
import com.odi.util.IndexIterator;
import com.odi.util.OSHashMapEntry;
import com.odi.util.OSHashtable;
import com.odi.util.OSHashtableEntry;
import com.odi.util.StringCharIterator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

class OSHashtableIterator
implements Enumeration,
IndexIterator {
    private OSHashtable hashtable;
    private int enumerateWhat;
    private int slot;
    private OSHashtableEntry currEntry;
    private OSHashtableEntry nextEntry;
    private StringCharIterator stringKeyCharIterator;
    private int modificationTick;

    private void findNextEntry() {
        if (this.nextEntry != null) {
            ObjectStore.fetch(this.nextEntry);
            this.nextEntry = this.nextEntry.next;
        }
        if (this.nextEntry == null) {
            ObjectStore.fetch(this.hashtable);
            ObjectStore.fetch(this.hashtable.table);
            while (this.slot < this.hashtable.table.length - 1) {
                if (this.hashtable.table[++this.slot] == null) continue;
                this.nextEntry = this.hashtable.table[this.slot];
                break;
            }
        }
        if (this.nextEntry != null) {
            ObjectStore.fetch(this.nextEntry);
        }
    }

    OSHashtableIterator(OSHashtable ht, int what) {
        this.hashtable = ht;
        ObjectStore.fetch(this.hashtable);
        ObjectStore.fetch(this.hashtable.table);
        this.enumerateWhat = what;
        this.slot = -1;
        this.currEntry = null;
        this.nextEntry = null;
        this.modificationTick = this.hashtable.getTick();
        this.findNextEntry();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextEntry != null;
    }

    public Object nextElement() {
        return this.next();
    }

    @Override
    public void advance() {
        this.checkTick();
        if (this.nextEntry == null) {
            throw new NoSuchElementException("OSHashtableIterator");
        }
        this.currEntry = this.nextEntry;
        ObjectStore.fetch(this.currEntry);
        this.findNextEntry();
    }

    public Object next() {
        Object obj = null;
        this.advance();
        switch (this.enumerateWhat) {
            case 0: {
                obj = this.currEntry.key;
                break;
            }
            case 1: {
                obj = this.currEntry.element;
                break;
            }
            case 2: {
                obj = new OSHashMapEntry(this.currEntry.key, this.currEntry.element);
            }
        }
        return obj;
    }

    @Override
    public Object currentKey() {
        this.checkTick();
        if (this.currEntry == null) {
            throw new IllegalStateException("OSHashtableIterator");
        }
        ObjectStore.fetch(this.currEntry);
        return this.currEntry.key;
    }

    @Override
    public int compareKey(Object key) {
        this.checkTick();
        if (this.currEntry == null) {
            throw new IllegalStateException("OSHashtableIterator");
        }
        ObjectStore.fetch(this.currEntry);
        return this.currEntry.key.equals(key) ? 0 : 1;
    }

    @Override
    public CharIterator currentStringKeyCharIterator() {
        if (this.stringKeyCharIterator == null) {
            this.stringKeyCharIterator = new StringCharIterator((String)this.currentKey());
        } else {
            this.stringKeyCharIterator.reset((String)this.currentKey());
        }
        return this.stringKeyCharIterator;
    }

    @Override
    public Object currentValue() {
        this.checkTick();
        if (this.currEntry == null) {
            throw new IllegalStateException("OSHashtableIterator");
        }
        ObjectStore.fetch(this.currEntry);
        return this.currEntry.element;
    }

    @Override
    public void remove() {
        this.checkTick();
        if (this.currEntry == null) {
            throw new IllegalStateException("OSHashtableIterator");
        }
        ObjectStore.fetch(this.currEntry);
        Object key = this.currEntry.key;
        this.hashtable.remove(key);
        this.currEntry = null;
        this.modificationTick = this.hashtable.getTick();
    }

    private void checkTick() {
        if (this.modificationTick != this.hashtable.getTick()) {
            throw new ConcurrentModificationException("Collection modified while iterating");
        }
    }

    @Override
    public boolean advanceToSubstringMatch(String substring, boolean caseInsensitive) {
        throw new FatalInternalException("OSHashtableIterator");
    }
}

