/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.NoSessionException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.Persistent;
import com.odi.Placement;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.util.BTree;
import com.odi.util.BTreeEntryNotFoundException;
import com.odi.util.BTreeIterator;
import com.odi.util.OSTreeMapCollectionView;
import com.odi.util.OSTreeMapSetView;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class OSTreeMap
implements IPersistent,
IPersistentHooks,
Map,
Serializable {
    static final long serialVersionUID = -5262347787432320614L;
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    private BTree tree;
    private static final ClassInfo OSTMI = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSTreeMap"));
    private transient ObjectReference ref;
    public transient byte objectState;

    @Override
    public void initializeContents(GenericObject genObject) {
        this.tree = (BTree)genObject.getClassField(1, OSTMI);
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setClassField(1, this.tree, OSTMI);
    }

    @Override
    public void clearContents() {
        this.tree = null;
    }

    @Override
    public void preDestroyPersistent() {
        ObjectStore.fetch(this);
        ObjectStore.destroy(this.tree);
    }

    protected OSTreeMap(ClassInfo ignored, int keySize) {
    }

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte objectState) {
        this.objectState = objectState;
    }

    protected OSTreeMap(Placement placement, int keySize, boolean fixedSizeKeys, boolean export) {
        this.tree = BTree.create(placement, keySize, fixedSizeKeys ? 1 : 0);
        ObjectStore.migrate(this, placement, export);
    }

    @Override
    public int size() {
        ObjectStore.fetch(this);
        return this.tree.size();
    }

    public int sizeEstimate() {
        ObjectStore.fetch(this);
        return this.tree.sizeEstimate();
    }

    public boolean isSizeMaintained() {
        ObjectStore.fetch(this);
        return this.tree.isSizeMaintained();
    }

    public void maintainSize(boolean maintainSize) {
        ObjectStore.fetch(this);
        this.tree.maintainSize(maintainSize);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        ObjectStore.fetch(this);
        BTreeIterator iter = this.tree.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this._containsKey(this.keyToByteArray(key, null));
    }

    public Object get(Object key) {
        return this._get(this.keyToByteArray(key, null));
    }

    public Object put(Object key, Object value) {
        return this._put(this.keyToByteArray(key, null), value);
    }

    public Object remove(Object key) {
        return this._remove(this.keyToByteArray(key, null));
    }

    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        ObjectStore.fetch(this);
        this.tree.clear();
    }

    public Set keySet() {
        return new OSTreeMapSetView(this, 0);
    }

    public Collection values() {
        return new OSTreeMapCollectionView(this, 1);
    }

    public Set entrySet() {
        return new OSTreeMapSetView(this, 2);
    }

    public Set entries() {
        return this.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)obj;
        Set keys1 = this.keySet();
        Set keys2 = otherMap.keySet();
        if (!keys1.equals(keys1)) {
            return false;
        }
        for (Object k : keys1) {
            if (!(this.get(k) == null ? otherMap.get(k) != null : !this.get(k).equals(otherMap.get(k)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash;
        block3: {
            hash = 0;
            try {
                for (Object obj : this.entrySet()) {
                    hash += obj.hashCode();
                }
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block3;
                throw e;
            }
        }
        return hash;
    }

    public abstract byte[] keyToByteArray(Object var1, byte[] var2);

    public abstract Object byteArrayToKey(byte[] var1);

    protected final boolean _containsKey(byte[] key) {
        ObjectStore.fetch(this);
        return this.tree.containsKey(key);
    }

    protected final Object _get(byte[] key) {
        ObjectStore.fetch(this);
        try {
            return this.tree.get(key);
        }
        catch (BTreeEntryNotFoundException e) {
            return null;
        }
    }

    protected final Object _put(byte[] key, Object value) {
        ObjectStore.fetch(this);
        return this.tree.put(key, value);
    }

    protected final Object _remove(byte[] key) {
        ObjectStore.fetch(this);
        try {
            return this.tree.remove(key);
        }
        catch (BTreeEntryNotFoundException e) {
            return null;
        }
    }

    BTreeIterator btreeIterator() {
        ObjectStore.fetch(this);
        return this.tree.iterator();
    }

    final int getKeySize() {
        return this.tree.getKeySize();
    }

    public BTree getBTree() {
        return this.tree;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Persistent.hasReadBarrier(this)) {
            throw new ObjectStoreException("OSTreeMap.writeObject() invoked without a preceding call to ObjectStore.deepFetch()");
        }
        out.writeInt(this.tree.getKeySize());
        out.writeBoolean(this.tree.hasFixedSizeKeys());
        out.writeInt(this.size());
        for (Object key : this.keySet()) {
            if (key instanceof byte[]) {
                out.writeObject(((byte[])key).clone());
            } else {
                out.writeObject(key);
            }
            Object value = this.get(key);
            ObjectStore.deepFetch(value);
            out.writeObject(value);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Placement placement = ObjectManager.getPlacementForSerialization(true);
        int keySize = in.readInt();
        boolean fixedSizeKeys = in.readBoolean();
        this.tree = BTree.create(placement, keySize, fixedSizeKeys ? 1 : 0);
        ObjectStore.migrate(this, placement, false);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }
}

