/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.FatalInternalException;
import com.odi.util.BTreeIterator;
import com.odi.util.CharIterator;
import com.odi.util.IndexIterator;
import com.odi.util.OSTreeMap;
import com.odi.util.OSTreeMapEntry;
import com.odi.util.StringCharIterator;

class OSTreeMapIterator
implements IndexIterator {
    private OSTreeMap map;
    private BTreeIterator iter;
    private int enumerateWhat;
    private byte[] keyBuffer;
    private StringCharIterator stringKeyCharIterator;

    OSTreeMapIterator(OSTreeMap m, int what) {
        this.map = m;
        this.iter = this.map.btreeIterator();
        this.enumerateWhat = what;
        this.keyBuffer = new byte[m.getKeySize()];
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Object next() {
        this.iter.advance();
        switch (this.enumerateWhat) {
            case 0: {
                return this.map.byteArrayToKey(this.iter.currentKey(this.keyBuffer));
            }
            case 1: {
                return this.iter.currentValue();
            }
            case 2: {
                return new OSTreeMapEntry(this.map.byteArrayToKey(this.iter.currentKey(this.keyBuffer)), this.iter.currentValue());
            }
        }
        return null;
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    @Override
    public Object currentKey() {
        return this.map.byteArrayToKey(this.iter.currentKey(this.keyBuffer));
    }

    @Override
    public int compareKey(Object key) {
        return this.iter.compareKey(this.map.keyToByteArray(key, this.keyBuffer));
    }

    @Override
    public CharIterator currentStringKeyCharIterator() {
        if (this.stringKeyCharIterator == null) {
            this.stringKeyCharIterator = new StringCharIterator((String)this.currentKey());
        } else {
            this.stringKeyCharIterator.reset((String)this.currentKey());
        }
        return this.stringKeyCharIterator;
    }

    @Override
    public Object currentValue() {
        return this.iter.currentValue();
    }

    @Override
    public void advance() {
        this.iter.advance();
    }

    @Override
    public boolean hasMoreElements() {
        return this.iter.hasNext();
    }

    public Object nextElement() {
        this.iter.advance();
        switch (this.enumerateWhat) {
            case 0: {
                return this.map.byteArrayToKey(this.iter.currentKey(this.keyBuffer));
            }
            case 1: {
                return this.iter.currentValue();
            }
            case 2: {
                return new OSTreeMapEntry(this.map.byteArrayToKey(this.iter.currentKey(this.keyBuffer)), this.iter.currentValue());
            }
        }
        return null;
    }

    @Override
    public boolean advanceToSubstringMatch(String substring, boolean caseInsensitive) {
        throw new FatalInternalException("OSTreeMapIterator");
    }
}

