/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.OSVector;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class SubList
implements List {
    private OSVector l;
    private int offset;
    private int size;

    SubList(OSVector list, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.l = list;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    public Object set(int index, Object element) {
        this.rangeCheck(index);
        return this.l.set(index + this.offset, element);
    }

    public Object get(int index) {
        this.rangeCheck(index);
        return this.l.get(index + this.offset);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void add(int index, Object element) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.l.add(index + this.offset, element);
        ++this.size;
    }

    public Object remove(int index) {
        this.rangeCheck(index);
        Object result = this.l.remove(index + this.offset);
        --this.size;
        return result;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        this.l.removeRange(fromIndex + this.offset, toIndex + this.offset);
        this.size -= toIndex - fromIndex;
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.indexOf(obj);
        if (index >= 0) {
            this.remove(index);
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        this.l.addAll(this.offset + index, c);
        this.size += cSize;
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection coll) {
        boolean modified = false;
        for (Object obj : coll) {
            int index = this.indexOf(obj);
            while (index != -1) {
                modified = true;
                this.l.removeElementAt(index + this.offset);
                --this.size;
            }
        }
        return modified;
    }

    @Override
    public synchronized boolean retainAll(Collection coll) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (coll.contains(obj)) continue;
            modified = true;
            --this.size;
            iter.remove();
        }
        return modified;
    }

    @Override
    public synchronized boolean containsAll(Collection coll) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized int indexOf(Object elem) {
        if (this.size == 0) {
            return -1;
        }
        int cindex = this.l.indexOf(elem, this.offset);
        if (cindex >= this.offset && cindex < this.offset + this.size) {
            return cindex - this.offset;
        }
        return -1;
    }

    @Override
    public synchronized int lastIndexOf(Object elem) {
        if (this.size == 0) {
            return -1;
        }
        int cindex = this.l.lastIndexOf(elem, this.offset + this.size);
        if (cindex >= this.offset && cindex < this.offset + this.size) {
            return cindex - this.offset;
        }
        return -1;
    }

    @Override
    public boolean contains(Object elem) {
        int cindex = this.l.indexOf(elem, this.offset);
        return cindex >= this.offset && cindex < this.offset + this.size;
    }

    @Override
    public void clear() {
        for (int i = this.offset + this.size - 1; i >= this.offset; --i) {
            this.l.removeElementAt(i);
        }
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] anArray = new Object[this.size];
        return this.toArray(anArray);
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < this.size; ++i) {
            a[i] = it.next();
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean add(Object obj) {
        this.l.insertElementAt(obj, this.offset + this.size);
        ++this.size;
        return true;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return new ListIterator(){
            private ListIterator i;
            {
                this.i = SubList.this.l.listIterator(index + SubList.this.offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < SubList.this.size;
            }

            @Override
            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.i.nextIndex() - SubList.this.offset;
            }

            @Override
            public int previousIndex() {
                return this.i.previousIndex() - SubList.this.offset;
            }

            @Override
            public void remove() {
                if (this.nextIndex() == 0 || this.previousIndex() >= SubList.this.size - 1) {
                    throw new NoSuchElementException();
                }
                this.i.remove();
                SubList.this.size--;
            }

            public void set(Object o) {
                if (this.nextIndex() == 0 || this.previousIndex() >= SubList.this.size - 1) {
                    throw new NoSuchElementException();
                }
                this.i.set(o);
            }

            public void add(Object o) {
                this.i.add(o);
                SubList.this.size++;
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubList(this.l, this.offset + fromIndex, this.offset + toIndex);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this.size);
        }
    }
}

