/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.TypedMapCollectionView;
import com.odi.util.TypedMapSetView;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class TypedMap
implements Map,
Cloneable,
Serializable {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    static final long serialVersionUID = 6748488955223602099L;
    private Hashtable table;
    PrivateNull privatenull;
    private Class keytype;
    private Class valuetype;
    boolean nullkeys;
    boolean nullvalues;

    private Object inputKey(Object key) {
        if (key != null && !this.keytype.isInstance(key)) {
            throw new ClassCastException("Key is not of class " + this.keytype);
        }
        if (this.nullkeys && key == null) {
            return this.privatenull;
        }
        return key;
    }

    private Object inputValue(Object value) {
        if (value != null && !this.valuetype.isInstance(value)) {
            throw new ClassCastException("Value is not of class " + this.valuetype);
        }
        if (this.nullvalues && value == null) {
            return this.privatenull;
        }
        return value;
    }

    Object outputKey(Object key) {
        if (this.nullkeys && key == this.privatenull) {
            return null;
        }
        return key;
    }

    Object outputValue(Object value) {
        if (this.nullvalues && value == this.privatenull) {
            return null;
        }
        return value;
    }

    public TypedMap(int capacity, Class keyType, Class valueType, boolean nullKeys, boolean nullValues) {
        this.table = new Hashtable(capacity);
        this.keytype = keyType;
        this.valuetype = valueType;
        this.nullkeys = nullKeys;
        this.nullvalues = nullValues;
        this.privatenull = new PrivateNull();
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.table.contains(this.inputValue(value));
    }

    public boolean contains(Object value) {
        return this.table.contains(this.inputValue(value));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.table.containsKey(this.inputKey(key));
    }

    public Enumeration elements() {
        return new TypedMapEnumerator(this.table.elements(), 1);
    }

    public Enumeration keys() {
        return new TypedMapEnumerator(this.table.keys(), 0);
    }

    public Object get(Object key) {
        return this.outputValue(this.table.get(this.inputKey(key)));
    }

    public Object put(Object key, Object value) {
        return this.outputValue(this.table.put(this.inputKey(key), this.inputValue(value)));
    }

    public Object remove(Object key) {
        return this.outputValue(this.table.remove(this.inputKey(key)));
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        return new TypedMapSetView(this, 0);
    }

    public Collection values() {
        return new TypedMapCollectionView(this, 1);
    }

    public Set entrySet() {
        return new TypedMapSetView(this, 2);
    }

    public Set entries() {
        return this.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)obj;
        Set keys1 = this.keySet();
        Set keys2 = otherMap.keySet();
        if (!keys1.equals(keys1)) {
            return false;
        }
        for (Object k : keys1) {
            if (!(this.get(k) == null ? otherMap.get(k) != null : !this.get(k).equals(otherMap.get(k)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (Object obj : this.entries()) {
            hash += obj.hashCode();
        }
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.table);
        out.writeObject(this.privatenull);
        out.writeObject(this.keytype);
        if (this.valuetype.getSuperclass() == null) {
            out.writeObject("ObjectClass");
        } else {
            out.writeObject(this.valuetype);
        }
        out.writeBoolean(this.nullkeys);
        out.writeBoolean(this.nullvalues);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.table = (Hashtable)in.readObject();
        this.privatenull = (PrivateNull)in.readObject();
        this.keytype = (Class)in.readObject();
        Object obj = in.readObject();
        this.valuetype = obj instanceof String ? Object.class : (Class)obj;
        this.nullkeys = in.readBoolean();
        this.nullvalues = in.readBoolean();
    }

    static class PrivateNull
    implements Serializable {
        static final long serialVersionUID = 8337855163722157559L;

        PrivateNull() {
        }
    }

    class TypedMapEnumerator
    implements Enumeration {
        private Enumeration enumeration;
        private int enumerateWhat;

        TypedMapEnumerator(Enumeration e, int what) {
            this.enumeration = e;
            this.enumerateWhat = what;
            if (this.enumerateWhat != 0 && this.enumerateWhat != 1) {
                throw new IllegalArgumentException("unrecognized enumeration flag in TypedMapEnumerator");
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        public Object nextElement() {
            switch (this.enumerateWhat) {
                case 0: {
                    return TypedMap.this.outputKey(this.enumeration.nextElement());
                }
                case 1: {
                    return TypedMap.this.outputValue(this.enumeration.nextElement());
                }
            }
            throw new IllegalArgumentException("unrecognized enumeration flag in TypedMapEnumerator");
        }
    }
}

