/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.TypedMap;
import com.odi.util.TypedMapIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

class TypedMapCollectionView
implements Collection {
    private int viewWhat;
    private TypedMap map;

    TypedMapCollectionView(TypedMap t, int what) {
        this.map = t;
        this.viewWhat = what;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        switch (this.viewWhat) {
            case 0: {
                return this.map.containsKey(o);
            }
            case 1: {
                return this.map.containsValue(o);
            }
            case 2: {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return this.map.containsKey(entry.getKey()) && entry.getValue().equals(this.map.get(entry.getKey()));
            }
        }
        return false;
    }

    @Override
    public synchronized Iterator iterator() {
        return new TypedMapIterator(this.map, this.viewWhat);
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] anArray = new Object[this.size()];
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            anArray[i++] = iter.next();
        }
        return anArray;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public synchronized boolean remove(Object o) {
        switch (this.viewWhat) {
            case 0: {
                return this.map.remove(o) != null;
            }
            case 1: {
                Enumeration mapKeys = this.map.keys();
                while (mapKeys.hasMoreElements()) {
                    Object key = mapKeys.nextElement();
                    Object value = this.map.get(key);
                    if ((value != null || o != null) && !value.equals(o)) continue;
                    this.map.remove(key);
                    return true;
                }
                return false;
            }
            case 2: {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                if (this.map.containsKey(entry.getKey()) && entry.getValue().equals(this.map.get(entry.getKey()))) {
                    this.map.remove(entry.getKey());
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Collection.add not supported by Map views");
    }

    public synchronized boolean containsAll(Collection coll) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAll(Collection coll) {
        boolean modified = false;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            modified = this.remove(iter.next());
        }
        return modified;
    }

    public synchronized boolean retainAll(Collection coll) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (coll.contains(obj)) continue;
            modified = true;
            iter.remove();
        }
        return modified;
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Collection.addAll not supported by Map views");
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection coll = (Collection)o;
        return coll.size() == this.map.size() && this.containsAll(coll);
    }

    @Override
    public synchronized int hashCode() {
        int h = 0;
        Iterator e = this.iterator();
        while (e.hasNext()) {
            h += e.next().hashCode();
        }
        return h;
    }
}

