/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.util.query.QueryEvalNode;
import com.odi.util.query.VectorOfChildrenEvalNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public final class IntersectionEvalNode
extends VectorOfChildrenEvalNode {
    public IntersectionEvalNode(Vector children) {
        super(children);
    }

    @Override
    protected VectorOfChildrenEvalNode newCopy() {
        return new IntersectionEvalNode();
    }

    private IntersectionEvalNode() {
    }

    @Override
    String operatorImage() {
        return "intersect";
    }

    @Override
    protected boolean containsInternal(Object object) {
        if (!this.hasFastContainsInternal()) {
            Iterator iterator = this.iterator(true);
            while (iterator.hasNext()) {
                if (iterator.next() != object) continue;
                return true;
            }
            return false;
        }
        Enumeration childrenEnum = this.children.elements();
        while (childrenEnum.hasMoreElements()) {
            if (((QueryEvalNode)childrenEnum.nextElement()).contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Iterator iteratorInternal(boolean allowDuplicates) {
        return new NodeIterator(allowDuplicates);
    }

    @Override
    protected Set computeSet() {
        QueryEvalNode[] childArray = this.getIterationChildren();
        Set result = childArray[0].getSet(true);
        Iterator resultElements = result.iterator();
        block0: while (resultElements.hasNext()) {
            Object element = resultElements.next();
            for (int i = 1; i < childArray.length; ++i) {
                QueryEvalNode child = childArray[i];
                if (child.contains(element)) continue;
                resultElements.remove();
                continue block0;
            }
        }
        return result;
    }

    @Override
    protected void estimateSize() {
        this.minSize = 0;
        this.maxSize = Integer.MAX_VALUE;
        int max = this.children.size();
        for (int i = 0; i < max; ++i) {
            QueryEvalNode child = (QueryEvalNode)this.children.elementAt(i);
            this.maxSize = Math.min(this.maxSize, child.getMaxSize());
        }
    }

    QueryEvalNode[] getIterationChildren() {
        Object[] childArray = new QueryEvalNode[this.children.size()];
        this.children.copyInto(childArray);
        int start = 0;
        if (this.hasFastContainsInternal()) {
            int smallestSize = Integer.MAX_VALUE;
            boolean foundSet = false;
            for (int i = 0; i < childArray.length; ++i) {
                Object child = childArray[i];
                int estSize = (((QueryEvalNode)child).getMinSize() + ((QueryEvalNode)child).getMaxSize()) / 2;
                if (((QueryEvalNode)child).isSetComputed()) {
                    if (foundSet && estSize >= smallestSize) continue;
                    start = i;
                    foundSet = true;
                    smallestSize = estSize;
                    continue;
                }
                if (foundSet || estSize >= smallestSize) continue;
                start = i;
                smallestSize = estSize;
            }
        } else {
            int slowSize = 0;
            for (int i = 0; i < childArray.length; ++i) {
                Object child = childArray[i];
                if (((QueryEvalNode)child).hasFastContains()) continue;
                int maxSize = ((QueryEvalNode)child).getMaxSize();
                if (maxSize == 0) {
                    start = i;
                    break;
                }
                int estSize = (((QueryEvalNode)child).getMinSize() + maxSize) / 2;
                if (estSize <= slowSize) continue;
                start = i;
                slowSize = estSize;
            }
        }
        Object temp = childArray[start];
        childArray[start] = childArray[0];
        childArray[0] = temp;
        return childArray;
    }

    @Override
    public String toString() {
        return this.identityToString() + ": " + super.toString();
    }

    final class NodeIterator
    implements Iterator {
        private QueryEvalNode[] children;
        private Iterator childIterator;
        private Object next = this;

        NodeIterator(boolean allowDuplicates) {
            this.children = IntersectionEvalNode.this.getIterationChildren();
            this.childIterator = this.children[0].iterator(allowDuplicates);
        }

        @Override
        public boolean hasNext() {
            if (this.next != this) {
                return true;
            }
            while (this.childIterator.hasNext()) {
                Object possibleNext = this.childIterator.next();
                boolean found = true;
                for (int i = 1; i < this.children.length; ++i) {
                    if (this.children[i].contains(possibleNext)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                this.next = possibleNext;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element");
            }
            Object result = this.next;
            this.next = this;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove() method is not supported on this iterator.");
        }
    }
}

