/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.FatalInternalException;
import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.ExceptionRange;
import com.odi.filter.classfile.ExceptionTable;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnLookupSwitch;
import com.odi.filter.classfile.InsnTarget;
import com.odi.filter.classfile.SourceFileAttribute;
import com.odi.filter.classfile.VMConstants;
import com.odi.imp.Utilities;
import com.odi.util.query.FreeVariables;
import com.odi.util.query.Methods;
import com.odi.util.query.QPT;
import com.odi.util.query.Query;
import com.odi.util.query.QueryClassLoader;
import java.io.IOException;
import java.util.Enumeration;

public final class MethodsGenerator
implements VMConstants {
    private String className;
    private ClassFile classFile;
    private FreeVariables freeVariables;
    private String thisClassName;
    private static int nameCounter = 0;
    private int numPredicates = 0;
    private int numGetFields = 0;
    private int numExpressions = 0;
    private boolean classCreated = false;

    public MethodsGenerator(FreeVariables freeVariables, Class thisClass, String className) {
        this.className = className;
        this.classFile = new ClassFile(className, "com/odi/util/query/Methods");
        this.freeVariables = freeVariables;
        this.thisClassName = Utilities.getClassVMName(thisClass);
        this.classFile.setAccessFlags(33);
        this.classFile.attributes().addElement(new SourceFileAttribute(this.classFile.pool().addUtf8("SourceFile"), this.classFile.pool().addUtf8("Generated.java")));
    }

    public MethodsGenerator(FreeVariables freeVariables, Class thisClass) {
        this(freeVariables, thisClass, MethodsGenerator.nextClassName());
    }

    public int addPredicate(QPT.Expr expr) {
        this.checkclassCreated();
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = expr.getInstructions(firstInsn, this.classFile, true);
        insn = insn.append(Insn.create(172));
        this.addMethod(2, "predicate" + this.numPredicates, "(L" + this.thisClassName + ";)Z", firstInsn);
        return this.numPredicates++;
    }

    public int addGetField(QPT.Expr expr) {
        this.checkclassCreated();
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = this.getInstructionsAsWrapper(expr, firstInsn, false);
        insn = insn.append(Insn.create(176));
        this.addMethod(2, "getField" + this.numGetFields, "(L" + this.thisClassName + ";)Ljava/lang/Object;", firstInsn);
        return this.numGetFields++;
    }

    public int addExpression(QPT.Expr expr) {
        this.checkclassCreated();
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = this.getInstructionsAsWrapper(expr, firstInsn, false);
        insn = insn.append(Insn.create(176));
        this.addMethod(2, "expression" + this.numExpressions, "()Ljava/lang/Object;", firstInsn);
        return this.numExpressions++;
    }

    public Methods createInstance(ClassLoader parentClassLoader) {
        Class newclass = this.createClass(parentClassLoader);
        try {
            return (Methods)newclass.newInstance();
        }
        catch (InstantiationException e) {
            throw new FatalInternalException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new FatalInternalException(e.toString());
        }
    }

    public Class createClass(ClassLoader parentClassLoader) {
        QueryClassLoader qcl = null;
        if (parentClassLoader == null) {
            qcl = new QueryClassLoader();
        } else {
            try {
                qcl = new QueryClassLoader(parentClassLoader);
            }
            catch (NoSuchMethodError nsme) {
                qcl = new QueryClassLoader();
            }
        }
        return qcl.addClass(this.className, this.createClassBytes());
    }

    public byte[] createClassBytes() {
        this.checkclassCreated();
        this.classCreated = true;
        this.createFields();
        this.createConstructor();
        this.createPredicate();
        this.createGetField();
        this.createExpression();
        this.createBind();
        byte[] bytes = null;
        try {
            bytes = this.classFile.getBytes();
        }
        catch (IOException ioe) {
            throw new FatalInternalException(ioe.toString());
        }
        if (Query.debugLevel() >= 10) {
            System.err.println("\nQuery debugging -- generated methods:");
            this.classFile.print(System.err);
        }
        return bytes;
    }

    private void createFields() {
        ConstantPool pool = this.classFile.pool();
        Enumeration freeVariablesEnum = this.freeVariables.keys();
        while (freeVariablesEnum.hasMoreElements()) {
            String name = (String)freeVariablesEnum.nextElement();
            Class type = (Class)this.freeVariables.get(name);
            this.classFile.addField(new ClassField(2, pool.addUtf8(name), pool.addUtf8(Utilities.getClassSignature(type)), new AttributeVector()));
        }
    }

    private void createConstructor() {
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        ConstantPool pool = this.classFile.pool();
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(183, pool.addMethodRef("com/odi/util/query/Methods", "<init>", "()V")));
        insn.append(Insn.create(177));
        this.addMethod(1, "<init>", "()V", firstInsn);
    }

    private void createPredicate() {
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        ConstantPool pool = this.classFile.pool();
        insn = insn.append(Insn.create(1));
        InsnTarget startRange = new InsnTarget();
        insn = insn.append(startRange);
        insn = insn.append(Insn.create(78));
        insn = insn.append(Insn.create(44));
        insn = insn.append(Insn.create(192, pool.addClass(this.thisClassName)));
        insn = insn.append(Insn.create(78));
        InsnTarget success = new InsnTarget();
        insn = insn.append(Insn.create(167, success));
        InsnTarget failure = new InsnTarget();
        insn = insn.append(failure);
        insn = insn.append(Insn.create(87));
        insn = insn.append(Insn.create(3));
        insn = insn.append(Insn.create(172));
        insn = insn.append(success);
        ExceptionTable exceptionTable = new ExceptionTable();
        exceptionTable.addElement(new ExceptionRange(startRange, success, failure, pool.addClass("java/lang/ClassCastException")));
        if (this.numPredicates != 0) {
            InsnTarget defaultOp = new InsnTarget();
            int[] matchesOp = new int[this.numPredicates];
            InsnTarget[] targetOps = new InsnTarget[this.numPredicates];
            Insn lastTarget = null;
            for (int i = 0; i < this.numPredicates; ++i) {
                matchesOp[i] = i;
                targetOps[i] = new InsnTarget();
                if (lastTarget != null) {
                    lastTarget.append(targetOps[i]);
                }
                lastTarget = targetOps[i];
                lastTarget = lastTarget.append(Insn.create(42));
                lastTarget = lastTarget.append(Insn.create(45));
                lastTarget = lastTarget.append(Insn.create(183, pool.addMethodRef(this.className, "predicate" + i, "(L" + this.thisClassName + ";)Z")));
                lastTarget = lastTarget.append(Insn.create(172));
            }
            insn = insn.append(Insn.create(27));
            insn = insn.append(new InsnLookupSwitch(defaultOp, matchesOp, targetOps));
            insn.append(targetOps[0]);
            insn = lastTarget;
            insn = insn.append(defaultOp);
        }
        insn = insn.append(Insn.create(27));
        insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/util/query/Methods", "noSuchIndex", "(I)V")));
        insn = insn.append(Insn.create(3));
        insn = insn.append(Insn.create(172));
        this.addMethod(1, "predicate", "(ILjava/lang/Object;)Z", firstInsn, exceptionTable);
    }

    private void createGetField() {
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        ConstantPool pool = this.classFile.pool();
        if (this.numGetFields != 0) {
            InsnTarget defaultOp = new InsnTarget();
            int[] matchesOp = new int[this.numGetFields];
            InsnTarget[] targetOps = new InsnTarget[this.numGetFields];
            Insn lastTarget = null;
            for (int i = 0; i < this.numGetFields; ++i) {
                matchesOp[i] = i;
                targetOps[i] = new InsnTarget();
                if (lastTarget != null) {
                    lastTarget.append(targetOps[i]);
                }
                lastTarget = targetOps[i];
                lastTarget = lastTarget.append(Insn.create(42));
                lastTarget = lastTarget.append(Insn.create(44));
                lastTarget = lastTarget.append(Insn.create(192, pool.addClass(this.thisClassName)));
                lastTarget = lastTarget.append(Insn.create(183, pool.addMethodRef(this.className, "getField" + i, "(L" + this.thisClassName + ";)Ljava/lang/Object;")));
                lastTarget = lastTarget.append(Insn.create(176));
            }
            insn = insn.append(Insn.create(27));
            insn = insn.append(new InsnLookupSwitch(defaultOp, matchesOp, targetOps));
            insn.append(targetOps[0]);
            insn = lastTarget;
            insn = insn.append(defaultOp);
        }
        insn = insn.append(Insn.create(27));
        insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/util/query/Methods", "noSuchIndex", "(I)V")));
        insn = insn.append(Insn.create(1));
        insn = insn.append(Insn.create(176));
        this.addMethod(1, "getField", "(ILjava/lang/Object;)Ljava/lang/Object;", firstInsn);
    }

    private void createExpression() {
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        ConstantPool pool = this.classFile.pool();
        if (this.numExpressions != 0) {
            InsnTarget defaultOp = new InsnTarget();
            int[] matchesOp = new int[this.numExpressions];
            InsnTarget[] targetOps = new InsnTarget[this.numExpressions];
            Insn lastTarget = null;
            for (int i = 0; i < this.numExpressions; ++i) {
                matchesOp[i] = i;
                targetOps[i] = new InsnTarget();
                if (lastTarget != null) {
                    lastTarget.append(targetOps[i]);
                }
                lastTarget = targetOps[i];
                lastTarget = lastTarget.append(Insn.create(42));
                lastTarget = lastTarget.append(Insn.create(183, pool.addMethodRef(this.className, "expression" + i, "()Ljava/lang/Object;")));
                lastTarget = lastTarget.append(Insn.create(176));
            }
            insn = insn.append(Insn.create(27));
            insn = insn.append(new InsnLookupSwitch(defaultOp, matchesOp, targetOps));
            insn.append(targetOps[0]);
            insn = lastTarget;
            insn = insn.append(defaultOp);
        }
        insn = insn.append(Insn.create(27));
        insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/util/query/Methods", "noSuchIndex", "(I)V")));
        insn = insn.append(Insn.create(1));
        insn = insn.append(Insn.create(176));
        this.addMethod(1, "expression", "(I)Ljava/lang/Object;", firstInsn);
    }

    private void createBind() {
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        ConstantPool pool = this.classFile.pool();
        Enumeration freeVariablesEnum = this.freeVariables.keys();
        while (freeVariablesEnum.hasMoreElements()) {
            String name = (String)freeVariablesEnum.nextElement();
            Class type = (Class)this.freeVariables.get(name);
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(43));
            insn = insn.append(Insn.create(18, pool.addString(name)));
            insn = insn.append(Insn.create(182, pool.addMethodRef("com/odi/util/TypedMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;")));
            insn = this.coerceToType(insn, type);
            insn = insn.append(Insn.create(181, pool.addFieldRef(this.className, name, Utilities.getClassSignature(type))));
        }
        insn = insn.append(Insn.create(177));
        this.addMethod(1, "bind", "(Lcom/odi/util/query/FreeVariableBindings;)V", firstInsn);
    }

    private Insn coerceToType(Insn insn, Class type) {
        ConstantPool pool = this.classFile.pool();
        if (!type.isPrimitive()) {
            if (type == Object.class) {
                return insn;
            }
            return insn.append(Insn.create(192, pool.addClass(Utilities.getClassVMName(type))));
        }
        String wrapperName = this.getWrapperName(type);
        insn = insn.append(Insn.create(192, pool.addClass(wrapperName)));
        insn = insn.append(Insn.create(182, pool.addMethodRef(wrapperName, type.getName() + "Value", "()" + Utilities.getClassSignature(type))));
        return insn;
    }

    private Insn getInstructionsAsWrapper(QPT.Expr expr, Insn insn, boolean asPredicate) {
        Class type = expr.getResultType();
        if (type == null || !type.isPrimitive()) {
            return expr.getInstructions(insn, this.classFile, asPredicate);
        }
        ConstantPool pool = this.classFile.pool();
        String wrapperName = this.getWrapperName(type);
        insn = insn.append(Insn.create(187, pool.addClass(wrapperName)));
        insn = insn.append(Insn.create(89));
        insn = expr.getInstructions(insn, this.classFile, asPredicate);
        insn = insn.append(Insn.create(183, pool.addMethodRef(wrapperName, "<init>", "(" + Utilities.getClassSignature(type) + ")V")));
        return insn;
    }

    private String getWrapperName(Class primitive) {
        if (primitive == Boolean.TYPE) {
            return "java/lang/Boolean";
        }
        if (primitive == Byte.TYPE) {
            return "java/lang/Byte";
        }
        if (primitive == Short.TYPE) {
            return "java/lang/Short";
        }
        if (primitive == Character.TYPE) {
            return "java/lang/Character";
        }
        if (primitive == Integer.TYPE) {
            return "java/lang/Integer";
        }
        if (primitive == Long.TYPE) {
            return "java/lang/Long";
        }
        if (primitive == Float.TYPE) {
            return "java/lang/Float";
        }
        if (primitive == Double.TYPE) {
            return "java/lang/Double";
        }
        throw new FatalInternalException("Unknown primitive type: " + primitive);
    }

    private void addMethod(int accFlags, String name, String signature, Insn firstInsn) {
        this.addMethod(accFlags, name, signature, firstInsn, new ExceptionTable());
    }

    private void addMethod(int accFlags, String name, String signature, Insn firstInsn, ExceptionTable exceptionTable) {
        ConstantPool pool = this.classFile.pool();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod method = new ClassMethod(accFlags, pool.addUtf8(name), pool.addUtf8(signature), methodAttrs);
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 256, 10, firstInsn, exceptionTable, new AttributeVector()));
        this.classFile.addMethod(method);
    }

    void checkclassCreated() {
        if (this.classCreated) {
            throw new FatalInternalException("An class has already been created.");
        }
    }

    private static synchronized String nextClassName() {
        return "GeneratedClass" + ++nameCounter;
    }
}

