/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.FatalInternalException;
import com.odi.IPersistent;
import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.ConstFieldRef;
import com.odi.filter.classfile.ConstMethodRef;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnInterfaceInvoke;
import com.odi.filter.classfile.InsnTarget;
import com.odi.filter.classfile.InsnUtils;
import com.odi.filter.classfile.VMConstants;
import com.odi.imp.Utilities;
import com.odi.util.IndexDescriptor;
import com.odi.util.IndexDescriptorSet;
import com.odi.util.IndexException;
import com.odi.util.query.CollectionEvalNode;
import com.odi.util.query.FilterEvalNode;
import com.odi.util.query.FreeVariables;
import com.odi.util.query.IndexFilterEvalNode;
import com.odi.util.query.IntersectionEvalNode;
import com.odi.util.query.InvalidPatternException;
import com.odi.util.query.PatternMatcher;
import com.odi.util.query.PrintableNode;
import com.odi.util.query.Query;
import com.odi.util.query.QueryEvalNode;
import com.odi.util.query.QueryParseException;
import com.odi.util.query.UnionEvalNode;
import com.odi.util.query.parser.Parser;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class QPT
implements VMConstants {
    public Class elementType;
    String queryExpression;
    Expr root;
    public FreeVariables freeVariables;
    IndexDescriptorSet availableIndexes;
    IndexDescriptorSet requiredIndexes = new IndexDescriptorSet();
    IndexDescriptorSet desirableIndexes;
    public static final int QUERY_TREE = 1;
    public static final int INDEX_TREE = 2;
    public static final int EXPR_TREE = 3;
    int rootType;
    public static boolean allowInvariantQueryExpressions = false;
    public static final byte LT = 1;
    public static final byte GT = 2;
    public static final byte LE = 3;
    public static final byte GE = 4;
    public static final byte EQ = 5;
    public static final byte NE = 6;
    public static final byte AND = 7;
    public static final byte OR = 8;
    public static final byte BITWISE_COMPLEMENT = 9;
    public static final byte LOGICAL_COMPLEMENT = 10;
    public static final byte UNARY_MINUS = 11;
    public static final byte MUL = 12;
    public static final byte DIV = 13;
    public static final byte REM = 14;
    public static final byte ADD = 15;
    public static final byte SUB = 16;
    public static final byte LEFT_SHIFT = 17;
    public static final byte RIGHT_SHIFT = 18;
    public static final byte RIGHT_UNSIGNED_SHIFT = 19;
    public static final byte XOR = 20;
    public static final byte MIN = 21;
    public static final byte MAX = 22;
    public static final byte MATCH_PATTERN = 23;
    public static final int UNKNOWN_POS = -1;

    public QPT(Class elementType, String queryExpression, FreeVariables freeVariables, int expectedRootType) {
        this.elementType = elementType;
        this.queryExpression = queryExpression;
        this.freeVariables = freeVariables == null ? new FreeVariables() : freeVariables;
        this.rootType = expectedRootType;
        if (elementType.isPrimitive()) {
            throw new IllegalArgumentException("Illegal primitive element type:" + elementType);
        }
        Expr expr = null;
        if (queryExpression.equals("")) {
            expr = new Literal(-1, new Boolean(true));
        } else {
            PrintWriter writer = null;
            Parser parser = new Parser(queryExpression);
            expr = parser.parse(this);
            if (Query.debugLevel() >= 5) {
                writer = new PrintWriter(System.err);
            }
            if (Query.debugLevel() >= 7) {
                System.err.println("\nQuery debugging -- raw parse tree:");
                expr.print(writer, 1);
                writer.flush();
            }
            expr = expr.getFoldedExpr();
            if (Query.debugLevel() >= 5) {
                System.err.println("\nQuery debugging -- parse tree with optimized constants:");
                expr.print(writer, 1);
                writer.flush();
            }
        }
        if (expr.getResultType() == Boolean.TYPE) {
            expr = expr.notOpt(false);
        }
        this.root = expr;
        if (expectedRootType == 1) {
            this.verifyQueryTree();
        } else if (expectedRootType == 2) {
            this.verifyIndexTree();
        } else if (expectedRootType != 3) {
            throw new IllegalArgumentException("Invalid tree type: " + expectedRootType);
        }
    }

    private void verifyQueryTree() {
        if (this.root.getResultType() != Boolean.TYPE) {
            this.error("The query expression " + QPT.quote(this.queryExpression) + " must yield a boolean result, not one of type " + this.root.getResultType());
        }
        if (this.root.isInvariant() && !allowInvariantQueryExpressions) {
            this.error("The query expression " + QPT.quote(this.queryExpression) + " is an invariant, that is, its value is independent of the" + " elements of the collection. ");
        }
    }

    private void verifyMethodInIndexTree(MethodSelect method) {
        for (int i = 0; i < method.actualArguments.length; ++i) {
            if (method.actualArguments[i] instanceof Literal) {
                Literal lit = (Literal)method.actualArguments[i];
                if (lit.value instanceof String || lit.getResultType().isPrimitive()) continue;
                this.error("Literals of type: " + lit.getResultType() + " are not permitted as arguments to a method in " + "an index expression.");
                continue;
            }
            this.error("Invalid index expression: " + QPT.quote(this.queryExpression) + " Arguments to a method used in an index must be literals");
        }
    }

    private void verifyIndexTree() {
        if (this.queryExpression.equals("")) {
            this.error("An empty string is an invalid index expression");
        }
        Expr expr = this.root;
        while (expr instanceof MemberSelect) {
            if (expr instanceof MethodSelect) {
                this.verifyMethodInIndexTree((MethodSelect)expr);
            }
            expr = ((MemberSelect)expr).op;
        }
        if (expr == this.root || !(expr instanceof ThisRef)) {
            this.error("Invalid index expression: " + QPT.quote(this.queryExpression) + " does not start with a non-static field or method.");
        }
    }

    public QueryEvalNode optimize(IndexDescriptorSet availableIndexes) {
        this.desirableIndexes = new IndexDescriptorSet();
        this.availableIndexes = availableIndexes != null ? availableIndexes : new IndexDescriptorSet();
        this.requiredIndexes.clear();
        return this.root.collOpt();
    }

    IndexDescriptorSet getRequiredIndexes() {
        return this.requiredIndexes;
    }

    IndexDescriptorSet getDesirableIndexes() {
        if (this.desirableIndexes == null) {
            this.optimize(null);
        }
        return this.desirableIndexes;
    }

    public Expr getRoot() {
        return this.root;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toString(this.hashCode(), 16) + ": elementType=" + this.elementType + ", queryExpression=" + this.queryExpression + ", root=" + this.root + ", freeVariables=" + this.freeVariables + ", indexPaths=" + this.availableIndexes;
    }

    public void print(PrintWriter out) {
        if (this.root != null) {
            this.root.print(out, 0);
        } else {
            out.println("null");
        }
    }

    public void foldExpressions() {
        this.root = this.getRoot().getFoldedExpr();
    }

    IndexDescriptor findIndex(Class elementType, String indexString, boolean ordered) {
        for (IndexDescriptor index : this.availableIndexes) {
            if (!index.elementClass().isAssignableFrom(elementType) || !index.pathString().equals(indexString) || ordered && !index.ordered()) continue;
            return index;
        }
        return null;
    }

    public static String quote(Object o) {
        return "\"" + o + "\"";
    }

    public void error(int pos, String msg) {
        this.error(msg + '\n' + this.highlightedQueryExpression(pos));
    }

    public void error(int[] posList, String msg) {
        this.error(msg + '\n' + this.highlightedQueryExpression(posList));
    }

    public void error(String msg) {
        throw this.rootType == 2 ? new IndexException(msg) : new QueryParseException(msg);
    }

    public boolean isIntegralType(Class c) {
        return c == Byte.TYPE || c == Character.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE;
    }

    public boolean isFloatingPointType(Class c) {
        return c == Float.TYPE || c == Double.TYPE;
    }

    public boolean isNumericType(Class c) {
        return this.isIntegralType(c) || this.isFloatingPointType(c);
    }

    public void notSupported(String msg) {
        throw new QueryParseException("Not supported: " + msg);
    }

    public void operatorNotSupported(int pos, String operatorName, String operator) {
        throw new QueryParseException("The " + operatorName + " operator (" + operator + ") is not supported in query expressions." + '\n' + this.highlightedQueryExpression(pos));
    }

    public void TBD(String msg) {
        throw new RuntimeException("TBD: " + msg);
    }

    public String highlightedQueryExpression(int pos) {
        StringBuffer result = new StringBuffer(this.queryExpression.length() + pos + 2);
        result.append(this.queryExpression);
        if (pos != -1) {
            result.append('\n');
            for (int i = 0; i < pos - 1; ++i) {
                result.append('.');
            }
            result.append('^');
        }
        return result.toString();
    }

    public String highlightedQueryExpression(int[] posList) {
        StringBuffer result = new StringBuffer(posList[posList.length - 1] + 2);
        for (int i = 0; i < posList.length; ++i) {
            if (posList[i] == -1) continue;
            for (int j = result.length(); j < posList[i] - 1; ++j) {
                result.append('.');
            }
            result.append('^');
        }
        if (result.length() != 0) {
            return this.queryExpression + "\n" + result.toString();
        }
        return this.queryExpression;
    }

    Class classForNameDefaultingPackage(String className) {
        if (className.indexOf(46) != -1) {
            try {
                return Utilities.findClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        try {
            String elementTypeName = this.elementType.getName();
            int lastDot = elementTypeName.lastIndexOf(46);
            String pkg = lastDot == -1 ? "" : elementTypeName.substring(0, lastDot + 1);
            return Utilities.findClass(pkg + className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Utilities.findClass("java.lang." + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    boolean canCast(Class source, Class target) {
        boolean targetIsAClass;
        boolean castOk = false;
        boolean sourceIsPrimitive = source == null ? true : source.isPrimitive();
        boolean targetIsPrimitive = target == null ? true : target.isPrimitive();
        boolean sourceIsAnInterface = source == null ? false : source.isInterface();
        boolean targetIsAnInterface = target == null ? false : target.isInterface();
        boolean sourceIsAnArray = source == null ? false : source.isArray();
        boolean targetIsAnArray = target == null ? false : target.isArray();
        boolean sourceIsAClass = !sourceIsPrimitive && !sourceIsAnInterface && !sourceIsAnArray;
        boolean bl = targetIsAClass = !targetIsPrimitive && !targetIsAnInterface && !targetIsAnArray;
        if (sourceIsPrimitive && source != null && targetIsPrimitive && source == Boolean.TYPE == (target == Boolean.TYPE) && source != Void.TYPE) {
            castOk = true;
        } else if (source == null && (targetIsAClass || targetIsAnInterface)) {
            castOk = true;
        } else if (sourceIsAClass) {
            if (targetIsAClass && (target.isAssignableFrom(source) || source.isAssignableFrom(target))) {
                castOk = true;
            } else if (targetIsAnInterface) {
                castOk = (source.getModifiers() & 0x10) == 0 ? true : this.oneImplementsTheOther(source, target);
            } else if (targetIsAnArray) {
                // empty if block
            }
        } else if (sourceIsAnInterface) {
            if (targetIsAClass) {
                castOk = (target.getModifiers() & 0x10) == 0 ? true : this.oneImplementsTheOther(target, source);
            } else if (targetIsAnInterface) {
                castOk = true;
            }
        } else if (sourceIsAnArray) {
            // empty if block
        }
        return castOk;
    }

    private boolean oneImplementsTheOther(Class one, Class theOther) {
        boolean result = false;
        Class<?>[] interfaces = one.getInterfaces();
        for (int i = 0; i < interfaces.length && !result; ++i) {
            if (!interfaces[i].equals(theOther)) continue;
            result = true;
        }
        return result;
    }

    Expr unaryPromotion(Expr op) {
        Class t = op.getResultType();
        if (t == Byte.TYPE || t == Character.TYPE || t == Short.TYPE) {
            return new Cast(op.pos, Integer.TYPE, op);
        }
        return op;
    }

    public static String minString(String x, String y) {
        if (x == null || y == null) {
            return null;
        }
        if (x == IndexFilterEvalNode.UNBOUND_LOW || y == IndexFilterEvalNode.UNBOUND_LOW) {
            return IndexFilterEvalNode.UNBOUND_LOW;
        }
        if (x == IndexFilterEvalNode.UNBOUND_HIGH) {
            return y;
        }
        if (y == IndexFilterEvalNode.UNBOUND_HIGH) {
            return x;
        }
        if (x.compareTo(y) < 0) {
            return x;
        }
        return y;
    }

    public static String maxString(String x, String y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        if (x == IndexFilterEvalNode.UNBOUND_HIGH || y == IndexFilterEvalNode.UNBOUND_HIGH) {
            return IndexFilterEvalNode.UNBOUND_HIGH;
        }
        if (x == IndexFilterEvalNode.UNBOUND_LOW) {
            return y;
        }
        if (y == IndexFilterEvalNode.UNBOUND_LOW) {
            return x;
        }
        if (x.compareTo(y) > 0) {
            return x;
        }
        return y;
    }

    public class PatternMatch
    extends Expr {
        Expr text;
        Expr pattern;

        public PatternMatch(int pos, Expr text, Expr pattern) {
            super(pos);
            this.text = text;
            this.pattern = pattern;
            if (text.getResultType() != String.class && text.getResultType() != null) {
                QPT.this.error(text.pos, "The operand to the '~~' operator that specified the text to match was not a String.");
            }
            if (pattern.getResultType() != String.class && pattern.getResultType() != null) {
                QPT.this.error(pattern.pos, "The pattern operand to the '~~' operator was not a String.");
            }
        }

        @Override
        boolean isInvariant() {
            return this.text.isInvariant() && this.pattern.isInvariant();
        }

        @Override
        public Class getResultType() {
            return Boolean.TYPE;
        }

        @Override
        QueryEvalNode collOpt() {
            IndexDescriptor index;
            if (this.pattern.isInvariant() && (index = this.text.getIndex(true)) != null) {
                return new IndexFilterEvalNode(QPT.this.elementType, index.elementClass(), index.pathString(), this.text, this.pattern, 23);
            }
            return new FilterEvalNode(new CollectionEvalNode(), this);
        }

        @Override
        Expr notOpt(boolean notOperand) {
            if (notOperand) {
                return new Unary(this.pos, 10, this);
            }
            return this;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            ConstantPool pool = classFile.pool();
            if (this.pattern.isInvariant()) {
                Vector fields = classFile.fields();
                int unique = 0;
                int max = fields.size();
                for (int i = 0; i < max; ++i) {
                    ClassField field = (ClassField)fields.elementAt(i);
                    String fieldName = field.name().asString();
                    if (!fieldName.startsWith("patternMatcher")) continue;
                    try {
                        int thisIndex = Integer.parseInt(fieldName.substring("patternMatcher".length()));
                        if (thisIndex < unique) continue;
                        unique = thisIndex + 1;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                String fieldName = "patternMatcher" + unique;
                String fieldType = "Lcom/odi/util/query/PatternMatcher;";
                classFile.addField(new ClassField(2, pool.addUtf8(fieldName), pool.addUtf8(fieldType), new AttributeVector()));
                ConstFieldRef fieldRef = pool.addFieldRef(classFile.className().asString(), fieldName, fieldType);
                insn = insn.append(Insn.create(42));
                insn = insn.append(Insn.create(180, fieldRef));
                InsnTarget nonNull = new InsnTarget();
                insn = insn.append(Insn.create(199, nonNull));
                insn = insn.append(Insn.create(42));
                insn = insn.append(Insn.create(187, pool.addClass("com/odi/util/query/PatternMatcher")));
                insn = insn.append(Insn.create(89));
                insn = this.pattern.getInstructions(insn, classFile, asPredicate);
                insn = insn.append(Insn.create(183, pool.addMethodRef("com/odi/util/query/PatternMatcher", "<init>", "(Ljava/lang/String;)V")));
                insn = insn.append(Insn.create(181, fieldRef));
                insn = insn.append(nonNull);
                insn = insn.append(Insn.create(42));
                insn = insn.append(Insn.create(180, fieldRef));
            } else {
                insn = insn.append(Insn.create(187, pool.addClass("com/odi/util/query/PatternMatcher")));
                insn = insn.append(Insn.create(89));
                insn = this.pattern.getInstructions(insn, classFile, asPredicate);
                insn = insn.append(Insn.create(183, pool.addMethodRef("com/odi/util/query/PatternMatcher", "<init>", "(Ljava/lang/String;)V")));
            }
            insn = this.text.getInstructions(insn, classFile, asPredicate);
            insn = insn.append(Insn.create(182, pool.addMethodRef("com/odi/util/query/PatternMatcher", "match", "(Ljava/lang/String;)Z")));
            return insn;
        }

        @Override
        public Expr getFoldedExpr() {
            this.text = this.text.getFoldedExpr();
            this.pattern = this.pattern.getFoldedExpr();
            if (this.pattern instanceof Literal) {
                try {
                    String patternString = ((Literal)this.pattern).stringValue();
                    if (this.text instanceof Literal) {
                        PatternMatcher matcher = new PatternMatcher(patternString);
                        return new Literal(this.pos, new Boolean(matcher.match(((Literal)this.text).stringValue())));
                    }
                    PatternMatcher.parse(patternString);
                }
                catch (InvalidPatternException e) {
                    QPT.this.error(this.pattern.pos + e.errorOffset, e.getMessage());
                }
            }
            return this;
        }

        @Override
        public String toString() {
            return this.identityToString() + ": text=" + this.text.identityToString() + ", pattern= " + this.pattern.identityToString();
        }

        @Override
        String toPrintString() {
            return "{" + this.text.toPrintString() + " ~~ " + this.pattern.toPrintString() + "}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            String flat = this.indentedString(indentLevel, this.toPrintString());
            if (flat.length() <= 80) {
                out.println(flat);
            } else {
                out.println(this.indentedString(indentLevel, "{"));
                this.text.print(out, indentLevel + 1);
                out.println(this.indentedString(indentLevel, "~~"));
                this.pattern.print(out, indentLevel + 1);
                out.println(this.indentedString(indentLevel, "}"));
            }
        }
    }

    public class MinOrMax
    extends BinaryExpr {
        public MinOrMax(int pos, byte genericOp, Expr op1, Expr op2) {
            super(pos, genericOp, op1, op2);
            if (genericOp != 21 && genericOp != 22) {
                throw new FatalInternalException("Bad op: " + genericOp);
            }
            Class t1 = op1.getResultType();
            Class t2 = op2.getResultType();
            if (t1 == String.class && t2 == String.class || t1 == String.class && t2 == null || t1 == null && t1 == String.class) {
                this.operationType = String.class;
            } else if (this.typesMismatched(t1, t2)) {
                int[] posList = new int[]{op1.pos, pos, op2.pos};
                QPT.this.error(posList, "Types mismatched in this operation; operand types: " + QPT.quote(t1) + " and " + QPT.quote(t2));
            } else if (!QPT.this.isNumericType(t1) && t1 != String.class) {
                int[] posList = new int[]{op1.pos, pos};
                QPT.this.error(posList, "Type must be numeric or String for this operator");
            } else {
                this.operationType = this.doBinaryNumericPromotions();
            }
        }

        @Override
        public Expr getFoldedExpr() {
            Class t1 = this.op1.getResultType();
            Class t2 = this.op2.getResultType();
            this.op1 = this.op1.getFoldedExpr();
            this.op2 = this.op2.getFoldedExpr();
            if (this.op1 instanceof Literal && this.op2 instanceof Literal) {
                Literal literal1 = (Literal)this.op1;
                Literal literal2 = (Literal)this.op2;
                if (t1 == Integer.TYPE && t2 == Integer.TYPE) {
                    int i1 = literal1.intValue();
                    int i2 = literal2.intValue();
                    return new Literal(this.pos, new Integer(this.genericOp == 21 ? (i1 < i2 ? i1 : i2) : (i1 > i2 ? i1 : i2)));
                }
            }
            return this;
        }

        @Override
        public Class getResultType() {
            return this.operationType;
        }

        @Override
        final boolean isInvariant() {
            return this.op1.isInvariant() && this.op2.isInvariant();
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            String signature;
            insn = this.op1.getInstructions(insn, classFile, asPredicate);
            insn = this.op2.getInstructions(insn, classFile, asPredicate);
            if (this.operationType == String.class) {
                return insn.append(Insn.create(184, classFile.pool().addMethodRef("com/odi/util/query/QPT", this.genericOp == 21 ? "minString" : "maxString", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;")));
            }
            if (this.operationType == Byte.TYPE || this.operationType == Short.TYPE || this.operationType == Character.TYPE || this.operationType == Integer.TYPE) {
                signature = "(II)I";
            } else if (this.operationType == Long.TYPE) {
                signature = "(JJ)J";
            } else if (this.operationType == Float.TYPE) {
                signature = "(FF)F";
            } else if (this.operationType == Double.TYPE) {
                signature = "(DD)D";
            } else {
                throw new FatalInternalException("Bad type: " + this.operationType);
            }
            return insn.append(Insn.create(184, classFile.pool().addMethodRef("java/lang/Math", this.genericOp == 21 ? "min" : "max", signature)));
        }

        @Override
        String operatorImage() {
            return this.genericOp == 21 ? "min" : "max";
        }
    }

    public class InstanceOf
    extends Expr {
        Expr op1;
        Class op2;

        public InstanceOf(int pos, Expr op1, Class op2) {
            super(pos);
            this.op1 = op1;
            this.op2 = op2;
            Class t1 = op1.getResultType();
            if (t1 != null && t1.isPrimitive()) {
                int[] posList = new int[]{op1.pos, pos};
                QPT.this.error(posList, "First operand must be a reference type for instanceof");
            }
            if (op2.isPrimitive()) {
                QPT.this.error(pos, "Second operand must be a class name for instanceof");
            }
            if (!QPT.this.canCast(t1, op2)) {
                QPT.this.error(pos, "It is impossible for an expression of type '" + t1 + "' to be an instance of '" + op2 + "'");
            }
        }

        @Override
        public Expr getFoldedExpr() {
            return this;
        }

        @Override
        public Class getResultType() {
            return Boolean.TYPE;
        }

        @Override
        Expr notOpt(boolean notOperand) {
            return notOperand ? new Unary(this.pos, 10, this) : this;
        }

        @Override
        public QueryEvalNode collOpt() {
            return new FilterEvalNode(new CollectionEvalNode(), this);
        }

        @Override
        final boolean isInvariant() {
            return this.op1.isInvariant();
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            insn = this.op1.getInstructions(insn, classFile, asPredicate);
            insn = insn.append(Insn.create(193, classFile.pool().addClass(Utilities.getClassVMName(this.op2))));
            return insn;
        }

        @Override
        public String toString() {
            return this.identityToString() + ": op1=" + this.op1.identityToString() + ", op2=" + this.op2.toString() + ", " + super.toString();
        }

        @Override
        String toPrintString() {
            return "{" + this.op1.toPrintString() + " instanceof " + this.op2.getName() + "}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            String text = this.indentedString(indentLevel, this.toPrintString());
            if (text.length() > 80) {
                out.println(this.indentedString(indentLevel, "{"));
                this.op1.print(out, indentLevel + 1);
                out.println(this.indentedString(indentLevel, "instanceof"));
                out.println(this.indentedString(indentLevel + 1, this.op2.getName()));
                out.println(this.indentedString(indentLevel, "}"));
            } else {
                out.println(text);
            }
        }
    }

    public class Bitwise
    extends BinaryExpr {
        public Bitwise(int pos, byte genericBitOp, Expr op1, Expr op2) {
            super(pos, genericBitOp, op1, op2);
            switch (genericBitOp) {
                case 7: 
                case 8: 
                case 20: {
                    break;
                }
                default: {
                    throw new FatalInternalException("Bad bitwise operator: " + genericBitOp);
                }
            }
            Class t1 = op1.getResultType();
            Class t2 = op2.getResultType();
            if (this.typesMismatched(t1, t2)) {
                int[] posList = new int[]{op1.pos, pos, op2.pos};
                QPT.this.error(posList, "Types mismatched in bitwise operation; operand types: " + QPT.quote(t1) + " and " + QPT.quote(t2));
            }
            if (t1 != Boolean.TYPE && !QPT.this.isIntegralType(t1)) {
                QPT.this.error(op1.pos, "Operand must be a boolean or an integral type");
            }
            if (t2 != Boolean.TYPE && !QPT.this.isIntegralType(t2)) {
                QPT.this.error(op2.pos, "Operand must be a boolean or an integral type");
            }
            this.operationType = t1 != Boolean.TYPE ? this.doBinaryNumericPromotions() : Boolean.TYPE;
        }

        @Override
        public Expr getFoldedExpr() {
            Expr result = this;
            this.op1 = this.op1.getFoldedExpr();
            this.op2 = this.op2.getFoldedExpr();
            if (this.op1 instanceof Literal && this.op2 instanceof Literal) {
                Literal literal1 = (Literal)this.op1;
                Literal literal2 = (Literal)this.op2;
                Comparable<Boolean> objectResult = null;
                if (this.operationType == Boolean.TYPE) {
                    boolean b1 = literal1.booleanValue();
                    boolean b2 = literal2.booleanValue();
                    boolean boolResult = false;
                    switch (this.genericOp) {
                        case 7: {
                            boolResult = b1 & b2;
                            break;
                        }
                        case 8: {
                            boolResult = b1 | b2;
                            break;
                        }
                        case 20: {
                            boolResult = b1 ^ b2;
                        }
                    }
                    objectResult = new Boolean(boolResult);
                } else if (this.operationType == Integer.TYPE) {
                    int i1 = literal1.intValue();
                    int i2 = literal2.intValue();
                    int intResult = 0;
                    switch (this.genericOp) {
                        case 7: {
                            intResult = i1 & i2;
                            break;
                        }
                        case 8: {
                            intResult = i1 | i2;
                            break;
                        }
                        case 20: {
                            intResult = i1 ^ i2;
                        }
                    }
                    objectResult = new Integer(intResult);
                } else if (this.operationType == Long.TYPE) {
                    long l1 = literal1.longValue();
                    long l2 = literal2.longValue();
                    long longResult = 0L;
                    switch (this.genericOp) {
                        case 7: {
                            longResult = l1 & l2;
                            break;
                        }
                        case 8: {
                            longResult = l1 | l2;
                            break;
                        }
                        case 20: {
                            longResult = l1 ^ l2;
                        }
                    }
                    objectResult = new Long(longResult);
                } else {
                    throw new FatalInternalException("Bad type: " + this.operationType);
                }
                result = new Literal(this.op1.pos, objectResult);
            }
            return result;
        }

        @Override
        public Class getResultType() {
            return this.operationType;
        }

        @Override
        final boolean isInvariant() {
            return this.op1.isInvariant() && this.op2.isInvariant();
        }

        @Override
        public QueryEvalNode collOpt() {
            if (this.getResultType() != Boolean.TYPE) {
                this.badCollOptCall();
            }
            return new Equality(this.pos, 5, this, new Literal(this.pos, new Boolean(true))).collOpt();
        }

        @Override
        Expr notOpt(boolean notOperand) {
            if (this.getResultType() != Boolean.TYPE) {
                this.badNotOptCall();
            }
            return notOperand ? new Unary(this.pos, 10, this) : this;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            int op;
            block11: {
                block12: {
                    block10: {
                        insn = this.op1.getInstructions(insn, classFile, asPredicate);
                        insn = this.op2.getInstructions(insn, classFile, asPredicate);
                        if (this.operationType != Boolean.TYPE && this.operationType != Byte.TYPE && this.operationType != Short.TYPE && this.operationType != Character.TYPE && this.operationType != Integer.TYPE) break block10;
                        switch (this.genericOp) {
                            case 7: {
                                op = 126;
                                break block11;
                            }
                            case 8: {
                                op = 128;
                                break block11;
                            }
                            case 20: {
                                op = 130;
                                break block11;
                            }
                            default: {
                                throw new FatalInternalException("Bad op: " + this.genericOp);
                            }
                        }
                    }
                    if (this.operationType != Long.TYPE) break block12;
                    switch (this.genericOp) {
                        case 7: {
                            op = 127;
                            break block11;
                        }
                        case 8: {
                            op = 129;
                            break block11;
                        }
                        case 20: {
                            op = 131;
                            break block11;
                        }
                        default: {
                            throw new FatalInternalException("Bad op: " + this.genericOp);
                        }
                    }
                }
                throw new FatalInternalException("Bad type: " + this.operationType);
            }
            return insn.append(Insn.create(op));
        }

        @Override
        String operatorImage() {
            switch (this.genericOp) {
                case 7: {
                    return "&";
                }
                case 8: {
                    return "|";
                }
                case 20: {
                    return "^";
                }
            }
            throw new FatalInternalException("Bad op: " + this.genericOp);
        }
    }

    public class Shift
    extends BinaryExpr {
        public Shift(int pos, byte genericShiftOp, Expr op1, Expr op2) {
            super(pos, genericShiftOp, op1, op2);
            switch (genericShiftOp) {
                case 17: 
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    throw new FatalInternalException("Bad shift operator: " + genericShiftOp);
                }
            }
            Class t1 = op1.getResultType();
            Class t2 = op2.getResultType();
            if (!QPT.this.isIntegralType(t1)) {
                QPT.this.error(op1.pos, "Operand must be an integral type");
            }
            if (!QPT.this.isIntegralType(t2)) {
                QPT.this.error(op2.pos, "Operand must be an integral type");
            }
            this.op1 = QPT.this.unaryPromotion(op1);
            this.op2 = QPT.this.unaryPromotion(op2);
            this.operationType = this.op1.getResultType();
        }

        @Override
        public Expr getFoldedExpr() {
            Expr result = this;
            this.op1 = this.op1.getFoldedExpr();
            this.op2 = this.op2.getFoldedExpr();
            if (this.op1 instanceof Literal && this.op2 instanceof Literal) {
                Class t1 = this.op1.getResultType();
                Class t2 = this.op2.getResultType();
                Literal literal1 = (Literal)this.op1;
                Literal literal2 = (Literal)this.op2;
                long l2 = t2 == Integer.TYPE ? (long)literal2.intValue() : literal2.longValue();
                if (this.operationType == Integer.TYPE) {
                    int i1 = literal1.intValue();
                    switch (this.genericOp) {
                        case 17: {
                            result = new Literal(this.op1.pos, new Integer(i1 << (int)l2));
                            break;
                        }
                        case 18: {
                            result = new Literal(this.op1.pos, new Integer(i1 >> (int)l2));
                            break;
                        }
                        case 19: {
                            result = new Literal(this.op1.pos, new Integer(i1 >>> (int)l2));
                        }
                    }
                } else if (this.operationType == Long.TYPE) {
                    long l1 = literal1.longValue();
                    switch (this.genericOp) {
                        case 17: {
                            result = new Literal(this.op1.pos, new Long(l1 << (int)l2));
                            break;
                        }
                        case 18: {
                            result = new Literal(this.op1.pos, new Long(l1 >> (int)l2));
                            break;
                        }
                        case 19: {
                            result = new Literal(this.op1.pos, new Long(l1 >>> (int)l2));
                        }
                    }
                } else {
                    throw new FatalInternalException("Bad type: " + this.operationType);
                }
            }
            return result;
        }

        @Override
        public Class getResultType() {
            return this.operationType;
        }

        @Override
        final boolean isInvariant() {
            return this.op1.isInvariant() && this.op2.isInvariant();
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            insn = this.op1.getInstructions(insn, classFile, asPredicate);
            insn = this.op2.getInstructions(insn, classFile, asPredicate);
            int op = 0;
            if (this.operationType == Byte.TYPE || this.operationType == Short.TYPE || this.operationType == Character.TYPE || this.operationType == Integer.TYPE) {
                switch (this.genericOp) {
                    case 17: {
                        op = 120;
                        break;
                    }
                    case 18: {
                        op = 122;
                        break;
                    }
                    case 19: {
                        op = 124;
                    }
                }
            } else if (this.operationType == Long.TYPE) {
                switch (this.genericOp) {
                    case 17: {
                        op = 121;
                        break;
                    }
                    case 18: {
                        op = 123;
                        break;
                    }
                    case 19: {
                        op = 125;
                    }
                }
            } else {
                throw new FatalInternalException("Bad type: " + this.operationType);
            }
            return insn.append(Insn.create(op));
        }

        @Override
        String operatorImage() {
            switch (this.genericOp) {
                case 17: {
                    return "<<";
                }
                case 18: {
                    return ">>";
                }
                case 19: {
                    return ">>>";
                }
            }
            return null;
        }
    }

    public class Arithmetic
    extends BinaryExpr {
        public Arithmetic(int pos, byte genericArithOp, Expr op1, Expr op2) {
            super(pos, genericArithOp, op1, op2);
            this.operationType = op1.getResultType();
            Class t1 = op1.getResultType();
            Class t2 = op2.getResultType();
            switch (genericArithOp) {
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    throw new FatalInternalException("Bad arithmetic operator: " + genericArithOp);
                }
            }
            if (genericArithOp == 15) {
                if (!QPT.this.isNumericType(t1) && t1 != String.class && t2 != String.class) {
                    int[] posList = new int[]{op1.pos, pos};
                    QPT.this.error(posList, "Type must be numeric or String for this operator");
                } else if (!QPT.this.isNumericType(t2) && t1 != String.class && t2 != String.class) {
                    int[] posList = new int[]{pos, op2.pos};
                    QPT.this.error(posList, "Type must be numeric or String for this operator");
                }
            } else if (!QPT.this.isNumericType(t1)) {
                int[] posList = new int[]{op1.pos, pos};
                QPT.this.error(posList, "Type must be numeric for this operator");
            } else if (!QPT.this.isNumericType(t2)) {
                int[] posList = new int[]{pos, op2.pos};
                QPT.this.error(posList, "Type must be numeric for this operator");
            }
            this.operationType = t1 != String.class && t2 != String.class ? this.doBinaryNumericPromotions() : String.class;
        }

        @Override
        public Expr getFoldedExpr() {
            Expr result = this;
            this.op1 = this.op1.getFoldedExpr();
            this.op2 = this.op2.getFoldedExpr();
            if (this.op1 instanceof Literal && this.op2 instanceof Literal) {
                Literal literal1 = (Literal)this.op1;
                Literal literal2 = (Literal)this.op2;
                Object objectResult = null;
                if (this.operationType == Integer.TYPE) {
                    int i1 = literal1.intValue();
                    int i2 = literal2.intValue();
                    int intResult = 0;
                    switch (this.genericOp) {
                        case 12: {
                            intResult = i1 * i2;
                            break;
                        }
                        case 13: {
                            intResult = i1 / i2;
                            break;
                        }
                        case 14: {
                            intResult = i1 % i2;
                            break;
                        }
                        case 15: {
                            intResult = i1 + i2;
                            break;
                        }
                        case 16: {
                            intResult = i1 - i2;
                        }
                    }
                    objectResult = new Integer(intResult);
                } else if (this.operationType == Long.TYPE) {
                    long l1 = literal1.longValue();
                    long l2 = literal2.longValue();
                    long longResult = 0L;
                    switch (this.genericOp) {
                        case 12: {
                            longResult = l1 * l2;
                            break;
                        }
                        case 13: {
                            longResult = l1 / l2;
                            break;
                        }
                        case 14: {
                            longResult = l1 % l2;
                            break;
                        }
                        case 15: {
                            longResult = l1 + l2;
                            break;
                        }
                        case 16: {
                            longResult = l1 - l2;
                        }
                    }
                    objectResult = new Long(longResult);
                } else if (this.operationType == Float.TYPE) {
                    float f1 = literal1.floatValue();
                    float f2 = literal2.floatValue();
                    float floatResult = 0.0f;
                    switch (this.genericOp) {
                        case 12: {
                            floatResult = f1 * f2;
                            break;
                        }
                        case 13: {
                            floatResult = f1 / f2;
                            break;
                        }
                        case 14: {
                            floatResult = f1 % f2;
                            break;
                        }
                        case 15: {
                            floatResult = f1 + f2;
                            break;
                        }
                        case 16: {
                            floatResult = f1 - f2;
                        }
                    }
                    objectResult = new Float(floatResult);
                } else if (this.operationType == Double.TYPE) {
                    double d1 = literal1.doubleValue();
                    double d2 = literal2.doubleValue();
                    double doubleResult = 0.0;
                    switch (this.genericOp) {
                        case 12: {
                            doubleResult = d1 * d2;
                            break;
                        }
                        case 13: {
                            doubleResult = d1 / d2;
                            break;
                        }
                        case 14: {
                            doubleResult = d1 % d2;
                            break;
                        }
                        case 15: {
                            doubleResult = d1 + d2;
                            break;
                        }
                        case 16: {
                            doubleResult = d1 - d2;
                        }
                    }
                    objectResult = new Double(doubleResult);
                } else if (this.operationType == String.class) {
                    objectResult = literal1.getResultType() == String.class ? new String(literal1.stringValue() + literal2.value) : new String(literal1.value + literal2.stringValue());
                } else {
                    throw new FatalInternalException("Bad type: " + this.operationType);
                }
                result = new Literal(this.op1.pos, objectResult);
            }
            return result;
        }

        @Override
        public Class getResultType() {
            return this.operationType;
        }

        @Override
        final boolean isInvariant() {
            return this.op1.isInvariant() && this.op2.isInvariant();
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            if (this.operationType == String.class) {
                return this.getStringInstructions(insn, classFile, asPredicate);
            }
            insn = this.op1.getInstructions(insn, classFile, asPredicate);
            insn = this.op2.getInstructions(insn, classFile, asPredicate);
            int op = 0;
            if (this.operationType == Byte.TYPE || this.operationType == Short.TYPE || this.operationType == Character.TYPE || this.operationType == Integer.TYPE) {
                switch (this.genericOp) {
                    case 15: {
                        op = 96;
                        break;
                    }
                    case 16: {
                        op = 100;
                        break;
                    }
                    case 12: {
                        op = 104;
                        break;
                    }
                    case 13: {
                        op = 108;
                        break;
                    }
                    case 14: {
                        op = 112;
                    }
                }
            } else if (this.operationType == Long.TYPE) {
                switch (this.genericOp) {
                    case 15: {
                        op = 97;
                        break;
                    }
                    case 16: {
                        op = 101;
                        break;
                    }
                    case 12: {
                        op = 105;
                        break;
                    }
                    case 13: {
                        op = 109;
                        break;
                    }
                    case 14: {
                        op = 113;
                    }
                }
            } else if (this.operationType == Float.TYPE) {
                switch (this.genericOp) {
                    case 15: {
                        op = 98;
                        break;
                    }
                    case 16: {
                        op = 102;
                        break;
                    }
                    case 12: {
                        op = 106;
                        break;
                    }
                    case 13: {
                        op = 110;
                        break;
                    }
                    case 14: {
                        op = 114;
                    }
                }
            } else if (this.operationType == Double.TYPE) {
                switch (this.genericOp) {
                    case 15: {
                        op = 99;
                        break;
                    }
                    case 16: {
                        op = 103;
                        break;
                    }
                    case 12: {
                        op = 107;
                        break;
                    }
                    case 13: {
                        op = 111;
                        break;
                    }
                    case 14: {
                        op = 115;
                    }
                }
            } else {
                throw new FatalInternalException("Bad type: " + this.operationType);
            }
            return insn.append(Insn.create(op));
        }

        private Insn getStringInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            ConstantPool pool = classFile.pool();
            insn = insn.append(Insn.create(187, pool.addClass("java/lang/StringBuffer")));
            insn = insn.append(Insn.create(89));
            insn = this.op1.getInstructions(insn, classFile, asPredicate);
            insn = insn.append(Insn.create(184, pool.addMethodRef("java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;")));
            insn = insn.append(Insn.create(183, pool.addMethodRef("java/lang/StringBuffer", "<init>", "(Ljava/lang/String;)V")));
            insn = this.op2.getInstructions(insn, classFile, asPredicate);
            insn = insn.append(Insn.create(182, pool.addMethodRef("java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;")));
            insn = insn.append(Insn.create(182, pool.addMethodRef("java/lang/StringBuffer", "toString", "()Ljava/lang/String;")));
            return insn;
        }

        @Override
        String operatorImage() {
            switch (this.genericOp) {
                case 12: {
                    return "*";
                }
                case 13: {
                    return "/";
                }
                case 14: {
                    return "%";
                }
                case 16: {
                    return "-";
                }
                case 15: {
                    return "+";
                }
            }
            return null;
        }
    }

    public class Unary
    extends UnaryExpr {
        byte genericUnaryOp;

        public Unary(int pos, byte genericUnaryOp, Expr newOp) {
            super(pos, newOp);
            this.genericUnaryOp = genericUnaryOp;
            Class t = null;
            boolean typeMismatch = true;
            this.op = QPT.this.unaryPromotion(this.op);
            t = this.op.getResultType();
            if (t == Boolean.TYPE) {
                if (genericUnaryOp == 10) {
                    typeMismatch = false;
                }
            } else if (t == Integer.TYPE || t == Long.TYPE) {
                if (genericUnaryOp != 10) {
                    typeMismatch = false;
                }
            } else if ((t == Float.TYPE || t == Double.TYPE) && genericUnaryOp == 11) {
                typeMismatch = false;
            }
            if (typeMismatch) {
                int[] posList = new int[]{pos, this.op.pos};
                QPT.this.error(posList, "Illegal operand for operator");
            }
        }

        @Override
        public Expr getFoldedExpr() {
            Expr result = this;
            this.op = this.op.getFoldedExpr();
            Class t = this.op.getResultType();
            if (this.op instanceof Literal) {
                Literal literal = (Literal)this.op;
                Comparable<Boolean> litValue = null;
                switch (this.genericUnaryOp) {
                    case 10: {
                        litValue = new Boolean(!literal.booleanValue());
                        break;
                    }
                    case 9: {
                        if (t == Integer.TYPE) {
                            litValue = new Integer(~literal.intValue());
                            break;
                        }
                        if (t == Long.TYPE) {
                            litValue = new Long(literal.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        throw new FatalInternalException("Bad type: " + t);
                    }
                    case 11: {
                        if (t == Integer.TYPE) {
                            if (literal.intValue() == Integer.MIN_VALUE) {
                                litValue = new Integer(literal.intValue());
                                break;
                            }
                            litValue = new Integer(-literal.intValue());
                            break;
                        }
                        if (t == Long.TYPE) {
                            if (literal.longValue() == Long.MIN_VALUE) {
                                litValue = new Long(literal.longValue());
                                break;
                            }
                            litValue = new Long(-literal.longValue());
                            break;
                        }
                        if (t == Float.TYPE) {
                            litValue = new Float(-literal.floatValue());
                            break;
                        }
                        if (t == Double.TYPE) {
                            litValue = new Double(-literal.doubleValue());
                            break;
                        }
                        throw new FatalInternalException("Bad type: " + t);
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericUnaryOp);
                    }
                }
                result = new Literal(this.op.pos, litValue);
            }
            return result;
        }

        @Override
        public Class getResultType() {
            return this.op.getResultType();
        }

        @Override
        boolean isInvariant() {
            return this.op.isInvariant();
        }

        @Override
        QueryEvalNode collOpt() {
            if (this.genericUnaryOp != 10) {
                this.badCollOptCall();
            }
            return new FilterEvalNode(new CollectionEvalNode(), this);
        }

        @Override
        Expr notOpt(boolean notOperand) {
            if (this.genericUnaryOp != 10) {
                this.badNotOptCall();
            }
            if (notOperand) {
                this.op.notOpt(false);
                return this.op;
            }
            return this.op.notOpt(true);
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            insn = this.op.getInstructions(insn, classFile, asPredicate);
            Class operationType = this.getResultType();
            if (this.genericUnaryOp == 11) {
                if (operationType == Byte.TYPE || operationType == Short.TYPE || operationType == Character.TYPE || operationType == Integer.TYPE) {
                    return insn.append(Insn.create(116));
                }
                if (operationType == Long.TYPE) {
                    return insn.append(Insn.create(117));
                }
                if (operationType == Float.TYPE) {
                    return insn.append(Insn.create(118));
                }
                if (operationType == Double.TYPE) {
                    return insn.append(Insn.create(119));
                }
                throw new FatalInternalException("Bad UNARY_MINUS type: " + operationType);
            }
            if (this.genericUnaryOp == 10) {
                if (operationType == Boolean.TYPE) {
                    insn = insn.append(Insn.create(4));
                    return insn.append(Insn.create(130));
                }
                throw new FatalInternalException("Bad LOGICAL_COMPLEMENT type: " + operationType);
            }
            if (this.genericUnaryOp == 9) {
                if (operationType == Byte.TYPE || operationType == Short.TYPE || operationType == Character.TYPE || operationType == Integer.TYPE) {
                    insn = insn.append(Insn.create(2));
                    return insn.append(Insn.create(130));
                }
                if (operationType == Long.TYPE) {
                    insn = insn.append(InsnUtils.longConstant(-1L, classFile.pool()));
                    return insn.append(Insn.create(131));
                }
                throw new FatalInternalException("Bad BITWISE_COMPLEMENT type: " + operationType);
            }
            throw new FatalInternalException("Bad op: " + this.genericUnaryOp);
        }

        @Override
        public String toString() {
            String result = this.identityToString() + ": operator=";
            switch (this.genericUnaryOp) {
                case 11: {
                    result = result + "-";
                    break;
                }
                case 10: {
                    result = result + "!";
                    break;
                }
                case 9: {
                    result = result + "~";
                    break;
                }
                default: {
                    throw new FatalInternalException("Bad op: " + this.genericUnaryOp);
                }
            }
            return result + ", " + super.toString();
        }

        @Override
        String toPrintString() {
            String result = "{";
            switch (this.genericUnaryOp) {
                case 11: {
                    result = result + "-";
                    break;
                }
                case 10: {
                    result = result + "!";
                    break;
                }
                case 9: {
                    result = result + "~";
                    break;
                }
                default: {
                    throw new FatalInternalException("Bad op: " + this.genericUnaryOp);
                }
            }
            return result + " " + this.op.toPrintString() + "}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            String text = this.indentedString(indentLevel, this.toPrintString());
            if (text.length() > 80) {
                out.println(this.indentedString(indentLevel, "{"));
                out.print(this.indentedString(indentLevel, ""));
                switch (this.genericUnaryOp) {
                    case 11: {
                        out.println("-");
                        break;
                    }
                    case 10: {
                        out.println("!");
                        break;
                    }
                    case 9: {
                        out.println("~");
                        break;
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericUnaryOp);
                    }
                }
                this.op.print(out, indentLevel + 1);
                out.println(this.indentedString(indentLevel, "}"));
            } else {
                out.println(text);
            }
        }
    }

    public class Cast
    extends UnaryExpr
    implements Lvalue {
        Class target;

        public Cast(int pos, Class target, Expr op1) {
            super(pos, op1);
            this.target = target;
            boolean castOk = false;
            Class source = op1.getResultType();
            if (!QPT.this.canCast(source, target)) {
                QPT.this.error("Bad cast from " + QPT.quote(source) + " to " + QPT.quote(target));
            }
        }

        @Override
        public IndexDescriptor getIndex(boolean ordered) {
            if (this.op instanceof Lvalue) {
                return ((Lvalue)((Object)this.op)).getIndex(ordered);
            }
            return null;
        }

        @Override
        public String getIndexString() {
            if (this.op instanceof Lvalue) {
                return ((Lvalue)((Object)this.op)).getIndexString();
            }
            return null;
        }

        @Override
        public void setIndexString(String indexString) {
            throw new FatalInternalException("setIndexString(): invoked on a Cast expression");
        }

        @Override
        public Class getResultType() {
            return this.target;
        }

        @Override
        boolean isInvariant() {
            return this.op.isInvariant();
        }

        @Override
        public Expr getFoldedExpr() {
            this.op = this.op.getFoldedExpr();
            Class source = this.op.getResultType();
            if (source == null || source == this.target) {
                return this.op;
            }
            if (!source.isPrimitive()) {
                return this;
            }
            if (this.op instanceof Literal) {
                Literal literal = (Literal)this.op;
                if (this.target == Byte.TYPE) {
                    return new Literal(this.pos, new Byte((byte)literal.intValue()));
                }
                if (this.target == Short.TYPE) {
                    return new Literal(this.pos, new Short((short)literal.intValue()));
                }
                if (this.target == Character.TYPE) {
                    return new Literal(this.pos, new Character((char)literal.intValue()));
                }
                if (this.target == Integer.TYPE) {
                    return new Literal(this.pos, new Integer(literal.intValue()));
                }
                if (this.target == Long.TYPE) {
                    return new Literal(this.pos, new Long(literal.longValue()));
                }
                if (this.target == Float.TYPE) {
                    return new Literal(this.pos, new Float(literal.floatValue()));
                }
                if (this.target == Double.TYPE) {
                    return new Literal(this.pos, new Double(literal.doubleValue()));
                }
            }
            return this;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            insn = this.op.getInstructions(insn, classFile, asPredicate);
            if (!this.target.isPrimitive()) {
                return insn.append(Insn.create(192, classFile.pool().addClass(Utilities.getClassVMName(this.target))));
            }
            Class source = this.op.getResultType();
            if (this.target == source) {
                return insn;
            }
            if (this.target == Long.TYPE) {
                if (source == Float.TYPE) {
                    return insn.append(Insn.create(140));
                }
                if (source == Double.TYPE) {
                    return insn.append(Insn.create(143));
                }
                return insn.append(Insn.create(133));
            }
            if (this.target == Float.TYPE) {
                if (source == Long.TYPE) {
                    return insn.append(Insn.create(137));
                }
                if (source == Double.TYPE) {
                    return insn.append(Insn.create(144));
                }
                return insn.append(Insn.create(134));
            }
            if (this.target == Double.TYPE) {
                if (source == Long.TYPE) {
                    return insn.append(Insn.create(138));
                }
                if (source == Float.TYPE) {
                    return insn.append(Insn.create(141));
                }
                return insn.append(Insn.create(135));
            }
            if (source == Long.TYPE) {
                insn = insn.append(Insn.create(136));
            } else if (source == Float.TYPE) {
                insn = insn.append(Insn.create(139));
            } else if (source == Double.TYPE) {
                insn = insn.append(Insn.create(142));
            }
            if (this.target == Byte.TYPE) {
                return insn.append(Insn.create(145));
            }
            if (this.target == Short.TYPE) {
                return insn.append(Insn.create(147));
            }
            if (this.target == Character.TYPE) {
                return insn.append(Insn.create(146));
            }
            return insn;
        }

        @Override
        public String toString() {
            return this.identityToString() + ": target=" + this.target + ", " + super.toString();
        }

        @Override
        String toPrintString() {
            return "{(" + this.target.getName() + ") " + this.op.toPrintString() + "}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            String text = this.indentedString(indentLevel, this.toPrintString());
            if (text.length() > 80) {
                out.println(this.indentedString(indentLevel, "{"));
                out.println(this.indentedString(indentLevel, "(" + this.target.getName() + ")"));
                this.op.print(out, indentLevel + 1);
                out.println(this.indentedString(indentLevel, "}"));
            } else {
                out.println(text);
            }
        }
    }

    public class Equality
    extends BinaryExpr {
        public Equality(int pos, byte genericEqOp, Expr op1, Expr op2) {
            Class t2;
            super(pos, genericEqOp, op1, op2);
            if (genericEqOp != 5 && genericEqOp != 6) {
                throw new FatalInternalException("Bad equality operator: " + genericEqOp);
            }
            Class t1 = op1.getResultType();
            if (this.typesMismatched(t1, t2 = op2.getResultType())) {
                int[] posList = new int[]{op1.pos, pos, op2.pos};
                QPT.this.error(posList, "Type mismatch in equality expression; operand types: " + QPT.quote(t1) + " and " + QPT.quote(t2));
            }
            this.operationType = t1 == Boolean.TYPE ? Boolean.TYPE : (QPT.this.isNumericType(t1) ? this.doBinaryNumericPromotions() : (t1 == String.class && t2 == String.class || t1 == String.class && t2 == null || t1 == null && t2 == String.class ? String.class : Object.class));
        }

        @Override
        public Class getResultType() {
            return Boolean.TYPE;
        }

        @Override
        public Expr getFoldedExpr() {
            boolean result;
            this.op1 = this.op1.getFoldedExpr();
            this.op2 = this.op2.getFoldedExpr();
            if (!(this.op1 instanceof Literal) || !(this.op2 instanceof Literal)) {
                return this;
            }
            Literal literal1 = (Literal)this.op1;
            Literal literal2 = (Literal)this.op2;
            if (this.operationType == Boolean.TYPE) {
                result = literal1.booleanValue() == literal2.booleanValue();
            } else if (this.operationType == Integer.TYPE) {
                result = literal1.intValue() == literal2.intValue();
            } else if (this.operationType == Long.TYPE) {
                result = literal1.longValue() == literal2.longValue();
            } else if (this.operationType == Float.TYPE) {
                result = literal1.floatValue() == literal2.floatValue();
            } else if (this.operationType == Double.TYPE) {
                result = literal1.doubleValue() == literal2.doubleValue();
            } else if (this.operationType == String.class) {
                result = literal1.getResultType() == null ? literal2.getResultType() == null : literal1.stringValue().equals(literal2.stringValue());
            } else if (!this.operationType.isPrimitive()) {
                result = literal1.value == literal2.value;
            } else {
                throw new FatalInternalException("Bad type: " + this.operationType);
            }
            if (this.genericOp == 6) {
                result = !result;
            }
            return new Literal(this.op1.pos, new Boolean(result));
        }

        @Override
        QueryEvalNode collOpt() {
            Expr invariantOp;
            Expr expr = this.op1.isInvariant() ? this.op1 : (invariantOp = this.op2.isInvariant() ? this.op2 : null);
            if (invariantOp == null) {
                return new FilterEvalNode(new CollectionEvalNode(), this);
            }
            Expr indexPathOp = this.op1 == invariantOp ? this.op2 : this.op1;
            IndexDescriptor index = indexPathOp.getIndex(false);
            if (index == null) {
                return new FilterEvalNode(new CollectionEvalNode(), this);
            }
            return new IndexFilterEvalNode(QPT.this.elementType, index.elementClass(), index.pathString(), indexPathOp, invariantOp, this.genericOp);
        }

        @Override
        Expr notOpt(boolean notOperand) {
            if (notOperand) {
                byte notOp = 0;
                switch (this.genericOp) {
                    case 5: {
                        notOp = 6;
                        break;
                    }
                    case 6: {
                        notOp = 5;
                        break;
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericOp);
                    }
                }
                return new Equality(this.pos, notOp, this.op1, this.op2);
            }
            return this;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            int specificEqOp;
            insn = this.op1.getInstructions(insn, classFile, asPredicate);
            insn = this.op2.getInstructions(insn, classFile, asPredicate);
            if (this.genericOp != 5 && this.genericOp != 6) {
                throw new FatalInternalException("Bad op: " + this.genericOp);
            }
            if (this.operationType == String.class) {
                return this.getStringInstructions(insn, classFile);
            }
            if (this.operationType == Boolean.TYPE || this.operationType == Byte.TYPE || this.operationType == Short.TYPE || this.operationType == Character.TYPE || this.operationType == Integer.TYPE) {
                specificEqOp = this.genericOp == 5 ? 159 : 160;
            } else if (!this.operationType.isPrimitive()) {
                specificEqOp = this.genericOp == 5 ? 165 : 166;
            } else {
                if (this.operationType == Double.TYPE) {
                    insn = insn.append(Insn.create(151));
                } else if (this.operationType == Float.TYPE) {
                    insn = insn.append(Insn.create(149));
                } else if (this.operationType == Long.TYPE) {
                    insn = insn.append(Insn.create(148));
                } else {
                    throw new FatalInternalException("Unknown operation type: " + this.operationType);
                }
                specificEqOp = this.genericOp == 5 ? 153 : 154;
            }
            return this.branchToBoolean(insn, specificEqOp, true);
        }

        @Override
        String operatorImage() {
            switch (this.genericOp) {
                case 5: {
                    return "==";
                }
                case 6: {
                    return "!=";
                }
            }
            throw new FatalInternalException("Bad op: " + this.genericOp);
        }

        private Insn getStringInstructions(Insn insn, ClassFile classFile) {
            InsnTarget a = new InsnTarget();
            InsnTarget z = new InsnTarget();
            insn = insn.append(Insn.create(92));
            insn = insn.append(Insn.create(87));
            insn = insn.append(Insn.create(199, a));
            insn = this.branchToBoolean(insn, this.genericOp == 5 ? 165 : 166, true);
            insn = insn.append(Insn.create(167, z));
            insn = insn.append(a).append(Insn.create(182, classFile.pool().addMethodRef("java/lang/String", "equals", "(Ljava/lang/Object;)Z")));
            if (this.genericOp == 6) {
                insn = insn.append(Insn.create(4));
                insn = insn.append(Insn.create(130));
            }
            insn = insn.append(z);
            return insn;
        }
    }

    public class Relational
    extends BinaryExpr {
        public Relational(int pos, byte genericRelOp, Expr op1, Expr op2) {
            int[] posList;
            super(pos, genericRelOp, op1, op2);
            this.operationType = op1.getResultType();
            switch (genericRelOp) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new FatalInternalException("Bad relational operator: " + genericRelOp);
                }
            }
            Class t1 = op1.getResultType();
            Class t2 = op2.getResultType();
            if (this.typesMismatched(t1, t2)) {
                posList = new int[]{op1.pos, pos, op2.pos};
                QPT.this.error(posList, "Type mismatch in relational expression; operand types: " + QPT.quote(t1) + " and " + QPT.quote(t2));
            }
            if (QPT.this.isNumericType(t1)) {
                this.operationType = this.doBinaryNumericPromotions();
            } else if (t1 == String.class && t2 == String.class || t1 == String.class && t2 == null || t1 == null && t2 == String.class) {
                this.operationType = String.class;
            } else {
                posList = new int[]{op1.pos, pos, op2.pos};
                QPT.this.error(posList, "Operator cannot be applied to " + QPT.quote(t1) + " value");
            }
        }

        @Override
        public Expr getFoldedExpr() {
            boolean result;
            this.op1 = this.op1.getFoldedExpr();
            this.op2 = this.op2.getFoldedExpr();
            if (!(this.op1 instanceof Literal) || !(this.op2 instanceof Literal)) {
                return this;
            }
            Literal literal1 = (Literal)this.op1;
            Literal literal2 = (Literal)this.op2;
            if (this.operationType == Integer.TYPE) {
                int i1 = literal1.intValue();
                int i2 = literal2.intValue();
                switch (this.genericOp) {
                    case 2: {
                        result = i1 > i2;
                        break;
                    }
                    case 1: {
                        result = i1 < i2;
                        break;
                    }
                    case 4: {
                        result = i1 >= i2;
                        break;
                    }
                    case 3: {
                        result = i1 <= i2;
                        break;
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericOp);
                    }
                }
            } else if (this.operationType == Long.TYPE) {
                long l1 = literal1.longValue();
                long l2 = literal2.longValue();
                switch (this.genericOp) {
                    case 2: {
                        result = l1 > l2;
                        break;
                    }
                    case 1: {
                        result = l1 < l2;
                        break;
                    }
                    case 4: {
                        result = l1 >= l2;
                        break;
                    }
                    case 3: {
                        result = l1 <= l2;
                        break;
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericOp);
                    }
                }
            } else if (this.operationType == Float.TYPE) {
                float f1 = literal1.floatValue();
                float f2 = literal2.floatValue();
                switch (this.genericOp) {
                    case 2: {
                        result = f1 > f2;
                        break;
                    }
                    case 1: {
                        result = f1 < f2;
                        break;
                    }
                    case 4: {
                        result = f1 >= f2;
                        break;
                    }
                    case 3: {
                        result = f1 <= f2;
                        break;
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericOp);
                    }
                }
            } else if (this.operationType == Double.TYPE) {
                double d1 = literal1.doubleValue();
                double d2 = literal2.doubleValue();
                switch (this.genericOp) {
                    case 2: {
                        result = d1 > d2;
                        break;
                    }
                    case 1: {
                        result = d1 < d2;
                        break;
                    }
                    case 4: {
                        result = d1 >= d2;
                        break;
                    }
                    case 3: {
                        result = d1 <= d2;
                        break;
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericOp);
                    }
                }
            } else if (this.operationType == String.class) {
                String s1 = literal1.stringValue();
                String s2 = literal2.stringValue();
                switch (this.genericOp) {
                    case 2: {
                        result = this.compareStrings(s1, s2) > 0;
                        break;
                    }
                    case 1: {
                        result = this.compareStrings(s1, s2) < 0;
                        break;
                    }
                    case 4: {
                        result = this.compareStrings(s1, s2) >= 0;
                        break;
                    }
                    case 3: {
                        result = this.compareStrings(s1, s2) <= 0;
                        break;
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericOp);
                    }
                }
            } else {
                throw new FatalInternalException("Bad type: " + this.operationType);
            }
            return new Literal(this.op1.pos, new Boolean(result));
        }

        private int compareStrings(String s1, String s2) {
            if (s1 == null) {
                if (s2 == null) {
                    return 0;
                }
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }

        @Override
        public Class getResultType() {
            return Boolean.TYPE;
        }

        @Override
        QueryEvalNode collOpt() {
            Expr invariantOp;
            Expr expr = this.op1.isInvariant() ? this.op1 : (invariantOp = this.op2.isInvariant() ? this.op2 : null);
            if (invariantOp == null) {
                return new FilterEvalNode(new CollectionEvalNode(), this);
            }
            Expr indexPathOp = this.op1 == invariantOp ? this.op2 : this.op1;
            IndexDescriptor index = indexPathOp.getIndex(true);
            if (index == null) {
                return new FilterEvalNode(new CollectionEvalNode(), this);
            }
            byte relOp = this.genericOp;
            if (this.op1.isInvariant()) {
                switch (this.genericOp) {
                    case 1: {
                        relOp = 2;
                        break;
                    }
                    case 3: {
                        relOp = 4;
                        break;
                    }
                    case 2: {
                        relOp = 1;
                        break;
                    }
                    case 4: {
                        relOp = 3;
                    }
                }
            }
            return new IndexFilterEvalNode(QPT.this.elementType, index.elementClass(), index.pathString(), indexPathOp, invariantOp, relOp);
        }

        @Override
        Expr notOpt(boolean notOperand) {
            if (notOperand) {
                byte notOp = 0;
                switch (this.genericOp) {
                    case 2: {
                        notOp = 3;
                        break;
                    }
                    case 1: {
                        notOp = 4;
                        break;
                    }
                    case 4: {
                        notOp = 1;
                        break;
                    }
                    case 3: {
                        notOp = 2;
                        break;
                    }
                    default: {
                        throw new FatalInternalException("Bad op: " + this.genericOp);
                    }
                }
                return new Relational(this.pos, notOp, this.op1, this.op2);
            }
            return this;
        }

        @Override
        final boolean isInvariant() {
            return this.op1.isInvariant() && this.op2.isInvariant();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            int specificRelOp;
            insn = this.op1.getInstructions(insn, classFile, asPredicate);
            insn = this.op2.getInstructions(insn, classFile, asPredicate);
            boolean jumpValue = true;
            if (this.operationType == Byte.TYPE || this.operationType == Short.TYPE || this.operationType == Character.TYPE || this.operationType == Integer.TYPE) {
                if (this.genericOp == 1) {
                    specificRelOp = 161;
                    return this.branchToBoolean(insn, specificRelOp, jumpValue);
                } else if (this.genericOp == 2) {
                    specificRelOp = 163;
                    return this.branchToBoolean(insn, specificRelOp, jumpValue);
                } else if (this.genericOp == 3) {
                    specificRelOp = 164;
                    return this.branchToBoolean(insn, specificRelOp, jumpValue);
                } else {
                    if (this.genericOp != 4) throw new FatalInternalException("Bad op: " + this.genericOp);
                    specificRelOp = 162;
                }
                return this.branchToBoolean(insn, specificRelOp, jumpValue);
            } else {
                if (this.genericOp == 1) {
                    specificRelOp = 155;
                } else if (this.genericOp == 2) {
                    specificRelOp = 157;
                } else if (this.genericOp == 3) {
                    specificRelOp = 157;
                    jumpValue = false;
                } else {
                    if (this.genericOp != 4) throw new FatalInternalException("Bad op: " + this.genericOp);
                    specificRelOp = 155;
                    jumpValue = false;
                }
                if (this.operationType == String.class) {
                    return this.getStringInstructions(insn, classFile, specificRelOp, jumpValue);
                }
                if (this.operationType == Double.TYPE) {
                    insn = insn.append(Insn.create(151));
                    return this.branchToBoolean(insn, specificRelOp, jumpValue);
                } else if (this.operationType == Float.TYPE) {
                    insn = insn.append(Insn.create(149));
                    return this.branchToBoolean(insn, specificRelOp, jumpValue);
                } else {
                    if (this.operationType != Long.TYPE) throw new FatalInternalException("Bad type: " + this.operationType);
                    insn = insn.append(Insn.create(148));
                }
            }
            return this.branchToBoolean(insn, specificRelOp, jumpValue);
        }

        @Override
        String operatorImage() {
            switch (this.genericOp) {
                case 1: {
                    return "<";
                }
                case 2: {
                    return ">";
                }
                case 3: {
                    return "<=";
                }
                case 4: {
                    return ">=";
                }
            }
            throw new FatalInternalException("Bad relational operator: " + this.genericOp);
        }

        private Insn getStringInstructions(Insn insn, ClassFile classFile, int specificRelOp, boolean jumpValue) {
            InsnTarget a = new InsnTarget();
            InsnTarget b = new InsnTarget();
            InsnTarget c = new InsnTarget();
            InsnTarget z = new InsnTarget();
            insn = insn.append(Insn.create(92));
            insn = insn.append(Insn.create(199, a));
            insn = insn.append(Insn.create(88));
            insn = insn.append(Insn.create(199, b));
            insn = insn.append(Insn.create(3));
            insn = insn.append(Insn.create(167, z));
            insn = insn.append(b).append(Insn.create(4));
            insn = insn.append(Insn.create(167, z));
            insn = insn.append(a).append(Insn.create(199, c));
            insn = insn.append(Insn.create(88));
            insn = insn.append(Insn.create(2));
            insn = insn.append(Insn.create(167, z));
            insn = insn.append(c).append(Insn.create(182, classFile.pool().addMethodRef("java/lang/String", "compareTo", "(Ljava/lang/String;)I")));
            insn = insn.append(z);
            insn = this.branchToBoolean(insn, specificRelOp, jumpValue);
            return insn;
        }
    }

    public class MethodSelect
    extends MemberSelect {
        String methodName;
        Method method;
        Expr[] actualArguments;

        public MethodSelect(int pos, Lvalue lhs, String methodName, Vector actualArguments) {
            super(pos, lhs, methodName);
            this.qualifyingClass = ((Expr)((Object)lhs)).getResultType();
            this.methodName = methodName;
            this.setActualArguments(actualArguments);
            this.resolveMethod();
        }

        public MethodSelect(int pos, Class qualifyingClass, String methodName, Vector actualArguments) {
            super(pos, null, methodName);
            this.qualifyingClass = qualifyingClass;
            this.methodName = methodName;
            this.setActualArguments(actualArguments);
            this.resolveMethod();
        }

        @Override
        public Expr getFoldedExpr() {
            return this;
        }

        private void resolveMethod() {
            Class[] actualArgTypes = new Class[this.actualArguments.length];
            for (int i = 0; i < this.actualArguments.length; ++i) {
                actualArgTypes[i] = this.actualArguments[i].getResultType();
            }
            Method[] m = this.qualifyingClass.getMethods();
            Stack<Method> applicableMethods = new Stack<Method>();
            int argMatch = 0;
            block1: for (int i = 0; i < m.length; ++i) {
                Method curr = m[i];
                Class<?>[] formalArgTypes = curr.getParameterTypes();
                if (!curr.getName().equals(this.methodName) || formalArgTypes.length != this.actualArguments.length) continue;
                ++argMatch;
                for (int j = 0; j < this.actualArguments.length; ++j) {
                    Class actualArgType = this.actualArguments[j].getResultType();
                    Class<?> formalArgType = formalArgTypes[j];
                    if (actualArgType == null ? formalArgType.isPrimitive() : !actualArgType.equals(formalArgType) && !formalArgType.isAssignableFrom(actualArgType) && !this.canApplyWideningConversion(formalArgType, actualArgType)) continue block1;
                }
                applicableMethods.push(curr);
            }
            if (argMatch == 0) {
                QPT.this.error(this.pos, "method does not exist or is not public");
            }
            if (applicableMethods.isEmpty()) {
                QPT.this.error(this.pos, "none of the methods defined in this class are applicable to this invocation.");
            }
            this.method = this.selectSpecificMethod(applicableMethods);
            if (this.method == null) {
                QPT.this.error(this.pos, "the method invocation is ambiguous");
            }
            this.applyWideningConversions(actualArgTypes);
            if (Modifier.isStatic(this.method.getModifiers())) {
                this.op = null;
            } else if (this.op == null) {
                QPT.this.error("static reference to non-static method " + QPT.quote(this.methodName));
            }
            this.qualifyingClass = this.method.getDeclaringClass();
        }

        private Method selectSpecificMethod(Stack applicableMethods) {
            block0: for (int i = 0; i < applicableMethods.size(); ++i) {
                Method curr = (Method)applicableMethods.elementAt(i);
                Class<?> currClass = curr.getDeclaringClass();
                Class<?>[] currArgTypes = curr.getParameterTypes();
                for (int j = 0; j < applicableMethods.size(); ++j) {
                    if (i == j) continue;
                    Method test = (Method)applicableMethods.elementAt(j);
                    Class<?> testClass = test.getDeclaringClass();
                    if (!testClass.isAssignableFrom(currClass)) continue block0;
                    Class<?>[] testArgTypes = test.getParameterTypes();
                    for (int k = 0; k < currArgTypes.length; ++k) {
                        Class<?> currArgType = currArgTypes[k];
                        Class<?> testArgType = testArgTypes[k];
                        if (!currArgType.equals(testArgType) && !testArgType.isAssignableFrom(currArgType) && !this.canApplyWideningConversion(testArgType, currArgType)) continue block0;
                    }
                }
                return curr;
            }
            return null;
        }

        private void applyWideningConversions(Class[] actualArgTypes) {
            Class<?>[] formalArgTypes = this.method.getParameterTypes();
            for (int i = 0; i < formalArgTypes.length; ++i) {
                if (!QPT.this.isNumericType(formalArgTypes[i]) || formalArgTypes[i].equals(actualArgTypes[i])) continue;
                this.actualArguments[i] = new Cast(this.actualArguments[i].pos, formalArgTypes[i], this.actualArguments[i]);
            }
        }

        private boolean canApplyWideningConversion(Class target, Class source) {
            if (source == Byte.TYPE) {
                return target == Short.TYPE || target == Integer.TYPE || target == Long.TYPE || QPT.this.isFloatingPointType(target);
            }
            if (source == Short.TYPE || source == Character.TYPE) {
                return target == Integer.TYPE || target == Long.TYPE || QPT.this.isFloatingPointType(target);
            }
            if (source == Integer.TYPE) {
                return target == Long.TYPE || QPT.this.isFloatingPointType(target);
            }
            if (source == Long.TYPE) {
                return QPT.this.isFloatingPointType(target);
            }
            if (source == Float.TYPE) {
                return target == Double.TYPE;
            }
            return false;
        }

        private void setActualArguments(Vector actualArguments) {
            this.actualArguments = new Expr[actualArguments.size()];
            for (int i = 0; i < actualArguments.size(); ++i) {
                this.actualArguments[i] = (Expr)actualArguments.elementAt(i);
            }
        }

        @Override
        final boolean isInvariant() {
            if (this.op != null && !this.op.isInvariant()) {
                return false;
            }
            for (int i = 0; i < this.actualArguments.length; ++i) {
                if (this.actualArguments[i].isInvariant()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Class getResultType() {
            if (this.method != null) {
                return this.method.getReturnType();
            }
            return Void.TYPE;
        }

        private String getMethodSignature() {
            String argSignature = "";
            Class<?>[] args = this.method.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                argSignature = argSignature + Utilities.getClassSignature(args[i]);
            }
            return "(" + argSignature + ")" + Utilities.getClassSignature(this.method.getReturnType());
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            if (this.op != null) {
                insn = this.op.getInstructions(insn, classFile, asPredicate);
                if (asPredicate) {
                    insn = insn.append(Insn.create(89));
                    InsnTarget a = new InsnTarget();
                    insn = insn.append(Insn.create(199, a));
                    insn = insn.append(Insn.create(3));
                    insn = insn.append(Insn.create(172));
                    insn = insn.append(a);
                }
            }
            for (int i = 0; i < this.actualArguments.length; ++i) {
                insn = this.actualArguments[i].getInstructions(insn, classFile, asPredicate);
            }
            if (this.method.getDeclaringClass().isInterface()) {
                insn = insn.append(new InsnInterfaceInvoke(classFile.pool().addInterfaceMethodRef(Utilities.getClassVMName(this.method.getDeclaringClass()), this.method.getName(), this.getMethodSignature()), this.actualArguments.length + 1));
            } else {
                ConstMethodRef methodRef = classFile.pool().addMethodRef(Utilities.getClassVMName(this.method.getDeclaringClass()), this.method.getName(), this.getMethodSignature());
                int opcall = Modifier.isStatic(this.method.getModifiers()) ? 184 : (this.op instanceof SuperRef ? 183 : 182);
                insn = insn.append(Insn.create(opcall, methodRef));
            }
            return insn;
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(this.identityToString() + "method=" + this.method + ", methodName=" + this.methodName + ", actualArguments={");
            if (this.actualArguments.length > 0) {
                result.append(this.actualArguments[0].identityToString());
                for (int i = 1; i < this.actualArguments.length; ++i) {
                    result.append(", " + this.actualArguments[i].identityToString());
                }
            }
            return result + "}, " + super.toString();
        }

        @Override
        String toPrintString() {
            String result = "{";
            if (Modifier.isStatic(this.method.getModifiers())) {
                result = result + "static ";
            }
            if (this.op != null && !(this.op instanceof ThisRef)) {
                result = result + this.op.toPrintString() + " . ";
            }
            result = result + this.method.getReturnType().getName() + " ";
            if (!this.qualifyingClass.getName().equals(QPT.this.elementType.getName())) {
                result = result + this.qualifyingClass.getName() + ".";
            }
            result = result + this.method.getName() + "(";
            for (int i = 0; i < this.actualArguments.length; ++i) {
                if (i != 0) {
                    result = result + ", ";
                }
                result = result + this.actualArguments[i].toPrintString();
            }
            result = result + ")}";
            return result;
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            out.println(this.indentedString(indentLevel, this.toPrintString()));
        }
    }

    public class FieldSelect
    extends MemberSelect {
        Field field;

        @Override
        public Expr getFoldedExpr() {
            return this;
        }

        private void resolveField(String fieldName) {
            if (this.qualifyingClass.isPrimitive()) {
                QPT.this.error("Attempt to select field " + QPT.quote(fieldName) + " of the primitive type " + QPT.quote(this.qualifyingClass.toString()));
            }
            try {
                this.field = this.qualifyingClass.getField(fieldName);
                if (Modifier.isStatic(this.field.getModifiers())) {
                    this.op = null;
                } else if (this.op == null) {
                    QPT.this.error("static reference to non-static field " + QPT.quote(fieldName));
                }
                this.qualifyingClass = this.field.getDeclaringClass();
            }
            catch (NoSuchFieldException e) {
                QPT.this.error("field " + QPT.quote(this.qualifyingClass.toString() + '.' + fieldName) + " does not exist or is not public");
            }
        }

        public FieldSelect(int pos, Class qualifyingClass, String fieldName) {
            super(pos, null, fieldName);
            this.qualifyingClass = qualifyingClass;
            this.resolveField(fieldName);
        }

        public FieldSelect(int pos, Lvalue lhs, String fieldName) {
            super(pos, lhs, fieldName);
            this.qualifyingClass = ((Expr)((Object)lhs)).getResultType();
            this.resolveField(fieldName);
        }

        @Override
        final boolean isInvariant() {
            return this.op == null || this.op.isInvariant();
        }

        @Override
        public Class getResultType() {
            return this.field.getType();
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            String typename = Utilities.getClassSignature(this.field.getType());
            ConstFieldRef fieldRef = classFile.pool().addFieldRef(Utilities.getClassVMName(this.qualifyingClass), this.field.getName(), typename);
            if (Modifier.isStatic(this.field.getModifiers())) {
                return insn.append(Insn.create(178, fieldRef));
            }
            insn = this.op.getInstructions(insn, classFile, asPredicate);
            if (asPredicate) {
                insn = insn.append(Insn.create(89));
                InsnTarget a = new InsnTarget();
                insn = insn.append(Insn.create(199, a));
                insn = insn.append(Insn.create(3));
                insn = insn.append(Insn.create(172));
                insn = insn.append(a);
            }
            if (IPersistent.class.isAssignableFrom(this.qualifyingClass)) {
                insn = insn.append(Insn.create(89));
                insn = insn.append(Insn.create(184, classFile.pool().addMethodRef("com/odi/ObjectStore", "fetch", "(Lcom/odi/IPersistent;)V")));
            }
            insn = insn.append(Insn.create(180, fieldRef));
            return insn;
        }

        @Override
        public String toString() {
            return this.identityToString() + ": field=" + this.field + ", qualifyingClass=" + this.qualifyingClass + ", " + super.toString();
        }

        @Override
        String toPrintString() {
            String result = "{";
            if ((this.field.getModifiers() & 8) != 0) {
                result = result + "static ";
            }
            if (this.op != null && !(this.op instanceof ThisRef)) {
                result = result + this.op.toPrintString() + " . ";
            }
            result = result + this.field.getType().getName() + " ";
            if (!this.qualifyingClass.getName().equals(QPT.this.elementType.getName())) {
                result = result + this.qualifyingClass.getName() + ".";
            }
            result = result + this.field.getName() + "}";
            return result;
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            String text = this.indentedString(indentLevel, this.toPrintString());
            if (text.length() > 80) {
                out.println(this.indentedString(indentLevel, "{"));
                if (this.op != null && !(this.op instanceof ThisRef)) {
                    this.op.print(out, indentLevel + 1);
                    out.println(this.indentedString(indentLevel, "."));
                }
                out.print(this.indentedString(indentLevel + 1, this.field.getType().getName() + " "));
                if (!this.qualifyingClass.getName().equals(QPT.this.elementType.getName())) {
                    out.print(this.qualifyingClass.getName() + ".");
                }
                out.println(this.field.getName());
                out.println(this.indentedString(indentLevel, "}"));
            } else {
                out.println(text);
            }
        }
    }

    abstract class MemberSelect
    extends UnaryExpr
    implements Lvalue {
        String indexString;
        Class qualifyingClass;

        @Override
        public void setIndexString(String indexString) {
            this.indexString = indexString.startsWith("this.") ? indexString.substring("this.".length()) : indexString;
        }

        @Override
        public String getIndexString() {
            return this.indexString;
        }

        @Override
        public Class getThisClass() {
            if (this.op == null) {
                return null;
            }
            if (this.op instanceof ThisRef) {
                return this.qualifyingClass;
            }
            return this.op.getThisClass();
        }

        @Override
        public IndexDescriptor getIndex(boolean ordered) {
            String indexString = this.getIndexString();
            if (indexString == null) {
                return null;
            }
            IndexDescriptor index = QPT.this.findIndex(QPT.this.elementType, indexString, ordered);
            if (index != null) {
                QPT.this.requiredIndexes.add(index);
            }
            QPT.this.desirableIndexes.add(new IndexDescriptor(QPT.this.elementType, indexString, ordered, false));
            return index;
        }

        MemberSelect(int pos, Lvalue lhs, String memberName) {
            Class lhsType;
            super(pos, (Expr)((Object)lhs));
            if (lhs != null && (lhsType = ((Expr)((Object)lhs)).getResultType()).isPrimitive()) {
                QPT.this.error("Illegal member access: " + lhsType + "." + memberName);
            }
        }

        @Override
        public QueryEvalNode collOpt() {
            if (this.getResultType() != Boolean.TYPE) {
                this.badCollOptCall();
            }
            return new Equality(this.pos, 5, this, new Literal(this.pos, new Boolean(true))).collOpt();
        }

        @Override
        Expr notOpt(boolean notOperand) {
            if (this.getResultType() != Boolean.TYPE) {
                this.badNotOptCall();
            }
            return notOperand ? new Unary(this.pos, 10, this) : this;
        }
    }

    public class ConditionalAndOr
    extends NaryExpr {
        int logicalOp;

        public ConditionalAndOr(int pos, int logicalOp, Vector ops) {
            super(pos, ops);
            this.logicalOp = logicalOp;
            Vector<Integer> posVector = new Vector<Integer>();
            if (logicalOp != 7 && logicalOp != 8) {
                throw new FatalInternalException("Bad ConditionalAndOr operator: " + logicalOp);
            }
            for (int i = 0; i < this.ops.length; ++i) {
                Expr op = this.ops[i];
                if (op.getResultType() == Boolean.TYPE) continue;
                posVector.addElement(new Integer(op.pos));
            }
            if (posVector.size() != 0) {
                int[] posList = new int[posVector.size()];
                for (int i = 0; i < posVector.size(); ++i) {
                    posList[i] = (Integer)posVector.elementAt(i);
                }
                QPT.this.error(posList, "Operator cannot be applied to non-boolean value");
            }
        }

        Expr[] removeNullElements(Expr[] oldOps, int removeCount) {
            int j = 0;
            Expr[] newOps = new Expr[oldOps.length - removeCount];
            for (int i = 0; i < oldOps.length; ++i) {
                if (oldOps[i] == null) continue;
                newOps[j++] = oldOps[i];
            }
            return newOps;
        }

        @Override
        public Expr getFoldedExpr() {
            int removeCount = 0;
            int firstOpPos = this.ops[0].pos;
            Expr result = this;
            for (int i = 0; i < this.ops.length && result == this; ++i) {
                this.ops[i] = this.ops[i].getFoldedExpr();
                if (!(this.ops[i] instanceof Literal)) continue;
                Literal literal = (Literal)this.ops[i];
                boolean value = literal.booleanValue();
                if (this.logicalOp == 7 && !value || this.logicalOp == 8 && value) {
                    result = new Literal(firstOpPos, new Boolean(this.logicalOp == 8));
                    continue;
                }
                this.ops[i] = null;
                ++removeCount;
            }
            if (removeCount == this.ops.length) {
                result = new Literal(firstOpPos, new Boolean(this.logicalOp == 7));
            } else if (removeCount > 0) {
                this.ops = this.removeNullElements(this.ops, removeCount);
            }
            return result;
        }

        @Override
        QueryEvalNode collOpt() {
            return this.logicalOp == 8 ? this.collOrOpt() : this.collAndOpt();
        }

        @Override
        Expr notOpt(boolean notOperand) {
            for (int i = 0; i < this.ops.length; ++i) {
                this.ops[i] = this.ops[i].notOpt(notOperand);
            }
            if (notOperand) {
                Vector<Expr> newOps = new Vector<Expr>();
                for (int i = 0; i < this.ops.length; ++i) {
                    newOps.addElement(this.ops[i]);
                }
                return new ConditionalAndOr(this.pos, this.logicalOp == 8 ? 7 : 8, newOps);
            }
            return this;
        }

        private void groupIndexFilter(Hashtable indexFilters, IndexFilterEvalNode node) {
            String indexString = node.getIndexPath();
            IndexFilterEvalNode n = (IndexFilterEvalNode)indexFilters.get(indexString);
            if (n == null) {
                indexFilters.put(indexString, node);
            } else if (this.logicalOp == 8) {
                n.addAll(node);
            } else {
                n.retainAll(node);
            }
        }

        private boolean tryGroupPredicate(Vector predicates, FilterEvalNode node) {
            QueryEvalNode child = node.getChild();
            if (child instanceof CollectionEvalNode) {
                predicates.addElement(node.getPredicate());
                return true;
            }
            return false;
        }

        private Vector groupOperands(Vector predicates) {
            Hashtable indexFilters = new Hashtable(5);
            Vector<QueryEvalNode> miscColl = new Vector<QueryEvalNode>(5);
            for (int i = 0; i < this.ops.length; ++i) {
                QueryEvalNode qnode = this.ops[i].collOpt();
                if (qnode instanceof IndexFilterEvalNode) {
                    this.groupIndexFilter(indexFilters, (IndexFilterEvalNode)qnode);
                    continue;
                }
                if (qnode instanceof FilterEvalNode) {
                    if (this.tryGroupPredicate(predicates, (FilterEvalNode)qnode)) continue;
                    miscColl.addElement(qnode);
                    continue;
                }
                miscColl.addElement(qnode);
            }
            Vector<Object> opnds = new Vector<Object>(5);
            Enumeration e = indexFilters.elements();
            while (e.hasMoreElements()) {
                opnds.addElement(e.nextElement());
            }
            for (int i = 0; i < miscColl.size(); ++i) {
                opnds.addElement(miscColl.elementAt(i));
            }
            return opnds;
        }

        QueryEvalNode collAndOpt() {
            Vector predicates = new Vector(5);
            Vector intersectionOps = this.groupOperands(predicates);
            QueryEvalNode result = intersectionOps.isEmpty() ? new CollectionEvalNode() : (intersectionOps.size() == 1 ? (QueryEvalNode)intersectionOps.elementAt(0) : new IntersectionEvalNode(intersectionOps));
            if (predicates.isEmpty()) {
                return result;
            }
            Expr predicateExpr = null;
            if (predicates.size() == 1) {
                predicateExpr = (Expr)predicates.elementAt(0);
            } else {
                Expr[] predOpnds = new Expr[predicates.size()];
                for (int i = 0; i < predicates.size(); ++i) {
                    predOpnds[i] = (Expr)predicates.elementAt(i);
                }
                this.ops = predOpnds;
                predicateExpr = this;
            }
            if (intersectionOps.size() == 1 && result instanceof IndexFilterEvalNode) {
                ((IndexFilterEvalNode)result).retainAll(predicateExpr);
                return result;
            }
            return new FilterEvalNode(result, predicateExpr);
        }

        QueryEvalNode collOrOpt() {
            Vector predicates = new Vector(5);
            Vector opnds = this.groupOperands(predicates);
            Expr[] predOpnds = new Expr[predicates.size()];
            FilterEvalNode predicateFilter = null;
            if (!predicates.isEmpty()) {
                for (int i = 0; i < predicates.size(); ++i) {
                    predOpnds[i] = (Expr)predicates.elementAt(i);
                }
                this.ops = predOpnds;
                predicateFilter = new FilterEvalNode(new CollectionEvalNode(), this);
            } else if (opnds.size() == 1) {
                return (QueryEvalNode)opnds.elementAt(0);
            }
            if (opnds.isEmpty()) {
                return predicateFilter;
            }
            if (predicateFilter != null) {
                opnds.addElement(predicateFilter);
            }
            return new UnionEvalNode(opnds);
        }

        @Override
        public Class getResultType() {
            return Boolean.TYPE;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            boolean isAnd = this.logicalOp == 7;
            InsnTarget known = new InsnTarget();
            int testOpcode = isAnd ? 153 : 154;
            for (int i = 0; i < this.ops.length; ++i) {
                Expr op = this.ops[i];
                insn = op.getInstructions(insn, classFile, asPredicate);
                insn = insn.append(Insn.create(testOpcode, known));
            }
            insn = insn.append(Insn.create(isAnd ? 4 : 3));
            InsnTarget end = new InsnTarget();
            insn = insn.append(Insn.create(167, end));
            insn = insn.append(known);
            insn = insn.append(Insn.create(isAnd ? 3 : 4));
            insn = insn.append(end);
            return insn;
        }

        @Override
        public String operatorImage() {
            if (this.logicalOp == 7) {
                return "&&";
            }
            return "||";
        }
    }

    public class Name
    extends Expr {
        Lvalue root;
        Vector members;

        public Name(Lvalue root, String member) {
            super(root != null ? ((Expr)((Object)root)).pos : -1);
            this.members = new Vector(5);
            this.root = root;
            if (member != null) {
                this.members.addElement(member);
            }
        }

        public Name(int pos, String member) {
            super(pos);
            this.members = new Vector(5);
            this.members.addElement(member);
        }

        public Name select(String member) {
            this.members.addElement(member);
            return this;
        }

        @Override
        public Expr getFoldedExpr() {
            throw new FatalInternalException("Name.getFoldedExpr() was called");
        }

        private Class extractMemberPrefixClass(boolean throwError) {
            String cname = null;
            Class currClass = null;
            int i = 0;
            for (i = 0; i < this.members.size() - 1 && (currClass = QPT.this.classForNameDefaultingPackage(cname = cname == null ? (String)this.members.elementAt(i) : cname + "." + (String)this.members.elementAt(i))) == null; ++i) {
            }
            if (throwError) {
                if (currClass == null) {
                    QPT.this.error("the identifier " + QPT.quote(cname == null ? this.members.elementAt(0) : cname) + " could not be resolved to a public field, " + "package or class name.");
                }
                if (this.members.size() == i + 1) {
                    QPT.this.error("Expected a field identifier, not the class identifier: " + cname);
                }
            }
            if (currClass != null) {
                while (i >= 0) {
                    this.members.removeElementAt(i);
                    --i;
                }
            }
            return currClass;
        }

        public Expr resolveToField() {
            if (this.root == null) {
                String id1 = (String)this.members.firstElement();
                Class fvType = (Class)QPT.this.freeVariables.get(id1);
                if (fvType == null) {
                    try {
                        QPT.this.elementType.getField(id1);
                        this.root = new ThisRef(this.pos);
                    }
                    catch (NoSuchFieldException e) {
                        Class c = this.extractMemberPrefixClass(true);
                        this.root = new FieldSelect(this.pos, c, (String)this.members.firstElement());
                        this.members.removeElementAt(0);
                    }
                } else {
                    this.root = new FreeVariableRef(this.pos, id1, fvType);
                    this.members.removeElementAt(0);
                }
            }
            Lvalue currExpr = this.root;
            for (int i = 0; i < this.members.size(); ++i) {
                currExpr = new FieldSelect(this.pos, currExpr, (String)this.members.elementAt(i));
            }
            String indexString = this.root.getIndexString();
            if (indexString != null) {
                for (int i = 0; i < this.members.size(); ++i) {
                    indexString = indexString + "." + (String)this.members.elementAt(i);
                }
                currExpr.setIndexString(indexString);
            }
            return (Expr)((Object)currExpr);
        }

        public MethodSelect resolveToMethod(Vector args) {
            String indexString;
            if (args == null) {
                args = new Vector();
            }
            String methodName = (String)this.members.lastElement();
            if (this.root == null) {
                if (this.members.size() == 1) {
                    this.root = new ThisRef(this.pos);
                } else {
                    Class c = this.extractMemberPrefixClass(false);
                    if (c != null) {
                        if (this.members.size() == 1) {
                            return new MethodSelect(this.pos, c, methodName, args);
                        }
                        this.root = new FieldSelect(this.pos, c, (String)this.members.elementAt(0));
                        this.members.removeElementAt(0);
                    }
                }
            }
            this.members.removeElementAt(this.members.size() - 1);
            if (this.members.size() != 0) {
                this.root = (Lvalue)((Object)this.resolveToField());
            }
            MethodSelect ms = new MethodSelect(this.pos, this.root, methodName, args);
            String indexArgs = this.getIndexArgsString(args);
            String indexRoot = this.root.getIndexString();
            if (indexArgs != null && indexRoot != null && (indexString = indexRoot + "." + methodName) != null) {
                ms.setIndexString(indexString + indexArgs);
            }
            return ms;
        }

        private String getIndexArgsString(Vector args) {
            String indexArgsString = "";
            if (args.isEmpty()) {
                return "()";
            }
            for (int i = 0; i < args.size(); ++i) {
                Expr lit = (Expr)args.elementAt(i);
                if (!(lit instanceof Literal)) {
                    return null;
                }
                indexArgsString = indexArgsString + "," + ((Literal)lit).indexStringValue();
            }
            return "(" + indexArgsString.substring(1, indexArgsString.length()) + ")";
        }

        public Class resolveToType() {
            String className = (String)this.members.elementAt(0);
            for (int i = 1; i < this.members.size(); ++i) {
                className = className + "." + (String)this.members.elementAt(i);
            }
            Class result = QPT.this.classForNameDefaultingPackage(className);
            if (result == null) {
                QPT.this.error(this.pos, "Class not found: " + className);
            }
            return result;
        }

        @Override
        boolean isInvariant() {
            throw new FatalInternalException("Name.isInvariant() was called");
        }

        @Override
        public Class getResultType() {
            throw new FatalInternalException("Name.getResultType() was called");
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            throw new FatalInternalException("Name.getInstructions() was called");
        }

        @Override
        public String toString() {
            return this.identityToString() + ": members=" + this.members + ", " + super.toString();
        }

        @Override
        String toPrintString() {
            throw new FatalInternalException("Name.toPrintString() was called");
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            throw new FatalInternalException("Name.print() was called");
        }
    }

    public class FreeVariableRef
    extends VariableRef {
        final String name;
        final Class type;

        public FreeVariableRef(String name, Class type) {
            super(-1);
            this.name = name;
            this.type = type;
        }

        public FreeVariableRef(int pos, String name, Class type) {
            super(pos);
            this.name = name;
            this.type = type;
        }

        @Override
        public Expr getFoldedExpr() {
            return this;
        }

        @Override
        final boolean isInvariant() {
            return true;
        }

        @Override
        public Class getResultType() {
            return this.type;
        }

        @Override
        public QueryEvalNode collOpt() {
            Class vtype = (Class)QPT.this.freeVariables.get(this.name);
            if (vtype != Boolean.TYPE) {
                this.badCollOptCall();
            }
            return new FilterEvalNode(new CollectionEvalNode(), this);
        }

        @Override
        Expr notOpt(boolean notOperand) {
            return notOperand ? new Unary(this.pos, 10, this) : this;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(180, classFile.pool().addFieldRef(classFile.className().asString(), this.name, Utilities.getClassSignature(this.type))));
            return insn;
        }

        @Override
        public String toString() {
            return this.identityToString() + ": type=" + this.type + ", name=" + this.name + ", " + super.toString();
        }

        @Override
        String toPrintString() {
            return "{Free Variable: " + this.type.getName() + " " + this.name + "}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            out.println(this.indentedString(indentLevel, this.toPrintString()));
        }

        @Override
        public String getIndexString() {
            return null;
        }
    }

    abstract class VariableRef
    extends Expr
    implements Lvalue {
        VariableRef(int pos) {
            super(pos);
        }

        @Override
        public void setIndexString(String s) {
            throw new FatalInternalException("setIndexString(): invoked on a VariableRef");
        }

        @Override
        public IndexDescriptor getIndex(boolean ordered) {
            return null;
        }
    }

    public class DeclaringThisRef
    extends VariableRef {
        Class declaringClass;

        public DeclaringThisRef(int pos, Class declaringClass) {
            super(pos);
            this.declaringClass = declaringClass;
        }

        @Override
        public Expr getFoldedExpr() {
            QPT.this.TBD("DeclaringThisRef.getFoldedExpr");
            return null;
        }

        @Override
        final boolean isInvariant() {
            return false;
        }

        @Override
        public Class getResultType() {
            return this.declaringClass;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            QPT.this.TBD("DeclaringThisRef.getInstructions not supported");
            return null;
        }

        @Override
        public String toString() {
            return this.identityToString() + ": declaringClass=" + this.declaringClass + ", " + super.toString();
        }

        @Override
        public String toPrintString() {
            return "{" + this.declaringClass.getName() + ".this}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            out.println(this.indentedString(indentLevel, this.toPrintString()));
        }

        @Override
        public String getIndexString() {
            return null;
        }
    }

    public class SuperRef
    extends VariableRef {
        public SuperRef(int pos) {
            super(pos);
        }

        @Override
        public Expr getFoldedExpr() {
            return this;
        }

        @Override
        final boolean isInvariant() {
            return false;
        }

        @Override
        public Class getResultType() {
            return QPT.this.elementType.getSuperclass();
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            return insn.append(Insn.create(43));
        }

        @Override
        public String toString() {
            return this.identityToString() + ": " + super.toString();
        }

        @Override
        String toPrintString() {
            return "{super}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            out.println(this.indentedString(indentLevel, this.toPrintString()));
        }

        @Override
        public String getIndexString() {
            return "this";
        }
    }

    public class ThisRef
    extends VariableRef {
        public ThisRef(int pos) {
            super(pos);
        }

        @Override
        public Expr getFoldedExpr() {
            return this;
        }

        @Override
        final boolean isInvariant() {
            return false;
        }

        @Override
        public Class getResultType() {
            return QPT.this.elementType;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            return insn.append(Insn.create(43));
        }

        @Override
        public String toString() {
            return this.identityToString() + ": " + super.toString();
        }

        @Override
        public String toPrintString() {
            return "{this}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            out.println(this.indentedString(indentLevel, this.toPrintString()));
        }

        @Override
        public String getIndexString() {
            return "this";
        }
    }

    public class Literal
    extends Expr {
        Object value;

        public Literal(int pos, Object value) {
            super(pos);
            this.value = value;
        }

        boolean booleanValue() {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            throw new FatalInternalException("Bad type: " + this.getResultType());
        }

        int intValue() {
            if (this.value instanceof Byte) {
                return ((Byte)this.value).byteValue();
            }
            if (this.value instanceof Character) {
                return ((Character)this.value).charValue();
            }
            if (this.value instanceof Short) {
                return ((Short)this.value).shortValue();
            }
            if (this.value instanceof Integer) {
                return (Integer)this.value;
            }
            if (this.value instanceof Long) {
                return (int)((Long)this.value).longValue();
            }
            if (this.value instanceof Float) {
                return (int)((Float)this.value).floatValue();
            }
            if (this.value instanceof Double) {
                return (int)((Double)this.value).doubleValue();
            }
            throw new FatalInternalException("Bad type: " + this.getResultType());
        }

        long longValue() {
            if (this.value instanceof Long) {
                return (Long)this.value;
            }
            if (this.value instanceof Float) {
                return (long)((Float)this.value).floatValue();
            }
            if (this.value instanceof Double) {
                return (long)((Double)this.value).doubleValue();
            }
            return this.intValue();
        }

        float floatValue() {
            if (this.value instanceof Long) {
                return ((Long)this.value).longValue();
            }
            if (this.value instanceof Float) {
                return ((Float)this.value).floatValue();
            }
            if (this.value instanceof Double) {
                return (float)((Double)this.value).doubleValue();
            }
            return this.intValue();
        }

        double doubleValue() {
            if (this.value instanceof Long) {
                return ((Long)this.value).longValue();
            }
            if (this.value instanceof Float) {
                return ((Float)this.value).floatValue();
            }
            if (this.value instanceof Double) {
                return (Double)this.value;
            }
            return this.intValue();
        }

        String stringValue() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            if (this.value == null) {
                return null;
            }
            throw new FatalInternalException("Bad type: " + this.getResultType());
        }

        String indexStringValue() {
            if (this.value instanceof String || this.getResultType().isPrimitive()) {
                if (this.value instanceof Character) {
                    return "'" + this.value.toString() + "'";
                }
                if (this.value instanceof String) {
                    return "\"" + this.value.toString() + "\"";
                }
                return this.value.toString();
            }
            throw new FatalInternalException("Bad type: " + this.getResultType());
        }

        @Override
        final boolean isInvariant() {
            return true;
        }

        @Override
        public Class getResultType() {
            if (this.value == null) {
                return null;
            }
            if (this.value instanceof String) {
                return String.class;
            }
            if (this.value instanceof Class) {
                return (Class)this.value;
            }
            if (this.value instanceof Boolean) {
                return Boolean.TYPE;
            }
            if (this.value instanceof Byte) {
                return Byte.TYPE;
            }
            if (this.value instanceof Character) {
                return Character.TYPE;
            }
            if (this.value instanceof Short) {
                return Short.TYPE;
            }
            if (this.value instanceof Integer) {
                return Integer.TYPE;
            }
            if (this.value instanceof Long) {
                return Long.TYPE;
            }
            if (this.value instanceof Float) {
                return Float.TYPE;
            }
            if (this.value instanceof Double) {
                return Double.TYPE;
            }
            throw new FatalInternalException("Bad type: " + this.value);
        }

        @Override
        public Expr getFoldedExpr() {
            return this;
        }

        @Override
        public QueryEvalNode collOpt() {
            if (!(this.value instanceof Boolean)) {
                super.collOpt();
            }
            if (this.booleanValue()) {
                return new CollectionEvalNode();
            }
            return new FilterEvalNode(new CollectionEvalNode(), new Literal(this.pos, new Boolean(false)));
        }

        @Override
        Expr notOpt(boolean notOperand) {
            if (!(this.value instanceof Boolean)) {
                this.badNotOptCall();
            }
            return notOperand ? new Literal(this.pos, new Boolean(!this.booleanValue())) : this;
        }

        @Override
        Insn getInstructions(Insn insn, ClassFile classFile, boolean asPredicate) {
            if (this.value == null) {
                return insn.append(Insn.create(1));
            }
            ConstantPool pool = classFile.pool();
            if (this.value instanceof String) {
                return insn.append(Insn.create(18, pool.addString((String)this.value)));
            }
            if (this.value instanceof Class) {
                return insn.append(Insn.create(18, pool.addClass(Utilities.getClassVMName((Class)this.value))));
            }
            Class resultType = this.getResultType();
            if (resultType == Float.TYPE) {
                return insn.append(InsnUtils.floatConstant(((Float)this.value).floatValue(), pool));
            }
            if (resultType == Double.TYPE) {
                return insn.append(InsnUtils.doubleConstant((Double)this.value, pool));
            }
            if (resultType == Long.TYPE) {
                return insn.append(InsnUtils.longConstant((Long)this.value, pool));
            }
            int intValue = 0;
            if (resultType == Boolean.TYPE) {
                intValue = (Boolean)this.value != false ? 1 : 0;
            } else if (resultType == Byte.TYPE) {
                intValue = ((Byte)this.value).byteValue();
            } else if (resultType == Character.TYPE) {
                intValue = ((Character)this.value).charValue();
            } else if (resultType == Short.TYPE) {
                intValue = ((Short)this.value).shortValue();
            } else if (resultType == Integer.TYPE) {
                intValue = (Integer)this.value;
            } else {
                QPT.this.error("Can't have a literal value of type " + resultType);
            }
            return insn.append(InsnUtils.integerConstant(intValue, pool));
        }

        String decoratedValueString() {
            if (this.value == null) {
                return "null";
            }
            if (this.value instanceof String) {
                return QPT.quote(this.value.toString());
            }
            if (this.value instanceof Class) {
                return "Class " + ((Class)this.value).getName();
            }
            if (this.value instanceof Boolean) {
                return "boolean " + this.value.toString();
            }
            if (this.value instanceof Byte) {
                return "byte " + this.value.toString();
            }
            if (this.value instanceof Character) {
                return "'" + this.value.toString() + "'";
            }
            if (this.value instanceof Short) {
                return "short " + this.value.toString();
            }
            if (this.value instanceof Integer) {
                return this.value.toString();
            }
            if (this.value instanceof Long) {
                return this.value.toString() + "L";
            }
            if (this.value instanceof Float) {
                return this.value.toString() + "F";
            }
            if (this.value instanceof Double) {
                return this.value.toString() + "D";
            }
            throw new FatalInternalException("Bad type: " + this.value);
        }

        @Override
        public String toString() {
            return this.identityToString() + ": value=" + this.decoratedValueString() + ", " + super.toString();
        }

        @Override
        String toPrintString() {
            return "{" + this.decoratedValueString() + "}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            out.println(this.indentedString(indentLevel, "") + this.toPrintString());
        }
    }

    abstract class NaryExpr
    extends Expr {
        Expr[] ops;

        NaryExpr(int pos, Vector operands) {
            super(pos);
            this.ops = new Expr[operands.size()];
            for (int i = 0; i < this.ops.length; ++i) {
                this.ops[i] = (Expr)operands.elementAt(i);
            }
        }

        @Override
        boolean isInvariant() {
            for (int i = 0; i < this.ops.length; ++i) {
                if (this.ops[i].isInvariant()) continue;
                return false;
            }
            return true;
        }

        abstract String operatorImage();

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(this.identityToString() + ": operator=" + this.operatorImage() + ", ops={" + this.ops[0].identityToString());
            for (int i = 1; i < this.ops.length; ++i) {
                result.append(", " + this.ops[i].identityToString());
            }
            return result + "}, " + super.toString();
        }

        @Override
        String toPrintString() {
            String result = "{" + this.ops[0].toPrintString();
            for (int i = 1; i < this.ops.length; ++i) {
                result = result + " " + this.operatorImage() + " " + this.ops[i].toPrintString();
            }
            result = result + "}";
            return result;
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            String text = this.indentedString(indentLevel, this.toPrintString());
            if (text.length() > 80) {
                out.println(this.indentedString(indentLevel, "{"));
                this.ops[0].print(out, indentLevel + 1);
                for (int i = 1; i < this.ops.length; ++i) {
                    out.println(this.indentedString(indentLevel, this.operatorImage()));
                    this.ops[i].print(out, indentLevel + 1);
                }
                out.println(this.indentedString(indentLevel, "}"));
            } else {
                out.println(text);
            }
        }
    }

    abstract class BinaryExpr
    extends Expr {
        final byte genericOp;
        Class operationType;
        Expr op1;
        Expr op2;

        BinaryExpr(int pos, byte genericOp, Expr op1, Expr op2) {
            super(pos);
            this.genericOp = genericOp;
            this.op1 = op1;
            this.op2 = op2;
        }

        Class doBinaryNumericPromotions() {
            Class t1 = this.op1.getResultType();
            Class t2 = this.op2.getResultType();
            if (t1 == Double.TYPE) {
                return this.convert(Double.TYPE, this.op2);
            }
            if (t2 == Double.TYPE) {
                return this.convert(Double.TYPE, this.op1);
            }
            if (t1 == Float.TYPE) {
                return this.convert(Float.TYPE, this.op2);
            }
            if (t2 == Float.TYPE) {
                return this.convert(Float.TYPE, this.op1);
            }
            if (t1 == Long.TYPE) {
                return this.convert(Long.TYPE, this.op2);
            }
            if (t2 == Long.TYPE) {
                return this.convert(Long.TYPE, this.op1);
            }
            this.convert(Integer.TYPE, this.op1);
            return this.convert(Integer.TYPE, this.op2);
        }

        Class convert(Class target, Expr op) {
            if (op.getResultType() == target) {
                return target;
            }
            Cast newOp = new Cast(op.pos, target, op);
            if (op == this.op1) {
                this.op1 = newOp;
            } else {
                this.op2 = newOp;
            }
            return target;
        }

        @Override
        boolean isInvariant() {
            return this.op1.isInvariant() && this.op2.isInvariant();
        }

        abstract String operatorImage();

        @Override
        public String toString() {
            return this.identityToString() + ": operator=" + this.operatorImage() + ", op1=" + this.op1.identityToString() + ", op2=" + this.op2.identityToString() + ", operationType=" + this.operationType + ", " + super.toString();
        }

        @Override
        String toPrintString() {
            return "{" + this.op1.toPrintString() + " " + this.operatorImage() + " " + this.op2.toPrintString() + "}";
        }

        @Override
        void print(PrintWriter out, int indentLevel) {
            String text = this.indentedString(indentLevel, this.toPrintString());
            if (text.length() > 80) {
                out.println(this.indentedString(indentLevel, "{"));
                this.op1.print(out, indentLevel + 1);
                out.println(this.indentedString(indentLevel, this.operatorImage()));
                this.op2.print(out, indentLevel + 1);
                out.println(this.indentedString(indentLevel, "}"));
            } else {
                out.println(text);
            }
        }

        boolean typesMismatched(Class t1, Class t2) {
            if (t1 == Void.TYPE || t2 == Void.TYPE) {
                return true;
            }
            if (t1 == t2) {
                return false;
            }
            if (t1 == Boolean.TYPE || t2 == Boolean.TYPE) {
                return true;
            }
            if (t1 == null) {
                return t2.isPrimitive();
            }
            if (t2 == null) {
                return t1.isPrimitive();
            }
            if (t1.isPrimitive()) {
                return !t2.isPrimitive();
            }
            if (t2.isPrimitive()) {
                return true;
            }
            return !t1.isAssignableFrom(t2) && !t2.isAssignableFrom(t1);
        }
    }

    abstract class UnaryExpr
    extends Expr {
        Expr op;

        UnaryExpr(int pos, Expr op) {
            super(pos);
            this.op = op;
        }

        @Override
        public String toString() {
            return "op=" + (this.op == null ? "null" : this.op.identityToString()) + ", " + super.toString();
        }
    }

    public abstract class Expr
    extends PrintableNode {
        public int pos = -1;

        abstract boolean isInvariant();

        public abstract Class getResultType();

        QueryEvalNode collOpt() {
            this.badCollOptCall();
            return null;
        }

        void badCollOptCall() {
            throw new FatalInternalException("Query expression: " + QPT.quote(QPT.this.queryExpression) + " collOpt() invoked on a " + this.getClass().getName() + " node with result type:" + this.getResultType());
        }

        Expr notOpt(boolean notOperand) {
            this.badNotOptCall();
            return null;
        }

        void badNotOptCall() {
            throw new FatalInternalException("Query expression: " + QPT.quote(QPT.this.queryExpression) + " notOpt() invoked on a " + this.getClass().getName() + " node with result type:" + this.getResultType());
        }

        IndexDescriptor getIndex(boolean ordered) {
            return null;
        }

        public Class getThisClass() {
            return null;
        }

        abstract Insn getInstructions(Insn var1, ClassFile var2, boolean var3);

        public QPT qpt() {
            return QPT.this;
        }

        Expr(int pos) {
            this.pos = pos;
        }

        public abstract Expr getFoldedExpr();

        String identityToString() {
            return this.getClass().getName() + "@" + Integer.toString(this.hashCode(), 16);
        }

        public String toString() {
            return "isInvariant=" + this.isInvariant() + ", resultType=" + this.getResultType() + ", pos=" + this.pos;
        }

        Insn branchToBoolean(Insn insn, int branchOp, boolean branchTrue) {
            InsnTarget jumpTo = new InsnTarget();
            InsnTarget end = new InsnTarget();
            insn = insn.append(Insn.create(branchOp, jumpTo));
            insn = insn.append(Insn.create(branchTrue ? 3 : 4));
            insn = insn.append(Insn.create(167, end));
            insn = insn.append(jumpTo);
            insn = insn.append(Insn.create(branchTrue ? 4 : 3));
            insn = insn.append(end);
            return insn;
        }
    }

    public static interface Lvalue {
        public IndexDescriptor getIndex(boolean var1);

        public String getIndexString();

        public void setIndexString(String var1);
    }
}

