/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.FatalInternalException;
import com.odi.util.query.FreeVariableBindings;
import com.odi.util.query.Methods;
import com.odi.util.query.MethodsGenerator;
import com.odi.util.query.PrintableNode;
import com.odi.util.query.QueryEvalTree;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class QueryEvalNode
extends PrintableNode {
    protected static final byte METHODS_NOT_COMPUTED = 1;
    protected static final byte METHODS_COMPUTED = 2;
    protected static final byte BOUND = 3;
    protected byte state = 1;
    private Set set;
    protected int minSize = -1;
    protected int maxSize = -1;

    public final void computeMethods(MethodsGenerator generator) {
        this.assertState((byte)1);
        this.state = (byte)2;
        this.computeMethodsInternal(generator);
    }

    public final QueryEvalNode bind(FreeVariableBindings freeVariableBindings, Collection collection, Methods methods) {
        this.assertState((byte)2);
        QueryEvalNode result = this.bindInternal(freeVariableBindings, collection, methods);
        result.state = (byte)3;
        return result;
    }

    public final Object pick() {
        if (this.getMaxSize() == 0) {
            throw new NoSuchElementException("No elements found");
        }
        return this.pickInternal();
    }

    public final boolean hasFastContains() {
        return this.hasFastContainsInternal();
    }

    public final boolean isSetComputed() {
        this.assertState((byte)3);
        return this.set != null;
    }

    public final Set getSet(boolean toModify) {
        this.assertState((byte)3);
        Set result = this.set == null ? this.computeSet() : this.set;
        this.set = toModify ? null : result;
        this.minSize = this.maxSize = result.size();
        return result;
    }

    public final int getMinSize() {
        this.assertState((byte)3);
        if (this.minSize == -1) {
            this.estimateSize();
        }
        return this.minSize;
    }

    public final int getMaxSize() {
        this.assertState((byte)3);
        if (this.maxSize == -1) {
            this.estimateSize();
        }
        return this.maxSize;
    }

    public final boolean contains(Object object) {
        if (this.getMaxSize() == 0) {
            return false;
        }
        return this.set != null ? this.set.contains(object) : this.containsInternal(object);
    }

    public final Iterator iterator(boolean allowDuplicates) {
        this.assertState((byte)3);
        return this.set != null ? this.set.iterator() : this.iteratorInternal(allowDuplicates);
    }

    public final void collectStatistics(QueryEvalTree tree) {
        this.assertState((byte)3);
        this.collectStatisticsInternal(tree);
    }

    protected abstract void computeMethodsInternal(MethodsGenerator var1);

    protected abstract QueryEvalNode bindInternal(FreeVariableBindings var1, Collection var2, Methods var3);

    protected abstract void collectStatisticsInternal(QueryEvalTree var1);

    protected abstract boolean hasFastContainsInternal();

    protected abstract boolean containsInternal(Object var1);

    protected abstract Iterator iteratorInternal(boolean var1);

    protected abstract Set computeSet();

    protected abstract void estimateSize();

    protected Object pickInternal() {
        if (this.set != null) {
            return this.set.iterator().next();
        }
        return this.iteratorInternal(true).next();
    }

    protected final void assertState(byte asserted) {
        if (this.state != asserted) {
            throw new FatalInternalException("State was " + this.state + " but should be " + asserted);
        }
    }

    String identityToString() {
        return this.getClass().getName() + "@" + Integer.toString(this.hashCode(), 16);
    }

    public String toString() {
        String text = "state=";
        switch (this.state) {
            case 1: {
                text = text + "METHODS_NOT_COMPUTED";
                break;
            }
            case 2: {
                text = text + "METHODS_COMPUTED";
                break;
            }
            case 3: {
                text = text + "BOUND";
                break;
            }
            default: {
                text = text + this.state;
            }
        }
        text = text + ", set=" + this.set + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize;
        return text;
    }

    @Override
    abstract String toPrintString();

    @Override
    public abstract void print(PrintWriter var1, int var2);
}

