/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query.parser;

import com.odi.util.query.QPT;
import com.odi.util.query.QueryException;
import com.odi.util.query.QueryParseException;
import com.odi.util.query.parser.JJParserCalls;
import com.odi.util.query.parser.ParseException;
import com.odi.util.query.parser.ParserConstants;
import com.odi.util.query.parser.ParserTokenManager;
import com.odi.util.query.parser.Token;
import com.odi.util.query.parser.TokenMgrError;
import com.odi.util.query.parser.UCode_UCodeESC_CharStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Parser
implements ParserConstants {
    QPT qpt;
    String queryExpression;
    boolean sawMinValue = false;
    Token minValueToken;
    public ParserTokenManager token_source;
    UCode_UCodeESC_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[45];
    private final int[] jj_la1_0 = new int[]{-2113323008, 0, -2113323008, -2113323008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1844887552, 0, 0, -1844887552, 0x10000000, 0, 0, 0, 0, 0x10000000, 0, 0, 0x10000000, -1844887552, 0, 0, 0, -1844887552, -1844887552, 0};
    private final int[] jj_la1_1 = new int[]{131392, 0, 131392, 268566848, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1807086272, 0, 0, -1807086272, -2075653120, 0, 0, 0, 0, -2075653120, 0, 0, -2080372736, -1807086272, 0, 0, 0, -1807086272, -1807086272, 0};
    private final int[] jj_la1_2 = new int[]{1024, 131072, 0, 1024, 0x400000, 0x400000, 0x8000000, 0, 0, 0, 0, 0, 0x20000000, 0x20000000, 0, -1048576000, -1048576000, 0, 0, 0, 0, 0, 0, 0, 0, 100673407, 0x6000000, 0x6000000, 10111, 100673407, 8192, 0, 0, 8192, 9087, 1024, 0x222000, 895, 100673407, 0x100000, 131072, 131072, 100706175, 100706175, 0x100000};
    private final int[] jj_la1_3 = new int[]{0, 0, 0, 0, 0x7FF0000, 0x7FF0000, 0, 2, 4, 1024, 2048, 512, 1, 1, 0, 0, 0, 57344, 57344, 96, 96, 4480, 4480, 0x8000000, 96, 120, 0, 0, 0, 0, 0, 24, 24, 0, 0, 0, 0, 0, 120, 0, 0, 0, 120, 120, 0};
    private final JJParserCalls[] jj_2_rtns = new JJParserCalls[15];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public Parser(String q) {
        this(Parser.createStream(q));
        this.queryExpression = q;
    }

    private static InputStream createStream(String q) {
        int len = q.length();
        char[] chars = new char[len];
        q.getChars(0, len, chars, 0);
        byte[] bytes = new byte[2 * len];
        int i = 0;
        int j = 0;
        while (i < len) {
            char c = chars[i];
            bytes[j] = (byte)(c >> 8);
            bytes[j + 1] = (byte)(c & 0xFF);
            ++i;
            j += 2;
        }
        class ParserByteArrayInputStream
        extends InputStream {
            private ByteArrayInputStream biso = null;
            private boolean isClosed = false;

            ParserByteArrayInputStream(byte[] bytes) {
                this.biso = new ByteArrayInputStream(bytes);
            }

            @Override
            public int read() throws IOException {
                if (this.isClosed) {
                    throw new IOException("stream is closed");
                }
                return this.biso.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.isClosed) {
                    throw new IOException("stream is closed");
                }
                return this.biso.read(b, off, len);
            }

            @Override
            public void close() throws IOException {
                if (this.isClosed) {
                    throw new IOException("stream is closed");
                }
                this.isClosed = true;
                this.biso.close();
            }
        }
        return new ParserByteArrayInputStream(bytes);
    }

    public QPT.Expr parse(QPT qpt) {
        this.qpt = qpt;
        try {
            return this.ParseExpression();
        }
        catch (ParseException e) {
            throw new QueryException(e.toString());
        }
    }

    QPT.Expr checkForMinValues(Token last, Token current) {
        if (last.kind == 102) {
            try {
                this.sawMinValue = true;
                this.minValueToken = current;
                switch (current.kind) {
                    case 63: {
                        QPT qPT = this.qpt;
                        qPT.getClass();
                        return qPT.new QPT.Literal(current.beginColumn, new Integer("-" + current.image));
                    }
                    case 64: {
                        QPT qPT = this.qpt;
                        qPT.getClass();
                        return qPT.new QPT.Literal(current.beginColumn, new Integer(Integer.parseInt("-" + current.image.substring(2), 16)));
                    }
                    case 65: {
                        QPT qPT = this.qpt;
                        qPT.getClass();
                        return qPT.new QPT.Literal(current.beginColumn, new Integer(Integer.parseInt("-" + current.image, 8)));
                    }
                    case 66: {
                        QPT qPT = this.qpt;
                        qPT.getClass();
                        return qPT.new QPT.Literal(current.beginColumn, new Long("-" + current.image.substring(0, current.image.length() - 1)));
                    }
                    case 67: {
                        QPT qPT = this.qpt;
                        qPT.getClass();
                        return qPT.new QPT.Literal(current.beginColumn, new Long(Long.parseLong("-" + current.image.substring(2, current.image.length() - 1), 16)));
                    }
                    case 68: {
                        QPT qPT = this.qpt;
                        qPT.getClass();
                        return qPT.new QPT.Literal(current.beginColumn, new Long(Long.parseLong("-" + current.image.substring(0, current.image.length() - 1), 8)));
                    }
                }
                this.qpt.error(current.beginColumn, "Internal Error: " + current.image);
            }
            catch (NumberFormatException nfe) {
                this.sawMinValue = false;
                this.minValueToken = null;
                this.qpt.error(current.beginColumn, "Number format exception: " + current.image);
            }
        } else {
            this.qpt.error(current.beginColumn, "Number format exception: " + current.image);
        }
        this.qpt.error(current.beginColumn, "Internal Error (null return): " + current.image);
        return null;
    }

    public static void main(String[] args) throws ClassNotFoundException, ParseException {
        if (args.length != 2) {
            System.out.println("Query Parser:  Usage is:");
            System.out.println("         java Parser <class> <query>");
            return;
        }
        System.out.println("Query Parser Version 1.1");
        Parser parser = new Parser(args[1]);
        parser.qpt = new QPT(Class.forName(args[0]), args[1], null, 1);
        System.out.println("Java Parser Version 1.1:  Java program parsed successfully.");
        System.out.println("Raw QPT:");
        parser.qpt.print(new PrintWriter(System.out, true));
        parser.qpt.foldExpressions();
        System.out.println("Folded QPT:");
        parser.qpt.print(new PrintWriter(System.out, true));
    }

    private char translateCharEscape(String s) {
        if (s.charAt(0) != '\\') {
            return s.charAt(0);
        }
        switch (s.charAt(1)) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
        }
        return (char)Integer.parseInt(s.substring(1), 8);
    }

    private String translateStringEscapes(String s) {
        int currentPos = 0;
        int escapePos = s.indexOf(92);
        String result = "";
        if (escapePos == -1) {
            result = s;
        } else {
            int escapeLength;
            do {
                result = result + s.substring(currentPos, escapePos);
                escapeLength = 2;
                if (Character.isDigit(s.charAt(escapePos + 1))) {
                    char currentChar;
                    for (int i = escapePos + escapeLength; i < escapePos + 4 && i < s.length() && (currentChar = s.charAt(i)) >= '0' && currentChar <= '7'; ++i) {
                        ++escapeLength;
                    }
                }
                result = result + this.translateCharEscape(s.substring(escapePos, escapePos + escapeLength));
            } while ((escapePos = s.indexOf(92, currentPos = escapePos + escapeLength)) != -1);
            result = result + s.substring(currentPos);
        }
        return result;
    }

    public final Class Type() throws ParseException {
        Class elementType = null;
        QPT.Name name = null;
        int dimensions = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 31: 
            case 38: 
            case 40: 
            case 49: {
                elementType = this.PrimitiveType();
                break;
            }
            case 74: {
                name = this.Name();
                elementType = name.resolveToType();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(81);
            this.jj_consume_token(82);
            ++dimensions;
        }
        if (dimensions <= 0) {
            return elementType;
        }
        this.qpt.notSupported("array expressions");
        throw new Error("Missing return statement in function");
    }

    public final Class PrimitiveType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                return Boolean.TYPE;
            }
            case 19: {
                this.jj_consume_token(19);
                return Character.TYPE;
            }
            case 16: {
                this.jj_consume_token(16);
                return Byte.TYPE;
            }
            case 49: {
                this.jj_consume_token(49);
                return Short.TYPE;
            }
            case 38: {
                this.jj_consume_token(38);
                return Integer.TYPE;
            }
            case 40: {
                this.jj_consume_token(40);
                return Long.TYPE;
            }
            case 31: {
                this.jj_consume_token(31);
                return Float.TYPE;
            }
            case 25: {
                this.jj_consume_token(25);
                return Double.TYPE;
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Class ResultType() throws ParseException {
        Class result = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                return Void.TYPE;
            }
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 31: 
            case 38: 
            case 40: 
            case 49: 
            case 74: {
                result = this.Type();
                return result;
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final QPT.Name Name() throws ParseException {
        QPT.Name name = null;
        Token id = this.jj_consume_token(74);
        QPT qPT = this.qpt;
        qPT.getClass();
        name = qPT.new QPT.Name(id.beginColumn, id.image);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(85);
            id = this.jj_consume_token(74);
            name.select(id.image);
        }
        return name;
    }

    public final QPT.Expr ParseExpression() throws ParseException {
        QPT.Expr result = null;
        try {
            result = this.Expression();
            this.jj_consume_token(0);
            return result;
        }
        catch (ParseException e) {
            int i;
            String retval = "Encountered \"";
            Token tok = e.currentToken.next;
            int maxSize = 0;
            for (i = 0; i < e.expectedTokenSequences.length; ++i) {
                if (maxSize >= e.expectedTokenSequences[i].length) continue;
                maxSize = e.expectedTokenSequences[i].length;
            }
            for (i = 0; i < maxSize; ++i) {
                if (i != 0) {
                    retval = retval + " ";
                }
                if (tok.kind == 0) {
                    retval = retval + e.tokenImage[0];
                    break;
                }
                retval = retval + tok.image;
                tok = tok.next;
            }
            retval = retval + "\" at column " + e.currentToken.next.beginColumn + ".\n" + this.qpt.highlightedQueryExpression(e.currentToken.next.beginColumn);
            throw new QueryParseException(retval);
        }
        catch (TokenMgrError e) {
            StringTokenizer st = new StringTokenizer(e.getMessage(), " ", true);
            String msg = "";
            String s = st.nextToken();
            while (!s.equals("line")) {
                msg = msg + s;
                s = st.nextToken();
            }
            s = st.nextToken();
            s = st.nextToken();
            s = st.nextToken();
            s = st.nextToken();
            msg = msg + s;
            s = st.nextToken();
            msg = msg + s;
            s = st.nextToken(".");
            int pos = Integer.parseInt(s);
            msg = msg + s;
            s = st.nextToken("\n");
            msg = msg + s;
            msg = msg + '\n' + this.qpt.highlightedQueryExpression(pos);
            throw new QueryParseException(msg);
        }
    }

    public final QPT.Expr Expression() throws ParseException {
        QPT.Expr result = null;
        result = this.ConditionalExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                Token t = this.AssignmentOperator();
                this.qpt.operatorNotSupported(this.token.beginColumn, "assignment", t.image);
                this.Expression();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        return result;
    }

    public final Token AssignmentOperator() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 86: {
                t = this.jj_consume_token(86);
                break;
            }
            case 114: {
                t = this.jj_consume_token(114);
                break;
            }
            case 115: {
                t = this.jj_consume_token(115);
                break;
            }
            case 119: {
                t = this.jj_consume_token(119);
                break;
            }
            case 112: {
                t = this.jj_consume_token(112);
                break;
            }
            case 113: {
                t = this.jj_consume_token(113);
                break;
            }
            case 120: {
                t = this.jj_consume_token(120);
                break;
            }
            case 121: {
                t = this.jj_consume_token(121);
                break;
            }
            case 122: {
                t = this.jj_consume_token(122);
                break;
            }
            case 116: {
                t = this.jj_consume_token(116);
                break;
            }
            case 118: {
                t = this.jj_consume_token(118);
                break;
            }
            case 117: {
                t = this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final QPT.Expr ConditionalExpression() throws ParseException {
        QPT.Expr result = null;
        result = this.ConditionalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                Token t = this.jj_consume_token(91);
                this.Expression();
                this.jj_consume_token(92);
                this.ConditionalExpression();
                this.qpt.operatorNotSupported(t.beginColumn, "conditional", "?:");
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        return result;
    }

    public final QPT.Expr ConditionalOrExpression() throws ParseException {
        QPT.Expr expr;
        QPT.Expr result = null;
        Vector<QPT.Expr> ops = null;
        Token tk = null;
        result = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 97: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            tk = this.jj_consume_token(97);
            if (ops == null) {
                ops = new Vector<QPT.Expr>(5);
                ops.addElement(result);
            }
            result = this.ConditionalAndExpression();
            ops.addElement(result);
        }
        if (ops == null) {
            expr = result;
        } else {
            QPT qPT = this.qpt;
            qPT.getClass();
            expr = qPT.new QPT.ConditionalAndOr(tk.beginColumn, 8, ops);
        }
        return expr;
    }

    public final QPT.Expr ConditionalAndExpression() throws ParseException {
        QPT.Expr expr;
        QPT.Expr result = null;
        Vector<QPT.Expr> ops = null;
        Token tk = null;
        result = this.InclusiveOrExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 98: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            tk = this.jj_consume_token(98);
            if (ops == null) {
                ops = new Vector<QPT.Expr>(5);
                ops.addElement(result);
            }
            result = this.InclusiveOrExpression();
            ops.addElement(result);
        }
        if (ops == null) {
            expr = result;
        } else {
            QPT qPT = this.qpt;
            qPT.getClass();
            expr = qPT.new QPT.ConditionalAndOr(tk.beginColumn, 7, ops);
        }
        return expr;
    }

    public final QPT.Expr InclusiveOrExpression() throws ParseException {
        QPT.Expr result = null;
        Token op = null;
        QPT.Expr op2 = null;
        result = this.ExclusiveOrExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 106: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(106);
            op2 = this.ExclusiveOrExpression();
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.Bitwise(op.beginColumn, 8, result, op2);
        }
        return result;
    }

    public final QPT.Expr ExclusiveOrExpression() throws ParseException {
        QPT.Expr result = null;
        Token op = null;
        QPT.Expr op2 = null;
        result = this.AndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 107: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(107);
            op2 = this.AndExpression();
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.Bitwise(op.beginColumn, 20, result, op2);
        }
        return result;
    }

    public final QPT.Expr AndExpression() throws ParseException {
        QPT.Expr result = null;
        Token op = null;
        QPT.Expr op2 = null;
        result = this.EqualityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 105: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(105);
            op2 = this.EqualityExpression();
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.Bitwise(op.beginColumn, 7, result, op2);
        }
        return result;
    }

    public final QPT.Expr EqualityExpression() throws ParseException {
        QPT.Expr result = null;
        QPT.Expr op2 = null;
        result = this.InstanceOfExpression();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: 
                case 96: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: {
                    op = this.jj_consume_token(93);
                    break;
                }
                case 96: {
                    op = this.jj_consume_token(96);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            op2 = this.InstanceOfExpression();
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.Equality(op.beginColumn, op.kind == 93 ? (byte)5 : 6, result, op2);
        }
        return result;
    }

    public final QPT.Expr InstanceOfExpression() throws ParseException {
        QPT.Expr result = null;
        Token op = null;
        Class op2 = null;
        result = this.RelationalExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                op = this.jj_consume_token(37);
                op2 = this.Type();
                QPT qPT = this.qpt;
                qPT.getClass();
                result = qPT.new QPT.InstanceOf(op.beginColumn, result, op2);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        return result;
    }

    public final QPT.Expr RelationalExpression() throws ParseException {
        QPT.Expr result = null;
        QPT.Expr op2 = null;
        result = this.ShiftExpression();
        block9: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: 
                case 88: 
                case 94: 
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 88: {
                    op = this.jj_consume_token(88);
                    break;
                }
                case 87: {
                    op = this.jj_consume_token(87);
                    break;
                }
                case 94: {
                    op = this.jj_consume_token(94);
                    break;
                }
                case 95: {
                    op = this.jj_consume_token(95);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            op2 = this.ShiftExpression();
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.Relational(op.beginColumn, (byte)(op.kind == 88 ? 1 : (op.kind == 87 ? 2 : (op.kind == 94 ? 3 : (op.kind == 95 ? 4 : -1)))), result, op2);
        }
        return result;
    }

    public final QPT.Expr ShiftExpression() throws ParseException {
        QPT.Expr result = null;
        result = this.AdditiveExpression();
        block13: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: 
                case 110: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block13;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: {
                    op = this.jj_consume_token(109);
                    break;
                }
                case 110: {
                    op = this.jj_consume_token(110);
                    break;
                }
                case 111: {
                    op = this.jj_consume_token(111);
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            QPT.Expr op2 = this.AdditiveExpression();
            byte shiftOp = 0;
            switch (op.kind) {
                case 109: {
                    shiftOp = 17;
                    break;
                }
                case 110: {
                    shiftOp = 18;
                    break;
                }
                case 111: {
                    shiftOp = 19;
                }
            }
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.Shift(op.beginColumn, shiftOp, result, op2);
        }
        return result;
    }

    public final QPT.Expr AdditiveExpression() throws ParseException {
        QPT.Expr result = null;
        Token op = null;
        QPT.Expr op2 = null;
        result = this.MultiplicativeExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 101: 
                case 102: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 101: {
                    op = this.jj_consume_token(101);
                    break;
                }
                case 102: {
                    op = this.jj_consume_token(102);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            op2 = this.MultiplicativeExpression();
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.Arithmetic(op.beginColumn, op.kind == 101 ? (byte)15 : 16, result, op2);
        }
        return result;
    }

    public final QPT.Expr MultiplicativeExpression() throws ParseException {
        QPT.Expr result = null;
        Token op = null;
        QPT.Expr op2 = null;
        result = this.PatternMatchExpression();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 103: 
                case 104: 
                case 108: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block13;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 103: {
                    op = this.jj_consume_token(103);
                    break;
                }
                case 104: {
                    op = this.jj_consume_token(104);
                    break;
                }
                case 108: {
                    op = this.jj_consume_token(108);
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            op2 = this.PatternMatchExpression();
            byte arithmeticOp = 0;
            switch (op.kind) {
                case 103: {
                    arithmeticOp = 12;
                    break;
                }
                case 104: {
                    arithmeticOp = 13;
                    break;
                }
                case 108: {
                    arithmeticOp = 14;
                }
            }
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.Arithmetic(op.beginColumn, arithmeticOp, result, op2);
        }
        return result;
    }

    public final QPT.Expr PatternMatchExpression() throws ParseException {
        QPT.Expr result = null;
        Token op = null;
        QPT.Expr op2 = null;
        result = this.UnaryExpression(false);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 123: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block3;
                }
            }
            op = this.jj_consume_token(123);
            op2 = this.UnaryExpression(false);
            QPT qPT = this.qpt;
            qPT.getClass();
            result = qPT.new QPT.PatternMatch(op.beginColumn, result, op2);
        }
        return result;
    }

    public final QPT.Expr UnaryExpression(boolean ignoreMinValue) throws ParseException {
        QPT.Expr result = null;
        Token operator = null;
        QPT.Expr operand = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 101: 
            case 102: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 101: {
                        operator = this.jj_consume_token(101);
                        break;
                    }
                    case 102: {
                        operator = this.jj_consume_token(102);
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                operand = this.UnaryExpression(true);
                if (operator.kind == 101) {
                    result = operand;
                    break;
                }
                QPT qPT = this.qpt;
                qPT.getClass();
                result = qPT.new QPT.Unary(operator.beginColumn, 11, operand);
                this.sawMinValue = false;
                this.minValueToken = null;
                break;
            }
            case 99: {
                result = this.PreIncrementExpression();
                break;
            }
            case 100: {
                result = this.PreDecrementExpression();
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 31: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 51: 
            case 54: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 89: 
            case 90: {
                result = this.UnaryExpressionNotPlusMinus();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (!ignoreMinValue && this.sawMinValue) {
            this.qpt.error(this.minValueToken.beginColumn, "Number format exception: " + this.minValueToken.image);
        }
        return result;
    }

    public final QPT.Expr PreIncrementExpression() throws ParseException {
        QPT.Expr result = null;
        Token t = this.jj_consume_token(99);
        result = this.PrimaryExpression();
        this.qpt.operatorNotSupported(t.beginColumn, "prefix increment", "++");
        return result;
    }

    public final QPT.Expr PreDecrementExpression() throws ParseException {
        QPT.Expr result = null;
        Token t = this.jj_consume_token(100);
        result = this.PrimaryExpression();
        this.qpt.operatorNotSupported(t.beginColumn, "prefix decrement", "--");
        return result;
    }

    public final QPT.Expr UnaryExpressionNotPlusMinus() throws ParseException {
        QPT.Expr result = null;
        Token operator = null;
        QPT.Expr operand = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 89: 
            case 90: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 90: {
                        operator = this.jj_consume_token(90);
                        break;
                    }
                    case 89: {
                        operator = this.jj_consume_token(89);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                operand = this.UnaryExpression(false);
                QPT qPT = this.qpt;
                qPT.getClass();
                result = qPT.new QPT.Unary(operator.beginColumn, operator.kind == 90 ? (byte)9 : 10, operand);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                if (this.jj_2_2(Integer.MAX_VALUE)) {
                    result = this.CastExpression();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 16: 
                    case 19: 
                    case 25: 
                    case 28: 
                    case 31: 
                    case 38: 
                    case 40: 
                    case 42: 
                    case 43: 
                    case 49: 
                    case 51: 
                    case 54: 
                    case 58: 
                    case 60: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 77: {
                        result = this.PostfixExpression();
                        break block0;
                    }
                }
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final void CastLookahead() throws ParseException {
        if (this.jj_2_3(2)) {
            this.jj_consume_token(77);
            this.PrimitiveType();
        } else if (this.jj_2_4(Integer.MAX_VALUE)) {
            this.jj_consume_token(77);
            this.Name();
            this.jj_consume_token(81);
            this.jj_consume_token(82);
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    this.jj_consume_token(77);
                    this.Name();
                    this.jj_consume_token(78);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 90: {
                            this.jj_consume_token(90);
                            break block0;
                        }
                        case 89: {
                            this.jj_consume_token(89);
                            break block0;
                        }
                        case 77: {
                            this.jj_consume_token(77);
                            break block0;
                        }
                        case 74: {
                            this.jj_consume_token(74);
                            break block0;
                        }
                        case 54: {
                            this.jj_consume_token(54);
                            break block0;
                        }
                        case 51: {
                            this.jj_consume_token(51);
                            break block0;
                        }
                        case 42: {
                            this.jj_consume_token(42);
                            break block0;
                        }
                        case 28: 
                        case 43: 
                        case 58: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 72: 
                        case 73: {
                            this.Literal();
                            break block0;
                        }
                    }
                    this.jj_la1[29] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final QPT.Expr PostfixExpression() throws ParseException {
        QPT.Expr result = null;
        Token op = null;
        result = this.PrimaryExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 99: 
            case 100: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 99: {
                        op = this.jj_consume_token(99);
                        this.qpt.operatorNotSupported(op.beginColumn, "postfix increment", "++");
                        break block0;
                    }
                    case 100: {
                        op = this.jj_consume_token(100);
                        this.qpt.operatorNotSupported(op.beginColumn, "postfix decrement", "--");
                        break block0;
                    }
                }
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
            }
        }
        return result;
    }

    public final QPT.Expr CastExpression() throws ParseException {
        Class castType = null;
        QPT.Expr result = null;
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            this.jj_consume_token(77);
            castType = this.Type();
            this.jj_consume_token(78);
            result = this.UnaryExpression(false);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: {
                    this.jj_consume_token(77);
                    castType = this.Type();
                    this.jj_consume_token(78);
                    result = this.UnaryExpressionNotPlusMinus();
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        QPT qPT = this.qpt;
        qPT.getClass();
        return qPT.new QPT.Cast(result.pos, castType, result);
    }

    public final QPT.Expr PrimaryExpression() throws ParseException {
        QPT.Expr result = this.PrimaryPrefix();
        while (this.jj_2_6(2)) {
            result = this.PrimarySuffix(result);
        }
        return result instanceof QPT.Name ? ((QPT.Name)result).resolveToField() : result;
    }

    public final QPT.Expr PrimaryPrefix() throws ParseException {
        Token t = null;
        QPT.Expr result = null;
        Class classLiteral = null;
        QPT.Name name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: 
            case 43: 
            case 58: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                result = this.Literal();
                return result;
            }
            case 54: {
                t = this.jj_consume_token(54);
                QPT qPT = this.qpt;
                qPT.getClass();
                return qPT.new QPT.ThisRef(t.beginColumn);
            }
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(85);
                t = this.jj_consume_token(74);
                QPT qPT = this.qpt;
                qPT.getClass();
                QPT qPT2 = this.qpt;
                qPT2.getClass();
                return qPT.new QPT.Name(qPT2.new QPT.SuperRef(t.beginColumn), t.image);
            }
            case 77: {
                this.jj_consume_token(77);
                result = this.Expression();
                this.jj_consume_token(78);
                return result;
            }
            case 42: {
                this.AllocationExpression();
                this.qpt.notSupported("allocation within a query expression.");
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                if (this.jj_2_7(Integer.MAX_VALUE)) {
                    classLiteral = this.ResultType();
                    this.jj_consume_token(85);
                    this.jj_consume_token(20);
                    this.qpt.TBD("class literals");
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, classLiteral);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 74: {
                        name = this.Name();
                        return name;
                    }
                }
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final QPT.Expr PrimarySuffix(QPT.Expr lhs) throws ParseException {
        Token t = null;
        Vector args = null;
        if (this.jj_2_8(2)) {
            this.jj_consume_token(85);
            t = this.jj_consume_token(54);
            if (!(lhs instanceof QPT.Name)) {
                this.qpt.error(t.beginColumn, "bad reference to declaring class in " + QPT.quote("this") + " expression.");
            }
            Class c = ((QPT.Name)lhs).resolveToType();
            QPT qPT = this.qpt;
            qPT.getClass();
            return qPT.new QPT.DeclaringThisRef(t.beginColumn, c);
        }
        if (this.jj_2_9(2)) {
            this.jj_consume_token(85);
            this.AllocationExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    this.jj_consume_token(81);
                    this.Expression();
                    this.jj_consume_token(82);
                    this.qpt.operatorNotSupported(this.token.beginColumn, "array dereference", "[]");
                    break;
                }
                case 85: {
                    this.jj_consume_token(85);
                    t = this.jj_consume_token(74);
                    if (lhs instanceof QPT.Name) {
                        return ((QPT.Name)lhs).select(t.image);
                    }
                    if (lhs instanceof QPT.Lvalue) {
                        QPT qPT = this.qpt;
                        qPT.getClass();
                        return qPT.new QPT.Name((QPT.Lvalue)((Object)lhs), t.image);
                    }
                    this.qpt.error(lhs.pos, "bad field expression");
                    break;
                }
                case 77: {
                    args = this.Arguments();
                    if (lhs instanceof QPT.Name) {
                        return ((QPT.Name)lhs).resolveToMethod(args);
                    }
                    this.qpt.error(lhs.pos, "bad method call expression");
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final QPT.Expr Literal() throws ParseException {
        Object result = null;
        Token t = null;
        boolean b = false;
        Object image = null;
        Token lastToken = this.getToken(0);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                t = this.jj_consume_token(63);
                try {
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, new Integer(t.image));
                }
                catch (NumberFormatException e) {
                    return this.checkForMinValues(lastToken, t);
                }
            }
            case 64: {
                t = this.jj_consume_token(64);
                try {
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, new Integer(Integer.parseInt(t.image.substring(2), 16)));
                }
                catch (NumberFormatException e) {
                    return this.checkForMinValues(lastToken, t);
                }
            }
            case 65: {
                t = this.jj_consume_token(65);
                try {
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, new Integer(Integer.parseInt(t.image, 8)));
                }
                catch (NumberFormatException e) {
                    return this.checkForMinValues(lastToken, t);
                }
            }
            case 66: {
                t = this.jj_consume_token(66);
                try {
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, new Long(t.image.substring(0, t.image.length() - 1)));
                }
                catch (NumberFormatException e) {
                    return this.checkForMinValues(lastToken, t);
                }
            }
            case 67: {
                t = this.jj_consume_token(67);
                try {
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, new Long(Long.parseLong(t.image.substring(2, t.image.length() - 1), 16)));
                }
                catch (NumberFormatException e) {
                    return this.checkForMinValues(lastToken, t);
                }
            }
            case 68: {
                t = this.jj_consume_token(68);
                try {
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, new Long(Long.parseLong(t.image.substring(0, t.image.length() - 1), 8)));
                }
                catch (NumberFormatException e) {
                    return this.checkForMinValues(lastToken, t);
                }
            }
            case 69: {
                t = this.jj_consume_token(69);
                try {
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, new Float(t.image));
                }
                catch (NumberFormatException e) {
                    this.qpt.error(t.beginColumn, "Number format exception: " + t.image);
                    break;
                }
            }
            case 70: {
                t = this.jj_consume_token(70);
                try {
                    QPT qPT = this.qpt;
                    qPT.getClass();
                    return qPT.new QPT.Literal(t.beginColumn, new Double(t.image));
                }
                catch (NumberFormatException e) {
                    this.qpt.error(t.beginColumn, "Number format exception: " + t.image);
                    break;
                }
            }
            case 72: {
                t = this.jj_consume_token(72);
                String escapeSequence = t.image.substring(1, t.image.length() - 1);
                QPT qPT = this.qpt;
                qPT.getClass();
                return qPT.new QPT.Literal(t.beginColumn, new Character(this.translateCharEscape(escapeSequence)));
            }
            case 73: {
                t = this.jj_consume_token(73);
                String unquotedString = t.image.substring(1, t.image.length() - 1);
                QPT qPT = this.qpt;
                qPT.getClass();
                return qPT.new QPT.Literal(t.beginColumn, this.translateStringEscapes(unquotedString));
            }
            case 58: {
                t = this.jj_consume_token(58);
                QPT qPT = this.qpt;
                qPT.getClass();
                return qPT.new QPT.Literal(t.beginColumn, new Boolean(t.image));
            }
            case 28: {
                t = this.jj_consume_token(28);
                QPT qPT = this.qpt;
                qPT.getClass();
                return qPT.new QPT.Literal(t.beginColumn, new Boolean(t.image));
            }
            case 43: {
                t = this.jj_consume_token(43);
                QPT qPT = this.qpt;
                qPT.getClass();
                return qPT.new QPT.Literal(t.beginColumn, null);
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Vector Arguments() throws ParseException {
        Vector args = null;
        this.jj_consume_token(77);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 31: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 51: 
            case 54: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 89: 
            case 90: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                args = this.ArgumentList();
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        this.jj_consume_token(78);
        return args;
    }

    public final Vector ArgumentList() throws ParseException {
        Vector<QPT.Expr> args = new Vector<QPT.Expr>(5);
        QPT.Expr arg = this.Expression();
        args.addElement(arg);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 84: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(84);
            arg = this.Expression();
            args.addElement(arg);
        }
        return args;
    }

    public final void AllocationExpression() throws ParseException {
        Token t;
        if (this.jj_2_10(2)) {
            t = this.jj_consume_token(42);
            this.PrimitiveType();
        } else if (this.jj_2_11(2)) {
            t = this.jj_consume_token(42);
            this.Name();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.qpt.operatorNotSupported(t.beginColumn, "allocation", "new");
    }

    public final void ArrayDimsAndInits() throws ParseException {
        if (this.jj_2_14(2)) {
            do {
                this.jj_consume_token(81);
                this.Expression();
                this.jj_consume_token(82);
            } while (this.jj_2_12(2));
            while (this.jj_2_13(2)) {
                this.jj_consume_token(81);
                this.jj_consume_token(82);
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    block8: while (true) {
                        this.jj_consume_token(81);
                        this.jj_consume_token(82);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 81: {
                                continue block8;
                            }
                        }
                        break;
                    }
                    this.jj_la1[40] = this.jj_gen;
                    this.ArrayInitializer();
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void VariableInitializer() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                this.ArrayInitializer();
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 31: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 51: 
            case 54: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 89: 
            case 90: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.Expression();
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ArrayInitializer() throws ParseException {
        this.jj_consume_token(79);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 31: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 51: 
            case 54: 
            case 58: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 79: 
            case 89: 
            case 90: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.VariableInitializer();
                while (this.jj_2_15(2)) {
                    this.jj_consume_token(84);
                    this.VariableInitializer();
                }
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        this.jj_consume_token(80);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_9();
        this.jj_save(8, xla);
        return retval;
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_10();
        this.jj_save(9, xla);
        return retval;
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_11();
        this.jj_save(10, xla);
        return retval;
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_12();
        this.jj_save(11, xla);
        return retval;
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_13();
        this.jj_save(12, xla);
        return retval;
    }

    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_14();
        this.jj_save(13, xla);
        return retval;
    }

    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_15();
        this.jj_save(14, xla);
        return retval;
    }

    private final boolean jj_3R_80() {
        if (this.jj_3R_81()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_22() {
        Token xsp;
        block3: {
            if (this.jj_scan_token(74)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_1()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_scan_token(102)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_3R_80()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        if (this.jj_3R_97()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_64()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_65()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_66()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_67()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_68()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_69()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_70()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_71()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_72()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_73()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_74()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_75()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_76()) {
                                                            return true;
                                                        }
                                                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_3R_96()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_42()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_15() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_27()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_3R_95()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_3R_79()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_94()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_3R_54()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_91()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_92()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_32()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_33()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_34()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_35()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_36()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_37()) {
                                        return true;
                                    }
                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_3R_88()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_3R_78()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        Token xsp;
        block6: {
            xsp = this.jj_scanpos;
            if (this.jj_3R_60()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_61()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_62()) break block6;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_3R_26()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_45()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_3R_57()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_9()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_38()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_39()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_40()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_3R_58()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_14() {
        Token xsp;
        block3: {
            if (this.jj_3_12()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_12()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_115() {
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_114() {
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_3R_87()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_11() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_23()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_113() {
        if (this.jj_3R_25()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_112() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_11()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_110() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_3R_56()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_109() {
        if (this.jj_3R_58()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_109()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_110()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_111()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_112()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_113()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_114()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_115()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_3R_86()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_3R_26()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        if (this.jj_3R_77()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_107() {
        if (this.jj_3R_108()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_3R_43()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_106() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_105() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_106()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_3R_85()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_104() {
        if (this.jj_3R_107()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_3R_84()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_47()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_48()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_49()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_50()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_51()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_52()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_53()) {
                                        return true;
                                    }
                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(82)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_29()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_102() {
        if (this.jj_scan_token(89)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_100() {
        if (this.jj_3R_104()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_99() {
        if (this.jj_3R_103()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_101() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_101()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_102()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_98()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_99()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_100()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_3R_82()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public Parser(InputStream stream) {
        int i;
        this.jj_input_stream = new UCode_UCodeESC_CharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 45; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJParserCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 45; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJParserCalls();
        }
    }

    public Parser(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 45; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJParserCalls();
        }
    }

    public void ReInit(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 45; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJParserCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJParserCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enu = this.jj_expentries.elements();
            while (enu.hasMoreElements()) {
                int[] oldentry = (int[])enu.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[124];
        for (i = 0; i < 124; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 45; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((this.jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((this.jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 124; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 15; ++i) {
            JJParserCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                        break;
                    }
                    case 13: {
                        this.jj_3_14();
                        break;
                    }
                    case 14: {
                        this.jj_3_15();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJParserCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJParserCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }
}

