/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.evs.nio;

import com.progress.blackbird.evs.nio.EvsDispatcherEvent;
import com.progress.blackbird.evs.nio.EvsListElement;
import com.progress.blackbird.evs.nio.EvsListHead;
import com.progress.blackbird.evs.nio.EvsObject;
import com.progress.blackbird.sys.SysListElement;

final class EvsTimerHeap
extends EvsObject {
    private EvsListHead timerList = EvsListHead.create();

    private EvsTimerHeap() {
    }

    private void addInternal(Timer timer, long l) {
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        SysListElement sysListElement = this.timerList;
        boolean bl = false;
        while ((sysListElement = sysListElement.getNext()) != null) {
            if (timer.nextDispatchTime > ((Timer)sysListElement).nextDispatchTime) continue;
            sysListElement.insertBefore(timer);
            bl = true;
            break;
        }
        if (!bl) {
            this.timerList.append(timer);
        }
        timer.addTime = l;
    }

    private void removeInternal(Timer timer) {
        timer.remove();
    }

    private Timer removeInternal(EvsDispatcherEvent evsDispatcherEvent) {
        Timer timer = (Timer)evsDispatcherEvent.getAttachment();
        if (timer != null) {
            this.removeInternal(timer);
            evsDispatcherEvent.setScheduleTime(timer.addTime);
        }
        return timer;
    }

    static EvsTimerHeap create() {
        return new EvsTimerHeap();
    }

    final void addTimer(int n, EvsDispatcherEvent evsDispatcherEvent) {
        if (this.checked) {
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (1 != evsDispatcherEvent.getClazz()) {
                throw new IllegalArgumentException("Invalid event class");
            }
            if (n < 0) {
                throw new IllegalArgumentException("Interval cannot be negative");
            }
        }
        long l = System.currentTimeMillis();
        Timer timer = (Timer)evsDispatcherEvent.getAttachment();
        if (timer == null) {
            timer = new Timer(n, (long)n + l, evsDispatcherEvent);
            timer.event.setAttachment(timer);
            this.addInternal(timer, l);
        } else {
            this.resetTimer(evsDispatcherEvent, l);
        }
    }

    final boolean resetTimer(EvsDispatcherEvent evsDispatcherEvent, long l) {
        Timer timer;
        if (this.checked) {
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Invalid event");
            }
            if (1 != evsDispatcherEvent.getClazz()) {
                throw new IllegalArgumentException("Invalid event class");
            }
        }
        if ((timer = this.removeInternal(evsDispatcherEvent)) != null) {
            timer.nextDispatchTime = l + (long)timer.interval;
            this.addInternal(timer, l);
        }
        return timer != null;
    }

    final int getMinExpiryTime() {
        SysListElement sysListElement = this.timerList.getNext();
        return (int)Math.max(sysListElement == null ? Integer.MAX_VALUE : ((Timer)sysListElement).nextDispatchTime - System.currentTimeMillis(), 0L);
    }

    final int getSize() {
        return this.timerList.getListSize();
    }

    final EvsDispatcherEvent getExpired() {
        Timer timer = (Timer)this.timerList.getNext();
        if (timer != null) {
            if (System.currentTimeMillis() >= timer.nextDispatchTime) {
                if (this.checked) {
                    if (timer != this.removeInternal(timer.event)) {
                        throw new InternalError("Internal error : Invalid timer bound to event");
                    }
                } else {
                    this.removeInternal(timer);
                }
            } else {
                timer = null;
            }
        }
        return timer != null ? timer.event : null;
    }

    final boolean removeTimer(EvsDispatcherEvent evsDispatcherEvent) {
        Timer timer;
        if (this.checked) {
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Invalid event");
            }
            if (1 != evsDispatcherEvent.getClazz()) {
                throw new IllegalArgumentException("Invalid event class");
            }
        }
        if ((timer = this.removeInternal(evsDispatcherEvent)) != null) {
            evsDispatcherEvent.setAttachment(null);
        }
        return timer != null;
    }

    private class Timer
    extends EvsListElement {
        long addTime;
        int interval;
        long nextDispatchTime;
        EvsDispatcherEvent event;

        Timer(int n, long l, EvsDispatcherEvent evsDispatcherEvent) {
            this.interval = n;
            this.nextDispatchTime = l;
            this.event = evsDispatcherEvent;
        }
    }
}

