/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.evs.nio;

import com.progress.blackbird.evs.EEvsObjectHotException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.IEvsTimerPort;
import com.progress.blackbird.evs.nio.EvsDispatcher;
import com.progress.blackbird.evs.nio.EvsDispatcherEvent;
import com.progress.blackbird.evs.nio.EvsPort;
import com.progress.blackbird.evs.nio.EvsPortEvent;
import com.progress.blackbird.evs.nio.EvsTimerPortEvent;

public final class EvsTimerPort
extends EvsPort
implements IEvsTimerPort {
    private EvsDispatcherEvent event;

    private EvsTimerPort(boolean bl) {
        super(0, bl);
    }

    private void startInternal(EvsDispatcher evsDispatcher, byte by, int n, IEvsPortEventHandler iEvsPortEventHandler, Object object) throws EEvsObjectHotException {
        if (this.event == null) {
            if (this.isHot()) {
                throw new InternalError("Internal error - Port shows to be hot when it should not be!");
            }
        } else {
            throw new EEvsObjectHotException();
        }
        this.setHot();
        this.event = EvsTimerPortEvent.create(this, evsDispatcher, by, iEvsPortEventHandler, object);
        evsDispatcher.scheduleTimerEvent(n, this.event);
    }

    private void resetInternal(long l) {
        if (this.event != null) {
            if (this.isHot()) {
                if (this.checked && this.event.getSource().getOwner() != Thread.currentThread()) {
                    throw new RuntimeException("calling thread is not dispatcher owner");
                }
                this.event.getSource().resetTimerEvent(this.event, l);
            } else {
                throw new InternalError("Internal error - Port shows to be cold when it should not be!");
            }
        }
    }

    private void stopInternal() {
        if (this.event != null) {
            if (this.isHot()) {
                if (this.checked && this.event.getSource().getOwner() != Thread.currentThread()) {
                    throw new RuntimeException("calling thread is not dispatcher owner");
                }
                this.event.getSource().unscheduleTimerEvent(this.event);
                this.event = null;
                this.setCold();
            } else {
                throw new InternalError("Internal error - Port shows to be cold when it should not be!");
            }
        }
    }

    public static IEvsTimerPort create(boolean bl) {
        return new EvsTimerPort(bl);
    }

    @Override
    final void handleEvent(EvsDispatcherEvent evsDispatcherEvent) {
        this.dispatch((EvsPortEvent)evsDispatcherEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start(IEvsDispatcher iEvsDispatcher, byte by, int n, IEvsPortEventHandler iEvsPortEventHandler, Object object) throws EEvsObjectHotException {
        if (this.checked) {
            if (iEvsDispatcher == null) {
                throw new IllegalArgumentException("null dispatcher");
            }
            if (n < 0) {
                throw new IllegalArgumentException("interval cannot be less than zero");
            }
            if (by < 0 || by > 31) {
                throw new IllegalArgumentException("Invalid priority");
            }
            if (iEvsPortEventHandler == null) {
                throw new IllegalArgumentException("null event handler");
            }
            if (iEvsDispatcher.getOwner() != Thread.currentThread()) {
                throw new IllegalArgumentException("calling thread is not dispatcher owner");
            }
        }
        if (this.isThreaded()) {
            EvsTimerPort evsTimerPort = this;
            synchronized (evsTimerPort) {
                this.startInternal((EvsDispatcher)iEvsDispatcher, by, n, iEvsPortEventHandler, object);
            }
        } else {
            this.startInternal((EvsDispatcher)iEvsDispatcher, by, n, iEvsPortEventHandler, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reset(long l) {
        if (this.isThreaded()) {
            EvsTimerPort evsTimerPort = this;
            synchronized (evsTimerPort) {
                this.resetInternal(l);
            }
        } else {
            this.resetInternal(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        if (this.isThreaded()) {
            EvsTimerPort evsTimerPort = this;
            synchronized (evsTimerPort) {
                this.stopInternal();
            }
        } else {
            this.stopInternal();
        }
    }
}

