/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.evs;

import cern.colt.list.ObjectArrayList;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.io.EIOConnectionAlreadyConnectedException;
import com.progress.blackbird.io.EIOConnectionClosedException;
import com.progress.blackbird.io.EIOConnectionFailedException;
import com.progress.blackbird.io.EIOConnectionNotConnectedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOFlushPendingException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.EIOInboundStreamOpenException;
import com.progress.blackbird.io.EIOTimeoutException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOConnectionEventHandler;
import com.progress.blackbird.io.IIOConnectionPacketHandler;
import com.progress.blackbird.io.IIOConnectionStatistics;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.IIOPacketSerializer;
import com.progress.blackbird.io.evs.IIONetworkConnectionPingPacketManager;
import com.progress.blackbird.io.evs.IOMultiNetworkConnection;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionActiveConnector;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionEvents;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionPassive;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.io.evs.IOObject;
import com.progress.blackbird.io.multi.IIOMultiConnectionFlowBalancer;
import com.progress.blackbird.io.multi.IIOMultiConnectionPacketManager;
import com.progress.blackbird.io.multi.IOMultiConnection;
import com.progress.blackbird.io.multi.IOMultiConnectionEvents;
import com.progress.blackbird.io.multi.IOMultiConnectionHandshaker;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysListHead;
import com.progress.blackbird.sys.SysUUID;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

final class IOMultiNetworkConnectionActive
extends IOObject {
    private IOMultiNetworkConnectionPassive owner;
    private IOMultiNetworkConnection.Parameters parameters;
    private Object synchronizer;
    private IIOConnectionEventHandler eventHandler;
    private IIOMultiConnectionPacketManager packetManager;
    private IIOMultiConnectionFlowBalancer flowBalancer;
    private boolean flgFailed;
    private boolean flgClosed;
    private boolean userThreaded;
    private String id;
    private LinkedHashSet connections;
    private IIOConnection multiConnection;
    private IIOConnectionPacketHandler packetHandler;
    private IEvsDispatcher dispatcher;

    IOMultiNetworkConnectionActive(IOMultiNetworkConnectionPassive iOMultiNetworkConnectionPassive, boolean bl, String[] stringArray, IIOConnection[] iIOConnectionArray, String string, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, IOMultiNetworkConnection.Parameters parameters) {
        try {
            this.init(iOMultiNetworkConnectionPassive, bl, bl, string, iIOConnectionEventHandler, iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, parameters);
            this.multiConnection = this.createUnderlyingMultiConnection(iIOConnectionArray, iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, parameters);
            for (int i = 0; i < stringArray.length; ++i) {
                this.connections.add(new Connection(stringArray[i], iIOConnectionArray[i]));
            }
        }
        catch (EIOException eIOException) {
            throw new InternalError("Exception thrown when wrapping a multi network connection around an accepted multi connection!");
        }
    }

    IOMultiNetworkConnectionActive(String[] stringArray, boolean bl, IONetworkConnection.Parameters[] parametersArray, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, IOMultiNetworkConnection.Parameters parameters) throws EIOException {
        this.init(null, true, bl, SysUUID.randomUUID().toString() + (parameters.getName() == null ? "" : parameters.getName()), iIOConnectionEventHandler, iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, parameters);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this.connections.add(new Connection(stringArray[i], this.userThreaded, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, parametersArray != null ? parametersArray[i] : null));
            }
            IOMultiNetworkConnectionActiveConnector.getInstance().register(this);
        }
        catch (EIOException eIOException) {
            Iterator iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                try {
                    ((Connection)iterator.next()).close();
                }
                catch (Exception exception) {
                    this.trace.outln("Error in closing underlying connection [" + ((Connection)iterator.next()).descriptor + "] during cleanup after initialization failure [" + exception.getMessage() + "]", 2);
                }
            }
            throw eIOException;
        }
    }

    private void init(IOMultiNetworkConnectionPassive iOMultiNetworkConnectionPassive, boolean bl, boolean bl2, String string, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, IOMultiNetworkConnection.Parameters parameters) throws EIOException {
        this.threaded = bl;
        this.userThreaded = bl2;
        this.owner = iOMultiNetworkConnectionPassive;
        this.parameters = parameters;
        this.synchronizer = new Object();
        this.eventHandler = iIOConnectionEventHandler;
        this.packetManager = iIOMultiConnectionPacketManager;
        this.flowBalancer = iIOMultiConnectionFlowBalancer;
        this.flgClosed = false;
        this.flgFailed = false;
        this.connections = new LinkedHashSet();
        this.id = string;
        this.packetHandler = null;
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.io.multi.trace");
    }

    private IIOConnection createUnderlyingMultiConnection(IIOConnection[] iIOConnectionArray, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, IOMultiNetworkConnection.Parameters parameters) {
        return (IOMultiConnection)IOMultiConnection.create(iIOConnectionArray, new EventHandler(), iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, this.threaded, parameters.getMultiParameters());
    }

    private Connection getConnection(IIOConnection iIOConnection) {
        for (Connection connection : this.connections) {
            if (connection.ioConnection != iIOConnection) continue;
            return connection;
        }
        return null;
    }

    private Connection getConnection(String string) {
        for (Connection connection : this.connections) {
            if ((this.owner != null || connection.descriptor.compareTo(string) != 0) && (this.owner == null || !connection.descriptor.startsWith(string))) continue;
            return connection;
        }
        return null;
    }

    private void notifyAcceptorConnectorOfClose() {
        if (this.owner != null) {
            this.owner.handleAcceptedConnectionClosed(this.id);
        } else {
            IOMultiNetworkConnectionActiveConnector.getInstance().unregister(this);
        }
    }

    private void handleConnectionFailure(EIOException eIOException) {
        this.flgFailed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
        if (eIOException == null) {
            this.packetHandler.handlePacket(eIOException, iIOPacket);
        } else {
            if (this.threaded) {
                Object object = this.synchronizer;
                synchronized (object) {
                    this.handleConnectionFailure(eIOException);
                }
            } else {
                this.handleConnectionFailure(eIOException);
            }
            this.notifyAcceptorConnectorOfClose();
            this.packetHandler.handlePacket(eIOException, null);
        }
    }

    private Connection handleConnectionDown(IIOConnection iIOConnection) {
        Connection connection = this.getConnection(iIOConnection);
        if (connection == null) {
            throw new InternalError("Failed to find connection reported in multi connection EVENT_CONNECTION_REMOVE event");
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            this.trace.outln("Failure in closing connection " + connection + " on connection down [" + exception.getMessage() + "]. Ignoring.", 2);
        }
        if (this.owner == null) {
            try {
                connection.prepareForConnect();
                IOMultiNetworkConnectionActiveConnector.getInstance().schedule(this, connection, this.parameters.getConnectRetryInterval());
            }
            catch (Exception exception) {
                this.trace.outln("Failed to schedule connection for reconnect on connection down [" + exception.getMessage() + "]", 2);
            }
        } else {
            this.connections.remove(connection);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvent(int n, Object object) {
        switch (n) {
            case 100: {
                break;
            }
            case 101: {
                Connection connection;
                IOMultiConnectionEvents.ConnectionRemoveEventData connectionRemoveEventData = (IOMultiConnectionEvents.ConnectionRemoveEventData)object;
                if (this.threaded) {
                    LinkedHashSet linkedHashSet = this.connections;
                    synchronized (linkedHashSet) {
                        connection = this.handleConnectionDown(connectionRemoveEventData.connection);
                    }
                } else {
                    connection = this.handleConnectionDown(connectionRemoveEventData.connection);
                }
                if (this.eventHandler == null) break;
                this.eventHandler.handleEvent(302, new IOMultiNetworkConnectionEvents.ConnectionDownEventData(connection.descriptor, connectionRemoveEventData.cause));
            }
        }
    }

    private List getInDoubtPacketsInternal() throws EIOException {
        return this.multiConnection != null ? ((IOMultiConnection)this.multiConnection).getInDoubtPackets() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IONetworkConnection getUnderlyingConnectionInternal(String string) {
        if (this.threaded) {
            LinkedHashSet linkedHashSet = this.connections;
            synchronized (linkedHashSet) {
                return (IONetworkConnection)this.getConnection((String)string).ioConnection;
            }
        }
        return (IONetworkConnection)this.getConnection((String)string).ioConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addInternal(String string, IIOConnection iIOConnection) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOConnectionNotConnectedException, EIOException {
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (this.multiConnection == null) throw new EIOConnectionNotConnectedException();
        ((IOMultiConnection)this.multiConnection).add(iIOConnection);
        if (this.threaded) {
            LinkedHashSet linkedHashSet = this.connections;
            synchronized (linkedHashSet) {
                if (this.getConnection(iIOConnection) != null) return;
                this.connections.add(new Connection(string, iIOConnection));
                return;
            }
        } else {
            if (this.getConnection(iIOConnection) != null) return;
            this.connections.add(new Connection(string, iIOConnection));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectInternal() throws EIOConnectionAlreadyConnectedException, EIOConnectionClosedException, EIOException {
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.multiConnection != null) throw new EIOConnectionAlreadyConnectedException();
        this.trace.outln("Establishing multi-connection " + this + "...", 3);
        ObjectArrayList objectArrayList = new ObjectArrayList();
        ObjectArrayList objectArrayList2 = new ObjectArrayList();
        try {
            for (Connection connection : this.connections) {
                try {
                    connection.connect();
                    objectArrayList.add(connection);
                }
                catch (EIOException eIOException) {
                    objectArrayList2.add(connection);
                }
            }
            if (objectArrayList.size() > 0) {
                int n;
                IIOConnection[] iIOConnectionArray = new IIOConnection[objectArrayList.size()];
                Object[] objectArray = objectArrayList.elements();
                int n2 = objectArrayList.size();
                for (n = 0; n < n2; ++n) {
                    iIOConnectionArray[n] = ((Connection)objectArray[n]).ioConnection;
                }
                this.multiConnection = this.createUnderlyingMultiConnection(iIOConnectionArray, this.packetManager, this.flowBalancer, this.parameters);
                objectArray = objectArrayList2.elements();
                n2 = objectArrayList2.size();
                for (n = 0; n < n2; ++n) {
                    IOMultiNetworkConnectionActiveConnector.getInstance().schedule(this, (Connection)objectArray[n], this.parameters.getConnectRetryInterval());
                }
            } else {
                this.trace.outln("Multi-connection " + this + " establishment failed - all underlying connections failed to connect/handshake", 3);
                throw new EIOException("no connections could be successfully connected");
            }
            this.trace.outln("Multi-connection " + this + " successfully established (success=" + objectArrayList.size() + " failed=" + objectArrayList2.size() + ")...", 3);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.trace.outln("Multi-connection " + this + " establishment encountered a runtime exception [" + runtimeException + "]. Failing connect", 4);
            Object[] objectArray = objectArrayList.elements();
            int n = objectArrayList.size();
            for (int i = 0; i < n; ++i) {
                try {
                    ((Connection)objectArray[i]).close();
                    continue;
                }
                catch (EIOException eIOException) {
                    this.trace.outln("Failed to close succesfully connected underlying connection after another underlying connection encountered runtime connect exception [" + eIOException.getMessage() + "]", 2);
                }
            }
            throw runtimeException;
        }
    }

    private boolean isConnectedInternal() throws EIOConnectionClosedException, EIOException {
        if (!this.flgClosed) {
            return this.multiConnection != null && !this.flgFailed;
        }
        throw new EIOConnectionClosedException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readInternal(IEvsDispatcher iEvsDispatcher, IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException {
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (this.multiConnection == null) throw new EIOConnectionNotConnectedException();
        if (iIOConnectionPacketHandler != null) {
            this.multiConnection.read(iEvsDispatcher, new PacketHandler());
            this.dispatcher = iEvsDispatcher;
            this.packetHandler = iIOConnectionPacketHandler;
            return;
        } else {
            this.multiConnection.read(iEvsDispatcher, null);
        }
    }

    private IIOConnectionPacketHandler setPacketHandlerInternal(IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (this.packetHandler == null) {
            throw new IllegalArgumentException("replacement packet handler cannot be null");
        }
        if (!this.flgClosed) {
            if (!this.flgFailed) {
                if (this.multiConnection != null) {
                    if (this.isInboundStreamOpenInternal()) {
                        IIOConnectionPacketHandler iIOConnectionPacketHandler2 = this.packetHandler;
                        this.packetHandler = iIOConnectionPacketHandler;
                        return iIOConnectionPacketHandler2;
                    }
                    throw new EIOInboundStreamClosedException();
                }
                throw new EIOConnectionNotConnectedException();
            }
            throw new EIOConnectionFailedException();
        }
        throw new EIOConnectionClosedException();
    }

    private boolean writeInternal(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.checked && iIOPacket == null) {
            throw new IllegalArgumentException("packet cannot be null");
        }
        if (!this.flgClosed) {
            if (!this.flgFailed) {
                if (this.multiConnection != null) {
                    return this.multiConnection.write(iIOPacket, flushContext, n);
                }
                throw new EIOConnectionNotConnectedException();
            }
            throw new EIOConnectionFailedException();
        }
        throw new EIOConnectionClosedException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flushInternal(IIOConnection.FlushContext flushContext) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.flgClosed) throw new EIOConnectionClosedException();
        if (this.flgFailed) throw new EIOConnectionFailedException();
        if (this.multiConnection == null) {
            throw new EIOConnectionNotConnectedException();
        }
        this.multiConnection.flush(flushContext);
    }

    private boolean isInboundStreamOpenInternal() throws EIOConnectionClosedException, EIOException {
        if (!this.flgClosed) {
            if (this.multiConnection != null) {
                if (this.packetHandler != null) {
                    boolean bl = this.multiConnection.isInboundStreamOpen();
                    if (!bl) {
                        this.packetHandler = null;
                    }
                    return bl;
                }
                return false;
            }
            return false;
        }
        throw new EIOConnectionClosedException();
    }

    private int getOutboundStreamBufferSizeInternal() throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOException {
        if (!this.flgClosed) {
            if (!this.flgFailed) {
                if (this.multiConnection != null) {
                    return this.multiConnection.getOutboundStreamBufferSize();
                }
                throw new EIOConnectionNotConnectedException();
            }
            throw new EIOConnectionFailedException();
        }
        throw new EIOConnectionClosedException();
    }

    private void closeInternal() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        if (!this.flgClosed) {
            if (!this.isInboundStreamOpenInternal()) {
                this.trace.outln("Closing...", 4);
                this.trace.outln("Closing core multi-connection...", 4);
                if (this.multiConnection != null) {
                    this.multiConnection.close();
                }
                this.trace.outln("Closing individual connections...", 4);
                for (Connection connection : this.connections) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        this.trace.outln("Failed to close individual connection " + connection + " during multi-connection " + this + " close", 2);
                    }
                }
                this.flgClosed = true;
                this.trace.outln("Connection closed.", 3);
            } else {
                throw new EIOInboundStreamOpenException();
            }
        }
    }

    private boolean isClosedInternal() throws EIOException {
        return this.flgClosed;
    }

    private boolean isFailedInternal() throws EIOConnectionClosedException, EIOException {
        if (!this.flgClosed) {
            return this.flgFailed;
        }
        throw new EIOConnectionClosedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List getInDoubtPackets() throws EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.getInDoubtPacketsInternal();
            }
        }
        return this.getInDoubtPacketsInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IONetworkConnection getUnderlyingConnection(String string) throws EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.getUnderlyingConnectionInternal(string);
            }
        }
        return this.getUnderlyingConnectionInternal(string);
    }

    final IIOConnectionStatistics getStatistics() {
        return this.multiConnection.getStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void add(String string, IIOConnection iIOConnection) throws EIOConnectionClosedException, EIOConnectionFailedException, EIOConnectionNotConnectedException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.addInternal(string, iIOConnection);
            }
        } else {
            this.addInternal(string, iIOConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connect() throws EIOConnectionAlreadyConnectedException, EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.connectInternal();
            }
        } else {
            this.connectInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isConnected() throws EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.isConnectedInternal();
            }
        }
        return this.isConnectedInternal();
    }

    final SysListHead receive(int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOTimeoutException, EIOInboundStreamOpenException, EIOException {
        throw new UnsupportedOperationException("method not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void read(IEvsDispatcher iEvsDispatcher, IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.readInternal(iEvsDispatcher, iIOConnectionPacketHandler);
            }
        } else {
            this.readInternal(iEvsDispatcher, iIOConnectionPacketHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IIOConnectionPacketHandler setPacketHandler(IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.setPacketHandlerInternal(iIOConnectionPacketHandler);
            }
        }
        return this.setPacketHandlerInternal(iIOConnectionPacketHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean write(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.writeInternal(iIOPacket, flushContext, n);
            }
        }
        return this.writeInternal(iIOPacket, flushContext, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flush(IIOConnection.FlushContext flushContext) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.flushInternal(flushContext);
            }
        } else {
            this.flushInternal(flushContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isInboundStreamOpen() throws EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.isInboundStreamOpenInternal();
            }
        }
        return this.isInboundStreamOpenInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getOutboundStreamBufferSize() throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.getOutboundStreamBufferSizeInternal();
            }
        }
        return this.getOutboundStreamBufferSizeInternal();
    }

    final void fail(Exception exception) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        throw new UnsupportedOperationException("fail() not supported on multi network connections");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        IOMultiNetworkConnectionActiveConnector.getInstance().suspend(this);
        try {
            if (this.threaded) {
                Object object = this.synchronizer;
                synchronized (object) {
                    this.closeInternal();
                }
            } else {
                this.closeInternal();
            }
            this.notifyAcceptorConnectorOfClose();
        }
        catch (EIOException eIOException) {
            IOMultiNetworkConnectionActiveConnector.getInstance().resume(this);
            throw eIOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isClosed() throws EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.isClosedInternal();
            }
        }
        return this.isClosedInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isFailed() throws EIOConnectionClosedException, EIOException {
        if (this.threaded) {
            Object object = this.synchronizer;
            synchronized (object) {
                return this.isFailedInternal();
            }
        }
        return this.isFailedInternal();
    }

    public final String toString() {
        return "[" + this.id + "]";
    }

    protected final void finalize() {
        IOMultiNetworkConnectionActiveConnector.getInstance().unregister(this);
    }

    private final class EventHandler
    implements IIOConnectionEventHandler {
        private EventHandler() {
        }

        @Override
        public final void handleEvent(int n, Object object) {
            IOMultiNetworkConnectionActive.this.handleEvent(n, object);
        }
    }

    private final class PacketHandler
    implements IIOConnectionPacketHandler {
        private PacketHandler() {
        }

        @Override
        public final void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
            IOMultiNetworkConnectionActive.this.handlePacket(eIOException, iIOPacket);
        }
    }

    final class Connection {
        String descriptor;
        boolean threaded;
        IIOPacketSerializer packetSerializer;
        IIONetworkConnectionPingPacketManager pingPacketManager;
        IONetworkConnection.Parameters parameters;
        IIOConnection ioConnection;

        private Connection(String string, IIOConnection iIOConnection) {
            this.init(string, iIOConnection.isThreaded(), null, null, null, iIOConnection);
        }

        Connection(String string, boolean bl, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, IONetworkConnection.Parameters parameters) throws EIOException {
            this.init(string, bl, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, parameters, null);
            this.prepareForConnect();
            IOMultiNetworkConnectionActive.this.trace.outln("Created connection " + this + "...", 4);
        }

        private void init(String string, boolean bl, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, IONetworkConnection.Parameters parameters, IIOConnection iIOConnection) {
            this.descriptor = string;
            this.threaded = bl;
            this.packetSerializer = iIOPacketSerializer;
            this.pingPacketManager = iIONetworkConnectionPingPacketManager;
            this.parameters = parameters;
            this.ioConnection = iIOConnection;
        }

        final void prepareForConnect() throws EIOException {
            this.ioConnection = IONetworkConnection.create(true, this.descriptor, this.threaded, this.packetSerializer, this.pingPacketManager, this.parameters);
        }

        final void connect() throws EIOException {
            IOMultiNetworkConnectionActive.this.trace.outln("Establishing connection " + this, 4);
            try {
                this.ioConnection.connect();
                IOMultiConnectionHandshaker.HandshakeCompletionData handshakeCompletionData = IOMultiConnectionHandshaker.doSynchronousHandshake(this.ioConnection, IOMultiConnectionHandshaker.HandshakeRequestData.create(IOMultiNetworkConnectionActive.this.id), IOMultiNetworkConnectionActive.this.parameters.getHandshakeTimeout(), null, IOMultiNetworkConnectionActive.this.packetManager);
                IOMultiNetworkConnectionActive.this.trace.outln("Handshake completion data " + handshakeCompletionData, 4);
                if (handshakeCompletionData.status != null) {
                    if (handshakeCompletionData.status instanceof EIOException) {
                        throw (EIOException)handshakeCompletionData.status;
                    }
                    throw new EIOException(handshakeCompletionData.status);
                }
                if (IOMultiNetworkConnectionActive.this.eventHandler != null) {
                    IOMultiNetworkConnectionActive.this.eventHandler.handleEvent(301, new IOMultiNetworkConnectionEvents.ConnectionUpEventData(this.descriptor));
                }
                IOMultiNetworkConnectionActive.this.trace.outln("Connection " + this + " successfully established.", 4);
            }
            catch (EIOException eIOException) {
                IOMultiNetworkConnectionActive.this.trace.outln("Connection " + this + " establishment failed [" + eIOException.getMessage() + "]", 4);
                try {
                    this.close();
                    this.prepareForConnect();
                }
                catch (Exception exception) {
                    IOMultiNetworkConnectionActive.this.trace.outln("Failed to prepare connection for reconnect after failed connect attempt [" + exception.getMessage() + "]", 2);
                }
                IOMultiNetworkConnectionActive.this.eventHandler.handleEvent(300, new IOMultiNetworkConnectionEvents.ConnectionConnectFailEventData(this.descriptor, eIOException));
                throw eIOException;
            }
        }

        final void close() throws EIOException {
            IOMultiNetworkConnectionActive.this.trace.outln("Closing connection " + this + "...", 4);
            this.ioConnection.close();
        }

        public final String toString() {
            return "[active, url=" + this.descriptor + "]";
        }
    }
}

