/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.evs;

import com.progress.blackbird.evs.EEvsObjectHotException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsPortEvent;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.IEvsTimerPort;
import com.progress.blackbird.evs.nio.EvsTimerPort;
import com.progress.blackbird.io.EIOConnectionClosedException;
import com.progress.blackbird.io.EIOConnectionFailedException;
import com.progress.blackbird.io.EIOConnectionNotConnectedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.evs.IIONetworkConnectionPingPacketManager;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.io.evs.IONetworkConnectionInputStream;
import com.progress.blackbird.io.evs.IONetworkConnectionOutputStream;
import com.progress.blackbird.io.evs.IOObject;
import com.progress.blackbird.sys.SysConfig;

final class IONetworkConnectionPingManager
extends IOObject {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_REQUEST_TIMER_EXPIRY_WAIT = 1;
    private static final int STATE_REPLY_TIMER_EXPIRY_WAIT = 2;
    private static final int STATE_EVENT_START = 0;
    private static final int STATE_EVENT_RR_TIMER_EXPIRED = 1;
    private static final int STATE_EVENT_FLUSH_TIMER_EXPIRED = 2;
    private static final int STATE_EVENT_PACKET_RCVD = 3;
    private static final int STATE_EVENT_STOP = 4;
    private final IONetworkConnection connection;
    private final IIONetworkConnectionPingPacketManager pingPacketManager;
    private final int interval;
    private final IEvsTimerPort rrTimer;
    private final IEvsTimerPort flushTimer;
    private IONetworkConnectionInputStream inputStream;
    private IONetworkConnectionOutputStream outputStream;
    private IEvsDispatcher dispatcher;
    private int state;
    private int sequenceNum;

    IONetworkConnectionPingManager(IONetworkConnection iONetworkConnection, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, int n, boolean bl) {
        super(bl);
        this.connection = iONetworkConnection;
        this.pingPacketManager = iIONetworkConnectionPingPacketManager;
        this.interval = n;
        this.state = 0;
        this.sequenceNum = 1;
        this.rrTimer = EvsTimerPort.create(true);
        this.flushTimer = EvsTimerPort.create(true);
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.io.ping.trace");
    }

    private void startPingProcess(IEvsDispatcher iEvsDispatcher) {
        if (this.interval > 0 && this.pingPacketManager != null) {
            this.trace.outln("Starting ping (interval=" + this.interval + ").", 4);
            try {
                this.rrTimer.start(iEvsDispatcher, (byte)15, this.interval * 1000, new RRTimerEventHandler(), null);
                this.dispatcher = iEvsDispatcher;
                this.state = 1;
            }
            catch (EEvsObjectHotException eEvsObjectHotException) {
                throw new InternalError("Exception encountered while starting request/reply timer [" + eEvsObjectHotException.getMessage() + "]");
            }
        } else {
            this.trace.outln("Ping is disabled (interval=" + this.interval + "). Not starting.", 4);
        }
    }

    private boolean send(IIOPacket iIOPacket) throws EIOException {
        IIOConnection.SyncNonBlockingFlushContext syncNonBlockingFlushContext = new IIOConnection.SyncNonBlockingFlushContext();
        if (iIOPacket != null) {
            this.connection.write(iIOPacket, syncNonBlockingFlushContext, 2);
        }
        this.connection.flush(syncNonBlockingFlushContext);
        return syncNonBlockingFlushContext.complete;
    }

    private void startFlushTimer() {
        try {
            this.flushTimer.start(this.dispatcher, (byte)15, 100, new FlushTimerEventHandler(), null);
        }
        catch (EEvsObjectHotException eEvsObjectHotException) {
            // empty catch block
        }
    }

    private void sendRequest() throws EIOException {
        this.trace.outln("Sending ping request [sno=" + this.sequenceNum + "].", 4);
        if (!this.send(this.pingPacketManager.createPingRequest(this.sequenceNum++))) {
            this.startFlushTimer();
        }
    }

    private void processRequest(IIOPacket iIOPacket) throws EIOException {
        this.trace.outln("Received ping request [sno=" + this.pingPacketManager.getPingRequestSno(iIOPacket) + "]. Sending reply.", 4);
        if (!this.send(this.pingPacketManager.createPingReply(iIOPacket))) {
            this.startFlushTimer();
        }
    }

    private void stopPingProcess() {
        this.trace.outln("Stopping ping.", 4);
        this.rrTimer.stop();
        this.flushTimer.stop();
        this.state = 0;
    }

    private boolean handlePingEvent(int n, Object object) {
        boolean bl;
        block40: {
            bl = false;
            if (this.trace.debug) {
                this.trace.debugln("Ping State Machine [State=" + this.state + " Event=" + n + " Data=" + object + "]...");
            }
            try {
                block2 : switch (this.state) {
                    case 0: {
                        switch (n) {
                            case 0: {
                                this.startPingProcess((IEvsDispatcher)object);
                                break block2;
                            }
                            case 3: {
                                IIOPacket iIOPacket = (IIOPacket)object;
                                if (this.pingPacketManager.isPingRequest(iIOPacket)) {
                                    this.processRequest(iIOPacket);
                                    bl = true;
                                    break block2;
                                }
                                break block40;
                            }
                            case 4: {
                                break block2;
                            }
                            default: {
                                throw new InternalError("Illegal event for current ping state. [State=" + this.state + " event=" + n + "]");
                            }
                        }
                    }
                    case 1: {
                        switch (n) {
                            case 1: {
                                this.sendRequest();
                                this.state = 2;
                                break block2;
                            }
                            case 2: {
                                if (this.send(null)) {
                                    this.flushTimer.stop();
                                    break block2;
                                }
                                break block40;
                            }
                            case 3: {
                                IIOPacket iIOPacket = (IIOPacket)object;
                                if (this.pingPacketManager.isPingRequest(iIOPacket)) {
                                    this.processRequest(iIOPacket);
                                    bl = true;
                                } else if (this.pingPacketManager.isPingReply(iIOPacket)) {
                                    this.trace.outln("Received spurious ping reply. Ignoring.", 4);
                                    bl = true;
                                }
                                this.rrTimer.reset(System.currentTimeMillis());
                                break block2;
                            }
                            case 4: {
                                this.stopPingProcess();
                                break block2;
                            }
                            default: {
                                throw new InternalError("Illegal event for current ping state. [State=" + this.state + " event=" + n + "]");
                            }
                        }
                    }
                    case 2: {
                        switch (n) {
                            case 1: {
                                this.trace.outln("Timed out in waiting for ping reply.", 4);
                                throw new EIOException("timed out in waiting for ping reply");
                            }
                            case 2: {
                                if (this.send(null)) {
                                    this.flushTimer.stop();
                                    break block2;
                                }
                                break block40;
                            }
                            case 3: {
                                IIOPacket iIOPacket = (IIOPacket)object;
                                if (this.pingPacketManager.isPingRequest(iIOPacket)) {
                                    this.processRequest(iIOPacket);
                                    bl = true;
                                } else if (this.pingPacketManager.isPingReply(iIOPacket)) {
                                    this.trace.outln("Received expected ping reply.", 4);
                                    this.state = 1;
                                    bl = true;
                                }
                                this.rrTimer.reset(System.currentTimeMillis());
                                break block2;
                            }
                            case 4: {
                                this.stopPingProcess();
                                break block2;
                            }
                            default: {
                                throw new InternalError("Illegal event for current ping state. [State=" + this.state + " event=" + n + "]");
                            }
                        }
                    }
                    default: {
                        throw new InternalError("Illegal ping state. [State=" + this.state + "]");
                    }
                }
            }
            catch (EIOException eIOException) {
                this.stopPingProcess();
                try {
                    this.connection.fail(new EIOException("ping failure <" + eIOException.getMessage() + ">"));
                }
                catch (EIOConnectionNotConnectedException eIOConnectionNotConnectedException) {
                    throw new InternalError("Connection reported as 'not connected' when failing connection on ping failure!");
                }
                catch (EIOConnectionFailedException eIOConnectionFailedException) {
                }
                catch (EIOConnectionClosedException eIOConnectionClosedException) {
                    throw new InternalError("Connection reported 'closed' when failing connection on ping failure!");
                }
                catch (EIOInboundStreamClosedException eIOInboundStreamClosedException) {
                }
                catch (EIOException eIOException2) {
                    this.trace.outln("Failed to fail connection on ping failure [" + eIOException2.getMessage() + "]", 2);
                }
            }
        }
        return bl;
    }

    final void bind(IONetworkConnectionInputStream iONetworkConnectionInputStream, IONetworkConnectionOutputStream iONetworkConnectionOutputStream) {
        this.inputStream = iONetworkConnectionInputStream;
        this.outputStream = iONetworkConnectionOutputStream;
    }

    final IIONetworkConnectionPingPacketManager getPingPacketManager() {
        return this.pingPacketManager;
    }

    final void start(IEvsDispatcher iEvsDispatcher) {
        this.handlePingEvent(0, iEvsDispatcher);
    }

    final boolean write(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOException {
        return this.outputStream.write(iIOPacket, flushContext, n);
    }

    final void flush(IIOConnection.FlushContext flushContext) throws EIOException {
        this.outputStream.flush(flushContext);
    }

    final void handlePacket(EIOException eIOException, IIOPacket iIOPacket) {
        boolean bl = true;
        try {
            if (eIOException == null) {
                bl = this.pingPacketManager == null || !this.handlePingEvent(3, iIOPacket);
            } else {
                this.handlePingEvent(4, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.connection.handlePacket(eIOException, iIOPacket);
        }
    }

    final void stop() {
        this.handlePingEvent(4, null);
    }

    private final class FlushTimerEventHandler
    implements IEvsPortEventHandler {
        private FlushTimerEventHandler() {
        }

        @Override
        public void handleEvent(IEvsPortEvent iEvsPortEvent) {
            IONetworkConnectionPingManager.this.handlePingEvent(2, null);
        }
    }

    private final class RRTimerEventHandler
    implements IEvsPortEventHandler {
        private RRTimerEventHandler() {
        }

        @Override
        public void handleEvent(IEvsPortEvent iEvsPortEvent) {
            IONetworkConnectionPingManager.this.handlePingEvent(1, null);
        }
    }
}

