/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.nwlink;

import com.progress.blackbird.nwlink.ENwLinkClassLoadException;
import com.progress.blackbird.nwlink.ENwLinkDescriptorFormatException;
import com.progress.blackbird.nwlink.ENwLinkException;
import com.progress.blackbird.nwlink.ENwLinkInvalidClassException;
import com.progress.blackbird.nwlink.INwLink;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class NwLinkFactory {
    private static String parseClassFromDescriptor(String string) throws ENwLinkException {
        String string2 = "://";
        int n = string.indexOf(string2);
        if (n > 0) {
            return string.substring(0, n);
        }
        throw new ENwLinkDescriptorFormatException(string);
    }

    public static INwLink create(int n, String string) throws ENwLinkInvalidClassException, ENwLinkClassLoadException, ENwLinkException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = NwLinkFactory.parseClassFromDescriptor(string);
        String string3 = null;
        Class<?> clazz = null;
        if (string2 != null) {
            if (string2.compareToIgnoreCase("tcp") == 0) {
                string3 = "com.progress.blackbird.nwlink.tcp.TCPNwLink";
            } else if (string2.compareToIgnoreCase("ssl") == 0) {
                string3 = "com.progress.blackbird.nwlink.ssl.SSLNwLink";
            }
        }
        if (string3 != null) {
            Object object;
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ENwLinkClassLoadException("Link class [" + string3 + "] could not be found");
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                throw new ENwLinkException("Link class [" + string3 + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
            }
            Method method = null;
            try {
                object = new Class[]{Class.forName("java.lang.Integer"), Class.forName("java.lang.String")};
                method = clazz.getMethod("create", (Class<?>)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InternalError("Failed to load class java.lang.Integer or java.lang.String during instantiation of link class [" + string3 + "]");
            }
            catch (SecurityException securityException) {
                throw new ENwLinkClassLoadException("Access to instantiation method 'create(Integer, String)' in class [" + string3 + "] is denied");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ENwLinkClassLoadException("Class [" + string3 + "] is not a valid link class <Class instantiation mehod 'create(Integer, String)' could not be found>");
            }
            object = null;
            try {
                Object[] objectArray = new Object[]{new Integer(n), string};
                object = method.invoke(null, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ENwLinkClassLoadException("Access to instantiation method 'create(Integer, String)' in class [" + string3 + "] is denied");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ENwLinkException(invocationTargetException.getCause());
            }
            try {
                return (INwLink)object;
            }
            catch (ClassCastException classCastException) {
                throw new ENwLinkClassLoadException("Class [" + string3 + "] is not a valid link class <Class instantiation mehod 'create(Integer, String)' returned an invalid type>");
            }
        }
        throw new ENwLinkInvalidClassException(string2);
    }
}

