/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import cern.colt.io.Converting;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.EPDUInvalidPacketTypeException;
import com.progress.blackbird.pdu.EPDUPacketFormatException;
import com.progress.blackbird.pdu.PDUObject;
import com.progress.blackbird.pdu.PDUPacketSubHeader;
import com.progress.blackbird.pdu.PDUPacketSubHeaderMultiConnection;
import com.progress.blackbird.pdu.PDUPacketSubHeaderMulticast;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public final class PDUPacketHeader
extends PDUObject
implements Cloneable {
    private final int HEADER_WIRE_SIZE = 24;
    private final int MAGIC = 0xFEEEED;
    private final int MAGIC_POS = 0;
    private final byte VERSION = 1;
    private final int VERSION_POS = 3;
    private final int SRC_POS = 4;
    private final int DEST_POS = 8;
    private final int FLOW_POS = 12;
    private final int FLAGS_POS = 16;
    private final int FLAG_ZERO_LATENCY = 1;
    private final int FLAG_SYNCHRONOUS = 2;
    private final int FLAG_MCONN_SUBHEADER_PRESENT = 0x20000000;
    private final int FLAG_MC_SUBHEADER_PRESENT = 0x40000000;
    private final int FLAG_FRAG_SUBHEADER_PRESENT = Integer.MIN_VALUE;
    private final int HTL_POS = 20;
    private final int CLAZZ_POS = 21;
    private final int TYPE_POS = 22;
    private final int MAX_SUBHEADERS = 2;
    private final int SUBHEADER_MULTICAST_INDEX = 0;
    private final int SUBHEADER_MULTICONN_INDEX = 1;
    private byte[] buffer;
    private PDUPacketSubHeader[] subHeaders = new PDUPacketSubHeader[2];
    public static final short PACKET_TYPE_INVALID = 0;
    public static final short PACKET_TYPE_NWCONN_PING_REQUEST = 1;
    public static final short PACKET_TYPE_NWCONN_PING_REPLY = 2;
    public static final short PACKET_TYPE_CLIENT_CONNECT_REQUEST = 3;
    public static final short PACKET_TYPE_CLIENT_CONNECT_REPLY = 4;
    public static final short PACKET_TYPE_BROKER_CONNECT_REQUEST = 5;
    public static final short PACKET_TYPE_BROKER_CONNECT_REPLY = 6;
    public static final short PACKET_TYPE_JOIN_REQUEST = 7;
    public static final short PACKET_TYPE_JOIN_REPLY = 8;
    public static final short PACKET_TYPE_LEAVE_REQUEST = 9;
    public static final short PACKET_TYPE_LEAVE_REPLY = 10;
    public static final short PACKET_TYPE_MCONN_ACK = 11;
    public static final short PACKET_TYPE_MCONN_NACK = 12;
    public static final short PACKET_TYPE_MCONN_SYNC = 13;
    public static final short PACKET_TYPE_MCONN_HANDSHAKE_REQUEST = 14;
    public static final short PACKET_TYPE_MCONN_HANDSHAKE_REPLY = 15;
    public static final short PACKET_TYPE_DATA = 255;
    public static final byte PACKET_CLASS_DEFAULT = 0;
    public static final byte PACKET_CLASS_UF = 1;
    public static final byte PACKET_CLASS_URP = 2;
    public static final byte PACKET_CLASS_MF = 3;
    public static final byte PACKET_CLASS_MRP = 4;
    public static final byte PACKET_CLASS_QM = 5;
    public static final byte PACKET_CLASS_QRP = 6;
    public static final byte PACKET_CLASS_RMF = 7;
    public static final byte PACKET_CLASS_MP = 8;
    private static final String[] typeStrArray = new String[256];

    private PDUPacketHeader(short s) {
        this.init(null, null);
        Converting.write((byte)s, this.buffer, 22);
        this.setHtl((short)255);
    }

    private PDUPacketHeader(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        this.init(null, null);
        try {
            int n;
            int n2;
            int n3 = 4;
            if (dataInputStream.available() >= n3) {
                n2 = dataInputStream.readInt();
                n = (n2 & 0xFFFFFF00) >>> 8;
                if (n != 0xFEEEED) {
                    throw new EPDUPacketFormatException("Invalid magic number");
                }
                byte by = (byte)(n2 & 0xFF);
                if (by != 1) {
                    throw new EPDUPacketFormatException("Invalid version");
                }
            } else {
                throw new EIOInsufficientDataException();
            }
            n2 = this.buffer.length - n3;
            if (dataInputStream.available() < n2) {
                throw new EIOInsufficientDataException();
            }
            dataInputStream.readFully(this.buffer, n3, n2);
            n = Converting.readInt(this.buffer, 16);
            if ((n & 0x40000000) == 0x40000000) {
                this.subHeaders[0] = new PDUPacketSubHeaderMulticast();
                this.subHeaders[0].deserialize(dataInputStream);
            }
            if ((n & 0x20000000) == 0x20000000) {
                this.subHeaders[1] = new PDUPacketSubHeaderMultiConnection();
                this.subHeaders[1].deserialize(dataInputStream);
            }
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    private PDUPacketHeader(short s, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this(s);
        PDUPacketSubHeader pDUPacketSubHeader;
        this.setSrc(PDUPacketHeader.askUnicastAddr("Source address", printStream, bufferedReader, 0));
        this.setDest(PDUPacketHeader.askUnicastAddr("Destination address", printStream, bufferedReader, 0));
        this.setFlow((int)SysInteractive.ask("Flow id", printStream, bufferedReader, 0.0));
        this.setZeroLatency(SysInteractive.askYesNo("Zero Latency (yes/no)", printStream, bufferedReader, false));
        this.setSynchronous(SysInteractive.askYesNo("Synchronous (yes/no)", printStream, bufferedReader, false));
        this.setHtl((byte)SysInteractive.ask("HTL (0-255)", printStream, bufferedReader, this.getHtl()));
        this.setClazz((short)SysInteractive.ask("Class", printStream, bufferedReader, 0.0));
        if (SysInteractive.askYesNo("Multicast subheader (yes/no)", printStream, bufferedReader, false)) {
            pDUPacketSubHeader = new PDUPacketSubHeaderMulticast();
            ((PDUPacketSubHeaderMulticast)pDUPacketSubHeader).deserialize(printStream, bufferedReader);
            this.setMulticastSubHeader((PDUPacketSubHeaderMulticast)pDUPacketSubHeader);
        }
        if (SysInteractive.askYesNo("Multiconn subheader (yes/no)", printStream, bufferedReader, false)) {
            pDUPacketSubHeader = new PDUPacketSubHeaderMultiConnection();
            ((PDUPacketSubHeaderMultiConnection)pDUPacketSubHeader).deserialize(printStream, bufferedReader);
            this.setMultiConnectionSubHeader((PDUPacketSubHeaderMultiConnection)pDUPacketSubHeader);
        }
    }

    static PDUPacketHeader create(short s) {
        return new PDUPacketHeader(s);
    }

    static PDUPacketHeader create(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketHeader(dataInputStream);
    }

    static PDUPacketHeader create(short s, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketHeader(s, printStream, bufferedReader);
    }

    public static int createUnicastAddr(short s, short s2, short s3) {
        return (s & 0x3FF) << 22 | s2 << 14 | s3 & 0x3FFF;
    }

    public static short parseUnicastAddrBrokerL2(int n) {
        return (short)((n & 0xFFC00000) >>> 22);
    }

    public static void validateUnicastAddrBrokerL2(short s) {
        short s2 = PDUPacketHeader.parseUnicastAddrBrokerL2(-1);
        short s3 = 1;
        if (s < s3 || s > s2) {
            throw new IllegalArgumentException("Broker L2 address out of range <min=" + s3 + " max=" + s2 + " parsed=" + s + ">");
        }
    }

    public static short parseUnicastAddrBrokerL1(int n) {
        return (short)((n & 0x3FC000) >>> 14);
    }

    public static void validateUnicastAddrBrokerL1(short s) {
        short s2 = PDUPacketHeader.parseUnicastAddrBrokerL1(-1);
        short s3 = 0;
        if (s < s3 || s > s2) {
            throw new IllegalArgumentException("Broker L1 address out of range <min=" + s3 + " max=" + s2 + " parsed=" + s + ">");
        }
    }

    public static short parseUnicastAddrClient(int n) {
        return (short)(n & 0x3FFF);
    }

    public static void validateUnicastAddrClient(short s) {
        short s2 = PDUPacketHeader.parseUnicastAddrClient(-1);
        short s3 = 0;
        if (s < s3 || s > s2) {
            throw new IllegalArgumentException("Client address out of range <min=" + s3 + " max=" + s2 + " parsed=" + s + ">");
        }
    }

    public static String unicastAddrToString(int n) {
        return String.valueOf(PDUPacketHeader.parseUnicastAddrBrokerL2(n)) + "." + String.valueOf(PDUPacketHeader.parseUnicastAddrBrokerL1(n)) + "." + String.valueOf(PDUPacketHeader.parseUnicastAddrClient(n));
    }

    public static int stringToUnicastAddr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        try {
            if (stringTokenizer.hasMoreTokens()) {
                s = Short.parseShort(stringTokenizer.nextToken());
                PDUPacketHeader.validateUnicastAddrBrokerL2(s);
            }
            if (stringTokenizer.hasMoreTokens()) {
                s2 = Short.parseShort(stringTokenizer.nextToken());
                PDUPacketHeader.validateUnicastAddrBrokerL1(s2);
            }
            if (stringTokenizer.hasMoreTokens()) {
                s3 = Short.parseShort(stringTokenizer.nextToken());
                PDUPacketHeader.validateUnicastAddrClient(s3);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return PDUPacketHeader.createUnicastAddr(s, s2, s3);
    }

    public static int askUnicastAddr(String string, PrintStream printStream, BufferedReader bufferedReader, int n) throws IOException {
        String string2;
        int n2 = n;
        while ((string2 = SysInteractive.ask(string, printStream, bufferedReader)).length() > 0) {
            try {
                n2 = PDUPacketHeader.stringToUnicastAddr(string2);
                break;
            }
            catch (Exception exception) {
                printStream.println("Error in parsing provided address [" + exception.getMessage() + "]. Please try again.");
            }
        }
        return n2;
    }

    public static String typeToString(short s) throws EPDUInvalidPacketTypeException {
        if (s < typeStrArray.length && typeStrArray[s] != null) {
            return typeStrArray[s];
        }
        throw new EPDUInvalidPacketTypeException(s);
    }

    public static short stringToType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("str cannot be null");
        }
        for (int n = 0; n < typeStrArray.length; n = (int)((short)(n + 1))) {
            if (typeStrArray[n] == null || typeStrArray[n].compareToIgnoreCase(string) != 0) continue;
            return (byte)n;
        }
        return 0;
    }

    final void init(byte[] byArray, PDUPacketSubHeader[] pDUPacketSubHeaderArray) {
        this.buffer = new byte[24];
        if (byArray != null) {
            if (byArray.length != 24) {
                throw new InternalError("Attempt to initialize packet with invalid header buffer");
            }
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
        }
        this.subHeaders = new PDUPacketSubHeader[2];
        if (pDUPacketSubHeaderArray != null) {
            if (pDUPacketSubHeaderArray.length != 2) {
                throw new InternalError("Attempt to initialize packet with invalid subheaders array");
            }
            for (int i = 0; i < pDUPacketSubHeaderArray.length; ++i) {
                if (pDUPacketSubHeaderArray[i] == null) continue;
                this.subHeaders[i] = (PDUPacketSubHeader)pDUPacketSubHeaderArray[i].clone();
            }
        }
    }

    final void serialize(DataOutputStream dataOutputStream) throws EIOException {
        try {
            Converting.write(-17896191, this.buffer, 0);
            dataOutputStream.write(this.buffer);
            for (int i = 0; i < this.subHeaders.length; ++i) {
                if (this.subHeaders[i] == null) continue;
                this.subHeaders[i].serialize(dataOutputStream);
            }
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    final int getWireSize() {
        int n = 24;
        for (int i = 0; i < this.subHeaders.length; ++i) {
            if (this.subHeaders[i] == null) continue;
            n += this.subHeaders[i].getWireSize();
        }
        return n;
    }

    public final short getType() {
        return (short)(0xFF & Converting.readByte(this.buffer, 22));
    }

    public final String getTypeStr() {
        try {
            return PDUPacketHeader.typeToString(this.getType());
        }
        catch (EPDUInvalidPacketTypeException ePDUInvalidPacketTypeException) {
            throw new InternalError("Internal Error: getType() returned an invalid packet type!");
        }
    }

    public final void setSrc(int n) {
        Converting.write(n, this.buffer, 4);
    }

    public final int getSrc() {
        return Converting.readInt(this.buffer, 4);
    }

    public final void setDest(int n) {
        Converting.write(n, this.buffer, 8);
    }

    public final int getDest() {
        return Converting.readInt(this.buffer, 8);
    }

    public final void setFlow(int n) {
        Converting.write(n, this.buffer, 12);
    }

    public final int getFlow() {
        return Converting.readInt(this.buffer, 12);
    }

    public final void setZeroLatency(boolean bl) {
        int n = Converting.readInt(this.buffer, 16);
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        Converting.write(n, this.buffer, 16);
    }

    public final boolean getZeroLatency() {
        return (Converting.readInt(this.buffer, 16) & 1) == 1;
    }

    public final void setSynchronous(boolean bl) {
        int n = Converting.readInt(this.buffer, 16);
        n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
        Converting.write(n, this.buffer, 16);
    }

    public final boolean getSynchronous() {
        return (Converting.readInt(this.buffer, 16) & 2) == 2;
    }

    public final void setHtl(short s) {
        Converting.write((byte)s, this.buffer, 20);
    }

    public final short getHtl() {
        return (short)(0xFF & Converting.readByte(this.buffer, 20));
    }

    public final void setClazz(short s) {
        Converting.write((byte)s, this.buffer, 21);
    }

    public final short getClazz() {
        return (short)(0xFF & Converting.readByte(this.buffer, 21));
    }

    public final void setMulticastSubHeader(PDUPacketSubHeaderMulticast pDUPacketSubHeaderMulticast) {
        int n = Converting.readInt(this.buffer, 16);
        n = pDUPacketSubHeaderMulticast != null ? (n |= 0x40000000) : (n &= 0xBFFFFFFF);
        Converting.write(n, this.buffer, 16);
        this.subHeaders[0] = pDUPacketSubHeaderMulticast;
    }

    public final PDUPacketSubHeaderMulticast getMulticastSubHeader() {
        return (PDUPacketSubHeaderMulticast)this.subHeaders[0];
    }

    public final void setMultiConnectionSubHeader(PDUPacketSubHeaderMultiConnection pDUPacketSubHeaderMultiConnection) {
        int n = Converting.readInt(this.buffer, 16);
        n = pDUPacketSubHeaderMultiConnection != null ? (n |= 0x20000000) : (n &= 0xDFFFFFFF);
        Converting.write(n, this.buffer, 16);
        this.subHeaders[1] = pDUPacketSubHeaderMultiConnection;
    }

    public final PDUPacketSubHeaderMultiConnection getMultiConnectionSubHeader() {
        return (PDUPacketSubHeaderMultiConnection)this.subHeaders[1];
    }

    public final Object clone() {
        PDUPacketHeader pDUPacketHeader;
        try {
            pDUPacketHeader = (PDUPacketHeader)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Received CloneNotSupportedException even when we implement Cloneable!");
        }
        pDUPacketHeader.init(this.buffer, this.subHeaders);
        return pDUPacketHeader;
    }

    public final String toString() {
        String string = "";
        string = string + this.hashCode();
        string = string + "[";
        string = string + "1,<" + PDUPacketHeader.unicastAddrToString(this.getSrc()) + ">," + "<" + PDUPacketHeader.unicastAddrToString(this.getDest()) + ">," + this.getFlow() + "," + "<zl=" + this.getZeroLatency() + " sync=" + this.getSynchronous() + ">" + "," + this.getHtl() + "," + this.getClazz() + "," + this.getTypeStr();
        for (int i = 0; i < this.subHeaders.length; ++i) {
            if (this.subHeaders[i] == null) continue;
            string = string + " " + this.subHeaders[i];
        }
        string = string + "]";
        return string;
    }

    static {
        PDUPacketHeader.typeStrArray[1] = "NWCONN_PING_REQUEST";
        PDUPacketHeader.typeStrArray[2] = "NWCONN_PING_REPLY";
        PDUPacketHeader.typeStrArray[3] = "CLIENT_CONNECT_REQUEST";
        PDUPacketHeader.typeStrArray[4] = "CLIENT_CONNECT_REPLY";
        PDUPacketHeader.typeStrArray[5] = "BROKER_CONNECT_REQUEST";
        PDUPacketHeader.typeStrArray[6] = "BROKER_CONNECT_REPLY";
        PDUPacketHeader.typeStrArray[7] = "JOIN_REQUEST";
        PDUPacketHeader.typeStrArray[8] = "JOIN_REPLY";
        PDUPacketHeader.typeStrArray[9] = "LEAVE_REQUEST";
        PDUPacketHeader.typeStrArray[10] = "LEAVE_REPLY";
        PDUPacketHeader.typeStrArray[11] = "MCONN_ACK";
        PDUPacketHeader.typeStrArray[12] = "MCONN_NACK";
        PDUPacketHeader.typeStrArray[13] = "MCONN_SYNC";
        PDUPacketHeader.typeStrArray[14] = "MULTI_NWCONN_HANDSHAKE_REQUEST";
        PDUPacketHeader.typeStrArray[15] = "MULTI_NWCONN_HANDSHAKE_REPLY";
        PDUPacketHeader.typeStrArray[255] = "DATA";
    }
}

