/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketMultiConnectionNack
extends PDUPacket {
    private int count;
    private long[] flowIds;
    private Object[] snoSets;
    private int wireSize;

    private PDUPacketMultiConnectionNack(int n, long[] lArray, Object[] objectArray) {
        super((short)12);
        this.setBody(n, lArray, objectArray);
    }

    private PDUPacketMultiConnectionNack(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 12) {
            throw new InternalError("MCONN NACK packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketMultiConnectionNack(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 12) {
            throw new InternalError("MCONN NACK packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            dataOutputStream.writeInt(this.wireSize);
            dataOutputStream.writeInt(this.count);
            for (int i = 0; i < this.count; ++i) {
                dataOutputStream.writeLong(this.flowIds[i]);
                long[] lArray = (long[])this.snoSets[i];
                dataOutputStream.writeInt(lArray.length);
                for (int j = 0; j < lArray.length; ++j) {
                    dataOutputStream.writeLong(lArray[j]);
                }
            }
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() < 4) throw new EIOInsufficientDataException(4 - dataInputStream.available());
            this.wireSize = dataInputStream.readInt();
            if (dataInputStream.available() < this.wireSize - 4) throw new EIOInsufficientDataException(this.wireSize - dataInputStream.available());
            int n = dataInputStream.readInt();
            long[] lArray = new long[n];
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = dataInputStream.readLong();
                int n2 = dataInputStream.readInt();
                long[] lArray2 = new long[n2];
                for (int j = 0; j < lArray2.length; ++j) {
                    lArray2[j] = dataInputStream.readLong();
                }
                objectArray[i] = lArray2;
            }
            this.setBody(n, lArray, objectArray);
            return;
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        int n;
        while ((n = (int)SysInteractive.ask("Flow count", printStream, bufferedReader, 0.0)) < 0) {
        }
        long[] lArray = new long[n];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            do {
                lArray[i] = (int)SysInteractive.ask("Id for flow #" + (i + 1), printStream, bufferedReader, i + 1);
            } while (lArray[i] < 0L);
            while ((n2 = (int)SysInteractive.ask("Num snos for flow #" + (i + 1), printStream, bufferedReader, 1.0)) < 0) {
            }
            long[] lArray2 = new long[n2];
            for (int j = 0; j < n2; ++j) {
                do {
                    lArray2[j] = (int)SysInteractive.ask("Nack sno #" + (j + 1), printStream, bufferedReader, 0.0);
                } while (lArray2[j] <= 0L);
            }
            objectArray[i] = lArray2;
        }
        this.setBody(n, lArray, objectArray);
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
        long[] lArray = new long[this.count];
        System.arraycopy(this.flowIds, 0, lArray, 0, this.count);
        Object[] objectArray = new Object[this.count];
        for (int i = 0; i < this.count; ++i) {
            long[] lArray2 = (long[])this.snoSets[i];
            long[] lArray3 = new long[lArray2.length];
            System.arraycopy(lArray2, 0, lArray3, 0, lArray3.length);
            objectArray[i] = lArray3;
        }
        ((PDUPacketMultiConnectionNack)pDUPacket).setBody(this.count, lArray, objectArray);
    }

    @Override
    final int getBodyWireSize() {
        return this.wireSize;
    }

    @Override
    final String bodyToString() {
        String string = "[";
        string = string + this.wireSize;
        string = string + ",";
        string = string + this.count;
        for (int i = 0; i < this.count; ++i) {
            string = string + " {" + this.flowIds[i];
            long[] lArray = (long[])this.snoSets[i];
            string = string + " <";
            for (int j = 0; j < lArray.length; ++j) {
                string = string + lArray[j];
                if (j == lArray.length - 1) continue;
                string = string + ",";
            }
            string = string + ">";
            string = string + "}";
        }
        string = string + "]";
        return string;
    }

    public static PDUPacketMultiConnectionNack create(int n, long[] lArray, Object[] objectArray) {
        return new PDUPacketMultiConnectionNack(n, lArray, objectArray);
    }

    static PDUPacketMultiConnectionNack create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketMultiConnectionNack(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketMultiConnectionNack create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketMultiConnectionNack(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setBody(int n, long[] lArray, Object[] objectArray) {
        this.count = n;
        this.flowIds = lArray;
        this.snoSets = objectArray;
        this.wireSize = 8;
        this.wireSize += 8 * n;
        for (int i = 0; i < n; ++i) {
            this.wireSize += 4;
            this.wireSize += 8 * ((long[])objectArray[i]).length;
        }
    }

    public final int getCount() {
        return this.count;
    }

    public final long[] getFlowIds() {
        return this.flowIds;
    }

    public final Object[] getSnoSets() {
        return this.snoSets;
    }
}

