/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketNetworkConnectionPingReply
extends PDUPacket {
    private int sno;
    private static final int BODY_WIRE_SIZE = 4;

    private PDUPacketNetworkConnectionPingReply(int n) {
        super((short)2);
        this.setSno(n);
    }

    private PDUPacketNetworkConnectionPingReply(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 2) {
            throw new InternalError("NWCONN PING REPLY packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketNetworkConnectionPingReply(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 2) {
            throw new InternalError("NWCONN PING REPLY packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            dataOutputStream.writeInt(this.sno);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() < this.getBodyWireSize()) {
                throw new EIOInsufficientDataException(this.getBodyWireSize() - dataInputStream.available());
            }
            this.setSno(dataInputStream.readInt());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setSno((int)SysInteractive.ask("Sequence Number", printStream, bufferedReader, 0.0));
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    final int getBodyWireSize() {
        return 4;
    }

    @Override
    final String bodyToString() {
        return "[" + this.getSno() + "]";
    }

    public static PDUPacketNetworkConnectionPingReply create(int n) {
        return new PDUPacketNetworkConnectionPingReply(n);
    }

    static PDUPacketNetworkConnectionPingReply create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketNetworkConnectionPingReply(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketNetworkConnectionPingReply create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketNetworkConnectionPingReply(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setSno(int n) {
        this.sno = n;
    }

    public final int getSno() {
        return this.sno;
    }
}

