/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketNetworkConnectionPingRequest
extends PDUPacket {
    private int sno;
    private static final int BODY_WIRE_SIZE = 4;

    private PDUPacketNetworkConnectionPingRequest(int n) {
        super((short)1);
        this.setSno(n);
    }

    private PDUPacketNetworkConnectionPingRequest(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 1) {
            throw new InternalError("NWCONN PING REQUEST packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketNetworkConnectionPingRequest(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 1) {
            throw new InternalError("NWCONN PING REQUEST packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            dataOutputStream.writeInt(this.sno);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() < this.getBodyWireSize()) {
                throw new EIOInsufficientDataException(this.getBodyWireSize() - dataInputStream.available());
            }
            this.setSno(dataInputStream.readInt());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setSno((int)SysInteractive.ask("Sequence Number", printStream, bufferedReader, 0.0));
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    final int getBodyWireSize() {
        return 4;
    }

    @Override
    final String bodyToString() {
        return "[" + this.getSno() + "]";
    }

    public static PDUPacketNetworkConnectionPingRequest create(int n) {
        return new PDUPacketNetworkConnectionPingRequest(n);
    }

    static PDUPacketNetworkConnectionPingRequest create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketNetworkConnectionPingRequest(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketNetworkConnectionPingRequest create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketNetworkConnectionPingRequest(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setSno(int n) {
        this.sno = n;
    }

    public final int getSno() {
        return this.sno;
    }
}

