/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacketSubHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketSubHeaderMulticast
extends PDUPacketSubHeader {
    private String topic;

    public PDUPacketSubHeaderMulticast() {
    }

    public PDUPacketSubHeaderMulticast(String string) {
        this.setTopic(string);
    }

    @Override
    final void serialize(DataOutputStream dataOutputStream) throws EIOException {
        try {
            String string = this.topic == null ? "" : this.topic;
            dataOutputStream.writeShort(2 + (short)string.length());
            dataOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserialize(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() >= 2) {
                short s = dataInputStream.readShort();
                if (dataInputStream.available() < s) {
                    throw new EIOInsufficientDataException(s - dataInputStream.available());
                }
            } else {
                throw new EIOInsufficientDataException();
            }
            this.setTopic(dataInputStream.readUTF());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserialize(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setTopic(SysInteractive.ask("Topic", printStream, bufferedReader, null));
    }

    @Override
    final int getWireSize() {
        return 4 + (this.topic == null ? 0 : this.topic.length());
    }

    @Override
    public final Object clone() {
        PDUPacketSubHeaderMulticast pDUPacketSubHeaderMulticast = (PDUPacketSubHeaderMulticast)super.clone();
        pDUPacketSubHeaderMulticast.setTopic(this.getTopic());
        return pDUPacketSubHeaderMulticast;
    }

    public final void setTopic(String string) {
        this.topic = string != null ? (string.length() == 0 ? null : string) : null;
    }

    public final String getTopic() {
        return this.topic;
    }

    public final String toString() {
        return "mcast" + this.hashCode() + "{" + this.topic + "}";
    }
}

