/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.sys;

import com.progress.blackbird.sys.ESysHnameFormatException;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysHname;
import com.progress.blackbird.sys.SysObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public final class SysHnameTable
extends SysObject {
    private int size;
    private Node root;
    private HashMap map;
    private final int TRACE_FLAG_CREATE = 1;
    private final int TRACE_FLAG_SET_NODE_OBJECT = 2;

    private SysHnameTable(SysConfig.PackageConfig packageConfig, int n) {
        super(packageConfig);
        this.size = n;
        this.init();
    }

    private void init() {
        this.root = new Node(null, null);
        this.map = this.size > 0 ? new HashMap(this.size) : new HashMap();
    }

    private void dump(Node node, PrintStream printStream, String string) {
        if (node.wildcardChildren != null) {
            for (Node node2 : node.wildcardChildren.values()) {
                printStream.println(" |" + string + " " + node2);
                this.dump(node2, printStream, string + "--");
            }
        }
        if (node.nonWildcardChildren != null) {
            for (Node node2 : node.nonWildcardChildren.values()) {
                printStream.println(" |" + string + " " + node2);
                this.dump(node2, printStream, string + "--");
            }
        }
        if (node.levelWildcardChild != null) {
            printStream.println(" |" + string + " " + node.levelWildcardChild);
        }
    }

    private ArrayList matchNodes(Node node, Node node2, ArrayList arrayList) {
        ArrayList<Node> arrayList2 = arrayList;
        if (node2.wildcardChildren != null) {
            for (Node node3 : node2.wildcardChildren.values()) {
                if (node3 == node || !SysHname.isElementMatch(node3.element, node.element)) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Node>();
                }
                arrayList2.add(node3);
            }
        }
        if (node.isWildcard() && node2.nonWildcardChildren != null) {
            for (Node node3 : node2.nonWildcardChildren.values()) {
                if (node3 == node || !SysHname.isElementMatch(node3.element, node.element)) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                }
                arrayList2.add(node3);
            }
        }
        return arrayList2;
    }

    private Node getChildNode(Node node, String string, int n) {
        Node node2 = null;
        if (!SysHname.isWildcard(string)) {
            node2 = node.getNonWildcardChild(string);
            if (node2 == null && (n & 1) == 1) {
                node2 = new Node(node, string);
                node.addNonWildcardChild(string, node2);
            }
        } else if (string.compareTo(SysHname.getLevelWildcard()) == 0) {
            node2 = node.levelWildcardChild;
            if (node2 == null && (n & 1) == 1) {
                node2 = node.levelWildcardChild = new Node(node, string);
            }
        } else {
            node2 = node.getWildcardChild(string);
            if (node2 == null && (n & 1) == 1) {
                node2 = new Node(node, string);
                node.addWildcardChild(string, node2);
            }
        }
        return node2;
    }

    private ArrayList prepareSiblingMatchingNodes(Node node, Node node2, ArrayList arrayList) {
        ArrayList arrayList2 = this.matchNodes(node, node2, null);
        if (arrayList != null) {
            for (Node node3 : arrayList) {
                arrayList2 = this.matchNodes(node, node3, arrayList2);
            }
        }
        return arrayList2;
    }

    private void matchNodeToChildrenOfANode(Node node, Node node2) {
        if (node2.wildcardChildren != null) {
            for (Node node3 : node2.wildcardChildren.values()) {
                if (node3 != node && node3.object != null) {
                    node.addMatchingNode(node3);
                    node3.addMatchingNode(node);
                }
                this.matchNodeToChildrenOfANode(node, node3);
            }
        }
        if (node2.nonWildcardChildren != null) {
            for (Node node3 : node2.nonWildcardChildren.values()) {
                if (node3 != node && node3.object != null) {
                    node.addMatchingNode(node3);
                    node3.addMatchingNode(node);
                }
                this.matchNodeToChildrenOfANode(node, node3);
            }
        }
        if (node2.levelWildcardChild != null && node2.levelWildcardChild != node) {
            node.addMatchingNode(node2.levelWildcardChild);
            node2.levelWildcardChild.addMatchingNode(node);
        }
    }

    private void matchNodeToLevelWildcard(Node node, Node node2, ArrayList arrayList) {
        block7: {
            block6: {
                if (node2.levelWildcardChild == node) break block6;
                if (node2.levelWildcardChild != null) {
                    if (node.object != null) {
                        node2.levelWildcardChild.addMatchingNode(node);
                    }
                    node.addMatchingNode(node2.levelWildcardChild);
                }
                if (arrayList == null) break block7;
                for (Node node3 : arrayList) {
                    if (node3.levelWildcardChild == null) continue;
                    if (node.object != null) {
                        node3.levelWildcardChild.addMatchingNode(node);
                    }
                    node.addMatchingNode(node3.levelWildcardChild);
                }
                break block7;
            }
            this.matchNodeToChildrenOfANode(node, node2);
            if (arrayList != null) {
                for (Node node4 : arrayList) {
                    this.matchNodeToChildrenOfANode(node, node4);
                }
            }
        }
    }

    private void checkNPruneChildNode(Node node, Node node2) {
        if (node2.isEmpty()) {
            if (!node.removeNonWildcardChild(node2.element) && !node.removeWildcardChild(node2.element)) {
                node.levelWildcardChild = null;
            }
            node2.parent = null;
            if (node2.matchingNodes != null) {
                for (Node node3 : node2.matchingNodes) {
                    node3.removeMatchingNode(node2);
                }
            }
        }
    }

    private void setMatchingNodes(Node node, ArrayList arrayList) {
        if (arrayList != null) {
            for (Node node2 : arrayList) {
                if (node2.object == null) continue;
                node2.addMatchingNode(node);
                node.addMatchingNode(node2);
            }
        }
    }

    private Node checkNCleanFoundNodeMatchList(Node node) {
        Node node2 = node;
        if (node.object == null && node.matchingNodes != null) {
            node2 = (Node)node.clone();
            for (Node node3 : node.matchingNodes) {
                node3.removeMatchingNode(node);
            }
            node.matchingNodes.clear();
        }
        return node2;
    }

    private Node trace(String[] stringArray, int n, Node node, ArrayList arrayList, Object object, int n2) {
        String string = null;
        if (n < stringArray.length && (string = stringArray[n].trim().toLowerCase()).length() > 0) {
            ArrayList arrayList2 = null;
            Node node2 = this.getChildNode(node, string, n2);
            if (node2 != null) {
                Node node3;
                if (!node2.isLevelWildcard() && (n2 & 1) == 1) {
                    arrayList2 = this.prepareSiblingMatchingNodes(node2, node, arrayList);
                }
                if ((node3 = this.trace(stringArray, n + 1, node2, arrayList2, object, n2)) != null) {
                    if ((n2 & 1) == 1) {
                        this.matchNodeToLevelWildcard(node3, node, arrayList);
                    }
                    this.checkNPruneChildNode(node, node2);
                    if (node == this.root) {
                        node3 = this.checkNCleanFoundNodeMatchList(node3);
                    }
                }
                return node3;
            }
            return null;
        }
        if ((n2 & 2) == 2) {
            node.object = object;
        }
        if ((n2 & 1) == 1) {
            this.setMatchingNodes(node, arrayList);
        }
        return node;
    }

    public static SysHnameTable create(SysConfig.PackageConfig packageConfig, int n) {
        return new SysHnameTable(packageConfig, n);
    }

    public final void add(String string, Object object) throws ESysHnameFormatException {
        if (this.checked && object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        string = SysHname.normalize(string, true);
        Node node = this.trace(SysHname.split(string), 0, this.root, null, object, 3);
        this.map.put(string, object);
    }

    public final int size() {
        return this.map.size();
    }

    public final Object get(String string) {
        try {
            string = SysHname.normalize(string, false);
        }
        catch (ESysHnameFormatException eSysHnameFormatException) {
            throw new InternalError("hname normalizer threw format exception with validate set to false!");
        }
        return this.map.get(string);
    }

    public final LinkedHashMap matches(String string) throws ESysHnameFormatException {
        string = SysHname.normalize(string, true);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Node node = this.trace(SysHname.split(string), 0, this.root, null, null, 0);
        if (node == null || node.object == null) {
            node = this.trace(SysHname.split(string), 0, this.root, null, null, 1);
        }
        if (node.matchingNodes != null) {
            for (Node node2 : node.matchingNodes) {
                if (this.checked && node2.object == null) {
                    throw new InternalError("Node with null object present in matching node list!");
                }
                linkedHashMap.put(node2.getName(), node2.object);
            }
        }
        return linkedHashMap;
    }

    public final void dump(PrintStream printStream) {
        printStream.println("");
        this.dump(this.root, printStream, "");
        printStream.println("");
    }

    public final Object remove(String string) throws ESysHnameFormatException {
        Object v = this.map.remove(string = SysHname.normalize(string, true));
        if (v != null) {
            Node node = this.trace(SysHname.split(string), 0, this.root, null, null, 2);
        }
        return v;
    }

    public final void clear() {
        this.init();
    }

    private final class Node {
        Node parent;
        String element;
        LinkedHashSet matchingNodes;
        LinkedHashMap nonWildcardChildren;
        LinkedHashMap wildcardChildren;
        Node levelWildcardChild;
        byte flags;
        Object object;
        static final byte FLAG_WILDCARD_ELEMENT = 1;
        static final byte FLAG_LEVEL_WILDCARD_ELEMENT = 2;

        Node(Node node, String string) {
            this.parent = node;
            this.element = string;
            if (this.element != null && SysHname.isWildcard(string)) {
                this.flags = 1;
                if (this.element.compareTo(SysHname.getLevelWildcard()) == 0) {
                    this.flags = (byte)(this.flags | 2);
                }
            }
        }

        final boolean isEmpty() {
            return !(this.nonWildcardChildren != null && !this.nonWildcardChildren.isEmpty() || this.wildcardChildren != null && !this.wildcardChildren.isEmpty() || this.levelWildcardChild != null || this.object != null);
        }

        final boolean isWildcard() {
            return (this.flags & 1) == 1;
        }

        final boolean isLevelWildcard() {
            return (this.flags & 2) == 2;
        }

        final String getName() {
            return this.parent == null ? "" : this.parent.getName() + SysHname.getElementSeparator() + this.element;
        }

        final void addWildcardChild(String string, Node node) {
            if (this.wildcardChildren == null) {
                this.wildcardChildren = new LinkedHashMap();
            }
            this.wildcardChildren.put(string, node);
        }

        final Node getWildcardChild(String string) {
            if (this.wildcardChildren != null) {
                return (Node)this.wildcardChildren.get(string);
            }
            return null;
        }

        final boolean removeWildcardChild(String string) {
            if (this.wildcardChildren == null || this.wildcardChildren.remove(string) == null) {
                return false;
            }
            if (this.wildcardChildren.isEmpty()) {
                this.wildcardChildren = null;
            }
            return true;
        }

        final void addNonWildcardChild(String string, Node node) {
            if (this.nonWildcardChildren == null) {
                this.nonWildcardChildren = new LinkedHashMap();
            }
            this.nonWildcardChildren.put(string, node);
        }

        final Node getNonWildcardChild(String string) {
            if (this.nonWildcardChildren != null) {
                return (Node)this.nonWildcardChildren.get(string);
            }
            return null;
        }

        final boolean removeNonWildcardChild(String string) {
            if (this.nonWildcardChildren == null || this.nonWildcardChildren.remove(string) == null) {
                return false;
            }
            if (this.nonWildcardChildren.isEmpty()) {
                this.nonWildcardChildren = null;
            }
            return true;
        }

        final void addMatchingNode(Node node) {
            if (this.matchingNodes == null) {
                this.matchingNodes = new LinkedHashSet();
            }
            this.matchingNodes.add(node);
        }

        final boolean removeMatchingNode(Node node) {
            if (this.matchingNodes == null || !this.matchingNodes.remove(node)) {
                return false;
            }
            if (this.matchingNodes.isEmpty()) {
                this.matchingNodes = null;
            }
            return true;
        }

        protected final Object clone() {
            Node node = new Node(this.parent, this.element);
            node.matchingNodes = this.matchingNodes == null ? null : (LinkedHashSet)this.matchingNodes.clone();
            node.nonWildcardChildren = this.nonWildcardChildren;
            node.wildcardChildren = this.wildcardChildren;
            node.levelWildcardChild = this.levelWildcardChild;
            node.flags = this.flags;
            node.object = this.object;
            return node;
        }

        public final String toString() {
            String string = this.element;
            string = string + " {" + (this.object == null ? "i" : "e");
            string = string + ", ";
            string = string + "matches=(";
            if (this.matchingNodes != null) {
                Iterator iterator = this.matchingNodes.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    string = string + node.getName();
                    if (!iterator.hasNext()) continue;
                    string = string + ", ";
                }
            }
            string = string + ")";
            string = string + "}";
            return string;
        }
    }
}

