/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.sys;

import com.progress.blackbird.sys.SysTrace;

public class SysRWLock {
    private String name;
    private int lockCount;
    private int waitingWriters;
    private int waitingReaders;
    private Object mutex;

    private SysRWLock(String string) {
        this.name = string;
        this.mutex = new Object();
    }

    public static SysRWLock create(String string) {
        return new SysRWLock(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getReadLock() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.lockCount == -1 || this.waitingWriters != 0) {
                this.mutex.wait();
            }
            ++this.lockCount;
        }
    }

    public final void getReadLockUninterrupted(SysRWLock sysRWLock, SysTrace sysTrace) {
        while (true) {
            try {
                sysRWLock.getReadLock();
            }
            catch (InterruptedException interruptedException) {
                if (sysTrace == null) continue;
                sysTrace.outln("Interrupted while acquiring read lock on <" + (this.name == null ? "noname" : this.name) + ">. Retrying...", 2);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getWriteLock() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            ++this.waitingWriters;
            while (this.lockCount != 0) {
                this.mutex.wait();
            }
            --this.waitingWriters;
            this.lockCount = -1;
        }
    }

    public final void getWriteLockUninterrupted(SysRWLock sysRWLock, SysTrace sysTrace) {
        while (true) {
            try {
                sysRWLock.getWriteLock();
            }
            catch (InterruptedException interruptedException) {
                if (this.name == null) continue;
                sysTrace.outln("Interrupted while acquiring write lock on <" + (this.name == null ? "noname" : this.name) + ">. Retrying...", 2);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseLock() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.lockCount == 0) {
                return;
            }
            this.lockCount = this.lockCount == -1 ? 0 : --this.lockCount;
            this.mutex.notifyAll();
        }
    }
}

