/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.lm.impl;

import com.sonicsw.lm.impl.Dependencies;
import com.sonicsw.lm.impl.Lock;
import com.sonicsw.lm.impl.LockManager;
import com.sonicsw.lm.impl.RequestorLocks;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class DeadlockDetection
implements Runnable {
    private static boolean TRACE_LOCKING = false;
    LockManager m_lm;
    Thread m_ddThread;
    boolean m_doDeadlockSearch;
    int m_ct;
    boolean DEBUG = false;
    Random m_rand;

    public DeadlockDetection(LockManager lm) {
        this.m_lm = lm;
        this.m_rand = new Random(System.currentTimeMillis());
    }

    synchronized void startDeadLockSearch() {
        if (this.m_ddThread == null) {
            ++this.m_ct;
            this.m_ddThread = new Thread((Runnable)this, "DeadLock Search " + this.m_ct);
            this.m_ddThread.setDaemon(true);
            this.m_ddThread.start();
        } else {
            this.m_doDeadlockSearch = true;
        }
    }

    synchronized void stopDeadLockSearch() {
        this.m_ddThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList findCycles(RequestorLocks rLocks, boolean findAll) {
        HashMap visited = new HashMap();
        ArrayList cycles = new ArrayList();
        try {
            if (rLocks != null) {
                if (this.DEBUG) {
                    this.debug("Starting cycle search: Lockrequestor= " + rLocks.getRequestor());
                }
                this.findCycles(rLocks, false, cycles, visited, new ArrayList());
            }
        }
        finally {
            for (RequestorLocks locks : visited.values()) {
                locks.setVisited(false);
            }
        }
        if (this.DEBUG) {
            this.debug("Completed cycle search: Lockrequestor= " + rLocks.getRequestor() + " cycles= " + cycles.size());
        }
        return cycles;
    }

    void findCycles(RequestorLocks rlInfo, boolean findAll, ArrayList cycles, HashMap visited, ArrayList lockCycle) {
        Object lockrequestor = rlInfo.getRequestor();
        if (cycles.size() > 0 && !findAll) {
            return;
        }
        Dependencies dependencies = rlInfo.getDynamicDependencies();
        visited.put(lockrequestor, rlInfo);
        for (int i = 0; i < dependencies.size(); ++i) {
            Object lholder = dependencies.getOwner(i);
            RequestorLocks dependency = this.m_lm.getRequestorLocks(lholder);
            if (dependency == null) continue;
            rlInfo.m_cycle = dependency;
            lockCycle.add(dependencies.getLock(i));
            if (dependency.m_cycle != null) {
                ArrayList cycle = this.saveCycle(dependency.m_cycle, lockCycle);
                lockCycle = new ArrayList<Lock>();
                cycles.add(cycle);
                if (this.DEBUG) {
                    this.printCycle(cycle);
                }
            } else if (visited.get(lholder) == null) {
                this.findCycles(dependency, findAll, cycles, visited, lockCycle);
            }
            rlInfo.m_cycle = null;
        }
    }

    private ArrayList saveCycle(RequestorLocks rLocks, ArrayList locksCycle) {
        ArrayList<Object> cycle = new ArrayList<Object>();
        RequestorLocks firstOne = rLocks;
        cycle.add(firstOne.getRequestor());
        RequestorLocks nextRequestorLocks = firstOne.m_cycle;
        while (nextRequestorLocks != null) {
            cycle.add(nextRequestorLocks.getRequestor());
            if (nextRequestorLocks == firstOne) break;
            nextRequestorLocks = nextRequestorLocks.m_cycle;
        }
        if (TRACE_LOCKING) {
            System.err.println("\n\t**** Deadlock cycle found. Cycle lock trace:");
            for (int i = 0; i < locksCycle.size(); ++i) {
                int indexOfBlocker = i % cycle.size();
                int indexOfBlocked = (i + 1) % cycle.size();
                System.err.println("\t\tTransaction " + cycle.get(indexOfBlocked) + " is waiting for transaction " + cycle.get(indexOfBlocker) + " on " + locksCycle.get(i));
            }
        }
        return cycle;
    }

    private int selectDeadLockVictimRandom(ArrayList cycles) {
        if (this.DEBUG) {
            this.debug("selectDeadLockVictimRandom; numcycles= " + cycles.size());
        }
        Iterator it = cycles.iterator();
        ArrayList victims = new ArrayList();
        while (it.hasNext()) {
            ArrayList acycle = (ArrayList)it.next();
            Iterator cycleIt = acycle.iterator();
            Object victim = null;
            while (cycleIt.hasNext()) {
                Object lockowner = cycleIt.next();
                if (!victims.contains(lockowner)) continue;
                victim = lockowner;
                break;
            }
            if (victim != null) continue;
            int ct = acycle.size();
            int indx = this.m_rand.nextInt(ct - 1);
            victim = acycle.get(indx);
            victims.add(victim);
            if (!this.DEBUG) continue;
            this.debug("selectDeadLockVictimRandom; selected Random Victim " + victim);
        }
        if (this.DEBUG) {
            this.debug("selectDeadLockVictimRandom; numVictims= " + victims.size());
        }
        for (Object theVictim : victims) {
            if (this.DEBUG) {
                this.debug("Canceling waiting req for " + theVictim);
            }
            this.m_lm.cancelAllWaitingReq(theVictim);
        }
        return victims.size();
    }

    private int selectDeadLockVictimFirst(ArrayList cycles) {
        if (this.DEBUG) {
            this.debug("selectDeadLockVictimFirst; numcycles= " + cycles.size());
        }
        Iterator it = cycles.iterator();
        ArrayList victims = new ArrayList();
        while (it.hasNext()) {
            ArrayList acycle = (ArrayList)it.next();
            Iterator cycleIt = acycle.iterator();
            Object victim = null;
            while (cycleIt.hasNext()) {
                Object lockowner = cycleIt.next();
                if (!victims.contains(lockowner)) continue;
                victim = lockowner;
                break;
            }
            if (victim != null) continue;
            victim = acycle.get(0);
            victims.add(victim);
            if (!this.DEBUG) continue;
            this.debug("selectDeadLockVictimFirst; selected Random Victim " + victim);
        }
        if (this.DEBUG) {
            this.debug("selectDeadLockVictimFirst; numVictims= " + victims.size());
        }
        for (Object aVictim : victims) {
            if (this.DEBUG) {
                this.debug("Canceling waiting req for " + aVictim);
            }
            this.m_lm.cancelAllWaitingReq(aVictim);
        }
        return victims.size();
    }

    private int selectDeadLockVictimMostCycles(ArrayList cycles) {
        if (this.DEBUG) {
            this.debug("selectDeadLockVictimMostCycles; numcycles= " + cycles.size());
        }
        if (cycles.isEmpty()) {
            return 0;
        }
        Iterator<Object> it = cycles.iterator();
        HashMap lockRequestorsToCycleCt = new HashMap();
        while (it.hasNext()) {
            ArrayList acycle = (ArrayList)it.next();
            Iterator cycleIt = acycle.iterator();
            boolean firstOne = true;
            while (cycleIt.hasNext()) {
                Object aLockRequestor = cycleIt.next();
                if (firstOne) {
                    firstOne = false;
                    continue;
                }
                Integer numCycles = (Integer)lockRequestorsToCycleCt.get(aLockRequestor);
                if (numCycles == null) {
                    lockRequestorsToCycleCt.put(aLockRequestor, new Integer(1));
                    continue;
                }
                lockRequestorsToCycleCt.put(aLockRequestor, new Integer(numCycles + 1));
            }
        }
        it = lockRequestorsToCycleCt.keySet().iterator();
        Object candidate = null;
        int maxCycleCount = 0;
        while (it.hasNext()) {
            Object lockRequestor = it.next();
            Integer cyclesL = (Integer)lockRequestorsToCycleCt.get(lockRequestor);
            if (this.DEBUG) {
                this.debug("selectDeadLockVictimMostCycles; CycleCount: requestor= " + lockRequestor + " cycles= " + cyclesL);
            }
            if (cyclesL <= maxCycleCount) continue;
            maxCycleCount = cyclesL;
            candidate = lockRequestor;
        }
        if (this.DEBUG) {
            this.debug("selectDeadLockVictimMostCycles; selected victim: holder= " + candidate + " numcycles= " + maxCycleCount);
        }
        this.m_lm.cancelAllWaitingReq(candidate);
        return 1;
    }

    public void printCycle(ArrayList cycle) {
        Object lockowner;
        StringBuffer buf = new StringBuffer();
        buf.append("Cycle: ");
        Iterator it = cycle.iterator();
        if (it.hasNext()) {
            lockowner = it.next();
            buf.append(lockowner.toString());
        }
        while (it.hasNext()) {
            lockowner = it.next();
            buf.append(" -> " + lockowner.toString());
        }
        this.debug(buf.toString());
    }

    void printDependencies(Object lockRequestor, ArrayList dependencies) {
        Object aLockRequestor;
        StringBuffer buf = new StringBuffer();
        buf.append("Dependencies: requestor= " + lockRequestor + " ct= " + dependencies.size() + " dep: ");
        Iterator it = dependencies.iterator();
        if (it.hasNext()) {
            aLockRequestor = it.next();
            buf.append(aLockRequestor.toString());
        }
        while (it.hasNext()) {
            aLockRequestor = it.next();
            buf.append(", " + aLockRequestor.toString());
        }
        this.debug(buf.toString());
    }

    private void debug(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int startups = this.m_ct;
        if (this.DEBUG) {
            this.debug("****Thread Starting; ct= " + startups);
        }
        boolean startNewSearch = true;
        while (startNewSearch && !Thread.interrupted()) {
            if (this.DEBUG) {
                this.debug("****Deadlock Search starting " + new Date());
            }
            int iterations = 0;
            boolean allDeadlocksResolved = false;
            while (!allDeadlocksResolved) {
                int numVictims = this.findAndResolveDeadlocks();
                ++iterations;
                if (numVictims == 0) {
                    allDeadlocksResolved = true;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (this.DEBUG) {
                this.debug("*****Deadlock search terminated; iterations= " + iterations);
            }
            DeadlockDetection deadlockDetection = this;
            synchronized (deadlockDetection) {
                if (this.m_doDeadlockSearch) {
                    this.m_doDeadlockSearch = false;
                    startNewSearch = true;
                } else {
                    this.m_ddThread = null;
                    startNewSearch = false;
                }
            }
        }
        if (this.DEBUG) {
            this.debug("*****Run: Deadlock Thread exiting; ct= " + startups);
        }
    }

    private int findAndResolveDeadlocks() {
        HashMap visited = new HashMap();
        ArrayList cycles = new ArrayList();
        Object[] requestors = this.m_lm.getLockRequestors();
        for (int i = 0; i < requestors.length; ++i) {
            Object owner = requestors[i];
            RequestorLocks rLocks = this.m_lm.getRequestorLocks(owner);
            if (rLocks == null || visited.get(owner) != null) continue;
            this.findCycles(rLocks, true, cycles, visited, new ArrayList());
        }
        int numVictims = 0;
        if (!cycles.isEmpty()) {
            if (this.DEBUG) {
                this.debug("DeadlockDetection: found " + cycles.size() + " cycles ");
            }
            numVictims = this.selectDeadLockVictimMostCycles(cycles);
        } else if (this.DEBUG) {
            this.debug("DeadlockDetection: No cycles found");
        }
        return numVictims;
    }

    static {
        String temp = System.getProperty("_PSETraceLocking");
        if (temp != null && temp.equalsIgnoreCase("true")) {
            TRACE_LOCKING = true;
        }
    }
}

