/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.lm.impl;

import com.sonicsw.lm.impl.LockManager;
import com.sonicsw.lm.impl.LockRequest;
import com.sonicsw.lm.impl.RequestorLocks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class Lock {
    static final int LOCK_MODE_NONE = 0;
    static final int LOCK_MODE_S = 1;
    static final int LOCK_MODE_X = 2;
    static final int LOCK_MODE_PERMIT = 3;
    private Object m_lockId;
    private int m_grantedMode;
    private LockManager m_lm;
    private int m_objectType;
    private String m_className;
    private LinkedList m_lockReq = new LinkedList();
    private Vector m_waitingReq = new Vector();

    Lock(Object lockid, LockManager lm, int objectType, String className) {
        this.m_lockId = lockid;
        this.m_grantedMode = 0;
        this.m_lm = lm;
        this.m_objectType = objectType;
        this.m_className = className;
    }

    Object getLockId() {
        return this.m_lockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LockRequest acquire(int lockMode, RequestorLocks requestorLocks) {
        LockRequest waitReq = null;
        Object requestor = requestorLocks.getRequestor();
        Lock lock = this;
        synchronized (lock) {
            if (this.isFree()) {
                LockRequest req = new LockRequest(this, lockMode, requestor);
                req.setStatus(1);
                this.m_lockReq.add(req);
                this.m_grantedMode = lockMode;
                requestorLocks.addRequest(req);
                return null;
            }
            LockRequest req = this.findRequestFromRequestor(requestor);
            if (req == null) {
                req = new LockRequest(this, lockMode, requestor);
                if (this.m_waitingReq.isEmpty()) {
                    if (this.isLockCompatible(lockMode, this.m_grantedMode)) {
                        req.setStatus(1);
                        this.m_lockReq.add(req);
                        this.m_grantedMode = this.getMaxLockMode(lockMode, this.m_grantedMode);
                        requestorLocks.addRequest(req);
                        return null;
                    }
                    if (this.isPermit(this.m_grantedMode)) {
                        this.releasePermits(null);
                        req.setStatus(1);
                        this.m_lockReq.add(req);
                        this.m_grantedMode = this.getMaxLockMode(lockMode, this.m_grantedMode);
                        requestorLocks.addRequest(req);
                        return null;
                    }
                }
                req.setStatus(0);
                this.m_lockReq.add(req);
                this.addWaitingReq(req);
                requestorLocks.addRequest(req);
                requestorLocks.beginWaitRequest(req);
                waitReq = req;
            } else {
                LockRequest lockRequest = req;
                synchronized (lockRequest) {
                    int convertedLockMode = this.getConvertedLockMode(lockMode, req.getMode());
                    if (req.getStatus() == 1) {
                        if (this.isLockCompatible(convertedLockMode, this.m_grantedMode)) {
                            req.setMode(this.getMaxLockMode(convertedLockMode, req.getMode()));
                            this.m_grantedMode = this.getMaxLockMode(convertedLockMode, this.m_grantedMode);
                            return null;
                        }
                        if (this.getCountConversions() == 0) {
                            if (this.isConvertedLockCompatible(convertedLockMode, req)) {
                                req.setMode(this.getMaxLockMode(convertedLockMode, req.getMode()));
                                this.m_grantedMode = this.getMaxLockMode(convertedLockMode, this.m_grantedMode);
                                return null;
                            }
                            if (this.isPermit(this.calculateGrantedModeWithoutThisReq(req))) {
                                this.releasePermits(req);
                                req.setMode(this.getMaxLockMode(convertedLockMode, req.getMode()));
                                this.m_grantedMode = this.getMaxLockMode(convertedLockMode, this.m_grantedMode);
                                return null;
                            }
                            req.setStatus(2);
                            req.setConvertMode(convertedLockMode);
                            this.addWaitingReq(req);
                            requestorLocks.beginWaitRequest(req);
                            waitReq = req;
                        } else if (this.isPermit(req.getCurrentGrantedMode())) {
                            req.setStatus(0);
                            req.setMode(lockMode);
                            this.recalculateGrantedMode();
                            this.addWaitingReq(req);
                            requestorLocks.beginWaitRequest(req);
                            waitReq = req;
                        } else {
                            LockRequest firstWaiter = (LockRequest)this.m_waitingReq.firstElement();
                            if (this.isPermit(firstWaiter.getCurrentGrantedMode())) {
                                firstWaiter.setStatus(0);
                                firstWaiter.setMode(firstWaiter.getConvertMode());
                                firstWaiter.setConvertMode(0);
                                this.recalculateGrantedMode();
                            }
                            req.setStatus(2);
                            req.setConvertMode(convertedLockMode);
                            this.addWaitingReq(req);
                            requestorLocks.beginWaitRequest(req);
                            waitReq = req;
                        }
                    } else {
                        throw new Error("Lock.acquireLock() called for Request in mode " + LockRequest.getStringStatus(req.getStatus()) + " previous request from " + req.getOwner() + " for this lock is in progress");
                    }
                }
            }
        }
        return waitReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean validateAndAcquireLock(int lockMode, RequestorLocks requestorLocks) {
        Object waitReq = null;
        Object requestor = requestorLocks.getRequestor();
        if (this.isFree()) {
            return false;
        }
        LockRequest req = this.findRequestFromRequestor(requestor);
        if (req == null) {
            return false;
        }
        LockRequest lockRequest = req;
        synchronized (lockRequest) {
            int convertedLockMode = this.getConvertedLockMode(lockMode, req.getMode());
            if (req.getStatus() == 1 && this.isLockCompatible(convertedLockMode, this.m_grantedMode)) {
                req.setMode(this.getMaxLockMode(convertedLockMode, req.getMode()));
                this.m_grantedMode = this.getMaxLockMode(convertedLockMode, this.m_grantedMode);
                return true;
            }
        }
        return false;
    }

    synchronized void markForRelease(RequestorLocks rlocks) {
        Object requestor = rlocks.getRequestor();
        LockRequest req = this.findRequestFromRequestor(requestor);
        if (req == null) {
            return;
        }
        if (req.getStatus() == 1 && this.isPermit(req.getMode())) {
            this.release(rlocks, false);
        } else {
            req.setMarkedForRelease(true);
        }
    }

    void release(RequestorLocks rlocks) {
        this.release(rlocks, false);
    }

    synchronized void release(RequestorLocks rlocks, boolean downgrade) {
        int newmode;
        Object requestor = rlocks.getRequestor();
        LockRequest req = this.findRequestFromRequestor(requestor);
        if (req == null) {
            return;
        }
        boolean removeReq = true;
        boolean grantWaitingReq = true;
        if (this.m_waitingReq.remove(req)) {
            req.setWaitResult(3);
        } else if (downgrade && (newmode = this.m_lm.getLockingRules().getDowngradedMode(req.getCurrentGrantedMode())) != 0) {
            removeReq = false;
            if (newmode == req.getCurrentGrantedMode()) {
                grantWaitingReq = false;
            } else {
                req.setMode(newmode);
            }
        }
        if (removeReq) {
            this.m_lockReq.remove(req);
            rlocks.removeRequest(req);
        }
        if (!grantWaitingReq) {
            return;
        }
        this.recalculateGrantedMode();
        if (this.m_waitingReq.isEmpty()) {
            return;
        }
        int granted = this.grantWaitingRequests();
        if (granted > 0) {
            return;
        }
        LockRequest firstWaitingReq = (LockRequest)this.m_waitingReq.firstElement();
        int testMode = this.calculateGrantedModeWithoutThisReq(firstWaitingReq);
        if (this.isPermit(testMode)) {
            this.releasePermits(firstWaitingReq);
            this.grantWaitingRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cancelWaitingReq(LockRequest cancelledReq, RequestorLocks rlocks, int reason) {
        boolean removed = this.m_waitingReq.remove(cancelledReq);
        if (!removed) {
            return;
        }
        if (cancelledReq.getStatus() == 0) {
            this.removeRequestFromRequestor(rlocks.getRequestor());
            rlocks.removeRequest(cancelledReq);
        } else if (cancelledReq.getStatus() == 2) {
            rlocks.endWaitRequest(cancelledReq);
        }
        LockRequest lockRequest = cancelledReq;
        synchronized (lockRequest) {
            if (cancelledReq.getStatus() == 0) {
                cancelledReq.setStatus(3);
            } else if (cancelledReq.getStatus() == 2) {
                cancelledReq.setStatus(1);
                cancelledReq.setConvertMode(0);
            }
            cancelledReq.setWaitResult(reason);
        }
        this.grantWaitingRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int grantWaitingRequests() {
        int granted = 0;
        while (!this.m_waitingReq.isEmpty()) {
            int requestedMode = 0;
            LockRequest req = (LockRequest)this.m_waitingReq.elementAt(0);
            if (req.getStatus() == 0) {
                requestedMode = req.getMode();
            } else if (req.getStatus() == 2) {
                requestedMode = req.getConvertMode();
            }
            if (!this.isLockCompatible(requestedMode, this.m_grantedMode) && !this.isConvertedLockCompatible(requestedMode, req)) break;
            this.m_grantedMode = this.getMaxLockMode(requestedMode, this.m_grantedMode);
            this.m_waitingReq.removeElementAt(0);
            this.m_lm.waitingRequestGranted(req);
            LockRequest lockRequest = req;
            synchronized (lockRequest) {
                req.setStatus(1);
                req.setMode(requestedMode);
                req.setConvertMode(0);
                req.setWaitResult(1);
                req.notifyAll();
            }
            ++granted;
        }
        return granted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLockMode(Object requestor) {
        Lock lock = this;
        synchronized (lock) {
            LockRequest req = this.findRequestFromRequestor(requestor);
            if (req == null) {
                return 0;
            }
            if (req.getStatus() == 1 || req.getStatus() == 2) {
                return req.getMode();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasLock(int lockmode, Object requestor) {
        Lock lock = this;
        synchronized (lock) {
            LockRequest req = this.findRequestFromRequestor(requestor);
            if (req == null) {
                return false;
            }
            if (req.getStatus() == 1 || req.getStatus() == 2) {
                int maxMode;
                int convertedLockMode = this.getConvertedLockMode(lockmode, req.getMode());
                if (req.getMode() == convertedLockMode) {
                    return true;
                }
                if (this.isLockCompatible(convertedLockMode, this.m_grantedMode) && (maxMode = this.getMaxLockMode(convertedLockMode, this.m_grantedMode)) == this.m_grantedMode) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isPermit(int mode) {
        return this.m_lm.getLockingRules().isPermit(mode);
    }

    private boolean isLockCompatible(int requestedMode, int grantedMode) {
        return this.m_lm.getLockingRules().isLockCompatible(requestedMode, grantedMode);
    }

    private int getMaxLockMode(int modeA, int modeB) {
        return this.m_lm.getLockingRules().getMaxLockMode(modeA, modeB);
    }

    private int getConvertedLockMode(int requestedMode, int grantedMode) {
        return this.m_lm.getLockingRules().getConvertedLockMode(requestedMode, grantedMode);
    }

    private boolean isConvertedLockCompatible(int newMode, LockRequest thisReq) {
        for (LockRequest req : this.m_lockReq) {
            int reqGrantedMode;
            if (req == thisReq || (reqGrantedMode = req.getCurrentGrantedMode()) == 0 || this.isLockCompatible(newMode, reqGrantedMode)) continue;
            return false;
        }
        return true;
    }

    private void recalculateGrantedMode() {
        Iterator it = this.m_lockReq.iterator();
        int grMode = 0;
        while (it.hasNext()) {
            LockRequest req = (LockRequest)it.next();
            grMode = this.getMaxLockMode(req.getCurrentGrantedMode(), grMode);
        }
        this.m_grantedMode = grMode;
    }

    private int calculateGrantedModeWithoutThisReq(LockRequest thisReq) {
        Iterator it = this.m_lockReq.iterator();
        int grMode = 0;
        while (it.hasNext()) {
            LockRequest req = (LockRequest)it.next();
            if (req == thisReq) continue;
            grMode = this.getMaxLockMode(req.getCurrentGrantedMode(), grMode);
        }
        return grMode;
    }

    void releasePermits(LockRequest exc) {
        Iterator it = this.m_lockReq.iterator();
        while (it.hasNext()) {
            LockRequest req = (LockRequest)it.next();
            if (req != null && req == exc || req.getStatus() != 1 || !this.isPermit(req.getCurrentGrantedMode())) continue;
            it.remove();
            this.m_lm.grantedRequestReleased(req);
        }
        this.recalculateGrantedMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printAllLockInfo() {
        this.printCounts();
        Lock lock = this;
        synchronized (lock) {
            for (LockRequest req : this.m_lockReq) {
                System.out.println("\t" + req.toStringAll());
            }
        }
    }

    void printCounts() {
        int ctGranted = this.getCountGranted();
        int ctWaiting = this.getCountWaiters();
        int ctWaitingConvert = this.getCountConversions();
        System.out.println("Lock id= " + this.m_lockId.toString() + ": GrantedMode= " + Lock.getStringMode(this.m_grantedMode) + " ctGranted " + ctGranted + " ctWaiting= " + ctWaiting + " ctWaitingConvert= " + ctWaitingConvert);
    }

    synchronized boolean isFree() {
        return this.m_grantedMode == 0;
    }

    synchronized int getCountWaiters() {
        return this.m_waitingReq.size();
    }

    synchronized int getCountGranted() {
        return this.m_lockReq.size() - this.m_waitingReq.size();
    }

    static String getStringMode(int mode) {
        switch (mode) {
            case 0: {
                return "LOCK_MODE_NONE";
            }
            case 1: {
                return "LOCK_MODE_SHARE";
            }
            case 2: {
                return "LOCK_MODE_EX";
            }
            case 3: {
                return "LOCK_MODE_PERMIT";
            }
        }
        return "UNKNOWN***";
    }

    public String toString() {
        String stringPresentation = "";
        if (this.m_objectType != -1) {
            stringPresentation = "Lock " + this.m_lockId + " " + Lock.getStringMode(this.m_grantedMode);
        }
        if (this.m_objectType == -1) {
            stringPresentation = stringPresentation + " index path: " + this.m_className + " lock mode: " + Lock.getStringMode(this.m_grantedMode);
        } else if (this.m_objectType != 0) {
            stringPresentation = stringPresentation + " class type #: " + this.m_objectType + (this.m_className != null ? " class name: " + this.m_className : " primitive type");
        }
        return stringPresentation;
    }

    synchronized LockRequest findRequestFromRequestor(Object requestor) {
        for (LockRequest req : this.m_lockReq) {
            if (!req.getOwner().equals(requestor)) continue;
            return req;
        }
        return null;
    }

    private boolean removeRequestFromRequestor(Object requestor) {
        Iterator it = this.m_lockReq.iterator();
        while (it.hasNext()) {
            LockRequest req = (LockRequest)it.next();
            if (!req.getOwner().equals(requestor)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public synchronized ArrayList getDependencies(LockRequest waitingReq, ArrayList dep) {
        int waitingMode = 0;
        if (waitingReq.getStatus() == 0) {
            waitingMode = waitingReq.getMode();
        } else if (waitingReq.getStatus() == 2) {
            waitingMode = waitingReq.getConvertMode();
        } else {
            return dep;
        }
        for (LockRequest req : this.m_lockReq) {
            int reqGrantedMode;
            if (req.getOwner().equals(waitingReq.getOwner()) || (reqGrantedMode = req.getCurrentGrantedMode()) == 0 || this.isLockCompatible(waitingMode, reqGrantedMode) || this.isPermit(reqGrantedMode)) continue;
            dep.add(req.getOwner());
        }
        for (LockRequest req : this.m_waitingReq) {
            if (req.getOwner().equals(waitingReq.getOwner())) {
                return dep;
            }
            if (req.getStatus() == 2) {
                if (this.isLockCompatible(waitingMode, req.getConvertMode())) continue;
                dep.add(req.getOwner());
                continue;
            }
            if (req.getStatus() != 0 || this.isLockCompatible(waitingMode, req.getMode())) continue;
            dep.add(req.getOwner());
        }
        return dep;
    }

    private void addWaitingReq(LockRequest req) {
        LockRequest waitReq;
        if (req.getStatus() == 0) {
            this.m_waitingReq.addElement(req);
            return;
        }
        Iterator it = this.m_waitingReq.iterator();
        int indx = 0;
        while (it.hasNext() && (waitReq = (LockRequest)it.next()).getStatus() != 0) {
            ++indx;
        }
        this.m_waitingReq.add(indx, req);
    }

    int getCountConversions() {
        LockRequest waitReq;
        Iterator it = this.m_waitingReq.iterator();
        int ct = 0;
        while (it.hasNext() && (waitReq = (LockRequest)it.next()).getStatus() == 2) {
            ++ct;
        }
        return ct;
    }
}

