/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.lm.impl;

import com.sonicsw.lm.DeadlockException;
import com.sonicsw.lm.LockWaitInterruptedException;
import com.sonicsw.lm.impl.Lock;

public class LockRequest {
    public static final int REQ_STATUS_WAITING = 0;
    public static final int REQ_STATUS_GRANTED = 1;
    public static final int REQ_STATUS_CONVERTING = 2;
    public static final int REQ_STATUS_CANCELLED = 3;
    public static final int REQ_STATUS_DENIED_DEADLOCK = 4;
    public static final int REQ_STATUS_DENIED_TIMEOUT = 5;
    Object m_owner;
    int m_status;
    Lock m_lock;
    int m_mode;
    int m_convertMode;
    volatile Thread m_currentWaiter;
    boolean m_markedForRelease;
    int m_waitResult;

    LockRequest(Lock lock, int lockMode, Object lockRequestor) {
        this.m_lock = lock;
        this.m_mode = lockMode;
        this.m_status = 0;
        this.m_owner = lockRequestor;
    }

    Lock getLock() {
        return this.m_lock;
    }

    synchronized void setStatus(int stat) {
        this.m_status = stat;
    }

    synchronized int getStatus() {
        return this.m_status;
    }

    Object getOwner() {
        return this.m_owner;
    }

    synchronized int getMode() {
        return this.m_mode;
    }

    synchronized void setMode(int m) {
        this.m_mode = m;
    }

    synchronized void setConvertMode(int mode) {
        this.m_convertMode = mode;
    }

    synchronized int getConvertMode() {
        return this.m_convertMode;
    }

    int getRequestedMode() {
        if (this.getStatus() == 2) {
            return this.getConvertMode();
        }
        return this.getMode();
    }

    synchronized int getCurrentGrantedMode() {
        if (this.getStatus() == 1 || this.getStatus() == 2) {
            return this.m_mode;
        }
        return 0;
    }

    synchronized void setWaiter(Thread t) {
        this.m_currentWaiter = t;
        this.m_waitResult = this.m_status;
    }

    synchronized Thread getWaiter() {
        return this.m_currentWaiter;
    }

    synchronized void setWaitResult(int result) {
        this.m_waitResult = result;
        this.notifyAll();
    }

    synchronized void setMarkedForRelease(boolean value) {
        this.m_markedForRelease = value;
    }

    synchronized boolean getMarkedForRelease() {
        return this.m_markedForRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForLock(long timeout) throws LockWaitInterruptedException, DeadlockException {
        long timeToWait = timeout;
        long endtime = System.currentTimeMillis() + timeout;
        LockRequest lockRequest = this;
        synchronized (lockRequest) {
            while (this.m_waitResult == 0 || this.m_waitResult == 2) {
                if (timeout == -1L) {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException ex) {
                        throw new LockWaitInterruptedException();
                    }
                }
                if (timeToWait <= 0L) break;
                try {
                    this.wait(timeToWait);
                    timeToWait = endtime - System.currentTimeMillis();
                }
                catch (InterruptedException ex) {
                    throw new LockWaitInterruptedException();
                }
            }
            if (this.m_waitResult == 4) {
                throw new DeadlockException();
            }
            return this.m_waitResult == 1;
        }
    }

    static String getStringStatus(int status) {
        switch (status) {
            case 0: {
                return "WAITING";
            }
            case 1: {
                return "GRANTED";
            }
            case 2: {
                return "CONVERTING";
            }
            case 3: {
                return "CANCELLED";
            }
            case 4: {
                return "DEADLOCK";
            }
            case 5: {
                return "TIMEOUT";
            }
        }
        return "UNKNOWN***";
    }

    public String toStringAll() {
        return "LockRequest: requestor= " + this.m_owner + " status= " + LockRequest.getStringStatus(this.m_status) + " Mode= " + Lock.getStringMode(this.m_mode) + (this.m_convertMode > 0 ? " ConvertMode " + Lock.getStringMode(this.m_convertMode) : "");
    }

    public String toString() {
        return "LockRequest: owner " + this.m_owner;
    }
}

