/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.lm.impl;

import com.sonicsw.lm.impl.Dependencies;
import com.sonicsw.lm.impl.Lock;
import com.sonicsw.lm.impl.LockRequest;
import java.util.ArrayList;
import java.util.LinkedList;

class RequestorLocks {
    Object m_requestor;
    LinkedList m_lockRequests = new LinkedList();
    LinkedList m_waitReq = new LinkedList();
    RequestorLocks m_cycle = null;
    boolean m_visited;

    RequestorLocks(Object requestor) {
        this.m_requestor = requestor;
    }

    Object getRequestor() {
        return this.m_requestor;
    }

    synchronized void addRequest(LockRequest req) {
        this.m_lockRequests.add(req);
    }

    synchronized void beginWaitRequest(LockRequest req) {
        if (!(req.getStatus() != 0 && req.getStatus() != 2 || this.m_waitReq.contains(req))) {
            this.m_waitReq.add(req);
        }
    }

    synchronized void endWaitRequest(LockRequest req) {
        this.m_waitReq.remove(req);
    }

    synchronized void removeRequest(LockRequest req) {
        this.m_lockRequests.remove(req);
        this.m_waitReq.remove(req);
    }

    void setCycle(RequestorLocks locks) {
        this.m_cycle = locks;
    }

    RequestorLocks getCycle() {
        return this.m_cycle;
    }

    void setVisited(boolean visited) {
        this.m_visited = visited;
    }

    boolean getVisited() {
        return this.m_visited;
    }

    int getCount() {
        return this.m_lockRequests.size();
    }

    LinkedList getLocks() {
        return this.m_lockRequests;
    }

    synchronized void printAllLocks() {
        this.debug("Requestor= " + this.m_requestor.toString() + " LockCount " + this.m_lockRequests.size());
        for (LockRequest req : this.m_lockRequests) {
            System.out.println("\t" + req.toStringAll());
        }
    }

    Dependencies getDynamicDependencies() {
        Dependencies dependencies = new Dependencies();
        for (LockRequest req : this.m_waitReq) {
            if (req.getStatus() != 0 && req.getStatus() != 2) continue;
            Lock lock = req.getLock();
            ArrayList lockDependencies = new ArrayList();
            lock.getDependencies(req, lockDependencies);
            for (int i = 0; i < lockDependencies.size(); ++i) {
                dependencies.add(lockDependencies.get(i), lock);
            }
        }
        return dependencies;
    }

    synchronized ArrayList getWaitingRequests() {
        ArrayList<LockRequest> waitingReq = new ArrayList<LockRequest>();
        for (LockRequest req : this.m_waitReq) {
            waitingReq.add(req);
        }
        return waitingReq;
    }

    private void debug(String s) {
        System.out.println(s);
    }

    public String toString() {
        return "RequestorLocks for " + this.m_requestor.toString();
    }
}

