/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.IContainerExitCodes;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.common.util.Container;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.IAuditManager;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.IHostManager;
import com.sonicsw.mf.framework.IMessageLogger;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.framework.agent.AgentCLI;
import com.sonicsw.mf.framework.agent.ConsoleLogger;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.ContainerStateNotifier;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.HostManager;
import com.sonicsw.mf.framework.agent.JMSConnectorServer;
import com.sonicsw.mf.framework.agent.NotificationPublisher;
import com.sonicsw.mf.framework.agent.PBE;
import com.sonicsw.mf.framework.agent.PingThread;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import com.sonicsw.mf.framework.agent.ci.LauncherJARBuilder;
import com.sonicsw.mf.framework.security.AuditManager;
import com.sonicsw.mf.framework.security.PermissionsManager;
import com.sonicsw.mf.framework.util.RollingFileLogger;
import com.sonicsw.mf.interceptor.actional.soniclog.SonicLogInterceptor;
import com.sonicsw.mf.jmx.client.MFNotification;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.sdf.AbstractMFComponentTracing;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class Agent
extends AbstractFrameworkComponent {
    public static final String FILELOG_SUFFIX = ".log";
    static final String SONICSW_HOME = System.getProperty("sonicsw.home");
    private static final String DOMAIN_CONFIG_ID = "/domain/domain";
    private static final boolean m_forceCLI = new Boolean(System.getProperty("sonicsw.mf.cli", "false"));
    private static final String SET_ENC_PWD_SH_SCRIPT_NAME = "set_encryption_pwd.sh";
    private static final String STARTUP_NOTIFICATION_TYPE = "Startup";
    private static final String SHUTDOWN_NOTIFICATION_TYPE = "Shutdown";
    private static final String LOAD_NOTIFICATION_TYPE = "Load";
    private static final String UNLOAD_NOTIFICATION_TYPE = "Unload";
    private static final String CONTAINER_STATE_NOTIFICATION_TYPE = "ContainerState";
    public static final String FAILOVER_NOTIFICATION_TYPE = "Failover";
    public static final String MANAGE_PERMISSION_DENIED_NOTIFICATION_TYPE = "ManagePermissionDenied";
    private static final String LOGFAILURE_NOTIFICATION_TYPE = "Failure";
    private static final String LOGTHRESHOLD_NOTIFICATION_TYPE = "Threshold";
    public static final String LOG_MESSAGE_NOTIFICATION_TYPE = "LogMessage";
    private static final String LOG_MESSAGE_OPERATION_NAME = "logMessage";
    private static final String[] LOG_MESSAGE_OPERATION_SIGNATURE = new String[]{String.class.getName()};
    private ContainerImpl m_containerImpl;
    private String m_agentManager;
    public static final OutputStream m_stdout = System.out;
    private boolean m_commandLineEnabled = false;
    private boolean m_logToConsole = true;
    private boolean m_logToFile = true;
    private String m_defaultLogFile = null;
    private String m_logDir = null;
    private long m_logFileThreshold = 0x1000000L;
    private long m_logFileRolloverThreshold = 0x100000L;
    private int m_logFileRolloverTimeInterval = 1440;
    private Boolean m_centrallyLogMessages = null;
    private boolean m_cliInitialized = false;
    private Boolean m_defaultActionalLogInterceptor = Boolean.FALSE;
    private boolean m_actionalLogInterceptor = this.m_defaultActionalLogInterceptor;
    private static volatile ConsoleLogger m_consoleLogger = null;
    private static volatile RollingFileLogger m_fileLogger = null;
    private TaskScheduler m_taskScheduler;
    private ContainerStateNotifier m_containerStateNotifier;
    private NotificationPublisher m_notificationPublisher;
    private Object m_asyncDSUpdateReceiverLock = new Object();
    private ArrayList m_asyncDSUpdateReceivers = new ArrayList();
    private IMetricsRegistrar m_metricsRegistrar;
    private static final String REPLACE_ENABLED_METRICS_OPERATION_NAME = "replaceEnabledMetrics";
    private static final String[] REPLACE_ENABLED_METRICS_OPERATION_SIGNATURE = new String[]{IMetricIdentity[].class.getName()};
    private static final String REPLACE_ENABLED_ALERTS_OPERATION_NAME = "replaceEnabledAlerts";
    private static final String[] REPLACE_ENABLED_ALERTS_OPERATION_SIGNATURE = new String[]{IAlert[].class.getName()};
    private IStatistic m_memoryUsageStatistic;
    private IStatistic m_maxMemoryUsageStatistic;
    private IStatistic m_totalThreadsStatistic;
    private PermissionsManager m_permissionsManager;
    private AuditManager m_auditManager;
    private boolean m_initialized = false;
    private String m_configID;
    private long m_initialConfigVersion = -1L;
    private ICanonicalName m_agentName;
    public static final String AGENT_TRACE_MASK_VALUES = "16=request/reply,32=request/reply failures,64=connection failures,128=connection state changes,,256=notification subscription expirations,512=configuration cache,1024=class loading failures,2048=container FT,4096=container launch,8192=permission denied";
    public static final int TRACE_DETAIL = 1;
    public static final int TRACE_SUBSCRIPTION_EXPIRATIONS = 256;
    public static final int TRACE_CONFIGURATION_CACHE = 512;
    public static final int TRACE_CLASS_LOADING_FAILURES = 1024;
    public static final int TRACE_CONTAINER_FT = 2048;
    public static final int TRACE_CONTAINER_LAUNCH = 4096;
    public static final int TRACE_PERMISSION_DENIED = 8192;
    private static final ArrayList ATTRIBUTE_INFOS = new ArrayList();
    private static final ArrayList OPERATION_INFOS = new ArrayList();
    private static final ArrayList NOTIFICATION_INFOS = new ArrayList();
    private static CompositeType LOG_COMPOSITE_TYPE;
    private static String[] LOG_COMPOSITE_TYPE_ITEM_NAMES;
    private boolean DEBUG = false;
    private SdfMFTracingIntegration m_SdfMFTracingIntegration = new SdfMFTracingIntegration();
    private HostManager m_hostManager;
    private HashSet m_nonConfiguredPropSet;
    private static Object FILE_LOCK_OBJ;
    private static Object CONSOLE_LOCK_OBJ;

    static void redirectOutput() {
        if (System.getProperty("sonicsw.mf.teeOutput", "true").equals("true")) {
            OutputStream os = new OutputStream(){

                @Override
                public synchronized void write(int b) throws IOException {
                    if (m_consoleLogger != null) {
                        m_consoleLogger.write(b);
                    } else {
                        try {
                            m_stdout.write(b);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    RollingFileLogger fileLogger = m_fileLogger;
                    if (fileLogger != null) {
                        fileLogger.write(b);
                    }
                }

                @Override
                public synchronized void write(byte[] b, int off, int len) throws IOException {
                    RollingFileLogger fileLogger;
                    boolean signal;
                    boolean bl = signal = len > 0 && (b[0] == 8 || b[0] == 7);
                    if (m_consoleLogger != null) {
                        if (IContainer.QA_MODE) {
                            m_consoleLogger.write(42);
                        }
                        m_consoleLogger.write(b, off, len);
                    } else {
                        try {
                            if (IContainer.QA_MODE) {
                                m_stdout.write(42);
                            }
                            m_stdout.write(b, off, len);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (!signal && (fileLogger = m_fileLogger) != null) {
                        if (IContainer.QA_MODE) {
                            fileLogger.write(42);
                        }
                        fileLogger.write(b, off, len);
                    }
                }
            };
            PrintStream ps = new PrintStream(os);
            System.setOut(ps);
            System.setErr(ps);
        }
    }

    public Agent() {
        this.m_SdfMFTracingIntegration.register();
    }

    public IHostManager getHostManager() {
        return this.m_hostManager;
    }

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    public void setContainer(ContainerImpl container) {
        this.m_containerImpl = container;
        this.m_hostManager = this.m_containerImpl.getHostManager();
    }

    @Override
    public void init(IComponentContext context) {
        super.init(context);
        this.loadNonConfiguredINIList();
        if (Boolean.getBoolean("sonicsw.mf.DS.startactive")) {
            this.m_context.logMessage("sonicsw.mf.DS.startactive is enabled for this start; resetting it to false in container.ini", 3);
            this.generateContainerINI();
        }
        this.m_agentManager = context.getComponentName().getDomainName() + '.' + "AGENT MANAGER" + ":ID=" + "AGENT MANAGER";
        IElement config = context.getConfiguration(true);
        this.m_configID = config.getIdentity().getName();
        IAttributeSet containerAttrs = config.getAttributes();
        Boolean logConsole = (Boolean)containerAttrs.getAttribute("LOG_TO_CONSOLE");
        this.setLogToConsole(logConsole == null ? Boolean.TRUE : logConsole);
        String fileName = (String)containerAttrs.getAttribute("LOG_FILE");
        this.m_defaultLogFile = this.getContainerName() + FILELOG_SUFFIX;
        try {
            Integer logFileRolloverTimeInterval = (Integer)containerAttrs.getAttribute("LOG_FILE_ROLLOVER_TIME_INTERVAL");
            this.setLogFileRolloverTimeInterval(logFileRolloverTimeInterval == null ? new Integer(1440) : logFileRolloverTimeInterval);
            this.setLogFile(fileName == null ? this.m_defaultLogFile : fileName);
            Boolean logToFile = (Boolean)containerAttrs.getAttribute("LOG_TO_FILE");
            this.setLogToFile(logToFile == null ? Boolean.TRUE : logToFile);
            Long logFileThresholdSize = (Long)containerAttrs.getAttribute("LOG_FILE_SIZE_THRESHOLD");
            this.setLogFileSizeThreshold(logFileThresholdSize == null ? new Long(0x1000000L) : logFileThresholdSize);
            Long logFileRolloverThresholdSize = (Long)containerAttrs.getAttribute("LOG_FILE_ROLLOVER_SIZE_THRESHOLD");
            this.setLogFileRolloverSizeThreshold(logFileRolloverThresholdSize == null ? new Long(0x100000L) : logFileRolloverThresholdSize);
            Boolean actionalLogInterceptor = (Boolean)containerAttrs.getAttribute("ACTIONAL_LOG_INTERCEPTOR");
            this.setActionalLogInterceptor(actionalLogInterceptor == null ? this.m_defaultActionalLogInterceptor : actionalLogInterceptor);
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed to setup container log file, trace follows...", (Throwable)e, 1);
        }
        Boolean centrallyLogMessages = (Boolean)containerAttrs.getAttribute("ENABLE_CENTRALIZED_LOGGING");
        Runnable centralLoggingConfigurator = new Runnable(){

            @Override
            public void run() {
                if (Agent.this.waitForContainerToBoot()) {
                    Agent.this.setCentrallyLogMessages();
                }
            }
        };
        this.m_context.scheduleTask(centralLoggingConfigurator, new Date());
        this.m_containerImpl.beginLogging();
        Boolean localCLI = (Boolean)containerAttrs.getAttribute("COMMAND_LINE");
        try {
            this.setCommandLine(localCLI == null ? Boolean.FALSE : localCLI);
        }
        catch (MFException e) {
            this.m_context.logMessage(e.getMessage(), 2);
        }
        this.m_taskScheduler = (TaskScheduler)this.m_container.getTaskScheduler();
        this.m_notificationPublisher = (NotificationPublisher)this.m_container.getNotificationPublisher();
        IMetricInfo[] agentMetricsInfo = Agent.getMetricsInfo();
        IMetricInfo[] taskSchedulerMetricsInfo = TaskScheduler.getMetricsInfo();
        IMetricInfo[] notificationPublisherMetricsInfo = NotificationPublisher.getMetricsInfo();
        IMetricInfo[] infos = new IMetricInfo[agentMetricsInfo.length + taskSchedulerMetricsInfo.length + notificationPublisherMetricsInfo.length];
        System.arraycopy(agentMetricsInfo, 0, infos, 0, agentMetricsInfo.length);
        System.arraycopy(taskSchedulerMetricsInfo, 0, infos, agentMetricsInfo.length, taskSchedulerMetricsInfo.length);
        System.arraycopy(notificationPublisherMetricsInfo, 0, infos, agentMetricsInfo.length + taskSchedulerMetricsInfo.length, notificationPublisherMetricsInfo.length);
        this.m_metricsRegistrar = this.m_context.initMetricsManagement(infos);
        this.initMetrics();
        this.m_taskScheduler.initMetrics(this.m_metricsRegistrar);
        this.m_notificationPublisher.initMetrics(this.m_metricsRegistrar);
        this.setTraceMask(super.getTraceMask());
        this.m_agentName = this.m_context.getComponentName();
        this.m_initialized = true;
    }

    private void loadNonConfiguredINIList() {
        this.m_nonConfiguredPropSet = new HashSet();
        try {
            File iniPropsFile = null;
            if (IContainer.CURRENT_LAUNCHER_VERSION != null) {
                File launcherHomeDir = new File(new File(SONICSW_HOME), IContainer.LAUNCHER_DIR);
                iniPropsFile = new File(new File(launcherHomeDir, "container_templates"), "container_ini.prop");
            }
            if (iniPropsFile != null && iniPropsFile.exists()) {
                Properties props = ContainerUtil.readProperties(new FileInputStream(iniPropsFile));
                Enumeration<Object> iniList = props.keys();
                while (iniList.hasMoreElements()) {
                    String prop = (String)iniList.nextElement();
                    boolean configured = new Boolean(props.getProperty(prop));
                    if (configured) continue;
                    this.m_nonConfiguredPropSet.add(prop);
                }
            }
        }
        catch (IOException e) {
            this.m_context.logMessage("Failed to load container.ini information, trace follows...", (Throwable)e, 2);
        }
    }

    public synchronized void start() {
        super.start();
        this.m_containerStateNotifier = new ContainerStateNotifier(this, this.m_context);
        Runnable stateNotifierStarter = new Runnable(){

            @Override
            public void run() {
                if (Agent.this.waitForContainerToBoot()) {
                    Agent.this.m_containerStateNotifier.start();
                }
            }
        };
        this.m_context.scheduleTask(stateNotifierStarter, new Date());
    }

    public synchronized void stop() {
        if (this.m_containerStateNotifier != null) {
            this.m_containerStateNotifier.cleanup();
        }
        this.m_state = 1;
    }

    public void destroy() {
    }

    public synchronized void enableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(IAgentProxy.SYSTEM_MEMORY_CURRENTUSAGE_METRIC_ID)) {
                this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_MEMORY_CURRENTUSAGE_METRIC_ID, this.m_memoryUsageStatistic);
                continue;
            }
            if (ids[i].equals(IAgentProxy.SYSTEM_MEMORY_MAXUSAGE_METRIC_ID)) {
                this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_MEMORY_MAXUSAGE_METRIC_ID, this.m_maxMemoryUsageStatistic);
                continue;
            }
            if (!ids[i].equals(IAgentProxy.SYSTEM_THREADS_CURRENTTOTAL_METRIC_ID)) continue;
            this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_THREADS_CURRENTTOTAL_METRIC_ID, this.m_totalThreadsStatistic);
        }
        this.m_taskScheduler.enableMetrics(ids);
        this.m_notificationPublisher.enableMetrics(ids);
    }

    public synchronized void disableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(IAgentProxy.SYSTEM_MEMORY_CURRENTUSAGE_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_MEMORY_CURRENTUSAGE_METRIC_ID);
                continue;
            }
            if (ids[i].equals(IAgentProxy.SYSTEM_MEMORY_MAXUSAGE_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_MEMORY_MAXUSAGE_METRIC_ID);
                continue;
            }
            if (!ids[i].equals(IAgentProxy.SYSTEM_THREADS_CURRENTTOTAL_METRIC_ID)) continue;
            this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_THREADS_CURRENTTOTAL_METRIC_ID);
        }
        this.m_taskScheduler.disableMetrics(ids);
        this.m_notificationPublisher.disableMetrics(ids);
    }

    public String getHostname() {
        return MFNotification.HOST;
    }

    public Boolean getStartupComplete() {
        return new Boolean(this.m_frameworkContext.getContainer().isBooted());
    }

    public Boolean getCommandLine() {
        return new Boolean(this.m_commandLineEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCommandLine(Boolean enabled) throws MFException {
        boolean enableCommandLine = enabled;
        if (!enableCommandLine && m_forceCLI) {
            if (!this.m_commandLineEnabled) {
                enableCommandLine = true;
            } else {
                throw new MFException("CLI cannot be disabled");
            }
        }
        if (this.m_commandLineEnabled == enableCommandLine) {
            return;
        }
        if (enableCommandLine) {
            if (!this.m_cliInitialized) {
                try {
                    AgentCLI.init(this);
                }
                catch (NoSuchMethodException e) {
                    MFException exception = new MFException("Failed to initialize command line");
                    exception.setLinkedException((Exception)e);
                    throw exception;
                }
            }
            IContainer e = this.m_container;
            synchronized (e) {
                if (this.m_container.isBooted()) {
                    this.m_context.logMessage("Command line started", 3);
                    AgentCLI.readParseExecute();
                } else {
                    Thread cliStarter = new Thread("AGENT - CLI Reader"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            IContainer iContainer = Agent.this.m_container;
                            synchronized (iContainer) {
                                while (!Agent.this.m_container.isBooted()) {
                                    if (Agent.this.m_container.isClosing()) {
                                        return;
                                    }
                                    try {
                                        Agent.this.m_container.wait(1000L);
                                    }
                                    catch (InterruptedException e) {
                                        return;
                                    }
                                }
                                AgentCLI.readParseExecute();
                            }
                        }
                    };
                    cliStarter.setDaemon(true);
                    cliStarter.start();
                }
                this.m_commandLineEnabled = true;
            }
        }
        try {
            AgentCLI.cancelReadParseExecute();
            this.m_commandLineEnabled = false;
            this.m_context.logMessage("Command line stopped", 3);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public Boolean getLogToConsole() {
        return new Boolean(this.m_logToConsole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogToConsole(Boolean enabled) {
        this.m_logToConsole = enabled;
        if (this.m_logToConsole) {
            if (m_consoleLogger == null) {
                Object object = CONSOLE_LOCK_OBJ;
                synchronized (object) {
                    if (m_consoleLogger == null) {
                        m_consoleLogger = new ConsoleLogger(this, m_stdout);
                        this.m_containerImpl.addMessageLogger(m_consoleLogger);
                        if (this.m_initialized) {
                            this.m_context.logMessage("(Re)started logging to console", 3);
                        }
                    }
                }
            }
        } else if (m_consoleLogger != null) {
            this.m_context.logMessage("Stopped logging to console", 3);
            this.m_containerImpl.removeMessageLogger(m_consoleLogger);
            m_consoleLogger = null;
        }
    }

    public Boolean getLogToFile() {
        return new Boolean(this.m_logToFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogToFile(Boolean enabled) throws Exception {
        this.m_logToFile = enabled;
        if (this.m_logToFile) {
            if (m_fileLogger == null) {
                Object object = FILE_LOCK_OBJ;
                synchronized (object) {
                    if (m_fileLogger == null) {
                        m_fileLogger = new RollingFileLogger(this.m_context, this.getLogFile(), this.m_containerImpl.getContainerIdentity().getCanonicalName(), this.m_logFileRolloverTimeInterval);
                        m_fileLogger.setSizeThreshold(this.m_logFileThreshold);
                        this.m_containerImpl.addMessageLogger((IMessageLogger)m_fileLogger);
                        if (this.m_initialized) {
                            this.m_context.logMessage("(Re)started logging to disk", 3);
                        }
                    }
                }
            }
        } else if (m_fileLogger != null) {
            this.m_context.logMessage("Stopped logging to disk", 3);
            this.m_containerImpl.removeMessageLogger((IMessageLogger)m_fileLogger);
            m_fileLogger.close();
            m_fileLogger = null;
        }
    }

    public String getLogFile() {
        return new File(this.m_logDir).getAbsolutePath();
    }

    public void setLogFile(String path) throws Exception {
        if (path == null || path.length() == 0) {
            path = this.m_defaultLogFile;
        }
        String oldFile = this.m_logDir;
        this.m_logDir = path;
        if (IContainer.CURRENT_LAUNCHER_VERSION != null && !this.m_logDir.equals(this.m_defaultLogFile)) {
            File logLocationFile = new File("log_location");
            logLocationFile.delete();
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(logLocationFile, false)), true);
            writer.print(this.m_logDir);
            writer.close();
        }
        RollingFileLogger fileLogger = m_fileLogger;
        if (this.m_logToFile && fileLogger != null) {
            try {
                fileLogger.resetLogDirectory(path);
            }
            catch (Exception e) {
                this.m_logDir = oldFile;
                throw e;
            }
        }
    }

    public Long getLogFileSize() {
        RollingFileLogger fileLogger = m_fileLogger;
        return new Long(fileLogger == null ? 0L : fileLogger.length());
    }

    public Long getLogFileSizeThreshold() {
        return new Long(this.m_logFileThreshold);
    }

    public void setLogFileSizeThreshold(Long thresholdSize) {
        RollingFileLogger fileLogger = m_fileLogger;
        if (thresholdSize != this.m_logFileThreshold && fileLogger != null) {
            fileLogger.setSizeThreshold(thresholdSize.longValue());
        }
        this.m_logFileThreshold = thresholdSize;
    }

    public Long getLogFileRolloverSizeThreshold() {
        return new Long(this.m_logFileRolloverThreshold);
    }

    public void setLogFileRolloverSizeThreshold(Long thresholdSize) {
        RollingFileLogger fileLogger = m_fileLogger;
        if (thresholdSize != this.m_logFileRolloverThreshold && fileLogger != null) {
            fileLogger.setRolloverThreshold(thresholdSize.longValue());
        }
        this.m_logFileRolloverThreshold = thresholdSize;
    }

    public Integer getLogFileRolloverTimeInterval() {
        return new Integer(this.m_logFileRolloverTimeInterval);
    }

    public void setLogFileRolloverTimeInterval(Integer timeInterval) {
        RollingFileLogger fileLogger = m_fileLogger;
        if (timeInterval != this.m_logFileRolloverTimeInterval && fileLogger != null) {
            fileLogger.set_LogRolloverTimeInterval(timeInterval.intValue());
        }
        this.m_logFileRolloverTimeInterval = timeInterval;
    }

    public Boolean getActionalLogInterceptor() {
        return new Boolean(this.m_actionalLogInterceptor);
    }

    public void setActionalLogInterceptor(Boolean enabled) throws Exception {
        this.m_actionalLogInterceptor = enabled;
        if (this.m_actionalLogInterceptor && this.m_context != null) {
            IElement config = this.m_context.getConfiguration(true);
            IAttributeSet containerAttrs = config.getAttributes();
            IAttributeSet systemProps = (IAttributeSet)containerAttrs.getAttribute("SYSTEM_PROPERTIES");
            Integer maxMsgSize = null;
            Boolean disableLogOutput = null;
            if (systemProps != null && systemProps.getAttributes().entrySet().size() > 0) {
                String maxMsgProp = (String)systemProps.getAttribute("com.progress.actional.interceptor.soniclog.maxMsgSize");
                if (maxMsgProp != null) {
                    try {
                        maxMsgSize = new Integer(maxMsgProp);
                    }
                    catch (NumberFormatException ex) {
                        maxMsgSize = null;
                    }
                } else {
                    maxMsgSize = null;
                }
                disableLogOutput = new Boolean((String)systemProps.getAttribute("com.progress.actional.interceptor.soniclog.disableLogOutput"));
            }
            SonicLogInterceptor.updateLoggingProperty((String)"com.progress.actional.interceptor.soniclog.maxMsgSize", maxMsgSize);
            SonicLogInterceptor.updateLoggingProperty((String)"com.progress.actional.interceptor.soniclog.disableLogOutput", disableLogOutput);
            this.m_containerImpl.logMessage(null, "Sonic logging interceptor enabled", 3);
        }
    }

    public Integer getMaxThreads() {
        return new Integer(this.m_taskScheduler.getMaxThreads());
    }

    public Integer getMinThreads() {
        return new Integer(this.m_taskScheduler.getMinThreads());
    }

    public String ping(String pingMessage) {
        return pingMessage;
    }

    public IContainerState getContainerState() throws Exception {
        return this.m_container.getContainerState();
    }

    public void terminate(Integer secondsDelay) {
        Runnable terminator = new Runnable(){

            @Override
            public void run() {
                if (Agent.this.m_containerImpl != null) {
                    Agent.this.m_containerImpl.logMessage(null, "QA CRASH INITIATED!", 3);
                }
                Runtime.getRuntime().halt(1);
            }
        };
        this.m_frameworkContext.scheduleTask(terminator, new Date(System.currentTimeMillis() + (long)(secondsDelay * 1000)));
    }

    public String diagnose(String instructions) {
        return this.m_containerImpl.diagnose(instructions);
    }

    public void shutdown() {
        this.shutdown(0);
    }

    public void restart() throws MFException {
        boolean allowRestart = Boolean.getBoolean("sonicsw.mf.allowRestart");
        if (!allowRestart) {
            throw new MFException("Restart by container's parent shell/process is not supported");
        }
        this.shutdown(14);
    }

    public void cleanRestart() throws MFException {
        boolean allowRestart = Boolean.getBoolean("sonicsw.mf.allowRestart");
        if (!allowRestart) {
            throw new MFException("Restart by container's parent shell/process is not supported");
        }
        this.shutdown(14, true);
    }

    synchronized void initFineGrainedSecurity() {
        this.m_permissionsManager = new PermissionsManager((IFrameworkComponentContext)this.m_context);
        this.m_auditManager = new AuditManager((IFrameworkComponentContext)this.m_context, this.m_containerImpl.m_mbeanServer);
    }

    IPermissionsManager getPermissionsManager() {
        return this.m_permissionsManager;
    }

    IAuditManager getAuditManager() {
        return this.m_auditManager;
    }

    void shutdown(int exitCode) {
        this.shutdown(exitCode, false);
    }

    void shutdown(final int exitCode, final boolean cleanRestart) {
        if (this.m_container.isClosing()) {
            return;
        }
        new Thread("AGENT - Shutdown Handler"){

            @Override
            public void run() {
                Agent.this.m_container.shutdown(exitCode, cleanRestart);
            }
        }.start();
    }

    String remotePing(String containerName, long timeout) {
        try {
            String retValue = this.m_containerImpl.remotePing(containerName, "PING", timeout);
            if (retValue != null && retValue.equals("PING")) {
                return "Ping succeeded.";
            }
            return "Ping failed.";
        }
        catch (InvokeTimeoutException e) {
            return "Destination container unreachable.";
        }
        catch (Exception e) {
            return "Ping failed: " + e.toString();
        }
    }

    public void reloadComponent(String id) throws Exception {
        if (id.equals("AGENT") || id.equals("DIRECTORY SERVICE")) {
            throw new MFException("Cannot reload ID=" + id);
        }
        this.m_containerImpl.reloadComponent(id);
    }

    public String getLogExtract(Long fromPosition, Long readLength) {
        if (fromPosition == null) {
            fromPosition = new Long(-1L);
        }
        if (readLength == null) {
            readLength = new Long(-1L);
        }
        RollingFileLogger fileLogger = m_fileLogger;
        if (this.m_logToFile && fileLogger != null) {
            try {
                return new String(fileLogger.read(fromPosition.longValue(), readLength.longValue()));
            }
            catch (IOException e) {
                MFRuntimeException mfe = new MFRuntimeException("Failed to read container log file");
                mfe.setLinkedException((Exception)e);
                throw mfe;
            }
        }
        return "<log to file disabled>";
    }

    public CompositeData getLogExtractAndLogFileSize(Long fromPosition, Long readLength) {
        RollingFileLogger fileLogger = m_fileLogger;
        if (this.m_logToFile && fileLogger != null) {
            try {
                Object[] itemValues = new Object[]{this.getLogExtract(fromPosition, readLength), new Long(this.m_logToFile ? m_fileLogger.length() : 0L)};
                return new CompositeDataSupport(LOG_COMPOSITE_TYPE, LOG_COMPOSITE_TYPE_ITEM_NAMES, itemValues);
            }
            catch (OpenDataException e) {
                this.m_context.logMessage("Failed to create container log extract, trace follows...", (Throwable)e, 2);
                return null;
            }
        }
        try {
            Object[] itemValues = new Object[]{"<log to file disabled>", new Long(0L)};
            return new CompositeDataSupport(LOG_COMPOSITE_TYPE, LOG_COMPOSITE_TYPE_ITEM_NAMES, itemValues);
        }
        catch (OpenDataException e) {
            this.m_context.logMessage("Failed to create container log extract, trace follows...", (Throwable)e, 2);
            return null;
        }
    }

    public void loadComponent(String id, String domainName, String configID, Boolean start, Integer traceMask) throws Exception {
        this.m_frameworkContext.loadComponent(id, configID, start, traceMask);
    }

    public void unloadComponent(String id) throws Exception {
        if (id.equals("AGENT") || id.equals("DIRECTORY SERVICE")) {
            throw new MFException("Cannot unload ID=" + id);
        }
        this.m_frameworkContext.unloadComponent(id);
        this.m_containerImpl.deleteRuntimeConfiguration(id);
    }

    public void setInitialConfigVersion(long version) {
        if (this.m_initialConfigVersion > -1L) {
            throw new IllegalStateException("Initial config version already set");
        }
        this.m_initialConfigVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveChangedElement(IBasicElement element) {
        if (this.waitForContainerToBoot()) {
            if ((this.m_traceMask & 0x200) > 0 && (this.m_traceMask & 1) > 0) {
                this.m_container.logMessage(null, "Received 1 configuration update", 7);
            }
            this.waitForDSUpdateReceiverTurn();
            try {
                Object object = this.m_asyncDSUpdateReceiverLock;
                synchronized (object) {
                    this.internalReceiveChangedElement(element);
                }
            }
            finally {
                this.notifyNextDSUpdateReceiver();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveChangedElements(IBasicElement[] elements) {
        if (this.waitForContainerToBoot()) {
            if ((this.m_traceMask & 0x200) > 0 && (this.m_traceMask & 1) > 0) {
                this.m_container.logMessage(null, "Received " + elements.length + " configuration update(s)", 7);
            }
            this.waitForDSUpdateReceiverTurn();
            try {
                Object object = this.m_asyncDSUpdateReceiverLock;
                synchronized (object) {
                    for (int i = 0; i < elements.length; ++i) {
                        this.internalReceiveChangedElement(elements[i]);
                    }
                }
            }
            finally {
                this.notifyNextDSUpdateReceiver();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveChangedElements(IDirElement[] elements) {
        if (this.waitForContainerToBoot()) {
            if ((this.m_traceMask & 0x200) > 0 && (this.m_traceMask & 1) > 0) {
                this.m_container.logMessage(null, "Received " + elements.length + " new configuration(s)", 7);
            }
            this.waitForDSUpdateReceiverTurn();
            try {
                Object object = this.m_asyncDSUpdateReceiverLock;
                synchronized (object) {
                    this.m_containerImpl.reportChangedElements(elements);
                }
            }
            finally {
                this.notifyNextDSUpdateReceiver();
            }
        }
    }

    private void internalReceiveChangedElement(IBasicElement element) {
        this.m_containerImpl.reportChangedElement(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDSUpdateReceiverTurn() {
        ArrayList arrayList = this.m_asyncDSUpdateReceivers;
        synchronized (arrayList) {
            this.m_asyncDSUpdateReceivers.add(Thread.currentThread());
            while (this.m_asyncDSUpdateReceivers.get(0) != Thread.currentThread()) {
                try {
                    this.m_asyncDSUpdateReceivers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNextDSUpdateReceiver() {
        ArrayList arrayList = this.m_asyncDSUpdateReceivers;
        synchronized (arrayList) {
            this.m_asyncDSUpdateReceivers.remove(0);
            this.m_asyncDSUpdateReceivers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForContainerToBoot() {
        IContainer iContainer = this.m_container;
        synchronized (iContainer) {
            while (!this.m_container.isBooted()) {
                if (this.m_container.isClosing()) {
                    return false;
                }
                try {
                    this.m_container.wait(1000L);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return !this.m_container.isClosing();
        }
    }

    public void stopComponent(String id) throws Exception {
        if (id.equals("AGENT")) {
            throw new MFException("Cannot stop ID=" + id);
        }
        this.m_frameworkContext.invoke(this.getContainerName() + ':' + "ID=" + id, "stop", new Object[0], new String[0], true, 0L);
    }

    public void startComponent(String id) throws Exception {
        this.m_frameworkContext.invoke(this.getContainerName() + ':' + "ID=" + id, "start", new Object[0], new String[0], true, 0L);
    }

    public void clearError(String id) throws Exception {
        this.m_frameworkContext.invoke(this.getContainerName() + ':' + "ID=" + id, "clearError", new Object[0], new String[0], true, 0L);
    }

    public void clearLogFile() {
        RollingFileLogger fileLogger = m_fileLogger;
        if (!this.m_logToFile || fileLogger == null) {
            return;
        }
        try {
            m_fileLogger.clearLogFile();
        }
        catch (IOException e) {
            MFRuntimeException runtimeException = new MFRuntimeException("Failed to clear container log file");
            runtimeException.setLinkedException((Exception)e);
            throw runtimeException;
        }
        this.m_context.logMessage("Container log file truncated", 3);
    }

    public void saveLogFile(String path) {
        RollingFileLogger fileLogger = m_fileLogger;
        if (!this.m_logToFile || fileLogger == null) {
            return;
        }
        try {
            fileLogger.saveLogFile(path);
        }
        catch (IOException e) {
            MFRuntimeException runtimeException = new MFRuntimeException("Failed to save container log file to " + path);
            runtimeException.setLinkedException((Exception)e);
            throw runtimeException;
        }
        this.m_context.logMessage("Container log file copied to " + path, 3);
    }

    public void attemptLogFileRollover() throws IOException {
        RollingFileLogger fileLogger = m_fileLogger;
        if (!this.m_logToFile || fileLogger == null) {
            return;
        }
        this.m_context.logMessage("Manual rollover attempt of container log file initiated", 7);
        fileLogger.attemptLogFileRollover();
    }

    public String getFaultToleranceRole() {
        return this.m_containerImpl.isFTContainer() ? this.m_containerImpl.getContainerFT().getRole() : "";
    }

    public Short getFaultTolerantState() {
        return new Short(this.m_containerImpl.isFTContainer() ? this.m_containerImpl.getContainerFT().getState() : (short)0);
    }

    public String getFaultTolerantStateString() {
        return IFaultTolerantState.STATE_TEXT[this.m_containerImpl.isFTContainer() ? (int)this.m_containerImpl.getContainerFT().getState() : 0];
    }

    public Boolean getAllowFailover() {
        return this.m_containerImpl.getAllowFailover();
    }

    public void setAllowFailover(Boolean allowFailover) {
        this.m_containerImpl.setAllowFailover(allowFailover);
    }

    void sendFailoverNotification() {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], FAILOVER_NOTIFICATION_TYPE, 2);
        notification.setLogType((short)1);
        notification.setAttribute("FaultToleranceRole", (Object)this.m_containerImpl.getContainerFT().getRole());
        this.m_context.sendNotification(notification);
    }

    public void suspendActiveRole(final Integer waitSeconds) throws MFException {
        short currentState = this.m_containerImpl.getContainerFT().getState();
        if (currentState != 2) {
            throw new MFException("Cannot suspend \"" + IFaultTolerantState.STATE_TEXT[2] + "\" state when container is in a \"" + IFaultTolerantState.STATE_TEXT[currentState] + "\" state.");
        }
        Runnable suspender = new Runnable(){

            @Override
            public void run() {
                block4: {
                    long waitTime = waitSeconds == null || waitSeconds == 0 ? (long)Agent.this.m_containerImpl.getContainerFT().getFaultDetectionInterval() : (long)(waitSeconds * 1000);
                    long startTime = System.currentTimeMillis();
                    PingThread pingThread = Agent.this.m_containerImpl.getPingThread();
                    if (pingThread == null) break block4;
                    Agent.this.m_containerImpl.logMessage(null, "Suspending \"" + IFaultTolerantState.STATE_TEXT[2] + "\" state for " + waitSeconds + " seconds...", 2);
                    pingThread.suspendActiveState();
                    do {
                        try {
                            Thread.sleep(2500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (Agent.this.m_containerImpl.isClosing()) break block4;
                    } while (System.currentTimeMillis() - startTime <= waitTime);
                    if (pingThread != null) {
                        Agent.this.m_containerImpl.logMessage(null, "...suspension complete", 3);
                        pingThread.resumeAfterSuspend();
                    }
                }
            }
        };
        this.m_context.scheduleTask(suspender, new Date());
    }

    public Properties getJVMProperties() throws MFException {
        return this.m_hostManager.getJVMProperties();
    }

    public void downloadArchives() throws Exception {
        this.m_context.logMessage("downloadArchives was called: Updating archives... ", 3);
        this.m_containerImpl.cacheAllArchivesIfNeeded();
        this.m_context.logMessage("...archives update is done", 3);
    }

    public void downloadArchives(String dsArchivePath0, String newVersion) throws Exception {
        String dsArchivePath;
        this.m_context.logMessage("downloadArchives was called: Updating archives from Directory Service folder \"" + dsArchivePath0 + "\" newVersion \"" + newVersion + "\"", 3);
        String string = dsArchivePath = dsArchivePath0.startsWith("sonicfs:///") ? dsArchivePath0.substring("sonicfs:///".length()) : dsArchivePath0;
        if (dsArchivePath.charAt(dsArchivePath.length() - 1) != '/') {
            dsArchivePath = dsArchivePath + "/";
        }
        this.m_containerImpl.downloadArchives(dsArchivePath, newVersion);
        this.m_context.logMessage("...archives update is done", 3);
    }

    public void downloadFile(String dsPath) throws Exception {
        this.m_containerImpl.cacheFileIfNeeded(dsPath, false, true);
        this.m_context.logMessage("downloadFile updated Directory Service file \"" + dsPath + "\"", 3);
    }

    void sendStartupNotification() {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], STARTUP_NOTIFICATION_TYPE, 3);
        notification.setLogType((short)0);
        this.m_context.sendNotification(notification);
    }

    void sendShutdownNotification(int exitCode) {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], SHUTDOWN_NOTIFICATION_TYPE, 3);
        notification.setLogType((short)0);
        notification.setAttribute("ExitCode", (Object)new Integer(exitCode));
        try {
            notification.setAttribute("ExitCodeString", (Object)IContainerExitCodes.EXIT_CODE_TEXTS[exitCode]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            notification.setAttribute("ExitCodeString", (Object)"n/a");
        }
        this.m_context.sendNotification(notification);
    }

    void sendComponentLoadNotification(String id, String configID, String lastError, Integer lastErrorLevel) {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], LOAD_NOTIFICATION_TYPE, 3);
        notification.setLogType((short)0);
        notification.setAttribute("ID", (Object)id);
        notification.setAttribute("ConfigID", (Object)configID);
        notification.setAttribute("LastError", (Object)lastError);
        notification.setAttribute("LastErrorLevel", (Object)lastErrorLevel);
        this.m_context.sendNotification(notification);
    }

    void sendComponentUnloadNotification(String id) {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], UNLOAD_NOTIFICATION_TYPE, 3);
        notification.setLogType((short)0);
        notification.setAttribute("ID", (Object)id);
        this.m_context.sendNotification(notification);
    }

    void sendLogMessageNotification(String id, String message, int severityLevel) {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[1], LOG_MESSAGE_NOTIFICATION_TYPE, severityLevel);
        notification.setLogType((short)0);
        notification.setAttribute("LogLevel", (Object)Level.LEVEL_TEXT[severityLevel]);
        if (id != null) {
            notification.setAttribute("ID", (Object)id);
        }
        notification.setAttribute("Message", (Object)message);
        this.m_context.sendNotification(notification);
    }

    void sendContainerStateNotification() {
        IContainerState containerState;
        INotification notification;
        block2: {
            notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], CONTAINER_STATE_NOTIFICATION_TYPE, 3);
            notification.setLogType((short)0);
            containerState = null;
            try {
                containerState = this.getContainerState();
            }
            catch (Exception e) {
                if (!this.DEBUG) break block2;
                System.out.println("Agent.sendContainerStateNotification: error obtaining container state...");
            }
        }
        notification.setAttribute(CONTAINER_STATE_NOTIFICATION_TYPE, (Object)containerState);
        this.m_context.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleElementChange(final IElementChange elementChange) {
        IContainer container;
        IContainer iContainer = container = this.m_container;
        synchronized (iContainer) {
            if (!container.isBooted()) {
                Runnable delayedHandler = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        IContainer iContainer = container;
                        synchronized (iContainer) {
                            while (!container.isBooted()) {
                                if (container.isClosing()) {
                                    return;
                                }
                                try {
                                    container.wait(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            Agent.this.handleElementChange(elementChange);
                        }
                    }
                };
                this.m_frameworkContext.scheduleTask(delayedHandler, new Date());
                return;
            }
        }
        if (container.isClosing()) {
            return;
        }
        IElementIdentity id = elementChange.getElement().getIdentity();
        String configID = id.getName();
        if (configID.equals(this.m_configID)) {
            long configVersion = id.getVersion();
            if (configVersion < this.m_initialConfigVersion) {
                return;
            }
            if (elementChange.getChangeType() == 1) {
                int i;
                IDeltaElement changeElement = (IDeltaElement)elementChange.getElement();
                IDeltaAttributeSet attrs = (IDeltaAttributeSet)changeElement.getDeltaAttributes();
                String[] mods1 = attrs.getModifiedAttributesNames();
                String[] mods2 = attrs.getNewAttributesNames();
                String[] mods3 = attrs.getDeletedAttributesNames();
                boolean shouldGenerateINI = false;
                boolean shouldGenerateDSBoot = false;
                for (i = 0; i < mods1.length; ++i) {
                    if (!Container.iniFileAttribute((String)mods1[i])) continue;
                    shouldGenerateINI = true;
                    break;
                }
                if (!shouldGenerateINI) {
                    for (i = 0; i < mods2.length; ++i) {
                        if (Container.iniFileAttribute((String)mods2[i])) {
                            shouldGenerateINI = true;
                        }
                        if (!mods2[i].equals("HOSTS_DIRECTORY_SERVICE")) continue;
                        shouldGenerateDSBoot = true;
                    }
                }
                if (!shouldGenerateINI) {
                    for (i = 0; i < mods3.length; ++i) {
                        if (!Container.iniFileAttribute((String)mods3[i])) continue;
                        shouldGenerateINI = true;
                        break;
                    }
                }
                if (shouldGenerateINI) {
                    this.generateContainerINI();
                }
                if (shouldGenerateDSBoot) {
                    this.generateDSBootFileIfNeeded();
                }
                this.handleChangeContainerAttrs(mods1, attrs);
                this.handleChangeContainerAttrs(mods2, attrs);
                this.handleDeletedContainerAttrs(mods3);
            }
        }
        if (configID.equals(DOMAIN_CONFIG_ID)) {
            this.setCentrallyLogMessages();
        }
        if (this.m_permissionsManager != null) {
            this.m_permissionsManager.handleElementChange(elementChange);
        }
        if (this.m_auditManager != null) {
            this.m_auditManager.handleElementChange(elementChange);
        }
    }

    private void generateContainerINI() {
        File iniFile = new File("container.ini");
        if (!iniFile.exists() || iniFile.isDirectory()) {
            return;
        }
        try {
            String encryptedPwd = this.getINIPwd();
            Properties oldProps = this.getINIProps(iniFile, encryptedPwd);
            if (oldProps == null) {
                return;
            }
            File tempIniFile = new File("tmp_container.ini");
            if (encryptedPwd != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(out);
                this.generateINIProps(oldProps, writer);
                String clearPwd = new String(PBE.decrypt(encryptedPwd.getBytes()));
                byte[] encryptedData = PBE.encrypt(out.toByteArray(), clearPwd);
                RandomAccessFile encFile = new RandomAccessFile(tempIniFile, "rw");
                encFile.write(encryptedData);
                encFile.close();
            } else {
                PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(tempIniFile, false)), true);
                this.generateINIProps(oldProps, writer);
            }
            if (!iniFile.delete()) {
                throw new IOException("Could not modify " + iniFile.getAbsolutePath());
            }
            tempIniFile.renameTo(iniFile);
            this.m_context.logMessage("Updated " + iniFile.getAbsolutePath(), 3);
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed to generate an updated container.ini file, trace follows...", (Throwable)e, 2);
        }
    }

    private void generateDSBootFileIfNeeded() {
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return;
        }
        try {
            String dsElementID = ContainerUtil.extractDSConfigIDFromContainerConfig(this.m_context.getConfiguration(true));
            if (dsElementID == null) {
                return;
            }
            this.m_containerImpl.generateDSBootFile(dsElementID);
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed to generate the \"ds.xml\" file, trace follows...", (Throwable)e, 2);
        }
    }

    private void generateINIProps(Properties oldProps, PrintWriter writer) throws Exception {
        Properties newProps = new Properties();
        Enumeration<Object> propItems = oldProps.keys();
        String oldCachePassword = oldProps.getProperty("CACHE_PASSWORD");
        while (propItems.hasMoreElements()) {
            String key = (String)propItems.nextElement();
            if (!this.m_nonConfiguredPropSet.contains(key.toUpperCase()) && !key.regionMatches(true, 0, "SystemProperty.", 0, "SystemProperty.".length())) continue;
            String propVal = key.indexOf("sonicsw.mf.DS.startactive") == -1 ? oldProps.getProperty(key) : "false";
            newProps.setProperty(key, propVal);
        }
        Container.bootConfigurationToProp((IElement)this.m_context.getConfiguration(true), (Properties)newProps);
        String newCachePassword = newProps.getProperty("CACHE_PASSWORD");
        propItems = newProps.keys();
        while (propItems.hasMoreElements()) {
            String key = (String)propItems.nextElement();
            String value = newProps.getProperty(key);
            if (value == null || value.length() == 0) continue;
            writer.println(key + "=" + value);
        }
        writer.close();
        if (oldCachePassword == null && newCachePassword != null || oldCachePassword != null && newCachePassword == null || oldCachePassword != null && newCachePassword != null && !newCachePassword.equals(oldCachePassword)) {
            this.requestCacheReset();
        }
    }

    private void requestCacheReset() {
        try {
            new FileOutputStream("reset_cache_file", true).close();
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed to create cache reset file, trace follows...", (Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getINIPwd() throws IOException {
        File setPwdScript = new File(SET_ENC_PWD_SH_SCRIPT_NAME);
        if (!setPwdScript.exists()) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(setPwdScript)));){
            reader.readLine();
            String srcLine = reader.readLine();
            if (null != srcLine) {
                String pwdProp = "sonicsw.mf.password=";
                int pwdIndex = srcLine.indexOf(pwdProp);
                String encryptedPwd = srcLine.substring(pwdIndex + pwdProp.length());
                String string = encryptedPwd.substring(0, encryptedPwd.length() - 1);
                return string;
            }
        }
        return null;
    }

    private Properties getINIProps(File iniFile, String encryptedPwd) throws Exception {
        RandomAccessFile raf = new RandomAccessFile(iniFile, "r");
        byte[] bytes = new byte[(int)raf.length()];
        raf.read(bytes);
        raf.close();
        if (encryptedPwd != null) {
            bytes = ContainerUtil.decryptBytes(bytes, encryptedPwd);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        return ContainerUtil.readProperties(stream);
    }

    public synchronized void handleFileChange(IFSElementChange fileChange) {
        if (this.m_auditManager != null) {
            this.m_auditManager.handleFileChange(fileChange);
        }
    }

    public String getTraceMaskValues() {
        return super.getTraceMaskValues() + "," + AGENT_TRACE_MASK_VALUES;
    }

    public void setTraceMask(Integer traceMask) {
        this.setTraceMask(traceMask, false);
    }

    private void setTraceMask(Integer traceMask, boolean fromSDF) {
        if (!fromSDF) {
            if (this.m_SdfMFTracingIntegration.wasUpdated()) {
                return;
            }
            this.m_SdfMFTracingIntegration.setTraceMask(traceMask);
        }
        super.setTraceMask(traceMask);
        if (this.m_container != null) {
            this.m_containerImpl.setTraceMask(super.getTraceMask());
        }
        if (this.m_permissionsManager != null) {
            this.m_permissionsManager.setTraceMask(super.getTraceMask().intValue());
        }
    }

    public String getContainerName() {
        return this.m_container.getContainerIdentity().getCanonicalName();
    }

    public String getContainerConfigID() {
        return this.m_container.getContainerIdentity().getConfigIdentity().getName();
    }

    void redoCLIPrompt() {
        if (this.m_commandLineEnabled) {
            AgentCLI.redoPrompt();
        }
    }

    void crAfterPrompt() {
        AgentCLI.crAfterPrompt();
    }

    Object[] getAttributeValues(String source, String[] attributeNames) throws Exception {
        return this.m_frameworkContext.getAttributeValues(source, attributeNames);
    }

    private void handleChangeContainerAttrs(String[] attributeNames, IDeltaAttributeSet modifiedAttrs) {
        try {
            for (int i = 0; i < attributeNames.length; ++i) {
                if (attributeNames[i].equals("TRACE_MASK")) {
                    this.setTraceMask((Integer)modifiedAttrs.getNewValue("TRACE_MASK"));
                    continue;
                }
                if (attributeNames[i].equals("COMMAND_LINE")) {
                    this.setCommandLine((Boolean)modifiedAttrs.getNewValue("COMMAND_LINE"));
                    continue;
                }
                if (attributeNames[i].equals("DIRECTORY_SERVICE_PING_INTERVAL")) {
                    this.m_containerImpl.setDSPingFrequency((Integer)modifiedAttrs.getNewValue("DIRECTORY_SERVICE_PING_INTERVAL"));
                    continue;
                }
                if (attributeNames[i].equals("LOG_TO_CONSOLE")) {
                    this.setLogToConsole((Boolean)modifiedAttrs.getNewValue("LOG_TO_CONSOLE"));
                    continue;
                }
                if (attributeNames[i].equals("LOG_TO_FILE")) {
                    this.setLogToFile((Boolean)modifiedAttrs.getNewValue("LOG_TO_FILE"));
                    continue;
                }
                if (attributeNames[i].equals("LOG_FILE_SIZE_THRESHOLD")) {
                    this.setLogFileSizeThreshold((Long)modifiedAttrs.getNewValue("LOG_FILE_SIZE_THRESHOLD"));
                    continue;
                }
                if (attributeNames[i].equals("LOG_FILE_ROLLOVER_SIZE_THRESHOLD")) {
                    this.setLogFileRolloverSizeThreshold((Long)modifiedAttrs.getNewValue("LOG_FILE_ROLLOVER_SIZE_THRESHOLD"));
                    continue;
                }
                if (attributeNames[i].equals("LOG_FILE_ROLLOVER_TIME_INTERVAL")) {
                    this.setLogFileRolloverTimeInterval((Integer)modifiedAttrs.getNewValue("LOG_FILE_ROLLOVER_TIME_INTERVAL"));
                    continue;
                }
                if (attributeNames[i].equals("LOG_FILE")) {
                    this.setLogFile((String)modifiedAttrs.getNewValue("LOG_FILE"));
                    continue;
                }
                if (attributeNames[i].equals("ACTIONAL_LOG_INTERCEPTOR")) {
                    this.setActionalLogInterceptor((Boolean)modifiedAttrs.getNewValue("ACTIONAL_LOG_INTERCEPTOR"));
                    continue;
                }
                if (attributeNames[i].equals("ENABLE_CENTRALIZED_LOGGING")) {
                    this.setCentrallyLogMessages();
                    continue;
                }
                if (attributeNames[i].equals("MAX_THREADS")) {
                    this.m_taskScheduler.setMaxThreads((Integer)modifiedAttrs.getNewValue("MAX_THREADS"));
                    continue;
                }
                if (attributeNames[i].equals("MIN_THREADS")) {
                    this.m_taskScheduler.setMinThreads((Integer)modifiedAttrs.getNewValue("MIN_THREADS"));
                    continue;
                }
                if (attributeNames[i].equals("NOTIFICATION_DISPATCH_QUEUE_SIZE")) {
                    this.m_notificationPublisher.setQueueSize((Integer)modifiedAttrs.getNewValue("NOTIFICATION_DISPATCH_QUEUE_SIZE"));
                    continue;
                }
                if (attributeNames[i].equals("ARCHIVE_SEARCH_PATH")) {
                    this.m_containerImpl.setSonicArchiveSearchPath((String)modifiedAttrs.getNewValue("ARCHIVE_SEARCH_PATH"));
                    continue;
                }
                if (attributeNames[i].equals("EXTENSIONS")) {
                    this.handleChangeExtensionsAttr((IDeltaAttributeSet)modifiedAttrs.getNewValue("EXTENSIONS"));
                    continue;
                }
                if (attributeNames[i].equals("COMPONENTS")) {
                    this.handleChangeComponentsAttr((IDeltaAttributeSet)modifiedAttrs.getNewValue("COMPONENTS"));
                    continue;
                }
                if (attributeNames[i].equals("CONNECTION")) {
                    this.handleChangeConnectionAttr((IDeltaAttributeSet)modifiedAttrs.getNewValue("CONNECTION"));
                    continue;
                }
                if (attributeNames[i].equals("MONITORING")) {
                    Object newValue = modifiedAttrs.getNewValue("MONITORING");
                    if (newValue instanceof IDeltaAttributeSet) {
                        this.handleChangeMonitoringAttr((IDeltaAttributeSet)newValue);
                        continue;
                    }
                    this.handleNewMonitoringAttr((IAttributeSet)newValue);
                    continue;
                }
                if (attributeNames[i].equals("ENABLED_METRICS")) {
                    this.resetMetrics("AGENT");
                    continue;
                }
                if (attributeNames[i].equals("ENABLED_ALERTS")) {
                    this.resetAlerts("AGENT");
                    continue;
                }
                if (!attributeNames[i].equals("FAULT_TOLERANCE_PARAMETERS")) continue;
                if (this.m_containerImpl.isFTContainer()) {
                    this.m_containerImpl.getContainerFT().handleChangeFTAttrs((IDeltaAttributeSet)modifiedAttrs.getNewValue("FAULT_TOLERANCE_PARAMETERS"));
                    continue;
                }
                this.m_containerImpl.logMessage(null, attributeNames[i] + " cannot be added at runtime. ", 2);
            }
        }
        catch (Exception e) {
            this.m_context.logMessage("Error modifying Agent runtime from configuration change, trace follows...", (Throwable)e, 2);
        }
    }

    private void resetMetrics(String componentID) {
        IAttributeSet mas = this.getEnabledMetricsOrAlertsFromConfiguration(componentID, "ENABLED_METRICS");
        IMetricIdentity[] enabledMetricIds = mas == null ? null : this.createMetricIds(mas);
        String target = this.m_agentName.getDomainName() + '.' + this.m_agentName.getContainerName() + ':' + "ID=" + componentID;
        try {
            this.m_containerImpl.invokeLocal(target, REPLACE_ENABLED_METRICS_OPERATION_NAME, new Object[]{enabledMetricIds}, REPLACE_ENABLED_METRICS_OPERATION_SIGNATURE, false);
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed to replace enabled metrics for ID=" + componentID + ", trace follows...", (Throwable)e, 1);
        }
    }

    private void resetAlerts(String componentID) {
        IAttributeSet aas = this.getEnabledMetricsOrAlertsFromConfiguration(componentID, "ENABLED_ALERTS");
        IAlert[] enabledAlerts = aas == null ? null : this.createAlerts(aas);
        String target = this.m_agentName.getDomainName() + '.' + this.m_agentName.getContainerName() + ':' + "ID=" + componentID;
        try {
            this.m_containerImpl.invokeLocal(target, REPLACE_ENABLED_ALERTS_OPERATION_NAME, new Object[]{enabledAlerts}, REPLACE_ENABLED_ALERTS_OPERATION_SIGNATURE, false);
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed to replace enabled alerts for ID=" + componentID + ", trace follows...", (Throwable)e, 1);
        }
    }

    private IAttributeSet getEnabledMetricsOrAlertsFromConfiguration(String componentID, String attributeName) {
        IAttributeSet as = null;
        IElement containerCE = this.m_context.getConfiguration(true);
        IAttributeSet containerAS = containerCE.getAttributes();
        if ("AGENT".equals(componentID)) {
            as = (IAttributeSet)containerAS.getAttribute(attributeName);
        } else {
            IAttributeSet componentAS = (IAttributeSet)containerAS.getAttribute("COMPONENTS");
            HashMap map = componentAS.getAttributes();
            IAttributeSet spas = (IAttributeSet)map.get(componentID);
            if (spas == null) {
                return null;
            }
            as = (IAttributeSet)spas.getAttribute(attributeName);
        }
        return as;
    }

    private void handleDeletedContainerAttrs(String[] attributeNames) {
        try {
            for (int i = 0; i < attributeNames.length; ++i) {
                if (attributeNames[i].equals("TRACE_MASK")) {
                    this.setTraceMask(new Integer(0));
                    continue;
                }
                if (attributeNames[i].equals("COMMAND_LINE")) {
                    this.setCommandLine(new Boolean(false));
                    continue;
                }
                if (attributeNames[i].equals("DIRECTORY_SERVICE_PING_INTERVAL")) {
                    this.m_containerImpl.setDSPingFrequency(new Integer(30));
                    continue;
                }
                if (attributeNames[i].equals("LOG_TO_CONSOLE")) {
                    this.setLogToConsole(new Boolean(true));
                    continue;
                }
                if (attributeNames[i].equals("LOG_TO_FILE")) {
                    this.setLogToFile(new Boolean(true));
                    continue;
                }
                if (attributeNames[i].equals("LOG_FILE_SIZE_THRESHOLD")) {
                    this.setLogFileSizeThreshold(new Long(0x1000000L));
                    continue;
                }
                if (attributeNames[i].equals("LOG_FILE_ROLLOVER_SIZE_THRESHOLD")) {
                    this.setLogFileRolloverSizeThreshold(new Long(0x100000L));
                    continue;
                }
                if (attributeNames[i].equals("LOG_FILE_ROLLOVER_TIME_INTERVAL")) {
                    this.setLogFileRolloverTimeInterval(new Integer(1440));
                    continue;
                }
                if (attributeNames[i].equals("LOG_FILE")) {
                    this.setLogFile(this.m_defaultLogFile);
                    continue;
                }
                if (attributeNames[i].equals("ACTIONAL_LOG_INTERCEPTOR")) {
                    this.setActionalLogInterceptor(this.m_defaultActionalLogInterceptor);
                    continue;
                }
                if (attributeNames[i].equals("ENABLE_CENTRALIZED_LOGGING")) {
                    this.setCentrallyLogMessages();
                    continue;
                }
                if (attributeNames[i].equals("MAX_THREADS")) {
                    this.m_taskScheduler.setMaxThreads(50);
                    continue;
                }
                if (attributeNames[i].equals("MIN_THREADS")) {
                    this.m_taskScheduler.setMinThreads(0);
                    continue;
                }
                if (attributeNames[i].equals("NOTIFICATION_DISPATCH_QUEUE_SIZE")) {
                    this.m_notificationPublisher.setQueueSize(100000);
                    continue;
                }
                if (!attributeNames[i].equals("FAULT_TOLERANCE_PARAMETERS")) continue;
                this.m_containerImpl.logMessage(null, "Dynamic removal of " + attributeNames[i] + " is not supported; a container restart is required", 2);
            }
        }
        catch (Exception e) {
            this.m_context.logMessage("Error modifying Agent runtime from configuration change", (Throwable)e, 1);
        }
    }

    private void handleChangeExtensionsAttr(IDeltaAttributeSet attrs) throws Exception {
        this.handleNewExtensionsAttrs(attrs.getNewAttributesNames(), attrs);
        this.handleModifiedExtensionsAttrs(attrs.getModifiedAttributesNames(), attrs);
        this.handleDeletedExtensionsAttrs(attrs.getDeletedAttributesNames());
    }

    private void handleNewExtensionsAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            this.m_containerImpl.loadConfiguredComponent(names[i], (IAttributeSet)attrs.getNewValue(names[i]), true, false);
        }
    }

    private void handleModifiedExtensionsAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            IDeltaAttributeSet modifiedAttrs = (IDeltaAttributeSet)attrs.getNewValue(names[i]);
            this.handleNewExtensionAttrs(names[i], modifiedAttrs.getNewAttributesNames(), modifiedAttrs);
            this.handleModifiedExtensionAttrs(names[i], modifiedAttrs.getModifiedAttributesNames(), modifiedAttrs);
            this.handleDeletedExtensionAttrs(names[i], modifiedAttrs.getDeletedAttributesNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeletedExtensionsAttrs(String[] names) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            IContainer iContainer = this.m_container;
            synchronized (iContainer) {
                if (!this.m_container.isHostingComponent(names[i])) {
                    continue;
                }
            }
            this.unloadComponent(names[i]);
            this.m_containerImpl.deleteRuntimeConfiguration(names[i]);
        }
    }

    private void handleNewExtensionAttrs(String id, String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals("EXTENSION_ACTIVE")) continue;
            this.unloadComponent(id);
        }
    }

    private void handleModifiedExtensionAttrs(String id, String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("EXTENSION_CONFIG_REF")) {
                this.logMessage("Dynamic changes to extension config references unsupported: " + names[i], 2);
                continue;
            }
            if (!names[i].equals("EXTENSION_ACTIVE")) continue;
            Boolean isActive = (Boolean)attrs.getNewValue("EXTENSION_ACTIVE");
            if (isActive.booleanValue() && !this.m_container.isHostingComponent(id)) {
                IAttributeSet extensionsAttrs = (IAttributeSet)this.m_context.getConfiguration(true).getAttributes().getAttribute("EXTENSIONS");
                this.m_containerImpl.loadConfiguredComponent(id, (IAttributeSet)extensionsAttrs.getAttribute(id), true, false);
                continue;
            }
            if (isActive.booleanValue() || !this.m_container.isHostingComponent(id)) continue;
            this.unloadComponent(id);
        }
    }

    private void handleDeletedExtensionAttrs(String id, String[] names) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("NATIVE_LIBRARIES")) {
                this.logMessage("Dynamic removal of component native libraries unsupported: " + names[i], 2);
                continue;
            }
            if (!names[i].equals("EXTENSION_ACTIVE") || !this.m_container.isHostingComponent(id)) continue;
            this.unloadComponent(id);
        }
    }

    private void handleChangeComponentsAttr(IDeltaAttributeSet attrs) throws Exception {
        this.handleNewComponentsAttrs(attrs.getNewAttributesNames(), attrs);
        this.handleModifiedComponentsAttrs(attrs.getModifiedAttributesNames(), attrs);
        this.handleDeletedComponentsAttrs(attrs.getDeletedAttributesNames());
    }

    private void handleNewComponentsAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("DIRECTORY SERVICE")) {
                try {
                    boolean done = LauncherJARBuilder.createMFdirectoryJAR();
                    if (done) {
                        this.m_context.logMessage("Added MFdirectory.jar to the launcher lib directory", 3);
                    }
                }
                catch (IOException e) {
                    this.m_context.logMessage("Failed to add MFdirectory.jar to the launcher lib directory", (Throwable)e, 2);
                }
                if (this.m_container.isHostingComponent(names[i])) continue;
                this.m_context.logMessage("Container must be restarted to load the " + names[i], 2);
                continue;
            }
            this.m_containerImpl.loadConfiguredComponent(names[i], (IAttributeSet)attrs.getNewValue(names[i]), false, false);
        }
    }

    private void handleModifiedComponentsAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            IDeltaAttributeSet modifiedAttrs = (IDeltaAttributeSet)attrs.getNewValue(names[i]);
            this.handleNewComponentAttrs(names[i], modifiedAttrs.getNewAttributesNames(), modifiedAttrs);
            this.handleModifiedComponentAttrs(names[i], modifiedAttrs.getModifiedAttributesNames(), modifiedAttrs);
            this.handleDeletedComponentAttrs(names[i], modifiedAttrs.getDeletedAttributesNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeletedComponentsAttrs(String[] names) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            IContainer iContainer = this.m_container;
            synchronized (iContainer) {
                if (!this.m_container.isHostingComponent(names[i])) {
                    continue;
                }
            }
            if (names[i].equals("DIRECTORY SERVICE")) {
                this.m_context.logMessage("Container must be restarted to unload the " + names[i], 2);
                continue;
            }
            this.unloadComponent(names[i]);
            this.m_containerImpl.deleteRuntimeConfiguration(names[i]);
        }
    }

    private void handleNewComponentAttrs(String id, String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("TRACE_MASK")) {
                this.setTraceMask(id, (Integer)attrs.getNewValue("TRACE_MASK"));
                continue;
            }
            if (names[i].equals("NATIVE_LIBRARIES")) {
                this.logMessage("Dynamic additions to component native libraries unsupported: " + names[i], 2);
                continue;
            }
            if (names[i].equals("ENABLED_METRICS")) {
                this.resetMetrics(id);
                continue;
            }
            if (!names[i].equals("ENABLED_ALERTS")) continue;
            this.resetAlerts(id);
        }
    }

    private void handleModifiedComponentAttrs(String id, String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("TRACE_MASK")) {
                this.setTraceMask(id, (Integer)attrs.getNewValue("TRACE_MASK"));
                continue;
            }
            if (names[i].equals("CONFIG_REF")) {
                this.logMessage("Dynamic changes to component config references unsupported: " + names[i], 2);
                continue;
            }
            if (names[i].equals("NATIVE_LIBRARIES")) {
                this.logMessage("Dynamic changes to component native libraries unsupported: " + names[i], 2);
                continue;
            }
            if (names[i].equals("ENABLED_METRICS")) {
                this.resetMetrics(id);
                continue;
            }
            if (!names[i].equals("ENABLED_ALERTS")) continue;
            this.resetAlerts(id);
        }
    }

    private void handleDeletedComponentAttrs(String id, String[] names) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("TRACE_MASK")) {
                this.setTraceMask(id, new Integer(0));
                continue;
            }
            if (!names[i].equals("NATIVE_LIBRARIES")) continue;
            this.logMessage("Dynamic removal of component native libraries unsupported: " + names[i], 2);
        }
    }

    private void handleNewMonitoringAttr(IAttributeSet attrs) throws Exception {
        Object notificationInterval = attrs.getAttribute("STATUS_POLL_INTERVAL");
        if (notificationInterval == null) {
            this.m_containerStateNotifier.setNotificationInterval(48000L);
        } else {
            this.m_containerStateNotifier.setNotificationInterval(((Integer)notificationInterval).longValue() * 800L);
        }
    }

    private void handleChangeMonitoringAttr(IDeltaAttributeSet attrs) throws Exception {
        this.handleModifiedMonitoringAttrs(attrs.getNewAttributesNames(), attrs);
        this.handleModifiedMonitoringAttrs(attrs.getModifiedAttributesNames(), attrs);
        this.handleDeletedMonitoringAttrs(attrs.getDeletedAttributesNames());
    }

    private void handleModifiedMonitoringAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals("STATUS_POLL_INTERVAL")) continue;
            this.m_containerStateNotifier.setNotificationInterval(((Integer)attrs.getNewValue(names[i])).longValue() * 800L);
        }
    }

    private void handleDeletedMonitoringAttrs(String[] names) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals("STATUS_POLL_INTERVAL")) continue;
            this.m_containerStateNotifier.setNotificationInterval(48000L);
        }
    }

    private void setTraceMask(String id, Integer traceMask) throws Exception {
        String target = this.m_agentName.getDomainName() + '.' + this.m_agentName.getContainerName() + ':' + "ID=" + id;
        this.m_frameworkContext.setAttributes(target, new String[]{"TraceMask"}, new Object[]{traceMask}, false);
    }

    private void handleChangeConnectionAttr(IDeltaAttributeSet attrs) throws Exception {
        this.handleModifiedConnectionAttrs(attrs.getNewAttributesNames(), attrs);
        this.handleModifiedConnectionAttrs(attrs.getModifiedAttributesNames(), attrs);
        this.handleDeletedConnectionAttrs(attrs.getDeletedAttributesNames());
    }

    private void handleModifiedConnectionAttrs(String[] names, IDeltaAttributeSet attrs) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals("REQUEST_TIMEOUT")) continue;
            this.m_container.getConnectorServer().setRequestTimeout((Integer)attrs.getNewValue(names[i]) * 1000);
        }
    }

    private void handleDeletedConnectionAttrs(String[] names) throws Exception {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals("REQUEST_TIMEOUT")) continue;
            this.m_container.getConnectorServer().setRequestTimeout(ConnectorClient.REQUEST_TIMEOUT_DEFAULT);
        }
    }

    private IMetricIdentity[] createMetricIds(String[] metricNames) {
        IMetricIdentity[] metricIds = new IMetricIdentity[metricNames.length];
        for (int i = 0; i < metricNames.length; ++i) {
            metricIds[i] = MetricsFactory.createMetricIdentity((String)metricNames[i]);
        }
        return metricIds;
    }

    private IMetricIdentity[] createMetricIds(IAttributeSet metricsAS) {
        HashMap metricsMap = metricsAS.getAttributes();
        Iterator iterator = metricsMap.values().iterator();
        ArrayList<IMetricIdentity> metricIDList = new ArrayList<IMetricIdentity>();
        while (iterator.hasNext()) {
            String metricName = (String)iterator.next();
            IMetricIdentity metricID = MetricsFactory.createMetricIdentity((String)metricName);
            metricIDList.add(metricID);
        }
        return metricIDList.toArray(new IMetricIdentity[metricIDList.size()]);
    }

    private IAlert[] createAlerts(IAttributeSet alertsAS) {
        HashMap alertsMap = alertsAS.getAttributes();
        Iterator itor = alertsMap.values().iterator();
        ArrayList<IAlert> alertsList = new ArrayList<IAlert>();
        while (itor.hasNext()) {
            int j;
            IAlert[] alerts;
            Object attr = itor.next();
            if (!(attr instanceof AttributeSet)) continue;
            AttributeSet alertAS = (AttributeSet)attr;
            AttributeName compoundName = alertAS.getCompoundName();
            String metricName = (String)compoundName.getComponent(compoundName.getComponentCount() - 1);
            IMetricIdentity metricID = MetricsFactory.createMetricIdentity((String)metricName);
            Object thresholds = alertAS.getAttribute("HIGH_THRESHOLDS");
            if (thresholds instanceof String) {
                alerts = MetricsFactory.createAlerts((IMetricIdentity)metricID, (boolean)true, (String)((String)thresholds));
                for (j = 0; j < alerts.length; ++j) {
                    alertsList.add(alerts[j]);
                }
            }
            if (!((thresholds = alertAS.getAttribute("LOW_THRESHOLDS")) instanceof String)) continue;
            alerts = MetricsFactory.createAlerts((IMetricIdentity)metricID, (boolean)false, (String)((String)thresholds));
            for (j = 0; j < alerts.length; ++j) {
                alertsList.add(alerts[j]);
            }
        }
        return alertsList.toArray(new IAlert[alertsList.size()]);
    }

    private void setCentrallyLogMessages() {
        boolean currentlyEnabled;
        IElement containerConfig;
        IAttributeSet containerAttributes;
        Boolean enableCentralizedLogging;
        boolean centrallyLogMessages = this.getForceCentralizedLogging();
        if (!centrallyLogMessages && (enableCentralizedLogging = (Boolean)(containerAttributes = (containerConfig = this.m_context.getConfiguration(true)).getAttributes()).getAttribute("ENABLE_CENTRALIZED_LOGGING")) != null) {
            centrallyLogMessages = enableCentralizedLogging;
        }
        boolean bl = currentlyEnabled = this.m_centrallyLogMessages == null ? false : this.m_centrallyLogMessages;
        if (centrallyLogMessages) {
            this.m_centrallyLogMessages = Boolean.TRUE;
            if (!currentlyEnabled) {
                this.m_container.logMessage(null, "Centralized logging enabled", 3);
            }
        } else {
            if (currentlyEnabled) {
                this.m_container.logMessage(null, "Centralized logging disabled", 3);
            }
            this.m_centrallyLogMessages = Boolean.FALSE;
        }
    }

    private boolean getForceCentralizedLogging() {
        IElement domainConfig = this.m_context.getConfiguration(DOMAIN_CONFIG_ID, true);
        if (domainConfig == null) {
            return false;
        }
        IAttributeSet domainAttributes = domainConfig.getAttributes();
        Boolean forceCentralizedLogging = (Boolean)domainAttributes.getAttribute("FORCE_CENTRALIZED_LOGGING");
        if (forceCentralizedLogging == null) {
            return false;
        }
        return forceCentralizedLogging;
    }

    void logMessage(String message, int level) {
        this.m_context.logMessage(message, level);
    }

    boolean centrallyLogMessage(String timestampedMessage) {
        if (this.m_centrallyLogMessages == null) {
            return false;
        }
        if (!this.m_centrallyLogMessages.booleanValue()) {
            return true;
        }
        if (timestampedMessage.startsWith("[")) {
            if (timestampedMessage.indexOf("] ID=") == 18) {
                timestampedMessage = timestampedMessage.replaceFirst("] ID=", "] " + this.m_agentName.getContainerName() + ".ID=");
            } else if (timestampedMessage.indexOf("] (") == 18) {
                timestampedMessage = timestampedMessage.replaceFirst("] \\(", "] " + this.m_agentName.getContainerName() + " (");
            }
        }
        boolean result = false;
        try {
            this.m_frameworkContext.invoke(this.m_agentManager, LOG_MESSAGE_OPERATION_NAME, new Object[]{timestampedMessage}, LOG_MESSAGE_OPERATION_SIGNATURE, false, 0L);
            result = true;
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed to centrally log message, trace follows...", (Throwable)e, 1);
            result = false;
        }
        try {
            Thread.sleep(25L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private static IMetricInfo[] getMetricsInfo() {
        IMetricInfo[] infos = new IMetricInfo[]{MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_MEMORY_CURRENTUSAGE_METRIC_ID, (short)0, (String)"Heap space used by the container and its hosted components.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"bytes"), MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_MEMORY_MAXUSAGE_METRIC_ID, (short)0, (String)"Maximum heap space used by the container and its hosted components since last metrics reset.", null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (String)"bytes"), MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_THREADS_CURRENTTOTAL_METRIC_ID, (short)0, (String)"Total number of threads used by the container and its hosted components.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"threads")};
        return infos;
    }

    private void initMetrics() {
        IStatisticProvider[] memoryStatisticProviders = new IStatisticProvider[]{new IStatisticProvider(){
            private Runtime runtime = Runtime.getRuntime();

            public void updateStatistic(ISampledStatistic statistic) {
                statistic.updateValue(this.runtime.totalMemory() - this.runtime.freeMemory());
            }

            public void resetStatistic(ISampledStatistic statistic) {
            }
        }};
        this.m_memoryUsageStatistic = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])memoryStatisticProviders, (short)0);
        this.m_maxMemoryUsageStatistic = StatisticsFactory.createStatistic((short)3, (boolean)false, (IStatisticProvider[])memoryStatisticProviders, (short)0);
        IStatisticProvider[] threadStatisticProviders = new IStatisticProvider[]{new IStatisticProvider(){
            private ThreadGroup rootThreadGroup;
            {
                this.rootThreadGroup = Agent.this.getRootThreadGroup();
            }

            public void updateStatistic(ISampledStatistic statistic) {
                statistic.updateValue((long)this.rootThreadGroup.activeCount());
            }

            public void resetStatistic(ISampledStatistic statistic) {
            }
        }};
        this.m_totalThreadsStatistic = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])threadStatisticProviders, (short)0);
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    long getNotificationInterval() {
        return this.m_containerStateNotifier == null ? JMSConnectorServer.NOTIFICATION_TTL : this.m_containerStateNotifier.getNotificationInterval();
    }

    static {
        FILE_LOCK_OBJ = new Object();
        CONSOLE_LOCK_OBJ = new Object();
        Object method = null;
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("CommandLine", Boolean.class.getName(), "Flag indicating if a local command line interface is enabled.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogToConsole", Boolean.class.getName(), "Flag indicating if messages logged via the framework should be sent to the container console.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogToFile", Boolean.class.getName(), "Flag indicating if messages logged via the framework should be sent to the log file.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFile", String.class.getName(), "The directory pathname of the container log file. Defaults to {<domain>.<container>.log} in the container's working directory.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFileSize", Long.class.getName(), "The number of bytes written to the container log file. This value gets reset to 0 when the log is cleared or archived.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFileSizeThreshold", Long.class.getName(), "Once the size of the container log file reaches this threshold or for each time the size exceeds this threshold by a further 10%, the Agent will send a warning notification.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFileRolloverSizeThreshold", Long.class.getName(), "If the current log file size equals or exceeds this threshold at midnight, then the container will roll over the old contents to an archive file and create a new empty container log file.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFileRolloverTimeInterval", Integer.class.getName(), "Time interval to rollover the log file contents.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("ActionalLogInterceptor", Boolean.class.getName(), "Flag indicating if the Sonic Logging Interceptor is enabled.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("MaxThreads", Integer.class.getName(), "The maximum number of threads that the container can create to service transient management tasks.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("MinThreads", Integer.class.getName(), "The minimum number of threads that the container will cache for reuse to service transient management tasks.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("Hostname", String.class.getName(), "The hostname for the container host machine.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultToleranceRole", String.class.getName(), "The fault tolerant role of the container (primary or backup) or null if not fault tolerant.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultTolerantState", Short.class.getName(), "The current fault tolerant state of this container.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultTolerantStateString", String.class.getName(), "The description of the current fault tolerant state of this container.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("AllowFailover", Boolean.class.getName(), "When this container is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("StartupComplete", Boolean.class.getName(), "Set to true when all components have been loaded and started (if required).", true, false, false));
        MBeanParameterInfo[] mbParamInfos = null;
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("instructions", String.class.getName(), "One or more diagnostic instructions - an instruction per line")};
        OPERATION_INFOS.add(new MBeanOperationInfo("diagnose", "Execute diagnostics instructions", mbParamInfos, String.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("pingMessage", String.class.getName(), "Any string.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("ping", "Checks the container for accessibility. Returns the given string.", mbParamInfos, String.class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("getContainerState", "Gets the execution state of the container and its hosted components.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, IContainerState.class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("shutdown", "Shutdown the Agent/Container.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("restart", "Restart the Agent/Container (requires support from parent shell/process).", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("cleanRestart", "Restart the Agent/Container after deleting runtime files from the container's working directory (requires support from parent shell/process).", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("id", String.class.getName(), "The runtime identity of the component within the container to be reloaded.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("reloadComponent", "Asynchronously reload the given component ID.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("clearLogFile", "Clear the log file.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("filename", String.class.getName(), "A valid filename (including path) to save the log file to.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("saveLogFile", "Saves the contents of the log file to the given file name.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("fromPosition", Long.class.getName(), "The starting position from which to read the log for the given date. If null, then the total log length minus the given readLength is assumed (i.e. the tail of the logging output). The total log length is calculated by summing the size of all log files (current + previous versions."), new MBeanParameterInfo("readLength", Long.class.getName(), "The maximum amount of bytes to read from the given (or assumed) starting position. The max size for this value is 1Mb. If null, 200Kb is assumed.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getLogExtract", "Reads the requested bytes from the log file and returns them as a String.", mbParamInfos, String.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("fromPosition", Long.class.getName(), "The starting position from which to read the log for the given date. If null, then the total log length minus the given readLength is assumed (i.e. the tail of the logging output). The total log length is calculated by summing the size of all log files (current + previous versions."), new MBeanParameterInfo("readLength", Long.class.getName(), "The maximum amount of bytes to read from the given (or assumed) starting position. The max size for this value is 1Mb. If null, 200Kb is assumed.")};
        try {
            LOG_COMPOSITE_TYPE_ITEM_NAMES = new String[]{"LogExtract", "LogFileSize"};
            LOG_COMPOSITE_TYPE = new CompositeType("LogExtract", "An extract from and the length of the current container log", LOG_COMPOSITE_TYPE_ITEM_NAMES, new String[]{"Log extract String", "Total log size"}, new OpenType[]{SimpleType.STRING, SimpleType.LONG});
        }
        catch (OpenDataException e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getLogExtractAndLogFileSize", "Reads the requested bytes from the log file and returns them as a String encapsulated with the current log size. The current log size is the size of the current log file plus the sum of all available prior versions. When evaluating log output to be read, the current log file and previous versions (due to rollover activity) will be effectively viewed as a single file.", mbParamInfos, CompositeData.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("seconds", Integer.class.getName(), "The minimum time the active role will be suspended.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("suspendActiveRole", "Relinquish the current active role to the the standby. For an active container, this operation attempts to relinquish the active role to the current standby. The active container will wait up to the given number of seconds for a standby to takeover the active role; if a standby does not takeover the active role in this period, the container will continue its active role.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getJVMProperties", "Returns the JVM's system properties.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Properties.class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("downloadArchives", "Makes sure all the latest versions of archives used by components of this container are cached in the container's cache.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("archivesRootDSpath", String.class.getName(), "The Directory Service path of the root of the archives - the \"sonicfs://\" prefix can be omitted. Example: \"/Archives\""), new MBeanParameterInfo("archivesVersion", String.class.getName(), "The version of the archive(s). Example: \"8.0\".")};
        OPERATION_INFOS.add(new MBeanOperationInfo("downloadArchives", "Makes sure all the archives from the specified Directory Service path and the specified version and used by components of this container are cached in the container's cache.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("dsFilePath", String.class.getName(), "The Directory Service path of the file.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("downloadFile", "Makes sure the latest version of the specified Directory Service file is cached in the container's cache.", mbParamInfos, Void.class.getName(), 1));
        if (IContainer.QA_MODE) {
            mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("id", String.class.getName(), "The unique name for the component instance in the container."), new MBeanParameterInfo("domainName", String.class.getName(), "Not currently used."), new MBeanParameterInfo("configID", String.class.getName(), "The name of the component's configuration (as known by the Directory Service). Name is equivalent to that returned by IElementIdentity.getName()."), new MBeanParameterInfo("start", Boolean.class.getName(), "If true, the component will be automatically started after it has been loaded and initialized."), new MBeanParameterInfo("traceMask", Integer.class.getName(), "The initial setting for the components debug mask.")};
            OPERATION_INFOS.add(new MBeanOperationInfo("loadComponent", "Load a component to the container.", mbParamInfos, Void.class.getName(), 1));
            mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("id", String.class.getName(), "The runtime identity of the component within the container to be unloaded.")};
            OPERATION_INFOS.add(new MBeanOperationInfo("unloadComponent", "Unload the given component ID.", mbParamInfos, Void.class.getName(), 1));
            mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("secondsDelay", Integer.class.getName(), "The delay (seconds) before termination.")};
            OPERATION_INFOS.add(new MBeanOperationInfo("terminate", "Immediately exit the container (QA mode only).", mbParamInfos, Void.class.getName(), 1));
            OPERATION_INFOS.add(new MBeanOperationInfo("attemptLogFileRollover", "Attempt a container log file rollover (QA mode only).", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        }
        String[] notifTypes = null;
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], SHUTDOWN_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Agent/Container shutdown initiated."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], LOAD_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Component load completed."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], UNLOAD_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Component unload completed."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[1], LOGFAILURE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Failure to write to the container log file."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[1], LOGTHRESHOLD_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "The size of the current container log has reached or exceeded (by a 10% increment) the configured threshold."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], CONTAINER_STATE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Update of container state "));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], FAILOVER_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Standby container has failed over to become the active container."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[5], MANAGE_PERMISSION_DENIED_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "User has been denied permission to perform a management task."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[1], LOG_MESSAGE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Message has been logged to the container log. Note: The following will not generate this notification: initial container startup messages, final container shutdown messages, trace messages."));
    }

    private class SdfMFTracingIntegration
    extends AbstractMFComponentTracing {
        private boolean m_updateTraceLevelWasCalled;

        SdfMFTracingIntegration() {
            super("sonic.mf.agent", Agent.this.getTraceMaskValues());
            this.m_updateTraceLevelWasCalled = false;
            this.setTraceMask();
        }

        private void setTraceMask() {
            this.setTraceMask(new Integer(Agent.this.m_traceMask));
        }

        boolean wasUpdated() {
            return this.m_updateTraceLevelWasCalled;
        }

        public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
            super.updateTraceLevel(doiIDNotUsed, parameters, buffer);
            this.m_updateTraceLevelWasCalled = true;
            Agent.this.setTraceMask(this.getCurrentMask(), true);
        }
    }
}

