/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.comm.IConnectionListener;
import com.sonicsw.mf.comm.IDurableConnectorConsumer;
import com.sonicsw.mf.comm.jms.DurableConnector;
import com.sonicsw.mf.framework.agent.ContainerFT;
import javax.jms.JMSException;
import progress.message.jclient.Connection;
import progress.message.jclient.TopicConnectionFactory;

class ContainerFTConnectorClient
implements IDurableConnectorConsumer,
IConnectionListener {
    private ContainerFT m_containerFT;
    private TopicConnectionFactory m_connectionFactory;
    private DurableConnector m_durableConnector;
    private static boolean DISABLE_FT_CLIENT;
    private static String DISABLE_FT_CLIENT_PROPERTY;

    ContainerFTConnectorClient(ContainerFT containerFT, String domainName, String containerName, String ftRole, String urls, String user, String password, int connectTimeout, long socketConnectTimeout, long pingTimeout) throws JMSException, InterruptedException {
        this.m_containerFT = containerFT;
        this.initConnectionFactory(domainName, containerName, ftRole, urls, user, password, connectTimeout, socketConnectTimeout, pingTimeout);
        this.m_durableConnector = new DurableConnector((IDurableConnectorConsumer)this, "Fault detection", pingTimeout);
    }

    boolean isConnected() {
        if (this.m_durableConnector == null) {
            return false;
        }
        try {
            return this.m_durableConnector.isConnected();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    Connection getConnection() {
        if (this.m_durableConnector == null) {
            return null;
        }
        try {
            return this.m_durableConnector.getConnection();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public int getTraceMask() {
        return this.m_containerFT.getTraceMask();
    }

    public TopicConnectionFactory getConnectionFactory() {
        return this.m_connectionFactory;
    }

    public IConnectionListener getConnectionListener() {
        return this;
    }

    public void logMessage(String message, int severity) {
        this.m_containerFT.logMessage(message, severity);
    }

    public void logMessage(String message, Throwable e, int severity) {
        this.m_containerFT.logMessage(message, e, severity);
    }

    public void onReconnect(String localRoutingNode) {
        this.m_containerFT.onReconnect();
    }

    public void onDisconnect() {
        this.m_containerFT.onDisconnect();
    }

    public void onFailure(Exception e) {
        this.m_containerFT.onFailure(e);
    }

    private void initConnectionFactory(String domainName, String containerName, String ftRole, String urls, String user, String password, int connectTimeout, long socketConnectTimeout, long pingTimeout) throws JMSException {
        int val;
        String monitorInterval;
        this.m_connectionFactory = new TopicConnectionFactory();
        String connectID = "SonicMQ/mf/" + domainName + '/' + containerName + '/' + ftRole;
        this.m_connectionFactory.setConnectID(connectID);
        this.m_connectionFactory.setConnectionURLs(urls);
        if (user != null) {
            this.m_connectionFactory.setDefaultUser(user);
            this.m_connectionFactory.setDefaultPassword(password);
        }
        if ((monitorInterval = System.getProperty("monitorInterval")) != null && (val = Integer.parseInt(monitorInterval)) >= 0) {
            this.m_connectionFactory.setMonitorInterval(new Integer(val));
        }
        this.m_connectionFactory.setLoadBalancing(true);
        this.m_connectionFactory.setSequential(true);
        this.m_connectionFactory.setPersistentDelivery(true);
        this.m_connectionFactory.setInitialConnectTimeout(new Integer(connectTimeout));
        this.m_connectionFactory.setSocketConnectTimeout(new Integer((int)socketConnectTimeout));
        int pingInterval = (int)(pingTimeout * 9L / 10000L);
        if (pingInterval < 20) {
            pingInterval = 20;
        }
        this.m_connectionFactory.setPingInterval((long)pingInterval);
        if (!DISABLE_FT_CLIENT) {
            this.m_connectionFactory.setFaultTolerant(Boolean.TRUE);
            this.m_connectionFactory.setFaultTolerantReconnectTimeout(new Integer(connectTimeout));
        }
    }

    static {
        DISABLE_FT_CLIENT_PROPERTY = "sonicsw.mf.disableFTClient";
        String disableFTClient = System.getProperty(DISABLE_FT_CLIENT_PROPERTY, "false");
        DISABLE_FT_CLIENT = disableFTClient != null && disableFTClient.equals("true");
    }
}

