/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;

public final class DirectoryBlobAttacher {
    private IDirectoryService m_ds;

    public static void main(String[] args) throws Exception {
        if (args.length < 3 || args[0].equals("?")) {
            DirectoryBlobAttacher.printUsage();
        }
        try {
            new DirectoryBlobAttacher(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DirectoryBlobAttacher(String[] args) throws Exception {
        String dsXML = this.getXMLStringFromFile(args[0]);
        this.m_ds = this.createDSInstance(dsXML);
        IDirElement element = this.m_ds.getElement(args[1], true);
        File blob = new File(args[2]);
        if (!blob.isFile() || !blob.canRead()) {
            throw new IOException("Cannot read BLOB: " + args[2]);
        }
        FileInputStream fis = new FileInputStream(blob);
        System.out.println("Attaching BLOB in directory store ...");
        this.m_ds.attachBlob(element.doneUpdate(), fis, null);
        String contents = this.m_ds.exportDirectoryToXML("/");
        if (System.getProperty("verbose", "false").equals("true")) {
            System.out.println("Reporting contents ...");
            System.out.println();
            System.out.println(contents);
            System.out.println();
        }
        this.m_ds.close();
        System.out.println("Done.");
        System.exit(0);
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage: -Dverbose={[false]|true} com.sonicsw.mf.framework.directory.storage.DirectoryBlobSeeder <ds.xml> <seeddata.xml> <blob>");
        System.out.println();
        System.out.println("Where: <ds.xml>  Directory Service configuration.");
        System.out.println("       <element> The configuration element against which the binary");
        System.out.println("                 file will be stored.");
        System.out.println("       <blob>    The path to the binary file to be stored with the");
        System.out.println("                 element.");
        System.exit(1);
    }

    private String getXMLStringFromFile(String xmlFilename) throws Exception {
        FileInputStream fis = new FileInputStream(xmlFilename);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        return new String(bytes);
    }

    private IDirectoryService createDSInstance(String dsXML) throws Exception {
        IDirElement dsConfig = ElementFactory.importElementFromXML((String)dsXML, null, (String)"MF_DIRECTORY_SERVICE");
        if (dsConfig == null) {
            dsConfig = ElementFactory.importElementFromXML((String)dsXML, null, (String)"MF_BACKUP_DIRECTORY_SERVICE");
        }
        IAttributeSet dsAttributes = dsConfig.getAttributes();
        String hostDir = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
        String domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
        Object tmp = dsAttributes.getAttribute("FILE_SYSTEM_STORAGE");
        if (domainName == null || tmp == null) {
            throw new MFRuntimeException("Bad Directory Service Configuration - must contain DOMAIN_NAME and FILE_SYSTEM_STORAGE.");
        }
        if (!(tmp instanceof IAttributeSet)) {
            throw new MFRuntimeException("Bad Directory Service Configuration - FILE_SYSTEM_STORAGE must be an attribute set.");
        }
        IAttributeSet fsStorage = (IAttributeSet)tmp;
        String hostDirDepricated = (String)fsStorage.getAttribute("HOST_DIRECTORY");
        String password = (String)fsStorage.getAttribute("PASSWORD");
        Hashtable<String, String> directoryEnv = new Hashtable<String, String>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        if (hostDirDepricated != null) {
            directoryEnv.put("FS_HOST_DIRECTORY_ATTRIBUTE", hostDirDepricated);
        }
        if (hostDir != null) {
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir);
        }
        if (password != null && password.length() != 0) {
            directoryEnv.put("PASSWORD", password);
        }
        DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
        return factory.createDirectoryService(domainName);
    }
}

