/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.directory.DSComponent;
import java.util.Date;
import java.util.HashMap;

class DistributedLockManager {
    private DSComponent m_dsComponent;
    private IFrameworkComponentContext m_context;
    private HashMap m_leasedLocks = new HashMap();

    DistributedLockManager(DSComponent dsComponent, IFrameworkComponentContext context) {
        this.m_dsComponent = dsComponent;
        this.m_context = context;
    }

    void cleanup() {
        this.m_leasedLocks.clear();
        this.m_dsComponent = null;
        this.m_context = null;
        this.m_leasedLocks = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean leaseLock(String lockName, String key, long leaseDuration) {
        if (lockName == null) {
            throw new IllegalArgumentException("Lock name cannot be null");
        }
        if (lockName.length() == 0) {
            throw new IllegalArgumentException("Lock name cannot be an empty string");
        }
        if (key == null) {
            throw new IllegalArgumentException("Lease key cannot be null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("Lease key cannot be an empty string");
        }
        if (leaseDuration < 5000L) {
            throw new IllegalArgumentException("Lease duration cannot be < 5 seconds");
        }
        HashMap hashMap = this.m_leasedLocks;
        synchronized (hashMap) {
            DistributedLock lock = (DistributedLock)this.m_leasedLocks.get(lockName);
            if (lock == null) {
                lock = new DistributedLock(lockName, key);
                this.m_leasedLocks.put(lockName, lock);
            }
            if (!lock.key.equals(key)) {
                return false;
            }
            lock.lease(leaseDuration);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLock(String lockName, String key) {
        if (lockName == null) {
            throw new IllegalArgumentException("Lock name cannot be null");
        }
        if (lockName.length() == 0) {
            throw new IllegalArgumentException("Lock name cannot be an empty string");
        }
        if (key == null) {
            throw new IllegalArgumentException("Lease key cannot be null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("Lease key cannot be an empty string");
        }
        if (this.m_leasedLocks == null) {
            return;
        }
        HashMap hashMap = this.m_leasedLocks;
        synchronized (hashMap) {
            DistributedLock lock = (DistributedLock)this.m_leasedLocks.get(lockName);
            if (lock == null) {
                return;
            }
            if (!lock.key.equals(key)) {
                return;
            }
            this.m_leasedLocks.remove(lockName);
        }
    }

    private class LeaseExpirer
    implements Runnable {
        private DistributedLock lock;

        private LeaseExpirer(DistributedLock lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap hashMap = DistributedLockManager.this.m_leasedLocks;
            synchronized (hashMap) {
                DistributedLock actualLock = (DistributedLock)DistributedLockManager.this.m_leasedLocks.get(this.lock.lockName);
                if (actualLock != null && actualLock == this.lock && this.lock.expirationTime <= System.currentTimeMillis()) {
                    DistributedLockManager.this.releaseLock(this.lock.lockName, this.lock.key);
                }
            }
        }
    }

    private class DistributedLock {
        private String lockName;
        private String key;
        private long expirationTime;

        private DistributedLock(String lockName, String key) {
            this.lockName = lockName;
            this.key = key;
        }

        private void lease(long duration) {
            this.expirationTime = System.currentTimeMillis() + duration;
            DistributedLockManager.this.m_context.scheduleTask(new LeaseExpirer(this), new Date(this.expirationTime));
        }
    }
}

