/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.framework.directory.IDebuggingMasks;
import com.sonicsw.mf.framework.directory.ILogger;
import com.sonicsw.mf.framework.directory.impl.IAuthListener;
import com.sonicsw.mf.framework.directory.impl.TimeoutException;
import com.sonicsw.security.pass.client.IPasswordUser;
import com.sonicsw.security.pass.mf.ConnectionException;
import com.sonicsw.security.pass.mf.IEvent;
import com.sonicsw.security.pass.mf.IEventDisconnected;
import com.sonicsw.security.pass.mf.IEventGroupsAdded;
import com.sonicsw.security.pass.mf.IEventGroupsDeleted;
import com.sonicsw.security.pass.mf.IEventGroupsModified;
import com.sonicsw.security.pass.mf.IEventUsersAdded;
import com.sonicsw.security.pass.mf.IEventUsersDeleted;
import com.sonicsw.security.pass.mf.IEventUsersModified;
import com.sonicsw.security.pass.mf.IGroup;
import com.sonicsw.security.pass.mf.IManagement;
import com.sonicsw.security.pass.mf.INotificationListener;
import com.sonicsw.security.pass.mf.InvalidConfigurationException;
import java.util.HashMap;

final class AuthSource
implements IDebuggingMasks {
    public static final long TRY_AGAIN_INTERVAL = 10000L;
    private IManagement m_managementInstance;
    private String m_domainName;
    private ILogger m_logger;
    private boolean m_isClosing = false;
    private HashMap m_connectionParameters;
    private Connector m_connector;
    private IAuthListener m_internalListener = null;

    AuthSource(IManagement managementInstance, String domainName, HashMap connectionParameters, ILogger logger) throws Throwable {
        this.m_domainName = domainName;
        this.m_managementInstance = managementInstance;
        this.m_logger = logger;
        this.m_connectionParameters = connectionParameters;
    }

    void connect() throws Throwable {
        boolean alreadyConnected = false;
        try {
            this.m_logger.trace(64, "Connecting to external source of " + this.m_domainName);
            this.m_managementInstance.connect(this.m_connectionParameters);
            this.m_logger.logMessage("Connected to the authentication source of domain \"" + this.m_domainName + "\"", 7);
            this.m_logger.trace(64, "Connected to external source of " + this.m_domainName);
            alreadyConnected = true;
        }
        catch (Throwable throwable) {
            this.m_logger.trace(64, "SPI connect failure, trace follows... ", throwable);
            if (throwable instanceof InvalidConfigurationException || !(throwable instanceof ConnectionException)) {
                if (throwable instanceof ConnectionException) {
                    this.m_logger.logMessage("Failed to connect to the authentication source of domain \"" + this.m_domainName + "\", trace follows...", throwable, 2);
                } else {
                    this.m_logger.logMessage("Failed to connect to the authentication source of domain \"" + this.m_domainName + "\", trace follows...", throwable, 2);
                }
                throw throwable;
            }
            this.m_logger.logMessage("Failed to connect to the authentication source of domain \"" + this.m_domainName + "\": " + throwable.getMessage() + " - retrying...", 2);
        }
        this.m_connector = new Connector(alreadyConnected, this.m_domainName, this.m_logger);
        this.m_connector.start();
    }

    IPasswordUser[] getUsers(long timeout) throws TimeoutException {
        this.m_logger.trace(64, "Getting users for " + this.m_domainName);
        IPasswordUser[] users = (IPasswordUser[])this.getPrincipals(timeout, true);
        this.m_logger.trace(64, "Got " + users.length + " users.");
        return users;
    }

    IGroup[] getGroups(long timeout) throws TimeoutException {
        this.m_logger.trace(64, "Getting groups for " + this.m_domainName);
        IGroup[] groups = (IGroup[])this.getPrincipals(timeout, false);
        this.m_logger.trace(64, "Got " + groups.length + " groups.");
        return groups;
    }

    Object getPrincipals(long timeout, boolean getUsers) throws TimeoutException {
        for (int tryAgain = 2; tryAgain > 0; tryAgain = (int)((short)(tryAgain - 1))) {
            if (!this.m_connector.isConnected()) {
                tryAgain = (short)(tryAgain - 1);
                if (!this.m_connector.waitUntilConnected(timeout)) {
                    throw new TimeoutException();
                }
                if (this.m_isClosing) {
                    throw new TimeoutException();
                }
            }
            if (this.m_isClosing) {
                throw new TimeoutException();
            }
            try {
                if (getUsers) {
                    return this.m_managementInstance.getUsers();
                }
                return this.m_managementInstance.getGroups();
            }
            catch (Throwable throwable) {
                this.m_logger.trace(64, "SPI failure, trace follows...", throwable);
                if (this.m_isClosing) {
                    throw new TimeoutException();
                }
                if (throwable instanceof ConnectionException) continue;
                this.m_logger.logMessage("SPI failure, trace follows...", throwable, 2);
                if (!this.m_connector.isConnected()) continue;
                this.m_connector.disconnected(throwable.getMessage(), null);
                continue;
            }
        }
        throw new TimeoutException();
    }

    private void disconnected(String message, Integer errorNum) {
        this.m_connector.disconnected(message, errorNum);
    }

    private void reconnected() {
        if (this.m_internalListener != null) {
            this.m_internalListener.connectionRecovered();
        }
    }

    void disconnect() {
        this.m_isClosing = true;
        this.m_connector.close();
        try {
            this.m_logger.trace(64, "Disconnecting from external source of " + this.m_domainName);
            this.m_managementInstance.disconnect();
            this.m_logger.trace(64, "Disconnected from external source of " + this.m_domainName);
        }
        catch (Throwable throwable) {
            this.m_logger.trace(64, "SPI disconnect failure, trace follows..." + throwable);
            throwable.printStackTrace();
        }
    }

    boolean isConnected() {
        return this.m_connector.isConnected();
    }

    boolean registerListener(IAuthListener internalListener) {
        this.m_internalListener = internalListener;
        this.m_logger.trace(64, "Setting listener to external source of " + this.m_domainName);
        boolean result = this.m_managementInstance.setNotificationListener((INotificationListener)new ExternalListener(this.m_internalListener));
        this.m_logger.trace(64, "Listener set - " + result);
        return result;
    }

    private final class Connector
    extends Thread {
        boolean m_connected;
        boolean m_closed;
        String m_domainName;
        ILogger m_logger;

        Connector(boolean alreadyConnected, String domainName, ILogger logger) {
            super("AuthSource.Connector for domain " + domainName);
            this.m_connected = alreadyConnected;
            this.m_domainName = domainName;
            this.m_closed = false;
            this.m_logger = logger;
        }

        private synchronized boolean finished() {
            if (this.m_closed) {
                return true;
            }
            while (this.m_connected) {
                if (this.m_closed) {
                    return true;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return false;
        }

        synchronized void close() {
            this.m_closed = true;
            this.notifyAll();
        }

        synchronized void disconnected(String message, Integer errorNum) {
            String printMessage;
            String string = printMessage = message == null || message.length() == 0 ? "." : ": " + message;
            if (errorNum != null) {
                printMessage = printMessage + " Error number: " + errorNum.toString();
            }
            this.m_logger.logMessage("Disconnected from authentication source of domain \"" + this.m_domainName + "\"" + printMessage, 3);
            this.m_connected = false;
            this.notifyAll();
        }

        boolean isConnected() {
            return this.m_connected;
        }

        synchronized boolean waitUntilConnected(long timeout) {
            if (this.m_closed) {
                return false;
            }
            if (this.m_connected) {
                return true;
            }
            try {
                long startTime = System.currentTimeMillis();
                if (timeout <= 0L) {
                    while (!this.m_connected && !this.m_closed) {
                        this.wait();
                    }
                } else {
                    long waitTime = timeout;
                    while (!this.m_connected && !this.m_closed && waitTime > 0L) {
                        this.wait(waitTime);
                        waitTime = timeout - (System.currentTimeMillis() - startTime);
                    }
                }
            }
            catch (InterruptedException e) {
                return this.m_connected;
            }
            return this.m_connected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Connector connector = this;
                synchronized (connector) {
                    if (this.finished()) {
                        return;
                    }
                    try {
                        this.m_logger.trace(64, "Connecting to external source of " + this.m_domainName);
                        AuthSource.this.m_managementInstance.connect(AuthSource.this.m_connectionParameters);
                        this.m_logger.trace(64, "Connected to external source of " + this.m_domainName);
                        this.m_connected = true;
                        this.m_logger.logMessage("Connected to the authentication source of domain \"" + this.m_domainName + "\"", 3);
                        AuthSource.this.reconnected();
                        this.notifyAll();
                    }
                    catch (Throwable throwable) {
                        this.m_logger.trace(64, "SPI connect failure, trace follows... ", throwable);
                        try {
                            this.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    private final class ExternalListener
    implements INotificationListener {
        private IAuthListener m_internalListener;

        ExternalListener(IAuthListener internalListener) {
            this.m_internalListener = internalListener;
        }

        @Override
        public void onNotification(IEvent event) {
            if (event == null) {
                AuthSource.this.m_logger.logMessage("INotificationListener got null event", 2);
                return;
            }
            AuthSource.this.m_logger.trace(64, "Got " + AuthSource.this.m_domainName + " event: " + event.getClass().getName());
            if (event instanceof IEventUsersAdded) {
                this.m_internalListener.updateUsers(((IEventUsersAdded)event).getUsersAdded());
            } else if (event instanceof IEventUsersModified) {
                this.m_internalListener.updateUsers(((IEventUsersModified)event).getUsersModified());
            } else if (event instanceof IEventUsersDeleted) {
                IPasswordUser[] deletedUsers = ((IEventUsersDeleted)event).getUsersDeleted();
                String[] userNames = new String[deletedUsers.length];
                for (int i = 0; i < deletedUsers.length; ++i) {
                    userNames[i] = deletedUsers[i].getName();
                }
                this.m_internalListener.deletePrincipals(userNames, true);
            } else if (event instanceof IEventGroupsAdded) {
                this.m_internalListener.updateGroups(((IEventGroupsAdded)event).getGroupsAdded());
            } else if (event instanceof IEventGroupsModified) {
                this.m_internalListener.updateGroups(((IEventGroupsModified)event).getGroupsModified());
            } else if (event instanceof IEventGroupsDeleted) {
                IGroup[] deletedGroups = ((IEventGroupsDeleted)event).getGroupsDeleted();
                String[] groupNames = new String[deletedGroups.length];
                for (int i = 0; i < deletedGroups.length; ++i) {
                    groupNames[i] = deletedGroups[i].getName();
                }
                this.m_internalListener.deletePrincipals(groupNames, false);
            } else if (event instanceof IEventDisconnected) {
                IEventDisconnected discEvent = (IEventDisconnected)event;
                AuthSource.this.disconnected(discEvent.getErrorMessage(), new Integer(discEvent.getErrorCode()));
            }
        }
    }
}

