/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.impl.DSTransaction;
import com.sonicsw.mf.common.config.impl.NextVersionToken;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.directory.RepairNoStorageReferences;
import com.sonicsw.mf.framework.directory.SharedPermissionChecks;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import java.util.ArrayList;

public final class ClientTransaction {
    ArrayList m_actions;
    DirectoryService m_ds;
    SharedPermissionChecks m_permissionChecks;
    int m_namingFailedIndex;
    ArrayList m_hierarchicalCreates = new ArrayList();
    ArrayList m_hierarchicalDeletes = new ArrayList();

    ClientTransaction(DSTransaction transaction, DirectoryService ds) {
        this.m_ds = ds;
        this.m_actions = transaction.getActions();
    }

    ClientTransaction(DSTransaction transaction, DirectoryService ds, IFrameworkComponentContext context) {
        this(transaction, ds);
        this.m_permissionChecks = new SharedPermissionChecks(context, ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INextVersionToken performActions() throws DirectoryServiceException {
        if (this.m_actions.isEmpty()) {
            return null;
        }
        if (this.m_actions.size() == 1 && this.m_actions.get(0) instanceof DSTransaction.CreateElements) {
            DSTransaction.CreateElements createElements = (DSTransaction.CreateElements)this.m_actions.get(0);
            if (this.m_ds.canBeDoneInBulk(createElements.m_elements)) {
                try {
                    this.m_ds.m_lock.writeLock();
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.createFSElementsCheck(createElements.m_elements);
                    }
                    INextVersionToken iNextVersionToken = this.m_ds.createFSElements(createElements.m_elements, this.m_ds.assignStorageNames(createElements.m_elements, true));
                    return iNextVersionToken;
                }
                finally {
                    this.m_ds.m_lock.releaseLock();
                }
            }
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        NextVersionToken token = null;
        boolean startedRememberingIDS = false;
        try {
            this.m_ds.m_lock.writeLock();
            startedRememberingIDS = this.m_ds.rememberNewIds();
            this.m_ds.m_trManager.join();
            joinedTransaction = true;
            ArrayList danglingRefList = new ArrayList();
            this.searchForHierarchicalConfigs();
            this.nameAndActionLoop(0, danglingRefList);
            if (!danglingRefList.isEmpty()) {
                try {
                    RepairNoStorageReferences.repairReferences((IDirectoryFileSystemService)this.m_ds, danglingRefList);
                }
                catch (Exception e) {
                    if (e instanceof DirectoryServiceException) {
                        throw (DirectoryServiceException)((Object)e);
                    }
                    throw new DirectoryServiceException(e.toString());
                }
            }
            transactOK = true;
        }
        finally {
            try {
                if (startedRememberingIDS) {
                    token = this.m_ds.createNextVersionToken(true);
                }
                if (joinedTransaction) {
                    this.m_ds.m_trManager.leave(transactOK);
                }
            }
            finally {
                this.m_ds.m_lock.releaseLock();
            }
        }
        return token;
    }

    private void nameAndActionLoop(int startAt, ArrayList danglingRefList) throws DirectoryServiceException {
        block4: {
            try {
                this.generateStorageNames(startAt);
            }
            catch (DirectoryServiceException e) {
                if (startAt != this.m_namingFailedIndex) break block4;
                throw e;
            }
        }
        if (this.m_namingFailedIndex < this.m_actions.size()) {
            this.performActionsInternal(startAt, this.m_namingFailedIndex - 1, danglingRefList);
            this.nameAndActionLoop(this.m_namingFailedIndex, danglingRefList);
        } else {
            this.performActionsInternal(startAt, this.m_actions.size() - 1, danglingRefList);
        }
    }

    private void performActionsInternal(int startIndex, int endIndex, ArrayList danglingRefList) throws DirectoryServiceException {
        String actionName = null;
        try {
            for (int i = startIndex; i <= endIndex; ++i) {
                String possibleParent;
                String possibleParent2;
                DSTransaction.UpdateElement action;
                if (this.m_actions.get(i) instanceof DSTransaction.UpdateElement) {
                    action = (DSTransaction.UpdateElement)this.m_actions.get(i);
                    actionName = "UpdateElement";
                    if (action.m_doNotUpdateIfEmpty && action.m_element.emptyDelta()) {
                        IElementIdentity elementID = action.m_element.getIdentity();
                        IElementIdentity dsID = this.m_ds.getFSIdentity(elementID.getName());
                        if (dsID != null && dsID.equalVersion(elementID)) continue;
                        String dsVersion = dsID == null ? null : new Long(dsID.getVersion()).toString();
                        this.m_ds.throwVersionException(elementID.getName(), "Directory version: " + dsVersion + "  Delta version: " + elementID.getVersion());
                        continue;
                    }
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.updateFSElementCheck(action.m_element.getIdentity().getName());
                    }
                    this.m_ds.updateFSElement(action.m_element, danglingRefList);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.SetAttributes) {
                    String attrObjectName;
                    actionName = "SetAttributes";
                    action = (DSTransaction.SetAttributes)this.m_actions.get(i);
                    if (this.m_permissionChecks != null && (possibleParent2 = this.m_ds.getHierarchicalPath(attrObjectName = action.m_name, this.m_hierarchicalCreates)) == null) {
                        this.m_permissionChecks.setMetaAttributesCheck(attrObjectName);
                    }
                    this.m_ds.setMetaAttributes(action.m_name, action.m_attributes);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.CreateElement) {
                    String createElementName;
                    actionName = "CreateElement";
                    action = (DSTransaction.CreateElement)this.m_actions.get(i);
                    if (this.m_permissionChecks != null && ((possibleParent2 = this.m_ds.getHierarchicalPath(createElementName = action.m_element.getIdentity().getName(), this.m_hierarchicalCreates)) == null || possibleParent2.equals(createElementName))) {
                        this.m_permissionChecks.createFSElementsCheck(new IDirElement[]{action.m_element});
                    }
                    this.m_ds.createFSElement(action.m_element, action.m_newStorageName, danglingRefList);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.CreateElements) {
                    actionName = "CreateElements";
                    action = (DSTransaction.CreateElements)this.m_actions.get(i);
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.createFSElementsCheck(action.m_elements);
                    }
                    this.m_ds.createFSElements(action.m_elements, action.m_newStorageNames);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.CreateFolder) {
                    actionName = "CreateFolder";
                    action = (DSTransaction.CreateFolder)this.m_actions.get(i);
                    if (this.m_permissionChecks != null && (possibleParent = this.m_ds.getHierarchicalPath(action.m_folderName, this.m_hierarchicalCreates)) == null) {
                        this.m_permissionChecks.createFolderCheck(action.m_folderName, action.m_existingOk);
                    }
                    this.m_ds.createFolder(action.m_folderName, action.m_existingOk);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.DeleteFolder) {
                    actionName = "DeleteFolder";
                    action = (DSTransaction.DeleteFolder)this.m_actions.get(i);
                    if (this.m_permissionChecks != null && ((possibleParent = this.m_ds.getHierarchicalPath(action.m_folderName, this.m_hierarchicalDeletes)) == null || possibleParent.equals(action.m_folderName))) {
                        this.m_permissionChecks.deleteFolderCheck(action.m_folderName);
                    }
                    this.m_ds.deleteFolder(action.m_folderName);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.AttachBlob) {
                    actionName = "AttachBlob";
                    action = (DSTransaction.AttachBlob)this.m_actions.get(i);
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.attachFSBlobCheck(action.m_element.getIdentity().getName());
                    }
                    if (action.m_stream != null) {
                        this.m_ds.attachFSBlobInternal(action.m_element, action.m_stream, action.m_newStorageName, danglingRefList);
                        continue;
                    }
                    this.m_ds.attachFSBlobInternal(action.m_element, action.m_blob, action.m_newStorageName, danglingRefList);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.AppendBlob) {
                    actionName = "AppendBlob";
                    action = (DSTransaction.AppendBlob)this.m_actions.get(i);
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.appendFSBlobCheck(action.m_element.getIdentity().getName());
                    }
                    this.m_ds.appendFSBlobInternal(action.m_element, action.m_blob, action.m_src, action.m_newStorageName, danglingRefList);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.SubclassElement) {
                    actionName = "SubclassElement";
                    action = (DSTransaction.SubclassElement)this.m_actions.get(i);
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.subclassFSElementCheck(action.m_delta.getIdentity().getName(), action.m_newElementPath);
                    }
                    this.m_ds.subclassFSElementInternal(action.m_delta, action.m_newElementPath, action.m_newStorageName);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.CloneElement0) {
                    actionName = "CloneElement0";
                    action = (DSTransaction.CloneElement0)this.m_actions.get(i);
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.cloneFSElementCheck(action.m_delta.getIdentity().getName(), action.m_newElementPath);
                    }
                    this.m_ds.cloneFSElementInternal(action.m_delta, null, action.m_newElementPath, action.m_createTemplate, action.m_newStorageName);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.CloneElement1) {
                    actionName = "CloneElement1";
                    action = (DSTransaction.CloneElement1)this.m_actions.get(i);
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.cloneFSElementCheck(action.m_sourcePath, action.m_newElementPath);
                    }
                    this.m_ds.cloneFSElementInternal(null, action.m_sourcePath, action.m_newElementPath, action.m_createTemplate, action.m_newStorageName);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.DeleteElement) {
                    actionName = "DeleteElement";
                    action = (DSTransaction.DeleteElement)this.m_actions.get(i);
                    if (this.m_permissionChecks != null && (possibleParent = this.m_ds.getHierarchicalPath(action.m_elementName, this.m_hierarchicalDeletes)) == null) {
                        this.m_permissionChecks.deleteFSElementCheck(action.m_elementName);
                    }
                    this.m_ds.deleteFSElement(action.m_elementName);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.Rename) {
                    actionName = "Rename";
                    action = (DSTransaction.Rename)this.m_actions.get(i);
                    if (this.m_permissionChecks != null) {
                        this.m_permissionChecks.renameCheck(action.m_oldName, action.m_newName);
                    }
                    this.m_ds.rename(action.m_oldName, action.m_newName);
                    continue;
                }
                if (!(this.m_actions.get(i) instanceof DSTransaction.DetachBlob)) continue;
                actionName = "DetachBlob";
                action = (DSTransaction.DetachBlob)this.m_actions.get(i);
                if (this.m_permissionChecks != null) {
                    this.m_permissionChecks.detachFSBlobCheck(action.m_delta.getIdentity().getName());
                }
                this.m_ds.detachFSBlob(action.m_delta);
            }
        }
        catch (DirectoryServiceException dirE) {
            String previousMessage = dirE.getMessage();
            String newMessage = "";
            if (actionName != null) {
                newMessage = actionName + " action failed in ClientTransaction";
                if (previousMessage != null && previousMessage.length() > 0) {
                    newMessage = newMessage + ": " + previousMessage;
                }
            } else {
                newMessage = previousMessage;
            }
            Exception linked = dirE.getLinkedException();
            DirectoryServiceException newE = new DirectoryServiceException(newMessage);
            newE.setLinkedException(linked);
            throw newE;
        }
    }

    void searchForHierarchicalConfigs() throws DirectoryServiceException {
        if (this.m_permissionChecks != null && this.m_permissionChecks.isPermissionsCheckingEnabled()) {
            for (int i = 0; i < this.m_actions.size(); ++i) {
                DSTransaction.CreateElement action;
                if (this.m_actions.get(i) instanceof DSTransaction.CreateElement) {
                    action = (DSTransaction.CreateElement)this.m_actions.get(i);
                    IElementIdentity id = action.m_element.getIdentity();
                    if (!this.m_ds.isHierarchicalConfig(id.getReleaseVersion(), id.getType())) continue;
                    String idString = id.getName();
                    this.m_hierarchicalCreates.add(idString);
                    this.m_hierarchicalCreates.add(idString.substring(0, idString.lastIndexOf(47)));
                    continue;
                }
                if (!(this.m_actions.get(i) instanceof DSTransaction.DeleteFolder)) continue;
                action = (DSTransaction.DeleteFolder)this.m_actions.get(i);
                String idString = action.m_folderName;
                if (!this.m_ds.isHierarchicalPath(idString)) continue;
                this.m_hierarchicalDeletes.add(idString);
            }
        }
    }

    void generateStorageNames(int startIndex) throws DirectoryServiceException {
        for (int i = startIndex; i < this.m_actions.size(); ++i) {
            try {
                DSTransaction.CreateElement action;
                if (this.m_actions.get(i) instanceof DSTransaction.CreateElement) {
                    action = (DSTransaction.CreateElement)this.m_actions.get(i);
                    action.m_newStorageName = this.m_ds.assignStorageName((IBasicElement)action.m_element);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.CreateElements) {
                    action = (DSTransaction.CreateElements)this.m_actions.get(i);
                    action.m_newStorageNames = this.m_ds.assignStorageNames(action.m_elements, false);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.SubclassElement) {
                    action = (DSTransaction.SubclassElement)this.m_actions.get(i);
                    action.m_newStorageName = this.m_ds.assignStorageName(action.m_newElementPath, action.m_delta.getIdentity().getType());
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.CloneElement0) {
                    action = (DSTransaction.CloneElement0)this.m_actions.get(i);
                    action.m_newStorageName = this.m_ds.assignStorageName(action.m_newElementPath, action.m_delta.getIdentity().getType());
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.CloneElement1) {
                    action = (DSTransaction.CloneElement1)this.m_actions.get(i);
                    IElementIdentity id = this.m_ds.getFSIdentity(action.m_sourcePath);
                    if (id == null) {
                        throw new DirectoryServiceException("CloneElement source " + action.m_sourcePath + " has not been defined yet");
                    }
                    String type = id.getType();
                    action.m_newStorageName = this.m_ds.assignStorageName(action.m_newElementPath, type);
                    continue;
                }
                if (this.m_actions.get(i) instanceof DSTransaction.AttachBlob) {
                    action = (DSTransaction.AttachBlob)this.m_actions.get(i);
                    if (!(action.m_element instanceof IDirElement) || this.m_ds.isHandledByHandler(action.m_element)) continue;
                    action.m_newStorageName = this.m_ds.assignStorageName(action.m_element);
                    continue;
                }
                if (!(this.m_actions.get(i) instanceof DSTransaction.AppendBlob)) continue;
                action = (DSTransaction.AppendBlob)this.m_actions.get(i);
                if (this.m_ds.isHandledByHandler(action.m_element)) continue;
                if (action.m_element instanceof IDirElement && action.m_src == 0) {
                    action.m_newStorageName = this.m_ds.assignStorageName(action.m_element);
                    continue;
                }
                if (!(action.m_element instanceof IDirElement) || action.m_src == 0) continue;
                action.m_newStorageName = this.m_ds.tempBlobLogicalToStorage(action.m_element.getIdentity().getName());
                continue;
            }
            catch (DirectoryServiceException e) {
                this.m_namingFailedIndex = i;
                throw e;
            }
        }
        this.m_namingFailedIndex = this.m_actions.size();
    }
}

