/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.config.impl.DeltaElement;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.EnvelopeElement;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.framework.directory.impl.BackReferenceMgr;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mf.framework.directory.impl.IModificationManager;
import com.sonicsw.mf.framework.directory.impl.ModificationItem;
import com.sonicsw.mf.framework.directory.storage.PackedDirUtil;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

final class ImportManager
implements IModificationManager {
    private static final short INITIALIZATION_PHASE = 1;
    private static final short CREATE_SUPERS_PHASE = 2;
    private static final short CREATE_SUBS_PHASE = 3;
    private DirectoryService m_ds;
    private short m_phase = 1;
    private HashMap m_oldIds;
    private HashMap m_importedSubs;
    private HashMap m_importedSupers;
    private HashMap m_importedRegulars;
    private HashGroups m_importedPacked;
    private HashMap m_modificationList;
    private HashMap m_deletionTable;
    private Element[] m_extraDeletionsList;
    private boolean m_noReplace;
    private boolean m_logicalNameSpaceModified;

    ImportManager(DirectoryService ds) throws DirectoryServiceException {
        this(ds, IEmptyArray.EMPTY_STRING_ARRAY, false);
    }

    ImportManager(DirectoryService ds, String[] deletionDirectories, boolean noReplace) throws DirectoryServiceException {
        this.m_ds = ds;
        this.m_noReplace = noReplace;
        this.createDeletionTable(deletionDirectories);
        this.reset();
    }

    void importedElement(Element element) throws DirectoryServiceException, VersionOutofSyncException {
        switch (this.m_phase) {
            case 1: {
                if (element.getIdentity().getName().equals(BackReferenceMgr.getBackRefElementPath())) {
                    this.m_ds.m_backRefMgr.setBackReferencesTypes(element);
                    break;
                }
                this.imported(element);
                break;
            }
            case 2: {
                if (element.getIdentity().getName().equals(BackReferenceMgr.getBackRefElementPath())) {
                    return;
                }
                if (element.getSuperElementName() != null) break;
                String[] subList = element.getSubclassedList();
                if (subList.length > 0) {
                    this.createSuper(element);
                } else {
                    this.createRegular(element);
                }
                this.m_ds.m_backRefMgr.elementCreated((IDirElement)element);
                break;
            }
            case 3: {
                if (element.getIdentity().getName().equals(BackReferenceMgr.getBackRefElementPath())) {
                    return;
                }
                if (element.getSuperElementName() == null) break;
                this.createSub(element);
                this.m_ds.m_backRefMgr.elementCreated((IDirElement)element);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void createSub(Element element) throws DirectoryServiceException, VersionOutofSyncException {
        String elementName = element.getIdentity().getName();
        Boolean exists = (Boolean)this.m_importedSubs.get(elementName);
        this.m_modificationList.put(element.getIdentity(), exists);
        Element superElement = (Element)this.m_ds.getElement(element.getSuperElementName(), true);
        superElement.cleanupSuperAttributes(true, true);
        DeltaElement calculatedDelta = superElement.createDelta(element);
        calculatedDelta.setIdentity(((ElementIdentity)superElement.getIdentity()).createClone());
        this.m_ds.subclassElement((IBasicElement)calculatedDelta, elementName, null);
    }

    private void createSuper(Element element) throws DirectoryServiceException, VersionOutofSyncException {
        String elementName = element.getIdentity().getName();
        Boolean exists = (Boolean)this.m_importedSupers.get(elementName);
        this.m_modificationList.put(element.getIdentity(), exists);
        element = (Element)element.createWritableClone();
        element.cleanupSuperAttributes(true, false);
        this.m_ds.setElement((IBasicElement)element, null);
    }

    private void createRegular(Element element) throws DirectoryServiceException, VersionOutofSyncException {
        String elementName = element.getIdentity().getName();
        EntityName eName = ImportManager.getEntity(elementName);
        if (PackedDirUtil.underPackedDir(eName)) {
            ElementPair pair = (ElementPair)this.m_importedPacked.get(elementName);
            if (pair != null && !pair.m_canceled) {
                this.m_modificationList.put(pair.m_afterImage.getIdentity(), pair.m_beforeImage == null ? Boolean.FALSE : Boolean.TRUE);
            }
            return;
        }
        Boolean exists = (Boolean)this.m_importedRegulars.get(elementName);
        this.m_modificationList.put(element.getIdentity(), exists);
        try {
            Integer blobState;
            IAttributeSet systemAttrs;
            IAttributeSet topSet = element.getAttributes();
            if (topSet != null && (systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES")) != null && (blobState = (Integer)systemAttrs.getAttribute("LARGE_FILE_STATE")) != null) {
                Blob.markBlobState((Element)element, (Object)Boolean.TRUE, (String)"BLOB_ENVELOPE_ELEMENT_IMPORT");
            }
        }
        catch (Exception configE) {
            DirectoryServiceException dirE = new DirectoryServiceException("Unable to set system attributes during import " + configE.toString());
            dirE.setLinkedException(configE);
            throw dirE;
        }
        this.m_ds.setElement((IBasicElement)element, null);
    }

    HashMap createAllPackedElements() throws DirectoryServiceException {
        HashMap groups = this.m_importedPacked.getGroups();
        Iterator iterator = groups.keySet().iterator();
        HashMap<String, IElementIdentity> newIdList = new HashMap<String, IElementIdentity>();
        while (iterator.hasNext()) {
            String parentDir = (String)iterator.next();
            ArrayList group = (ArrayList)groups.get(parentDir);
            ArrayList<IDirElement> newList = new ArrayList<IDirElement>();
            for (int i = 0; i < group.size(); ++i) {
                ElementPair pair = (ElementPair)this.m_importedPacked.get(group.get(i));
                if (pair.m_afterImage == null || pair.m_canceled) continue;
                newList.add(pair.m_afterImage);
            }
            IDirElement[] newElements = new IDirElement[newList.size()];
            newList.toArray(newElements);
            this.m_ds.setElements(newElements);
            for (int i = 0; i < newElements.length; ++i) {
                IElementIdentity elementID = newElements[i].getIdentity();
                newIdList.put(elementID.getName(), elementID);
            }
        }
        return newIdList;
    }

    private void importedPacked(String name, Element element) throws DirectoryServiceException {
        DirectoryService.initializeElementVersion((ElementIdentity)element.getIdentity());
        ElementPair pair = (ElementPair)this.m_importedPacked.get(name);
        if (pair == null) {
            IDirElement[] elements = this.m_ds.getElements(name, false);
            boolean wasPlaced = false;
            for (int i = 0; i < elements.length; ++i) {
                String elementName = elements[i].getIdentity().getName();
                if (name.equals(elementName)) {
                    pair = new ElementPair(elements[i], (IDirElement)element);
                    wasPlaced = true;
                } else if (this.m_importedPacked.get(elementName) == null) {
                    pair = new ElementPair(elements[i], null);
                }
                if (pair == null) continue;
                this.m_importedPacked.put(elementName, pair);
            }
            if (!wasPlaced) {
                this.m_importedPacked.put(name, new ElementPair(null, (IDirElement)element));
            }
        } else {
            pair.m_afterImage = element;
        }
    }

    boolean wasLogicalNameSpaceModified() {
        return this.m_logicalNameSpaceModified;
    }

    private void imported(Element element) throws DirectoryServiceException {
        boolean isSuper;
        String name = element.getIdentity().getName();
        EntityName eName = null;
        try {
            eName = ImportManager.getEntity(name);
        }
        catch (IllegalArgumentException e) {
            throw new DirectoryServiceException(e.getMessage());
        }
        if (PackedDirUtil.underPackedDir(eName)) {
            this.importedPacked(name, element);
            return;
        }
        String canonicalName = eName.getName();
        if (canonicalName.equals("/_MFSchema/view") || canonicalName.equals("/_MFSchema/storage_hints")) {
            this.m_logicalNameSpaceModified = true;
        }
        boolean exists = false;
        try {
            IDirElement oldElement = this.m_ds.getElement(name, false);
            if (oldElement != null) {
                exists = true;
                this.m_oldIds.put(name, oldElement.getIdentity());
            }
        }
        catch (DirectoryServiceException e) {
            // empty catch block
        }
        boolean isSub = element.getSuperElementName() != null;
        boolean bl = isSuper = element.getSubclassedList().length > 0;
        if (isSub) {
            this.m_importedSubs.put(name, new Boolean(exists));
        } else if (isSuper) {
            this.m_importedSupers.put(name, new Boolean(exists));
        } else {
            try {
                this.m_importedRegulars.put(name, new Boolean(exists));
            }
            catch (IllegalArgumentException e) {
                throw new DirectoryServiceException(e.getMessage());
            }
        }
    }

    void nextPhase() throws DirectoryServiceException, VersionOutofSyncException {
        switch (this.m_phase) {
            case 1: {
                this.validateSubsImported();
                this.cancelRedundantImportOfPackedElements();
                this.deleteOldElements();
                this.m_phase = (short)2;
                break;
            }
            case 2: {
                this.m_phase = (short)3;
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void cancelRedundantImportOfPackedElements() {
        for (ElementPair pair : this.m_importedPacked.values()) {
            Element e2;
            Element e1;
            DeltaElement calculatedDelta;
            if (pair == null || pair.m_afterImage == null || pair.m_beforeImage == null || !(calculatedDelta = (e1 = (Element)pair.m_afterImage).createDelta(e2 = (Element)pair.m_beforeImage)).emptyDelta()) continue;
            pair.m_canceled = true;
        }
    }

    private void validateSubsImported() throws DirectoryServiceException {
        for (String superName : this.m_importedSupers.keySet()) {
            if (!((Boolean)this.m_importedSupers.get(superName)).booleanValue()) continue;
            Element oldSuperElement = (Element)this.m_ds.getElement(superName, false);
            String[] subList = oldSuperElement.getSubclassedList();
            for (int i = 0; i < subList.length; ++i) {
                if (this.m_importedSubs.get(subList[i]) != null) continue;
                throw new DirectoryServiceException("A sub-classed element of '" + superName + "' - '" + subList[i] + "' is not imported. If a super element is imported " + "then all the sub-classed elements that already exist in storage " + "must be imported as well, or deleted or unSubclassed.");
            }
        }
    }

    private void createDeletionTable(String[] deletionList) throws DirectoryServiceException {
        this.m_deletionTable = new HashMap();
        for (int i = 0; i < deletionList.length; ++i) {
            EntityName dirName = null;
            try {
                dirName = ImportManager.getEntity(deletionList[i]);
            }
            catch (IllegalStateException e) {
                throw new DirectoryServiceException(deletionList[i] + " is an illegal directory name.");
            }
            if (!PackedDirUtil.isPackedDir(dirName)) {
                throw new DirectoryServiceException(deletionList[i] + " is not a packed directory.");
            }
            HashMap<String, IElementIdentity> dirList = new HashMap<String, IElementIdentity>();
            this.m_deletionTable.put(deletionList[i], dirList);
            IElementIdentity[] list = this.m_ds.listElements(deletionList[i]);
            for (int j = 0; j < list.length; ++j) {
                dirList.put(list[j].getName(), list[j]);
            }
        }
    }

    private void deleteOldElements() throws DirectoryServiceException {
        ArrayList group;
        HashMap groups = this.m_importedPacked.getGroups();
        for (String parentDir : groups.keySet()) {
            HashMap deletionGroup = (HashMap)this.m_deletionTable.get(parentDir);
            if (deletionGroup == null) continue;
            group = (ArrayList)groups.get(parentDir);
            for (int i = 0; i < group.size(); ++i) {
                String elementName = (String)group.get(i);
                ElementPair pair = (ElementPair)this.m_importedPacked.get(elementName);
                if (pair.m_beforeImage == null || !pair.m_canceled && pair.m_afterImage == null) continue;
                deletionGroup.remove(elementName);
            }
        }
        for (HashMap dirList : this.m_deletionTable.values()) {
            Iterator iterator = dirList.keySet().iterator();
            group = new ArrayList();
            while (iterator.hasNext()) {
                group.add(iterator.next());
            }
            String[] elementNames = new String[group.size()];
            group.toArray(elementNames);
            this.m_ds.importDeleteElements(elementNames);
        }
        this.m_extraDeletionsList = this.deletionListFromTable();
        for (String elementName : this.m_importedRegulars.keySet()) {
            if (!((Boolean)this.m_importedRegulars.get(elementName)).booleanValue()) continue;
            this.m_ds.m_backRefMgr.elementDeleted(elementName);
            this.m_ds.importDeleteElement(elementName, null);
        }
        for (String elementName : this.m_importedSubs.keySet()) {
            if (!((Boolean)this.m_importedSubs.get(elementName)).booleanValue()) continue;
            this.m_ds.m_backRefMgr.elementDeleted(elementName);
            this.m_ds.importDeleteElement(elementName, null);
        }
        for (String elementName : this.m_importedSupers.keySet()) {
            if (!((Boolean)this.m_importedSupers.get(elementName)).booleanValue()) continue;
            this.m_ds.m_backRefMgr.elementDeleted(elementName);
            this.m_ds.importDeleteElement(elementName, null);
        }
    }

    private Element[] deletionListFromTable() {
        ArrayList deletedElementsList = new ArrayList();
        for (HashMap dirList : this.m_deletionTable.values()) {
            Iterator iterator = dirList.values().iterator();
            while (iterator.hasNext()) {
                deletedElementsList.add(iterator.next());
            }
        }
        Element[] result = new Element[deletedElementsList.size()];
        for (int i = 0; i < deletedElementsList.size(); ++i) {
            result[i] = (Element)Element.createDeletedElement((IElementIdentity)((IElementIdentity)deletedElementsList.get(i)));
        }
        return result;
    }

    @Override
    public void validate() throws DirectoryServiceException {
        ArrayList<ModificationItem> list = new ArrayList<ModificationItem>();
        for (IElementIdentity elementID : this.m_modificationList.keySet()) {
            String elementName = elementID.getName();
            boolean exists = (Boolean)this.m_modificationList.get(elementID);
            if (this.m_noReplace && exists) {
                throw new DirectoryServiceException(elementName + " already exists.");
            }
            ElementPair pair = (ElementPair)this.m_importedPacked.get(elementName);
            IDirElement element = null;
            if (pair == null) {
                element = this.m_ds.getElement(elementName, false);
            } else {
                if (pair.m_canceled) continue;
                element = pair.m_afterImage;
            }
            if (exists) {
                IElementIdentity oldID = null;
                oldID = pair == null ? (IElementIdentity)this.m_oldIds.get(elementID.getName()) : pair.m_beforeImage.getIdentity();
                list.add(new ModificationItem((Element)Element.createDeletedElement((IElementIdentity)oldID), true));
            }
            if (pair == null) {
                list.add(new ModificationItem(this.m_ds, (ElementIdentity)element.getIdentity()));
                continue;
            }
            list.add(new ModificationItem((Element)element));
        }
        for (int i = 0; i < this.m_extraDeletionsList.length; ++i) {
            list.add(new ModificationItem(this.m_extraDeletionsList[i], true));
        }
        this.m_ds.runValidationTriggers(list, true);
    }

    @Override
    public void audit() throws DirectoryServiceException {
    }

    @Override
    public void doNotify() throws DirectoryServiceException {
        if (!this.m_ds.hasConsumer()) {
            return;
        }
        Iterator iterator = this.m_modificationList.keySet().iterator();
        GroupNotification groupNotification = new GroupNotification();
        while (iterator.hasNext()) {
            IElementIdentity elementID = (IElementIdentity)iterator.next();
            String elementName = elementID.getName();
            boolean exists = (Boolean)this.m_modificationList.get(elementID);
            ElementPair pair = (ElementPair)this.m_importedPacked.get(elementName);
            String parentName = null;
            IDirElement element = null;
            if (pair == null) {
                element = this.m_ds.getElement(elementName, false);
            } else {
                if (pair.m_canceled) continue;
                element = pair.m_afterImage;
                parentName = pair.m_parent;
            }
            if (exists) {
                IElementIdentity oldID = null;
                oldID = pair == null ? (IElementIdentity)this.m_oldIds.get(elementID.getName()) : pair.m_beforeImage.getIdentity();
                EnvelopeElement envelope = new EnvelopeElement((IElement)Element.createDeletedElement((IElementIdentity)oldID));
                envelope.setProperty("DRE", "true");
                groupNotification.addNotification((Element)envelope, parentName, true);
                element = new EnvelopeElement((IElement)element);
                ((IEnvelope)element).setProperty("R", "true");
            }
            groupNotification.addNotification((Element)element, parentName, false);
        }
        for (int i = 0; i < this.m_extraDeletionsList.length; ++i) {
            Element element = this.m_extraDeletionsList[i];
            EntityName eName = ImportManager.getEntity(element.getIdentity().getName());
            String parentName = eName.getParent();
            groupNotification.addNotification(element, parentName, true);
        }
        groupNotification.doNotify();
    }

    @Override
    public void reset() {
        this.m_oldIds = new HashMap();
        this.m_importedSubs = new HashMap();
        this.m_importedSupers = new HashMap();
        this.m_importedRegulars = new HashMap();
        this.m_importedPacked = new HashGroups();
        this.m_modificationList = new HashMap();
        this.m_logicalNameSpaceModified = false;
    }

    private static EntityName getEntity(String name) {
        EntityName entity = null;
        try {
            entity = new EntityName(name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(name + " is illegal.");
        }
        return entity;
    }

    @Override
    public void onCreate() throws DirectoryServiceException {
    }

    @Override
    public void afterCreate() throws DirectoryServiceException {
    }

    @Override
    public void onUpdate() throws DirectoryServiceException {
    }

    @Override
    public void afterUpdate() throws DirectoryServiceException {
    }

    @Override
    public void onDelete() throws DirectoryServiceException {
    }

    @Override
    public void afterDelete() throws DirectoryServiceException {
    }

    private class HashGroups
    extends HashMap {
        private HashMap m_groups = new HashMap();

        HashGroups() {
        }

        @Override
        public Object put(Object key, Object value) {
            EntityName eName = ImportManager.getEntity((String)key);
            String parentName = eName.getParent();
            ArrayList<Object> group = (ArrayList<Object>)this.m_groups.get(parentName);
            if (group == null) {
                group = new ArrayList<Object>();
                this.m_groups.put(parentName, group);
            }
            group.add(key);
            ((ElementPair)value).m_parent = parentName;
            return super.put(key, value);
        }

        HashMap getGroups() {
            return this.m_groups;
        }

        @Override
        public Object get(Object key) {
            return super.get(key);
        }

        public void cancel(Object key) {
            ElementPair pair = (ElementPair)super.get(key);
            if (pair == null) {
                return;
            }
            pair.m_canceled = true;
        }

        @Override
        public Object remove(Object key) {
            throw new IllegalStateException("Not Supported");
        }
    }

    private class ElementPair
    extends HashMap {
        IDirElement m_beforeImage;
        IDirElement m_afterImage;
        boolean m_canceled;
        String m_parent;

        ElementPair(IDirElement beforeImage, IDirElement afterImage) {
            this.m_beforeImage = beforeImage;
            this.m_afterImage = afterImage;
            this.m_canceled = false;
            this.m_parent = null;
        }
    }

    private class GroupNotification {
        HashMap m_groups = new HashMap();

        GroupNotification() {
        }

        void addNotification(Element element, String parentName, boolean deleted) {
            if (parentName == null) {
                if (deleted) {
                    ImportManager.this.m_ds.notifyMods(element, true);
                } else {
                    ImportManager.this.m_ds.notifyMods(element);
                }
                return;
            }
            ArrayList<Notification> group = (ArrayList<Notification>)this.m_groups.get(parentName);
            if (group == null) {
                group = new ArrayList<Notification>();
                this.m_groups.put(parentName, group);
            }
            group.add(new Notification(element, deleted));
        }

        void doNotify() {
            for (ArrayList currentGroup : this.m_groups.values()) {
                ArrayList<ModificationItem> modList = new ArrayList<ModificationItem>();
                boolean hasDelete = false;
                for (int i = 0; i < currentGroup.size(); ++i) {
                    Notification notification = (Notification)currentGroup.get(i);
                    notification.m_element.setReadOnly(true);
                    ModificationItem modItem = null;
                    if (notification.m_deleted) {
                        hasDelete = true;
                        modItem = new ModificationItem(notification.m_element, true);
                    } else {
                        modItem = new ModificationItem(notification.m_element);
                    }
                    modList.add(modItem);
                }
                ImportManager.this.m_ds.groupNotifyMods(modList, hasDelete);
            }
        }

        private class Notification {
            Element m_element;
            boolean m_deleted;

            Notification(Element element, boolean deleted) {
                this.m_element = element;
                this.m_deleted = deleted;
            }
        }
    }
}

