/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.BTreeKeyNotFoundException;
import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.BTreeCopyNote;
import com.sonicsw.mtstorage.impl.BTreeEmptyNodeNote;
import com.sonicsw.mtstorage.impl.BTreeInitRootNote;
import com.sonicsw.mtstorage.impl.BTreeInsertNote;
import com.sonicsw.mtstorage.impl.BTreeKeyBuffer;
import com.sonicsw.mtstorage.impl.BTreeLeafNode;
import com.sonicsw.mtstorage.impl.BTreeNode;
import com.sonicsw.mtstorage.impl.BTreeReplaceNote;
import com.sonicsw.mtstorage.impl.BTreeRootFirstEntryNote;
import com.sonicsw.mtstorage.impl.BTreeSecondary;
import com.sonicsw.mtstorage.impl.BTreeSplitNote;
import com.sonicsw.mtstorage.impl.DataPage;
import com.sonicsw.mtstorage.impl.Logger;
import java.io.IOException;

abstract class BTreeAbstractNode {
    protected static final int FLAGS_OFFSET = 0;
    protected static final byte LEAF_NODE_FLAG = 1;
    protected static final byte UNIQUE_INDEX_FLAG = 2;
    protected static final byte ROOT_FLAG = 4;
    protected static final int NO_PAGE = 0;
    protected BTreeKeyBuffer m_keyBuffer;
    protected boolean m_uniqueIndex;
    protected Logger m_logger;
    protected long m_dbk;
    protected DataPage m_page;
    protected byte[] m_buffer;
    protected int m_start;
    protected int m_length;
    protected BTreeSecondary m_secondary;
    private BTreeSplitNote m_btreeSplitNote;
    private BTreeCopyNote m_btreeCopyNote;
    private BTreeEmptyNodeNote m_btreeEmptyNote;
    private BTreeReplaceNote m_btreeReplaceNote;
    private BTreeInsertNote m_btreeInsertNote;

    BTreeAbstractNode(Logger logger, BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, boolean uniqueIndex, int keyBufferStart, int keyBufferLength, boolean node, boolean createNew, BTreeSecondary secondary) {
        this.m_logger = logger;
        this.m_dbk = allocatedBuffer.m_dbk;
        this.m_page = allocatedBuffer.m_page;
        this.m_secondary = secondary;
        this.m_buffer = allocatedBuffer.m_buffer;
        this.m_start = allocatedBuffer.m_offset;
        this.m_length = allocatedBuffer.m_length;
        this.m_uniqueIndex = uniqueIndex;
        this.m_keyBuffer = new BTreeKeyBuffer(this.m_buffer, keyBufferStart, keyBufferLength, this.m_uniqueIndex || node, createNew, this.m_secondary);
        this.m_btreeSplitNote = new BTreeSplitNote();
        this.m_btreeCopyNote = new BTreeCopyNote();
        this.m_btreeEmptyNote = new BTreeEmptyNodeNote();
        this.m_btreeReplaceNote = new BTreeReplaceNote();
        this.m_btreeInsertNote = new BTreeInsertNote();
    }

    DataPage getPage() {
        return this.m_page;
    }

    void split(BTreeAbstractNode newNode, boolean doLog) throws IOException {
        if (doLog) {
            this.m_btreeSplitNote.initNote(this.m_dbk, this.m_buffer, this.m_start, this.m_length, newNode.m_dbk);
            long noteID = this.m_logger.writeNote(this.m_btreeSplitNote);
            this.m_page.setNoteID(noteID);
            newNode.m_page.setNoteID(noteID);
        }
        this.m_keyBuffer.split(newNode.m_keyBuffer);
    }

    BTreeKeyBuffer.BufferKey getKey(int position) {
        return this.m_keyBuffer.getKey(position);
    }

    BTreeKeyBuffer.BufferKey getFirstKey() {
        return this.m_keyBuffer.getFirstKey();
    }

    BTreeKeyBuffer.BufferKey getLastKey() {
        return this.m_keyBuffer.getLastKey();
    }

    int getKeyPosition(BTreeKeyBuffer.BufferKey key) {
        return this.m_keyBuffer.find(key);
    }

    int getKeyGreaterEqualPosition(byte[] key) {
        return this.m_keyBuffer.findGreaterEqual(key);
    }

    int getKeyGreaterEqualPosition(BTreeKeyBuffer.BufferKey key) {
        return this.m_keyBuffer.findGreaterEqual(key);
    }

    int getKeyGreaterPosition(BTreeKeyBuffer.BufferKey key) {
        return this.m_keyBuffer.findGreater(key);
    }

    int getKeySmallerEqualPosition(BTreeKeyBuffer.BufferKey key) {
        return this.m_keyBuffer.findSmallerEqual(key);
    }

    int getKeySmallerPosition(BTreeKeyBuffer.BufferKey key) {
        return this.m_keyBuffer.findSmaller(key);
    }

    void replaceInThisNode(BTreeKeyBuffer.BufferKey key, byte[] valueBuffer, int valueOffset, int valueLength) throws IOException {
        int entryPosition = this.m_keyBuffer.find(key);
        this.m_keyBuffer.replace(entryPosition, valueBuffer, valueOffset, valueLength);
    }

    void removeInThisNode(BTreeKeyBuffer.BufferKey key) throws IOException {
        int position = this.m_keyBuffer.find(key);
        this.m_keyBuffer.delete(true, position);
    }

    byte[] replace(BTreeKeyBuffer.BufferKey key, int entryPosition, byte[] newValue) throws IOException {
        byte[] oldValue = this.m_keyBuffer.replace(entryPosition, newValue, 0, newValue != null ? newValue.length : 0);
        this.m_btreeReplaceNote.initNote(this.m_dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, newValue, oldValue);
        long noteID = this.m_logger.writeNote(this.m_btreeReplaceNote);
        this.m_page.setNoteID(noteID);
        return oldValue;
    }

    byte[] getValue(byte[] key, byte[] valueBuffer) throws BTreeKeyNotFoundException, IOException {
        int position = this.m_keyBuffer.find(key);
        if (position == -1) {
            throw new BTreeKeyNotFoundException();
        }
        return this.m_keyBuffer.getValue(position, valueBuffer);
    }

    boolean insert(BTreeKeyBuffer.BufferKey key, byte[] value, boolean doLog) throws IOException {
        int position;
        if (doLog) {
            this.m_btreeInsertNote.initNote(this.m_dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, value);
            long noteID = this.m_logger.writeNote(this.m_btreeInsertNote);
            this.m_page.setNoteID(noteID);
        }
        if ((position = this.m_keyBuffer.findGreater(key)) == -1) {
            position = this.m_keyBuffer.getNumEntries();
        }
        return this.m_keyBuffer.insert(position, key, value);
    }

    boolean canInsert(BTreeKeyBuffer.BufferKey key, byte[] value) {
        int reservedSpace = this instanceof BTreeNode ? 256 : 0;
        int position = this.m_keyBuffer.findGreater(key);
        if (position == -1) {
            position = this.m_keyBuffer.getNumEntries();
        }
        return this.m_keyBuffer.canInsert(position, key, value, reservedSpace);
    }

    void initializeRoot(boolean doLog) throws IOException {
        if (doLog) {
            BTreeInitRootNote btreeInitRootNote = new BTreeInitRootNote();
            btreeInitRootNote.initNote(this.m_dbk);
            long noteID = this.m_logger.writeNote(btreeInitRootNote);
            this.m_page.setNoteID(noteID);
        }
        int n = this.m_start + 0;
        this.m_buffer[n] = (byte)(this.m_buffer[n] | 4);
        BTreeKeyBuffer.BufferKey key = new BTreeKeyBuffer.BufferKey();
        key.m_isInfinite = true;
        this.m_keyBuffer.insert(0, key, new byte[8]);
    }

    void initializeRoot(BTreeKeyBuffer.BufferKey key, byte[] value, boolean doLog) throws IOException {
        if (doLog) {
            BTreeRootFirstEntryNote rootFirstEntryNote = new BTreeRootFirstEntryNote();
            rootFirstEntryNote.initNote(this.m_dbk, key.m_buffer, key.m_offset, key.m_length, key.m_isNull, key.m_isInfinite, value);
            long noteID = this.m_logger.writeNote(rootFirstEntryNote);
            this.m_page.setNoteID(noteID);
        }
        int n = this.m_start + 0;
        this.m_buffer[n] = (byte)(this.m_buffer[n] | 4);
        this.m_keyBuffer.insert(0, key, value);
    }

    BTreeAbstractNode copy(BTreeAbstractNode node) throws IOException {
        this.m_btreeCopyNote.initNote(node.m_dbk, this.m_buffer, this.m_start, this.m_length, node.m_buffer, node.m_start, node.m_length);
        long noteID = this.m_logger.writeNote(this.m_btreeCopyNote);
        this.m_page.setNoteID(noteID);
        System.arraycopy(this.m_buffer, this.m_start, node.m_buffer, node.m_start, this.m_length);
        return BTreeAbstractNode.createExistingNode(this.m_logger, new BTreeAbstractBufferSupply.AllocatedBuffer(node.m_buffer, node.m_start, node.m_length, node.m_dbk, node.m_page), node.m_secondary);
    }

    static BTreeAbstractNode nodeFromBytes(Logger logger, byte[] buffer, int start, int length, BTreeAbstractNode node) throws IOException {
        System.arraycopy(buffer, start, node.m_buffer, node.m_start, length);
        return BTreeAbstractNode.createExistingNode(logger, new BTreeAbstractBufferSupply.AllocatedBuffer(node.m_buffer, node.m_start, node.m_length, node.m_dbk, node.m_page), node.m_secondary);
    }

    BTreeAbstractNode createEmptyNode(BTreeSecondary secondary, boolean doLog) throws IOException {
        if (doLog) {
            this.m_btreeEmptyNote.initNote(this.m_dbk, this.m_buffer, this.m_start, this.m_length);
            long noteID = this.m_logger.writeNote(this.m_btreeEmptyNote);
            this.m_page.setNoteID(noteID);
        }
        return BTreeAbstractNode.createNewNode(this.m_logger, new BTreeAbstractBufferSupply.AllocatedBuffer(this.m_buffer, this.m_start, this.m_length, this.m_dbk, this.m_page), false, this.m_uniqueIndex, secondary, doLog);
    }

    boolean getUniqueIndex() {
        return (this.m_buffer[this.m_start + 0] & 2) != 0;
    }

    static BTreeAbstractNode createExistingNode(Logger logger, BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, BTreeSecondary secondary) throws IOException {
        byte[] buffer = allocatedBuffer.m_buffer;
        int start = allocatedBuffer.m_offset;
        return BTreeAbstractNode.createNode(logger, allocatedBuffer, false, (buffer[start + 0] & 2) != 0, secondary, false);
    }

    static boolean insertInNew(BTreeKeyBuffer.BufferKey key, BTreeAbstractNode node1, BTreeAbstractNode node2) {
        return BTreeKeyBuffer.compareKeys(key, node2.getLastKey()) == -2;
    }

    static BTreeAbstractNode createNewNode(Logger logger, BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, boolean leaf, boolean uniqueIndex, BTreeSecondary secondary, boolean doLog) throws IOException {
        byte[] buffer = allocatedBuffer.m_buffer;
        int start = allocatedBuffer.m_offset;
        buffer[start + 0] = 0;
        if (leaf) {
            int n = start + 0;
            buffer[n] = (byte)(buffer[n] | 1);
        }
        if (uniqueIndex) {
            int n = start + 0;
            buffer[n] = (byte)(buffer[n] | 2);
        }
        return BTreeAbstractNode.createNode(logger, allocatedBuffer, true, uniqueIndex, secondary, doLog);
    }

    private static BTreeAbstractNode createNode(Logger logger, BTreeAbstractBufferSupply.AllocatedBuffer allocatedBuffer, boolean createNew, boolean uniqueIndex, BTreeSecondary secondary, boolean doLog) throws IOException {
        byte[] buffer = allocatedBuffer.m_buffer;
        int start = allocatedBuffer.m_offset;
        if ((buffer[start + 0] & 1) != 0) {
            return new BTreeLeafNode(logger, allocatedBuffer, createNew, uniqueIndex, secondary, doLog);
        }
        return new BTreeNode(logger, allocatedBuffer, createNew, uniqueIndex, secondary, doLog);
    }

    int getNumEntries() {
        return this.m_keyBuffer.getNumEntries();
    }

    BTreeKeyBuffer.BufferKey getKeyDEBUG(int position) {
        return this.m_keyBuffer.getKeyDEBUG(position);
    }

    byte[] getValueDEBUG(int position) throws IOException {
        return this.m_keyBuffer.getValueDEBUG(position);
    }
}

