/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTree;
import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.BTreeAbstractNode;
import com.sonicsw.mtstorage.impl.BTreeAddValueNote;
import com.sonicsw.mtstorage.impl.BTreeCopyNote;
import com.sonicsw.mtstorage.impl.BTreeCreateLeafNote;
import com.sonicsw.mtstorage.impl.BTreeCreateNodeNote;
import com.sonicsw.mtstorage.impl.BTreeEmptyNodeNote;
import com.sonicsw.mtstorage.impl.BTreeInitRootNote;
import com.sonicsw.mtstorage.impl.BTreeInsertNote;
import com.sonicsw.mtstorage.impl.BTreeLeafNode;
import com.sonicsw.mtstorage.impl.BTreeMemoryBufferSupply;
import com.sonicsw.mtstorage.impl.BTreeNode;
import com.sonicsw.mtstorage.impl.BTreeRemoveKeyNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveSecondaryPointerNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveValueNote;
import com.sonicsw.mtstorage.impl.BTreeReplaceNote;
import com.sonicsw.mtstorage.impl.BTreeRootFirstEntryNote;
import com.sonicsw.mtstorage.impl.BTreeSecondary;
import com.sonicsw.mtstorage.impl.BTreeSecondaryCreateNote;
import com.sonicsw.mtstorage.impl.BTreeSetSecondaryDbkNote;
import com.sonicsw.mtstorage.impl.BTreeSplitNote;
import com.sonicsw.mtstorage.impl.DataPage;
import com.sonicsw.mtstorage.impl.Logger;
import java.io.IOException;

final class BTreePhysicalRecovery {
    private BTreeAbstractBufferSupply m_bufferSupply;
    private Logger m_logger;
    private BTreeSecondary m_secondary;

    BTreePhysicalRecovery(Logger logger, BTreeAbstractBufferSupply bufferSupply, BTreeSecondary secondary) {
        this.m_bufferSupply = bufferSupply;
        this.m_logger = logger;
        this.m_secondary = secondary;
    }

    void undo(AbstractNote note) throws IOException {
        BTreeAbstractBufferSupply.AllocatedBuffer buffer = this.m_bufferSupply.getBuffer(note.getPageNum(), true);
        DataPage page = buffer.m_page;
        BTree.AllocatedNode allocatedNode = this.nodeFromDbk(buffer);
        BTreeAbstractNode node = allocatedNode.m_node;
        if (note instanceof BTreeSplitNote) {
            BTreeSplitNote splitNote = (BTreeSplitNote)note;
            BTreeAbstractNode originalSrcNode = BTreeAbstractNode.nodeFromBytes(this.m_logger, splitNote.m_srcBuffer, splitNote.m_srcValueOffset, splitNote.m_srcLength, node);
            allocatedNode.m_buffer.m_cachedState = originalSrcNode;
            this.m_bufferSupply.setCachedState(allocatedNode.m_buffer);
        } else if (note instanceof BTreeInsertNote) {
            BTreeInsertNote insertNote = (BTreeInsertNote)note;
            node.removeInThisNode(insertNote.getKey());
        } else if (note instanceof BTreeAddValueNote) {
            BTreeAddValueNote addNote = (BTreeAddValueNote)note;
            ((BTreeLeafNode)node).removeInThisNode(addNote.getKey(), addNote.getValue());
        } else if (note instanceof BTreeRemoveValueNote) {
            BTreeRemoveValueNote removeNote = (BTreeRemoveValueNote)note;
            ((BTreeLeafNode)node).addValue(removeNote.getKey(), removeNote.getValue(), false);
        } else if (note instanceof BTreeRemoveKeyNote) {
            BTreeRemoveKeyNote removeNote = (BTreeRemoveKeyNote)note;
            node.insert(removeNote.getKey(), removeNote.getValue(), false);
        } else if (!(note instanceof BTreeCreateLeafNote || note instanceof BTreeCreateNodeNote || note instanceof BTreeSetSecondaryDbkNote)) {
            if (note instanceof BTreeSecondaryCreateNote) {
                BTreeSecondaryCreateNote secondaryCreateNote = (BTreeSecondaryCreateNote)note;
                ((BTreeLeafNode)node).replaceMultiValues(secondaryCreateNote.m_oldEntry, secondaryCreateNote.m_oldEntryOffset);
            } else if (note instanceof BTreeRemoveSecondaryPointerNote) {
                BTreeRemoveSecondaryPointerNote removePointerNote = (BTreeRemoveSecondaryPointerNote)note;
                node.insert(removePointerNote.getKey(), removePointerNote.getValue(), false);
                ((BTreeLeafNode)node).markSecondaryBTreeEntry(removePointerNote.getKey());
            } else if (!(note instanceof BTreeCopyNote)) {
                if (note instanceof BTreeEmptyNodeNote) {
                    BTreeEmptyNodeNote emptyNodeNote = (BTreeEmptyNodeNote)note;
                    BTreeAbstractNode originalNode = BTreeAbstractNode.nodeFromBytes(this.m_logger, emptyNodeNote.m_oldBuffer, emptyNodeNote.m_oldValueOffset, emptyNodeNote.m_oldLength, node);
                    allocatedNode.m_buffer.m_cachedState = originalNode;
                    this.m_bufferSupply.setCachedState(allocatedNode.m_buffer);
                } else if (!(note instanceof BTreeInitRootNote) && !(note instanceof BTreeRootFirstEntryNote)) {
                    if (note instanceof BTreeReplaceNote) {
                        BTreeReplaceNote replaceNote = (BTreeReplaceNote)note;
                        node.replaceInThisNode(replaceNote.getKey(), replaceNote.m_oldValueNull ? null : replaceNote.m_noteBuffer, replaceNote.m_oldValueOffset, replaceNote.m_oldValueLength);
                    } else {
                        throw new IOException("Redo for " + note + " is not implemented");
                    }
                }
            }
        }
        page.setNoteID(note.getNoteID() - 1L);
    }

    void redo(AbstractNote note) throws IOException {
        if (note instanceof BTreeSplitNote) {
            this.redoSplit((BTreeSplitNote)note);
            return;
        }
        if (this.m_bufferSupply.getBufferNoteID(note.getPageNum()) >= note.getNoteID()) {
            return;
        }
        BTreeAbstractBufferSupply.AllocatedBuffer buffer = this.m_bufferSupply.getBuffer(note.getPageNum(), true);
        DataPage page = buffer.m_page;
        BTree.AllocatedNode allocatedNode = null;
        BTreeAbstractNode node = null;
        if (this.nodeAlreadyExists(note)) {
            allocatedNode = this.nodeFromDbk(buffer);
            node = allocatedNode.m_node;
        }
        if (note instanceof BTreeInsertNote) {
            BTreeInsertNote insertNote = (BTreeInsertNote)note;
            node.insert(insertNote.getKey(), insertNote.getValue(), false);
        } else if (note instanceof BTreeAddValueNote) {
            BTreeAddValueNote addNote = (BTreeAddValueNote)note;
            ((BTreeLeafNode)node).addValue(addNote.getKey(), addNote.getValue(), false);
        } else if (note instanceof BTreeRemoveValueNote) {
            BTreeRemoveValueNote removeNote = (BTreeRemoveValueNote)note;
            ((BTreeLeafNode)node).removeInThisNode(removeNote.getKey(), removeNote.getValue());
        } else if (note instanceof BTreeRemoveKeyNote) {
            BTreeRemoveKeyNote removeNote = (BTreeRemoveKeyNote)note;
            ((BTreeNode)node).remove(removeNote.getKey(), false);
        } else if (note instanceof BTreeCreateLeafNote) {
            BTreeCreateLeafNote createLeafNote = (BTreeCreateLeafNote)note;
            allocatedNode = this.allocateLeaf(createLeafNote.getPageNum(), createLeafNote.m_unique);
            allocatedNode.m_buffer.m_cachedState = allocatedNode.m_node;
            this.m_bufferSupply.setCachedState(allocatedNode.m_buffer);
        } else if (note instanceof BTreeCreateNodeNote) {
            BTreeCreateNodeNote createNodeNote = (BTreeCreateNodeNote)note;
            allocatedNode = this.allocateNode(createNodeNote.getPageNum(), createNodeNote.m_unique);
            allocatedNode.m_buffer.m_cachedState = allocatedNode.m_node;
            this.m_bufferSupply.setCachedState(allocatedNode.m_buffer);
        } else if (note instanceof BTreeSetSecondaryDbkNote) {
            BTreeSetSecondaryDbkNote setNote = (BTreeSetSecondaryDbkNote)note;
            ((BTreeLeafNode)node).setSecondaryTreeDBK(setNote.getEntryPosition(), setNote.getSecondaryDbk(), false);
        } else if (note instanceof BTreeSecondaryCreateNote) {
            BTreeSecondaryCreateNote secondaryCreateNote = (BTreeSecondaryCreateNote)note;
            ((BTreeLeafNode)node).replacePointer(secondaryCreateNote.m_newEntry, secondaryCreateNote.m_newEntryOffset);
        } else if (note instanceof BTreeRemoveSecondaryPointerNote) {
            BTreeRemoveSecondaryPointerNote removePointerNote = (BTreeRemoveSecondaryPointerNote)note;
            node.removeInThisNode(removePointerNote.getKey());
        } else if (note instanceof BTreeCopyNote) {
            BTreeCopyNote copyNote = (BTreeCopyNote)note;
            BTreeAbstractNode newNode = BTreeAbstractNode.nodeFromBytes(this.m_logger, copyNote.m_newBuffer, copyNote.m_newValueOffset, copyNote.m_newLength, node);
            allocatedNode.m_buffer.m_cachedState = newNode;
            this.m_bufferSupply.setCachedState(allocatedNode.m_buffer);
        } else if (note instanceof BTreeEmptyNodeNote) {
            BTreeAbstractNode newNode = node.createEmptyNode(this.m_secondary, false);
            buffer.m_cachedState = newNode;
            this.m_bufferSupply.setCachedState(buffer);
        } else if (note instanceof BTreeInitRootNote) {
            node.initializeRoot(false);
        } else if (note instanceof BTreeRootFirstEntryNote) {
            BTreeRootFirstEntryNote rootInitNote = (BTreeRootFirstEntryNote)note;
            node.initializeRoot(rootInitNote.getKey(), rootInitNote.getValue(), false);
        } else if (note instanceof BTreeReplaceNote) {
            BTreeReplaceNote replaceNote = (BTreeReplaceNote)note;
            node.replaceInThisNode(replaceNote.getKey(), replaceNote.m_newValueNull ? null : replaceNote.m_noteBuffer, replaceNote.m_newValueOffset, replaceNote.m_newValueLength);
        } else {
            throw new IOException("Redo for " + note + " is not implemented");
        }
        page.setNoteID(note.getNoteID());
    }

    private boolean nodeAlreadyExists(AbstractNote note) {
        return !(note instanceof BTreeCreateLeafNote) && !(note instanceof BTreeCreateNodeNote);
    }

    void redoSplit(BTreeSplitNote note) throws IOException {
        boolean noDup;
        boolean newNeedsRedo;
        boolean srcNeedsRedo = this.m_bufferSupply.getBufferNoteID(note.getPageNum()) < note.getNoteID();
        boolean bl = newNeedsRedo = this.m_bufferSupply.getBufferNoteID(note.getNewPageNum()) < note.getNoteID();
        if (!srcNeedsRedo && !newNeedsRedo) {
            return;
        }
        BTree.AllocatedNode srcAllocatedNode = null;
        BTreeAbstractNode srcNode = null;
        BTree.AllocatedNode newAllocatedNode = null;
        BTreeAbstractNode newNode = null;
        if (srcNeedsRedo) {
            srcAllocatedNode = this.nodeFromDbk(this.m_bufferSupply.getBuffer(note.getPageNum(), true));
            srcNode = srcAllocatedNode.m_node;
        }
        if (newNeedsRedo) {
            newAllocatedNode = this.nodeFromDbk(this.m_bufferSupply.getBuffer(note.getNewPageNum(), true));
            newNode = newAllocatedNode.m_node;
        }
        boolean leaf = srcNode != null ? srcNode instanceof BTreeLeafNode : newNode instanceof BTreeLeafNode;
        boolean bl2 = noDup = srcNode != null ? srcNode.getUniqueIndex() : newNode.getUniqueIndex();
        if (!srcNeedsRedo) {
            srcAllocatedNode = this.allocateInMemory(leaf, noDup);
            srcNode = srcAllocatedNode.m_node;
        }
        if (!newNeedsRedo) {
            newAllocatedNode = this.allocateInMemory(leaf, noDup);
            newNode = newAllocatedNode.m_node;
        }
        BTreeAbstractNode originalSrcNode = BTreeAbstractNode.nodeFromBytes(this.m_logger, note.m_srcBuffer, note.m_srcValueOffset, note.m_srcLength, srcNode);
        if (srcNeedsRedo) {
            srcAllocatedNode.m_buffer.m_cachedState = originalSrcNode;
            this.m_bufferSupply.setCachedState(srcAllocatedNode.m_buffer);
        }
        originalSrcNode.split(newNode, false);
        if (srcNeedsRedo) {
            srcAllocatedNode.m_buffer.m_page.setNoteID(note.getNoteID());
        }
        if (newNeedsRedo) {
            newAllocatedNode.m_buffer.m_page.setNoteID(note.getNoteID());
        }
    }

    private BTree.AllocatedNode allocateInMemory(boolean leaf, boolean noDuplicates) throws IOException {
        BTreeAbstractBufferSupply.AllocatedBuffer buffer = new BTreeMemoryBufferSupply().allocateBuffer(0L, 0L);
        BTreeAbstractNode node = BTreeAbstractNode.createNewNode(this.m_logger, buffer, leaf, noDuplicates, this.m_secondary, false);
        return new BTree.AllocatedNode(node, buffer);
    }

    private BTree.AllocatedNode allocateLeaf(long useThisPage, boolean noDuplicates) throws IOException {
        return this.allocateNodeOrLeaf(true, useThisPage, noDuplicates);
    }

    private BTree.AllocatedNode allocateNode(long useThisPage, boolean noDuplicates) throws IOException {
        return this.allocateNodeOrLeaf(false, useThisPage, noDuplicates);
    }

    private BTree.AllocatedNode allocateNodeOrLeaf(boolean leaf, long pageDbk, boolean noDuplicates) throws IOException {
        BTreeAbstractBufferSupply.AllocatedBuffer buffer = this.m_bufferSupply.getBuffer(pageDbk, true);
        BTreeAbstractNode node = BTreeAbstractNode.createNewNode(this.m_logger, buffer, leaf, noDuplicates, this.m_secondary, false);
        return new BTree.AllocatedNode(node, buffer);
    }

    private BTree.AllocatedNode nodeFromDbk(BTreeAbstractBufferSupply.AllocatedBuffer buffer) throws IOException {
        BTreeAbstractNode node = null;
        if (buffer.m_cachedState != null) {
            node = (BTreeAbstractNode)buffer.m_cachedState;
        } else {
            node = BTreeAbstractNode.createExistingNode(this.m_logger, buffer, this.m_secondary);
            buffer.m_cachedState = node;
            this.m_bufferSupply.setCachedState(buffer);
        }
        return new BTree.AllocatedNode(node, buffer);
    }
}

